/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="locationMessage")
public class LocationHandle
extends WeiXinMessage
implements ReplyMessageHandle {
    @Autowired
    private CustomerInterface customerService;

    @Override
    public XMLMessage receiveMessage(final EventMessage eventMessage, final int platformId) {
        final String openId = eventMessage.getFromUserName();
        try {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    LocationHandle.this.reportLocation(eventMessage, platformId, openId);
                }
            });
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return null;
    }

    private void reportLocation(EventMessage eventMessage, int platformId, String openId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u7528\u6237:{},\u5e73\u53f0:{}\u672a\u6ce8\u518c", (Object)eventMessage.getFromUserName(), (Object)platformId);
            return;
        }
        CustomerEntity customerEntity = this.customerService.getCustomer(customerDetailVo.getCustomerId());
        if (!openId.isEmpty()) {
            customerEntity.setPositionX(eventMessage.getLatitude());
            customerEntity.setPositionY(eventMessage.getLongitude());
            customerEntity.setScale(eventMessage.getScale());
            this.customerService.updateCustomerEntitySelective(customerEntity);
        }
    }
}

