/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerOnlineEntity;
import cc.lechun.mall.entity.weixin.WeekEnum;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerOnlineInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import weixin.popular.bean.message.EventMessage;

public class ManualMessage
extends WeiXinMessage {
    @Autowired
    private CustomerOnlineInterface customerOnlineService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    private MallOrderPlanDomainInterface orderPlanDomainInterface;

    protected void saveCustomerOnlineRecord(EventMessage eventMessage, int platformId, String key, CustomerDetailVo customerDetailVo) {
        try {
            CustomerOnlineEntity customerOnlineEntity = new CustomerOnlineEntity();
            customerOnlineEntity.setOpenId(eventMessage.getFromUserName());
            customerOnlineEntity.setCreateTime(DateUtils.now());
            customerOnlineEntity.setCustomerId(customerDetailVo == null ? "" : customerDetailVo.getCustomerId());
            this.customerOnlineService.saveCustomerOnline(customerOnlineEntity);
            if (platformId == 1) {
                this.customerService.saveCustomerInfo(platformId, customerDetailVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveCustomerOnlineRecord(EventMessage eventMessage, int platformId, String key) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        this.saveCustomerOnlineRecord(eventMessage, platformId, key, customerDetailVo);
    }

    protected void cancelPlan(EventMessage eventMessage, int platformId) {
        try {
            final CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
            this.logger.info("\u7528\u6237:{}\u8f93\u5165\u53d6\u6d88", (Object)customerDetailVo.getCustomerId());
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    ManualMessage.this.orderPlanDomainInterface.cancelPlan(customerDetailVo.getCustomerId());
                }
            });
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }

    protected boolean checkIsExistOnline(String openId) {
        return this.customerOnlineService.checkIsExistOnline(openId);
    }

    protected void pushCustomerMessage(EventMessage eventMessage, int platformId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        if (customerDetailVo == null) {
            this.logger.info("\u7528\u6237:{}:\u5e73\u53f0:{} \u672a\u6ce8\u518c \u67e5\u627e\u7528\u6237\u8bb0\u5f55\u4e3a\u7a7a", (Object)eventMessage.getFromUserName(), (Object)platformId);
            return;
        }
        String key = DateUtils.date() + ":" + customerDetailVo.getCustomerId() + ":clickRecord";
        if (this.redisCacheUtil.get(key) == null) {
            CustomerEntity customerEntity;
            this.redisCacheUtil.set(key, (Object)1, Long.valueOf(86400L));
            if (customerDetailVo != null && (customerEntity = this.customerService.getCustomer(customerDetailVo.getCustomerId())) != null) {
                if (Objects.equals(customerEntity.getIsNew(), 1)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "");
                    BaseJsonVo baseJsonVo = this.messageService.sendWechatMessage("clickMenu", customerDetailVo.getCustomerId(), map);
                    this.logger.info("\u5355\u51fb\u83dc\u5355\u63a8\u9001\u6d88\u606f:{}", (Object)baseJsonVo.isSuccess());
                } else if (Objects.equals(customerEntity.getIsNew(), 0)) {
                    List<WeekEnum> weekEnumList = WeekEnum.getList();
                    int index = this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue();
                    this.logger.info("\u4eca\u5929\u662f\u672c\u5468\u7b2c{}\u5929", (Object)index);
                    if (index <= 5) {
                        ArrayList<String> stringList = new ArrayList<String>();
                        stringList.add("\u4f1a\u5458\u65e5");
                        stringList.add("\u79d2\u6740\u65e5");
                        stringList.add("\u725b\u5976\u65e5");
                        stringList.add("\u5496\u5561\u65e5");
                        stringList.add("\u4ee3\u9910\u65e5");
                        String week = weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1).getName();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "");
                        map.put("day", (String)stringList.get(index - 1));
                        BaseJsonVo baseJsonVo = this.messageService.sendWechatMessage("clickMenu-old", customerDetailVo.getCustomerId(), map);
                        this.logger.info("\u5355\u51fb\u83dc\u5355\u63a8\u9001\u6d88\u606f:{}", (Object)baseJsonVo.isSuccess());
                    }
                }
            }
        }
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }
}

