/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.InteractionTypeEnum;
import cc.lechun.mall.entity.weixin.WeiXinMenuEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMenuInterface;
import cc.lechun.mall.service.weixin.reply.ManualMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="view_miniprogramMessage")
public class MiniPageMessageHandle
extends ManualMessage
implements ReplyMessageHandle {
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinMenuInterface weiXinMenuInterface;

    @Override
    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        super.pushCustomerMessage(eventMessage, platformId);
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u7528\u6237:{},\u5e73\u53f0:{}\u672a\u6ce8\u518c", (Object)eventMessage.getFromUserName(), (Object)platformId);
            return null;
        }
        WeiXinMenuEntity weiXinMenuEntity = this.weiXinMenuInterface.getMenuByPagePath(eventMessage.getEventKey());
        this.interactionInterface.saveCustomerInteractionAsync(customerDetailVo.getCustomerId(), 1, InteractionTypeEnum.CLICK_MENU.getValue(), weiXinMenuEntity != null ? weiXinMenuEntity.getMenuKey() : "", platformId);
        return null;
    }
}

