/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.tempqrcode.TempQrcodeContext;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component
public class ScanInfoMessage
extends WeiXinMessage {
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private TempQrcodeContext tempQrcodeContext;
    @Autowired
    private ActiveInviteInterface activeInviteService;

    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        this.logger.info("\u626b\u7801{},\u5e73\u53f0:{}", (Object)eventMessage.toString(), (Object)platformId);
        String scene = eventMessage.getEventKey().replace("qrscene_", "");
        if (StringUtils.isNotEmpty((String)scene)) {
            if (scene.length() >= 32) {
                ActiveEntity activeEntity;
                DictionaryEntity dic = this.dictionaryService.getDictionary(1000, 28, "2");
                String bindCode = "";
                if (dic == null || StringUtils.isEmpty((String)dic.getDictionaryName())) {
                    this.logger.info("\u5b57\u5178\u672a\u914d\u7f6e\u63a8\u9001\u4e8c\u7ef4\u7801\u6d3b\u52a8");
                    return null;
                }
                bindCode = dic.getDictionaryName();
                if (scene.equals(bindCode)) {
                    this.tempQrcodeContext.scanTempQrcode(eventMessage.getToUserName(), scene, platformId);
                    this.logger.info("scene={}", (Object)scene);
                }
                if ((activeEntity = this.activeService.getActiveEntityByQrcode(scene)) != null) {
                    BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
                    if (baseJsonVo.isSuccess()) {
                        ActiveQrcodeEntity qrcodeEntity = this.activeQrcodeService.getActiveQrcode(scene);
                        if (qrcodeEntity != null) {
                            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
                            if (customerDetailVo != null) {
                                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                                messageBody.put("userId", customerDetailVo.getCustomerId());
                                messageBody.put("dtFrom", qrcodeEntity.getQrcodeName());
                                messageBody.put("bindCode", scene);
                                messageBody.put("openId", eventMessage.getFromUserName());
                                messageBody.put("platformId", platformId);
                                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.scanCode, MessageParam.messageParam((String)customerDetailVo.getCustomerId(), messageBody));
                            }
                            if (activeEntity.getActiveType() == 28) {
                                String inviteId = this.activeInviteService.getActiveInviteDetailEntity(customerDetailVo.getCustomerId(), activeEntity.getBindCode()).getInviteId();
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("inviteId", inviteId == null ? "" : inviteId);
                                return this.pushMessage(eventMessage, qrcodeEntity.getKeywordId(), platformId, map);
                            }
                            return this.pushMessage(eventMessage, qrcodeEntity.getKeywordId(), platformId);
                        }
                        this.logger.info("\u627e\u4e0d\u5230\u4e8c\u7ef4\u7801\u5b9e\u4f53,scene={}", (Object)scene);
                    } else {
                        this.logger.info("\u6d3b\u52a8\u5df2\u8fc7\u671f\u6216\u672a\u542f\u7528\uff0c\u6d3b\u52a8\u5b9e\u4f53={}", (Object)activeEntity.getActiveNo());
                    }
                } else {
                    this.logger.info("\u6c38\u4e45\u4e2a\u4eba\u4e8c\u7ef4\u7801:{}", (Object)scene);
                    this.tempQrcodeContext.scanTempQrcode(eventMessage.getTicket(), eventMessage.getFromUserName(), scene, platformId, 2);
                }
            } else {
                this.logger.info("\u4e34\u65f6\u4e8c\u7ef4\u7801:{},ticket={}", (Object)scene, (Object)eventMessage.getTicket());
                if (eventMessage.getTicket() != null) {
                    this.tempQrcodeContext.scanTempQrcode(eventMessage.getTicket(), eventMessage.getFromUserName(), scene, platformId, 2);
                } else {
                    this.logger.info("\u626b\u7801:ticket\u4e3anull,\u4e34\u65f6\u4e8c\u7ef4\u7801:{},openId:{}", (Object)scene, (Object)eventMessage.getFromUserName());
                }
            }
        } else {
            this.logger.warn("\u626b\u7801\u503c\u4e3a\u7a7a:{}", (Object)eventMessage.toString());
        }
        return null;
    }
}

