/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.apiinvoke.baseservice.TaskInvoke;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.weixin.reply.ManualMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="keywordMessage")
public class WeiXinKeywordHandle
extends ManualMessage
implements ReplyMessageHandle {
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private TaskInvoke taskInvoke;

    @Override
    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        WeiXinKeywordEntity weiXinKeywordEntity;
        String inputContent = eventMessage.getContent().trim();
        this.logger.info("\u7528\u6237\u8f93\u5165\u5173\u952e\u5b57:{}", (Object)inputContent);
        if (inputContent.equals("\u4eba\u5de5") || inputContent.equals("\u4eba\u5de5\u5ba2\u670d") || inputContent.equals("\u8f6c\u4eba\u5de5")) {
            this.saveCustomerOnlineRecord(eventMessage, platformId, inputContent);
        }
        if (Objects.equals(inputContent, "\u53d6\u6d88") || Objects.equals(inputContent, "\u3010\u53d6\u6d88\u3011")) {
            this.cancelPlan(eventMessage, platformId);
        }
        if ((weiXinKeywordEntity = this.weiXinKeywordService.getKeywordByKeyword(inputContent, platformId)) == null) {
            if (this.checkIsExistOnline(eventMessage.getFromUserName())) {
                return null;
            }
            weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(699);
        }
        new Thread(() -> this.messageService.pushFixedTimeMessageByEvent(eventMessage, platformId)).start();
        HashSet<Integer> sended = new HashSet<Integer>();
        block0: for (int i = 0; i < 3 && sended.size() <= 3; ++i) {
            List<WeiXinKeywordEntity> subKeywords = this.weiXinKeywordService.getKeywordByParentID(weiXinKeywordEntity.getId());
            for (WeiXinKeywordEntity subKeyword : subKeywords) {
                if (sended.size() > 3) continue block0;
                if (sended.contains(subKeyword.getId())) continue;
                BaseJsonVo keywordContent = this.weiXinKeywordService.getKeywordContent(subKeyword.getId(), null);
                if (keywordContent.isSuccess()) {
                    Message value = (Message)keywordContent.getValue();
                    HashMap<Integer, Message> map = new HashMap<Integer, Message>();
                    map.put(1, value);
                    WeiXinKeywordEntity finalWeiXinKeywordEntity = weiXinKeywordEntity;
                    new Thread(() -> {
                        try {
                            Thread.currentThread();
                            Thread.sleep(200 * sended.size());
                        }
                        catch (InterruptedException e) {
                            this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5f02\u5e38\uff1a{}", (Object)subKeyword.getKeyword(), (Object)e);
                        }
                        BaseJsonVo baseJsonVo = this.messageService.sendWechatMessageBase(subKeyword.getPlatformId(), finalWeiXinKeywordEntity.getId(), eventMessage.getFromUserName(), map, true);
                        if (baseJsonVo.isSuccess()) {
                            this.logger.info("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u6210\u529f\uff1a{}", (Object)subKeyword.getKeyword(), (Object)baseJsonVo.getMessage());
                        } else {
                            this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5931\u8d25\uff1a{}", (Object)subKeyword.getKeyword(), (Object)baseJsonVo.getMessage());
                        }
                    }).start();
                    sended.add(subKeyword.getId());
                    continue;
                }
                this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5931\u8d25\uff1a{}", (Object)subKeyword.getKeyword(), (Object)"\u65e0\u6cd5\u67e5\u8be2\u5230\u5173\u952e\u5b57Content");
            }
        }
        return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId);
    }
}

