/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.OrderSource;
import cc.lechun.mall.service.youshu.OrderStatus;
import cc.lechun.mall.service.youshu.OrderType;
import cc.lechun.mall.service.youshu.PaymentType;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import weixin.popular.api.YouShuOrderAPI;
import weixin.popular.bean.advertisement.YouShuBaseResult;
import weixin.popular.bean.youshu.order.MainOrderData;
import weixin.popular.bean.youshu.order.ModifyOrder;
import weixin.popular.bean.youshu.order.OrderSum;
import weixin.popular.bean.youshu.order.OrderSumItem;
import weixin.popular.util.JsonUtil;

@Component
public class OrderDataService {
    @Value(value="${youshu.appid:bie5646769c6144de1}")
    private String app_id;
    @Value(value="${youshu.secret:3a1f49ae2b2e441b96abeaac8faa218f}")
    private String app_secret;
    @Value(value="${youshu.merchantId:10001378}")
    private String merchantId;
    @Value(value="${youshu.baseUrl:https://zhls.qq.com/}")
    private String baseUrl;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallGroupInterface mallGroupInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            return;
        }
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
        if (customerDetailVo == null) {
            this.logger.error("\u975e\u5fae\u4fe1\u6e20\u9053\u8ba2\u5355:{},customerId:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getCustomerId());
            return;
        }
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.main_order.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                List<MallOrderGroupProductEntity> productList = this.orderGroupProductInterface.getOrderGroupProductListByMianOrderNo(orderMainEntity.getOrderMainNo());
                String orderSource = one.getDictionaryName();
                MainOrderData mainOrderData = new MainOrderData();
                mainOrderData.setDataSourceId(orderSource);
                MainOrderData.Order order = new MainOrderData.Order();
                ArrayList<MainOrderData.Order> orders = new ArrayList<MainOrderData.Order>();
                mainOrderData.setOrders(orders);
                order.setCreate_time(String.valueOf(orderMainEntity.getCreateTime().getTime()));
                order.setExternal_order_id(orderMainEntity.getOrderMainNo());
                order.setFreight_amount(orderMainEntity.getFreight());
                order.setGoods_amount_total(PriceUtils.subtract((BigDecimal)orderMainEntity.getTotalAmount(), (BigDecimal)orderMainEntity.getFreight()));
                order.setPayment_amount(PriceUtils.add((BigDecimal)orderMainEntity.getOrderAmount(), (BigDecimal)orderMainEntity.getFreight()));
                order.setPayable_amount(orderMainEntity.getTotalAmount());
                if (orderMainEntity.getStatus() >= 4 && orderMainEntity.getStatus() < 16) {
                    order.setOrder_status(OrderStatus.getName(10));
                } else {
                    order.setOrder_status(OrderStatus.getName(orderMainEntity.getStatus()));
                }
                order.setStatus_change_time(String.valueOf(DateUtils.now().getTime()));
                int orderType = OrderType.common_order.getValue();
                if (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.CHARGE_ORDER.getValue() || orderMainEntity.getOrderSource() == 18 || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue()) {
                    orderType = OrderType.add_recharge_order.getValue();
                }
                order.setOrder_type(Integer.valueOf(orderType));
                order.setOrder_source(orderMainEntity.getPlatformId() == 1 ? OrderSource.mobileweb.getName() : (orderMainEntity.getPlatformId() == 4 ? OrderSource.wxapp.getName() : OrderSource.other.getName()));
                order.setOrder_amount(orderMainEntity.getTotalAmount());
                order.setGoods_num_total(Integer.valueOf(productList.stream().mapToInt(MallOrderGroupProductEntity::getQuantity).sum()));
                MainOrderData.UserInfo userInfo = new MainOrderData.UserInfo();
                userInfo.setOpen_id(customerDetailVo.getOpenId());
                userInfo.setUnion_id(customerDetailVo.getUnionid());
                userInfo.setUser_id(orderMainEntity.getCustomerId());
                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getWeixinBaseByFlatformId(orderMainEntity.getPlatformId());
                userInfo.setApp_id(weiXinBaseEntity.getAppid());
                order.setUser_info(userInfo);
                ArrayList goodsInfoList = new ArrayList();
                if (productList.size() > 0) {
                    productList.stream().collect(Collectors.toMap(MallOrderGroupProductEntity::getProductId, Function.identity(), (p1, p2) -> {
                        p1.setQuantity(p1.getQuantity() + p2.getQuantity());
                        p1.setOriginPriceSum(PriceUtils.add((BigDecimal)p1.getOriginPriceSum(), (BigDecimal)p2.getOriginPriceSum()));
                        return p1;
                    })).forEach((k, v) -> {
                        MainOrderData.GoodsInfo goodsInfo = new MainOrderData.GoodsInfo();
                        MallOrderGroupProductEntity orderGroupProductEntity = v;
                        goodsInfo.setExternal_sku_id(v.getProductId());
                        goodsInfo.setGoods_amount(orderGroupProductEntity.getUnitPrice());
                        goodsInfo.setGoods_num(orderGroupProductEntity.getQuantity());
                        goodsInfo.setPayment_amount(orderGroupProductEntity.getOriginPriceSum());
                        goodsInfo.setSku_name_chinese(orderGroupProductEntity.getProductName());
                        goodsInfo.setSpu_name_chinese(orderGroupProductEntity.getProductName());
                        goodsInfo.setExternal_spu_id(orderGroupProductEntity.getProductId());
                        goodsInfoList.add(goodsInfo);
                    });
                    order.setGoods_info(goodsInfoList);
                }
                ArrayList<MainOrderData.CouponInfo> couponInfoList = new ArrayList<MainOrderData.CouponInfo>();
                ArrayList<MainOrderData.PaymentInfo> paymentInfoList = new ArrayList<MainOrderData.PaymentInfo>();
                List<MallOrderPayEntity> orderPayList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
                if (orderPayList.size() > 0) {
                    BigDecimal couponAmount = BigDecimal.ZERO;
                    List<MallOrderPayEntity> cashPayList = orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PaymentType.coupon.getValue()).collect(Collectors.toList());
                    MainOrderData.CouponInfo couponInfo = new MainOrderData.CouponInfo();
                    if (cashPayList != null && cashPayList.size() > 0) {
                        couponInfo.setCoupon_amount_total(cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add));
                        couponInfo.setCoupon_type(Integer.valueOf(1));
                        couponInfoList.add(couponInfo);
                        order.setCoupon_info(couponInfoList);
                        ArrayList couponDetailList = new ArrayList();
                        cashPayList.forEach(orderPay -> {
                            MainOrderData.CouponDetail couponDetail = new MainOrderData.CouponDetail();
                            couponDetail.setExternal_coupon_id(String.valueOf(orderPay.getCashticketId()));
                            CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getCashticketCustomer(orderPay.getCashticketId());
                            couponDetail.setCoupon_batch_id(cashticketCustomerEntity == null ? "" : cashticketCustomerEntity.getTicketBatchId());
                            couponDetail.setCoupon_name(orderPay.getCashticketNo());
                            couponDetail.setCoupon_amount(orderPay.getPayamount());
                            couponDetailList.add(couponDetail);
                        });
                        couponInfo.setCoupon_detail(couponDetailList);
                        order.setCoupon_info(couponInfoList);
                    }
                    MainOrderData.PaymentInfo paymentInfo = new MainOrderData.PaymentInfo();
                    BigDecimal payAmount = orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
                        paymentInfo.setPayment_type(PaymentType.getName(orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).findFirst().get().getPaytypeId()));
                        paymentInfo.setTrans_id(orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).findFirst().get().getTradeNo());
                    } else {
                        payAmount = cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        paymentInfo.setTrans_amount(cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add));
                        paymentInfo.setPayment_type(PaymentType.getName(PaymentType.coupon.getValue()));
                        paymentInfo.setTrans_id(orderPayList.get(0).getTradeNo());
                    }
                    paymentInfo.setTrans_amount(payAmount);
                    order.setPayment_amount(payAmount);
                    paymentInfoList.add(paymentInfo);
                    order.setPayment_info(paymentInfoList);
                }
                order.setIs_deleted(Integer.valueOf(0));
                orders.add(order);
                data = JsonUtil.toJSONString((Object)mainOrderData);
                this.logger.info("\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
                YouShuBaseResult youShuBaseResult = YouShuOrderAPI.addOrder((String)this.baseUrl, (String)url, (String)data);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6709\u6570\u8ba2\u5355{}\u4e0a\u62a5\u51fa\u9519:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)e.getMessage());
        }
    }

    public void updateOrder(MallOrderMainEntity orderMainEntity) {
        try {
            if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                return;
            }
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.main_order.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                ModifyOrder modifyOrder = new ModifyOrder();
                modifyOrder.setDataSourceId(one.getDictionaryName());
                ModifyOrder.ModifyOrderItem modifyOrderItem = new ModifyOrder.ModifyOrderItem();
                modifyOrderItem.setExternal_order_id(orderMainEntity.getOrderMainNo());
                modifyOrderItem.setStatus_change_time(String.valueOf(DateUtils.now().getTime()));
                if (orderMainEntity.getStatus() >= 4 && orderMainEntity.getStatus() < 16) {
                    modifyOrderItem.setOrder_status(OrderStatus.getName(10));
                } else {
                    modifyOrderItem.setOrder_status(OrderStatus.getName(orderMainEntity.getStatus()));
                }
                ArrayList<ModifyOrder.ModifyOrderItem> list = new ArrayList<ModifyOrder.ModifyOrderItem>();
                list.add(modifyOrderItem);
                modifyOrder.setOrders(list);
                data = JsonUtil.toJSONString((Object)modifyOrder);
                this.logger.info("\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
                YouShuBaseResult youShuBaseResult = YouShuOrderAPI.updateOrder((String)this.baseUrl, (String)url, (String)data);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6709\u6570\u8ba2\u5355{}\u4e0a\u62a5\u51fa\u9519:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)e.getMessage());
        }
    }

    public void addOrderSum(Date date) {
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.add_order_sum.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                OrderSum orderSum = new OrderSum();
                orderSum.setDataSourceId(one.getDictionaryName());
                ArrayList<OrderSumItem> orders = new ArrayList<OrderSumItem>();
                OrderSumItem orderSumItem = new OrderSumItem();
                orderSumItem.setRef_date(String.valueOf(DateUtils.getAddDateByDay((Date)date, (int)-1).getTime()));
                List<Map<String, Object>> orderAmountSumList = this.orderMainInterface.getPayOrderSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 0);
                orderAmountSumList.forEach(item -> {
                    BigDecimal amount_sum = new BigDecimal(0);
                    if (item.get("amount_sum") != null) {
                        amount_sum = new BigDecimal(item.get("amount_sum").toString());
                    }
                    orderSumItem.setGive_order_amount_sum(amount_sum);
                });
                orderAmountSumList = this.orderMainInterface.getPayOrderSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 1);
                orderAmountSumList.forEach(item -> {
                    BigDecimal amount_sum = new BigDecimal(0);
                    if (item.get("amount_sum") != null) {
                        amount_sum = new BigDecimal(item.get("amount_sum").toString());
                    }
                    orderSumItem.setPayment_amount_sum(amount_sum);
                });
                List<Map<String, Object>> orderSumList = this.orderMainInterface.getOrderNumSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 0);
                orderSumList.forEach(item -> {
                    int orderNumSum = 0;
                    if (item.get("num_sum") != null) {
                        orderNumSum = Integer.valueOf(item.get("num_sum").toString());
                    }
                    orderSumItem.setGive_order_num_sum(Integer.valueOf(orderNumSum));
                });
                orderSumList = this.orderMainInterface.getOrderNumSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 1);
                orderSumList.forEach(item -> {
                    int orderNumSum = 0;
                    if (item.get("num_sum") != null) {
                        orderNumSum = Integer.valueOf(item.get("num_sum").toString());
                    }
                    orderSumItem.setPayed_num_sum(Integer.valueOf(orderNumSum));
                });
                orders.add(orderSumItem);
                orderSum.setOrders(orders);
                data = JsonUtil.toJSONString((Object)orderSum);
                this.logger.info("\u8ba2\u5355\u6c47\u603b\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
                YouShuBaseResult youShuBaseResult = YouShuOrderAPI.addOrderSum((String)this.baseUrl, (String)url, (String)data);
                this.logger.info("\u8ba2\u5355\u6c47\u603b\u4e0a\u62a5\u6570\u636e:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.addOrder(orderMainEntity);
    }

    public void updateOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.updateOrder(orderMainEntity);
    }
}

