/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import weixin.popular.api.YouShuProductCategoriesAPI;
import weixin.popular.api.YouShuSkuAPI;
import weixin.popular.api.YouShuSpuAPI;
import weixin.popular.bean.advertisement.YouShuBaseResult;
import weixin.popular.bean.youshu.product.ProductCategoryInfo;
import weixin.popular.bean.youshu.product.SkuInfo;
import weixin.popular.bean.youshu.product.SpuInfo;
import weixin.popular.util.JsonUtil;

@Component
public class ProductService {
    @Value(value="${youshu.appid:bie5646769c6144de1}")
    private String app_id;
    @Value(value="${youshu.secret:3a1f49ae2b2e441b96abeaac8faa218f}")
    private String app_secret;
    @Value(value="${youshu.merchantId:10001378}")
    private String merchantId;
    @Value(value="${youshu.baseUrl:https://zhls.qq.com/}")
    private String baseUrl;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private MallGroupInterface groupInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseJsonVo importYouShu(String productId) {
        return this.importYouShu(this.productInterface.getProduct(productId));
    }

    public BaseJsonVo importYouShu(MallProductEntity mallProductEntity) {
        List<String> listPicList;
        Map<String, List<String>> picMap = this.picService.getProductPicUrlMap(mallProductEntity.getProId(), SalesTypeEnum.SALES_PRODUCT.getValue());
        SkuInfo skuInfo = new SkuInfo();
        SkuInfo.Sku sku = new SkuInfo.Sku();
        sku.setExternal_sku_id(mallProductEntity.getProId());
        ArrayList<SkuInfo.ImgUrl> imgUrlList = new ArrayList<SkuInfo.ImgUrl>();
        SkuInfo.ImgUrl imgUrl = new SkuInfo.ImgUrl();
        List<String> headList = picMap.get(ProductPicTypeEnum.PRO_HEAD.getName());
        if (headList != null && headList.size() > 0) {
            ArrayList<SkuInfo.Imgs> imgsList = new ArrayList<SkuInfo.Imgs>();
            for (String string : headList) {
                SkuInfo.Imgs imgs = new SkuInfo.Imgs();
                imgs.setImg_url(string);
                imgsList.add(imgs);
            }
            imgUrl.setPrimary_imgs(imgsList);
        }
        if ((listPicList = picMap.get(ProductPicTypeEnum.PRO_LIST.getName())) != null && listPicList.size() > 0) {
            ArrayList<SkuInfo.Imgs> imgsList = new ArrayList<SkuInfo.Imgs>();
            for (String string : listPicList) {
                SkuInfo.Imgs imgs = new SkuInfo.Imgs();
                imgs.setImg_url(string);
                imgsList.add(imgs);
            }
            imgUrl.setImgs(imgsList);
        } else {
            List<String> smallList = picMap.get(ProductPicTypeEnum.PRO_SAMLL.getName());
            if (listPicList != null && listPicList.size() > 0) {
                ArrayList<SkuInfo.Imgs> arrayList = new ArrayList<SkuInfo.Imgs>();
                for (String listPicUrl : listPicList) {
                    SkuInfo.Imgs imgs = new SkuInfo.Imgs();
                    imgs.setImg_url(listPicUrl);
                    arrayList.add(imgs);
                }
                imgUrl.setImgs(arrayList);
            }
        }
        imgUrlList.add(imgUrl);
        sku.setImg_urls(imgUrlList);
        SkuInfo.DescProps descProps = new SkuInfo.DescProps();
        descProps.setProduct_name_chinese(mallProductEntity.getProName());
        sku.setDesc_props(descProps);
        SkuInfo.SalesProps salesProps = new SkuInfo.SalesProps();
        salesProps.setIs_available(mallProductEntity.getProState() == 1);
        sku.setSales_props(salesProps);
        sku.setExternal_created_time(String.valueOf(mallProductEntity.getCreateTime().getTime()));
        ArrayList<SkuInfo.Sku> arrayList = new ArrayList<SkuInfo.Sku>();
        arrayList.add(sku);
        skuInfo.setSkus(arrayList);
        this.addSku(skuInfo);
        return BaseJsonVo.success((Object)"");
    }

    @Async
    public BaseJsonVo importYouShu(Integer platformGroupId) {
        List<MallProductEntity> list = this.productInterface.getAllProductList(platformGroupId);
        if (list.size() > 0) {
            list.forEach(mallProduct -> this.importYouShu((MallProductEntity)mallProduct));
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo importSpuYouShu(String groupId) {
        return this.importSpuYouShu(this.groupInterface.getGroup(groupId));
    }

    public BaseJsonVo importSpuYouShu(MallProductGroupEntity mallProductGroupEntity) {
        SpuInfo spuInfo = new SpuInfo();
        SpuInfo.Spu spu = new SpuInfo.Spu();
        SpuInfo.SpuDescProp spuDescProp = new SpuInfo.SpuDescProp();
        spuDescProp.setProduct_name_chinese(mallProductGroupEntity.getGroupName());
        spu.setExternal_spu_id(mallProductGroupEntity.getGroupId());
        spu.setDesc_props(spuDescProp);
        ArrayList<SpuInfo.Spu> list = new ArrayList<SpuInfo.Spu>();
        list.add(spu);
        spuInfo.setSpus(list);
        this.addSpu(spuInfo);
        return BaseJsonVo.success((Object)"");
    }

    @Async
    public BaseJsonVo importSpuYouShu(Integer platformGroupId) {
        List<MallProductGroupEntity> list = this.groupInterface.findEnnableGroup(platformGroupId);
        list.forEach(group -> this.importSpuYouShu((MallProductGroupEntity)group));
        return BaseJsonVo.success((Object)"");
    }

    public void addSku(SkuInfo skuInfo) {
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.sku.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                String orderSource = one.getDictionaryName();
                skuInfo.setDataSourceId(orderSource);
                this.logger.info("sku \u4e0a\u62a5\u6570\u636e:{}", (Object)JsonUtil.toJSONString((Object)skuInfo));
                YouShuBaseResult youShuBaseResult = YouShuSkuAPI.addSku((String)this.baseUrl, (String)url, (SkuInfo)skuInfo);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSpu(SpuInfo spuInfo) {
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.spus.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                String orderSource = one.getDictionaryName();
                spuInfo.setDataSourceId(orderSource);
                this.logger.info("spu \u4e0a\u62a5\u6570\u636e:{}", (Object)JsonUtil.toJSONString((Object)spuInfo));
                YouShuBaseResult youShuBaseResult = YouShuSpuAPI.addSpu((String)this.baseUrl, (String)url, (SpuInfo)spuInfo);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCategory(ProductCategoryInfo productCategory) {
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            DictionaryEntity query = new DictionaryEntity();
            query.setDictionaryTypeId(213);
            query.setDictionaryKey(String.valueOf(DataSource.product_categories.getValue()));
            DictionaryEntity one = this.dictionaryInterface.getSingle(query);
            if (one != null) {
                String orderSource = one.getDictionaryName();
                productCategory.setDataSourceId(orderSource);
                this.logger.info("\u4e0a\u62a5\u5206\u7c7b \u6570\u636e:{}", (Object)JsonUtil.toJSONString((Object)productCategory));
                YouShuBaseResult youShuBaseResult = YouShuProductCategoriesAPI.addProductCategories((String)this.baseUrl, (String)url, (ProductCategoryInfo)productCategory);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

