/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationUtils {
    private static String key = "M24BZ-NNNK4-2PDUP-XZ3FU-FDGKT-7WBYZ";
    private static String gaodeKey = "60ad273ec1c38fbdedb172a46a7494fd";
    protected static Logger logger = LoggerFactory.getLogger(LocationUtils.class);

    public static Map getLocationAddress(double longitude, double latitude) {
        Map result;
        String url = "https://apis.map.qq.com/ws/geocoder/v1/?location=" + latitude + "," + longitude + "&key=" + key + "&output=JSON";
        String json = HttpRequest.get((String)url, (String)"");
        HashedMap areaMap = new HashedMap();
        Map map = JsonUtils.stringToMap((String)json);
        if (map != null && map.get("status").toString().equals("0") && (result = JsonUtils.stringToMap((String)map.get("result").toString())) != null) {
            Map map1 = JsonUtils.stringToMap((String)result.get("address_component").toString());
            String province = "";
            String city = "";
            String area = "";
            if (map1 != null) {
                province = map1.get("province");
                city = map1.get("city");
                area = map1.get("district");
            }
            areaMap.put("province", province);
            areaMap.put("city", city);
            areaMap.put("area", area);
            areaMap.put("address", result.get("address"));
            areaMap.put("lng", longitude);
            areaMap.put("lat", latitude);
        }
        return areaMap;
    }

    public static Map getLocationLngLat(String address, String area, String city, String province) {
        HashedMap res = new HashedMap();
        res.put("province", province);
        res.put("city", city);
        res.put("area", area);
        res.put("address", address);
        try {
            if (!address.isEmpty()) {
                address = address.replaceAll("(\r\n|\r|\n|\n\r)", "");
                logger.info("\u7ecf\u7eac\u5ea6\u8bf7\u6c42\u5730\u5740:" + province + city + area + address);
                String c = (province == null ? "" : province) + (city == null ? "" : city) + (area == null ? "" : area);
                String url = "https://apis.map.qq.com/ws/geocoder/v1/?key=" + key + "&address=" + c + address + (StringUtils.isNotEmpty((String)city) ? "&region=" + c : "") + "&output=JSON";
                logger.info("\u7ecf\u7eac\u5ea6\u8bf7\u6c42\u5730\u5740\uff1a" + url);
                String json = HttpRequest.get((String)url, (String)"");
                Map r = (Map)JsonUtils.fromJson((String)json, Map.class);
                if (r.get("status").equals(0)) {
                    Map map = (Map)r.get("result");
                    Map lnglat = (Map)map.get("location");
                    lnglat.put("province", province);
                    lnglat.put("city", city);
                    lnglat.put("area", area);
                    lnglat.put("address", address);
                    return lnglat;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7ecf\u7eac\u5ea6\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return res;
    }

    public static String getLocationLngLatByGaode(String address, String city) {
        try {
            Object location;
            List mapList;
            String url;
            String json;
            Map r;
            if (!address.isEmpty() && (r = (Map)JsonUtils.fromJson((String)(json = HttpRequest.get((String)(url = "https://restapi.amap.com/v3/geocode/geo?key=" + gaodeKey + "&address=" + address + "&city=" + city), (String)"")), Map.class)).get("status").equals("1") && (mapList = (List)r.get("geocodes")) != null && mapList.size() > 0 && (location = ((Map)mapList.get(0)).get("location")) != null && StringUtils.isNotEmpty((String)location.toString())) {
                return location.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static double distance(double x1, double y1, double x2, double y2) {
        double EARTH_RADIUS = 6378.137;
        double lat1 = Math.toRadians(y1);
        double lat2 = Math.toRadians(y2);
        double lng1 = Math.toRadians(x1);
        double lng2 = Math.toRadians(x2);
        double a = lat1 - lat2;
        double b = lng1 - lng2;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return BigDecimal.valueOf(s *= 6378.137).setScale(6, 4).doubleValue();
    }

    public static double getDistance(String address1, String address2) {
        String ll = LocationUtils.getLocationLngLatByGaode(address1, "");
        if (StringUtils.isEmpty((String)ll)) {
            return -1.0;
        }
        String[] s = ll.split(",");
        double x1 = Double.valueOf(s[0]);
        double y1 = Double.valueOf(s[1]);
        ll = LocationUtils.getLocationLngLatByGaode(address2, "");
        if (StringUtils.isEmpty((String)ll)) {
            return -1.0;
        }
        s = ll.split(",");
        double x2 = Double.valueOf(s[0]);
        double y2 = Double.valueOf(s[1]);
        return LocationUtils.distance(x1, y1, x2, y2);
    }
}

