/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.framework.common.utils.string.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class URLUtil {
    public static String getQueryMap(String query, String key) {
        try {
            String[] arr;
            if (StringUtils.isNotEmpty((String)query) && (arr = query.split("\\?")).length > 1) {
                String[] params = arr[1].split("&");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String param : params) {
                    String value;
                    if (!param.contains("=")) continue;
                    String[] paraArr = param.split("=");
                    String name = paraArr[0];
                    String string = value = paraArr.length > 1 ? param.split("=")[1] : "";
                    if (map.containsKey(name)) continue;
                    map.put(name, value);
                }
                return map.containsKey(key) ? (String)map.get(key) : "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static Map<String, Object> getParameterMap(String pageUrl) {
        try {
            String[] arr;
            if (StringUtils.isNotEmpty((String)pageUrl) && (arr = pageUrl.split("\\?")).length > 1) {
                String[] params = arr[1].split("&");
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String param : params) {
                    String value;
                    if (!param.contains("=")) continue;
                    String[] paraArr = param.split("=");
                    String name = paraArr[0];
                    String string = value = paraArr.length > 1 ? param.split("=")[1] : "";
                    if (map.containsKey(name)) continue;
                    map.put(name, value);
                }
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean hasPara(String query, String key) {
        try {
            String[] arr;
            if (StringUtils.isNotEmpty((String)query) && (arr = query.split("\\?")).length > 1) {
                String[] params = arr[1].split("&");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String param : params) {
                    String value;
                    if (!param.contains("=")) continue;
                    String[] paraArr = param.split("=");
                    String name = paraArr[0];
                    String string = value = paraArr.length > 1 ? param.split("=")[1] : "";
                    if (map.containsKey(name)) continue;
                    map.put(name, value);
                }
                return map.containsKey(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isURLExist(String url) {
        try {
            URL u = new URL(url);
            HttpURLConnection urlconn = (HttpURLConnection)u.openConnection();
            int state = urlconn.getResponseCode();
            return state == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getParamString(Map params) {
        StringBuffer queryString = new StringBuffer(256);
        Iterator it = params.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] param = (String[])params.get(key);
            for (int i = 0; i < param.length; ++i) {
                if (count == 0) {
                    ++count;
                } else {
                    queryString.append("&");
                }
                queryString.append(key);
                queryString.append("=");
                try {
                    queryString.append(URLEncoder.encode(param[i], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return queryString.toString();
    }

    public static String getRequestURL(HttpServletRequest request) {
        StringBuffer originalURL = new StringBuffer(request.getServletPath());
        Map parameters = request.getParameterMap();
        if (parameters != null && parameters.size() > 0) {
            originalURL.append("?");
            originalURL.append(URLUtil.getParamString(parameters));
        }
        return originalURL.toString();
    }

    public static String url2Str(String urlString) {
        try {
            String temp;
            StringBuffer html = new StringBuffer();
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            URLConnection c = url.openConnection();
            c.connect();
            String contentType = c.getContentType();
            String characterEncoding = null;
            int index = contentType.indexOf("charset=");
            characterEncoding = index == -1 ? "UTF-8" : contentType.substring(index + 8, contentType.length());
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), characterEncoding);
            BufferedReader br = new BufferedReader(isr);
            while ((temp = br.readLine()) != null) {
                html.append(temp).append("\n");
            }
            br.close();
            isr.close();
            return html.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String replaceParam(String urlTemp, Map<String, Object> paramMap) {
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = (String)entry.getValue();
            String check = key + "=?";
            String fill = key + "=" + value;
            boolean isExist = urlTemp.contains(check);
            if (isExist) {
                urlTemp = urlTemp.replace(check, fill);
            }
            String check1 = "#" + key;
            String fill1 = value;
            boolean isExist1 = urlTemp.contains(check1);
            if (!isExist1) continue;
            urlTemp = urlTemp.replace(check1, fill1);
        }
        if (urlTemp.matches(".*&.*=\\?.*")) {
            System.err.println("\u5b58\u5728\u672a\u66ff\u6362?\u53c2\u6570\uff0c\u6267\u884c\u53bb\u9664\u53c2\u6570\uff01");
            urlTemp = urlTemp.replaceAll("&[A-Za-z0-9_]*=\\?", "");
        }
        return urlTemp;
    }
}

