/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.jd;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.response.get.TraceDTO;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.etms.LdopReceiveTraceGetRequest;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdUtils.class);
    private static final String HEX_CHARACTERS = "0123456789ABCDEF";
    @Autowired
    private JdClient client;

    public BaseJsonVo<List<TraceDTO>> trace(String wayNo) throws Exception {
        LdopReceiveTraceGetRequest request = new LdopReceiveTraceGetRequest();
        request.setCustomerCode("010K2064972");
        request.setWaybillCode(wayNo);
        LdopReceiveTraceGetResponse response = (LdopReceiveTraceGetResponse)this.client.execute((JdRequest)request);
        logger.info("\u67e5\u8be2\u4eac\u4e1c\u7269\u6d41\u8fd4\u56de\uff1a{}", (Object)JsonUtils.toJson((Object)response, (boolean)false));
        return response != null && response.getQuerytraceResult() != null && response.getQuerytraceResult().getData() != null && response.getQuerytraceResult().getData().size() > 0 ? BaseJsonVo.success((Object)response.getQuerytraceResult().getData()) : BaseJsonVo.error((String)(wayNo + "\u672a\u83b7\u53d6\u5230\u7269\u6d41\u4fe1\u606f"));
    }

    public List<Map<String, Object>> buildBody(String orderId, String remark, String senderName, String senderMobile, String senderAddr, Date pickupStartTime, Date pickupEndTime) {
        String receiverName = "\u5218\u7ecf\u7406";
        String receiverMobile = "18911572551";
        String receiverAddr = "\u5317\u4eac\u5e02\u901a\u5dde\u533a\u878d\u5546\u4e09\u8def32\u53f7\u4eac\u4e1c\u51b7\u94fe";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderId", orderId);
        HashMap<String, String> senderContact = new HashMap<String, String>();
        senderContact.put("name", senderName);
        senderContact.put("mobile", senderMobile);
        senderContact.put("fullAddress", senderAddr);
        map.put("senderContact", senderContact);
        HashMap<String, String> receiverContact = new HashMap<String, String>();
        receiverContact.put("name", receiverName);
        receiverContact.put("mobile", receiverMobile);
        receiverContact.put("fullAddress", receiverAddr);
        map.put("receiverContact", receiverContact);
        HashMap<String, String> productsReq = new HashMap<String, String>();
        productsReq.put("productCode", "ed-m-0001");
        map.put("productsReq", productsReq);
        map.put("orderOrigin", 1);
        map.put("customerCode", "010K2064972");
        map.put("settleType", 3);
        ArrayList cargoes = new ArrayList();
        HashMap<String, Object> pro = new HashMap<String, Object>();
        pro.put("name", "\u9178\u5976\u676f");
        pro.put("quantity", 1);
        pro.put("weight", new BigDecimal("1.00"));
        pro.put("volume", new BigDecimal("1.00"));
        cargoes.add(pro);
        map.put("cargoes", cargoes);
        map.put("pickupStartTime", pickupStartTime.getTime());
        map.put("pickupEndTime", pickupEndTime.getTime());
        list.add(map);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public BaseJsonVo produce(String body) throws GeneralSecurityException, UnsupportedEncodingException, MalformedURLException {
        block66: {
            String baseUri = "https://api.jdl.com";
            String appKey = "aedc52fae12646aa94b46df7c804ee03";
            String appSecret = "983a5b4dd2834c00ad9fc5962c1cc93b";
            String accessToken = "a36a4cf57f2d436aabd66e3a89b51a78";
            String refreshToken = "363f1dd5149f4eacbb58890af9e30e2c";
            String domain = "ECAP";
            String path = "/ecap/v1/orders/create";
            String method = "POST";
            String algorithm = "md5-salt";
            String timestamp = DateUtils.now(null);
            String content = String.join((CharSequence)"", appSecret, "access_token", accessToken, "app_key", appKey, "method", path, "param_json", body, "timestamp", timestamp, "v", "2.0", appSecret);
            String sign = JdUtils.sign(algorithm, content.getBytes(StandardCharsets.UTF_8), appSecret.getBytes(StandardCharsets.UTF_8));
            String uri = baseUri + path;
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("LOP-DN", domain);
            query.put("app_key", appKey);
            query.put("access_token", accessToken);
            query.put("timestamp", timestamp);
            query.put("v", "2.0");
            query.put("sign", sign);
            query.put("algorithm", algorithm);
            logger.info("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012content:{}", (Object)JsonUtils.toJson((Object)content, (boolean)false));
            logger.info("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012query:{}", (Object)JsonUtils.toJson(query, (boolean)false));
            URL url = new URL(uri + "?" + JdUtils.httpBuildQuery(query));
            int offset = OffsetTime.now().getOffset().getTotalSeconds() / 3600;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("lop-tz", String.valueOf(offset));
            headers.put("User-Agent", "lop-http/java");
            HttpURLConnection connection = null;
            try {
                InputStream inputStream;
                Object header2;
                block61: {
                    BaseJsonVo baseJsonVo;
                    block64: {
                        block65: {
                            Map map;
                            block60: {
                                BaseJsonVo baseJsonVo2;
                                block62: {
                                    block63: {
                                        connection = (HttpURLConnection)url.openConnection();
                                        connection.setRequestMethod(method);
                                        connection.setDoInput(true);
                                        connection.setDoOutput(true);
                                        for (Object header2 : headers.entrySet()) {
                                            connection.setRequestProperty((String)header2.getKey(), (String)header2.getValue());
                                        }
                                        OutputStream outputStream = connection.getOutputStream();
                                        header2 = null;
                                        try {
                                            outputStream.write(body.getBytes(StandardCharsets.UTF_8));
                                        }
                                        catch (Throwable throwable) {
                                            header2 = throwable;
                                            throw throwable;
                                        }
                                        finally {
                                            if (outputStream != null) {
                                                if (header2 != null) {
                                                    try {
                                                        outputStream.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        ((Throwable)header2).addSuppressed(throwable);
                                                    }
                                                } else {
                                                    outputStream.close();
                                                }
                                            }
                                        }
                                        inputStream = connection.getInputStream();
                                        header2 = null;
                                        String resultStr = new String(JdUtils.readAllBytes(inputStream), StandardCharsets.UTF_8);
                                        logger.info("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012\u6210\u529f\uff1a{}", (Object)resultStr);
                                        map = (Map)JsonUtils.fromJson((String)resultStr, Map.class);
                                        if (!map.containsKey("code") || (Integer)map.get("code") != 0) break block60;
                                        if (!map.containsKey("data")) break block61;
                                        String waybillCode = (String)((Map)map.get("data")).get("waybillCode");
                                        baseJsonVo2 = BaseJsonVo.success((Object)waybillCode);
                                        if (inputStream == null) break block62;
                                        if (header2 == null) break block63;
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)header2).addSuppressed(throwable);
                                        }
                                        break block62;
                                    }
                                    inputStream.close();
                                }
                                return baseJsonVo2;
                            }
                            if (!map.containsKey("msg")) break block61;
                            String errMsg = (String)map.get("msg");
                            if (map.containsKey("subMsg")) {
                                errMsg = errMsg + (String)map.get("subMsg");
                            }
                            baseJsonVo = BaseJsonVo.error((String)errMsg);
                            if (inputStream == null) break block64;
                            if (header2 == null) break block65;
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)header2).addSuppressed(throwable);
                            }
                            break block64;
                        }
                        inputStream.close();
                    }
                    return baseJsonVo;
                }
                try {
                    if (inputStream != null) {
                        if (header2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)header2).addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                    break block66;
                    {
                        catch (Throwable throwable) {
                            try {
                                header2 = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (inputStream != null) {
                                    if (header2 != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)header2).addSuppressed(throwable3);
                                        }
                                    } else {
                                        inputStream.close();
                                    }
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    try (InputStream errorStream = connection.getErrorStream();){
                        logger.error("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012\u5931\u8d25\uff1a{}", (Object)new String(JdUtils.readAllBytes(errorStream), StandardCharsets.UTF_8));
                        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)new String(JdUtils.readAllBytes(errorStream), StandardCharsets.UTF_8));
                        return baseJsonVo;
                    }
                }
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return BaseJsonVo.error((String)"\u547c\u53eb\u5931\u8d25\uff0c\u539f\u56e0\u672a\u77e5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public BaseJsonVo cancle(String waybillCode) throws GeneralSecurityException, UnsupportedEncodingException, MalformedURLException {
        block64: {
            String baseUri = "https://api.jdl.com";
            String appKey = "aedc52fae12646aa94b46df7c804ee03";
            String appSecret = "983a5b4dd2834c00ad9fc5962c1cc93b";
            String accessToken = "a36a4cf57f2d436aabd66e3a89b51a78";
            String refreshToken = "363f1dd5149f4eacbb58890af9e30e2c";
            String domain = "ECAP";
            String path = "/ecap/v1/orders/create";
            String method = "POST";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("waybillCode", waybillCode);
            map.put("orderOrigin", "1");
            map.put("customerCode", "010K2064972");
            map.put("cancelReason", "\u7528\u6237\u53d6\u6d88");
            map.put("cancelReasonCode", "1");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            String body = JsonUtils.toJson(list, (boolean)false);
            String algorithm = "md5-salt";
            String timestamp = DateUtils.now(null);
            String content = String.join((CharSequence)"", appSecret, "access_token", accessToken, "app_key", appKey, "method", path, "param_json", body, "timestamp", timestamp, "v", "2.0", appSecret);
            String sign = JdUtils.sign(algorithm, content.getBytes(StandardCharsets.UTF_8), appSecret.getBytes(StandardCharsets.UTF_8));
            String uri = baseUri + path;
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("LOP-DN", domain);
            query.put("app_key", appKey);
            query.put("access_token", accessToken);
            query.put("timestamp", timestamp);
            query.put("v", "2.0");
            query.put("sign", sign);
            query.put("algorithm", algorithm);
            logger.info("\u53d6\u6d88\u4eac\u4e1c\u5feb\u9012body:{}", (Object)JsonUtils.toJson((Object)body, (boolean)false));
            logger.info("\u53d6\u6d88\u4eac\u4e1c\u5feb\u9012content:{}", (Object)JsonUtils.toJson((Object)content, (boolean)false));
            logger.info("\u53d6\u6d88\u4eac\u4e1c\u5feb\u9012query:{}", (Object)JsonUtils.toJson(query, (boolean)false));
            URL url = new URL(uri + "?" + JdUtils.httpBuildQuery(query));
            int offset = OffsetTime.now().getOffset().getTotalSeconds() / 3600;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("lop-tz", String.valueOf(offset));
            headers.put("User-Agent", "lop-http/java");
            HttpURLConnection connection = null;
            try {
                InputStream inputStream;
                Object header2;
                block61: {
                    BaseJsonVo baseJsonVo;
                    block62: {
                        block63: {
                            Map resultMap;
                            block58: {
                                BaseJsonVo baseJsonVo2;
                                block59: {
                                    block60: {
                                        connection = (HttpURLConnection)url.openConnection();
                                        connection.setRequestMethod(method);
                                        connection.setDoInput(true);
                                        connection.setDoOutput(true);
                                        for (Object header2 : headers.entrySet()) {
                                            connection.setRequestProperty((String)header2.getKey(), (String)header2.getValue());
                                        }
                                        OutputStream outputStream = connection.getOutputStream();
                                        header2 = null;
                                        try {
                                            outputStream.write(body.getBytes(StandardCharsets.UTF_8));
                                        }
                                        catch (Throwable throwable) {
                                            header2 = throwable;
                                            throw throwable;
                                        }
                                        finally {
                                            if (outputStream != null) {
                                                if (header2 != null) {
                                                    try {
                                                        outputStream.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        ((Throwable)header2).addSuppressed(throwable);
                                                    }
                                                } else {
                                                    outputStream.close();
                                                }
                                            }
                                        }
                                        inputStream = connection.getInputStream();
                                        header2 = null;
                                        String resultStr = new String(JdUtils.readAllBytes(inputStream), StandardCharsets.UTF_8);
                                        logger.info("\u53d6\u6d88\u4eac\u4e1c\u5feb\u9012\u6210\u529f\uff1a{}", (Object)resultStr);
                                        resultMap = (Map)JsonUtils.fromJson((String)resultStr, Map.class);
                                        if (!resultMap.containsKey("code") || (Integer)resultMap.get("code") != 0) break block58;
                                        baseJsonVo2 = BaseJsonVo.success(null);
                                        if (inputStream == null) break block59;
                                        if (header2 == null) break block60;
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)header2).addSuppressed(throwable);
                                        }
                                        break block59;
                                    }
                                    inputStream.close();
                                }
                                return baseJsonVo2;
                            }
                            if (!resultMap.containsKey("msg")) break block61;
                            baseJsonVo = BaseJsonVo.error((String)((String)resultMap.get("msg")));
                            if (inputStream == null) break block62;
                            if (header2 == null) break block63;
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)header2).addSuppressed(throwable);
                            }
                            break block62;
                        }
                        inputStream.close();
                    }
                    return baseJsonVo;
                }
                try {
                    if (inputStream != null) {
                        if (header2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)header2).addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                    break block64;
                    {
                        catch (Throwable throwable) {
                            try {
                                header2 = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (inputStream != null) {
                                    if (header2 != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)header2).addSuppressed(throwable3);
                                        }
                                    } else {
                                        inputStream.close();
                                    }
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    try (InputStream errorStream = connection.getErrorStream();){
                        logger.error("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012\u5931\u8d25\uff1a{}", (Object)new String(JdUtils.readAllBytes(errorStream), StandardCharsets.UTF_8));
                    }
                }
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return BaseJsonVo.error((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\u672a\u77e5");
    }

    private static String sign(String algorithm, byte[] data, byte[] secret) throws GeneralSecurityException {
        if (Objects.equals(algorithm, "md5-salt")) {
            return JdUtils.bytesToHex(MessageDigest.getInstance("md5").digest(data));
        }
        if (Objects.equals(algorithm, "HMacMD5")) {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secret, algorithm));
            return Base64.getEncoder().encodeToString(mac.doFinal(data));
        }
        if (Objects.equals(algorithm, "HMacSHA1")) {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secret, algorithm));
            return Base64.getEncoder().encodeToString(mac.doFinal(data));
        }
        if (Objects.equals(algorithm, "HMacSHA256")) {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secret, algorithm));
            return Base64.getEncoder().encodeToString(mac.doFinal(data));
        }
        if (Objects.equals(algorithm, "HMacSHA512")) {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secret, algorithm));
            return Base64.getEncoder().encodeToString(mac.doFinal(data));
        }
        throw new GeneralSecurityException("Algorithm " + algorithm + " not supported yet");
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            stringBuilder.append(HEX_CHARACTERS.charAt(b >>> 4 & 0xF));
            stringBuilder.append(HEX_CHARACTERS.charAt(b & 0xF));
        }
        return stringBuilder.toString();
    }

    public static String httpBuildQuery(Map<String, String> query) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : query.entrySet()) {
            if (!first) {
                stringBuilder.append("&");
            } else {
                first = false;
            }
            stringBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
        }
        return stringBuilder.toString();
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((n = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, n);
        }
        return outputStream.toByteArray();
    }
}

