/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.shunfeng;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.reunion.sfExpress.Order;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.utils.shunfeng.ShunFenConfig;
import cc.lechun.utils.shunfeng.entity.Route;
import cc.lechun.utils.shunfeng.entity.SfCallbackRequest;
import cc.lechun.utils.shunfeng.entity.WaybillRoute;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sf.csim.express.service.CallExpressServiceTools;
import com.sf.csim.express.service.EspServiceCode;
import com.sf.csim.express.service.HttpClientUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShunFenUtils {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ShunFenConfig shunFenConfig;

    public BaseJsonVo produce(Order order) {
        this.logger.info("\u987a\u4e30\u4e0b\u5355\u65b9\u6cd5\u8c03\u7528\u53c2\u6570\uff1a{}", (Object)JsonUtils.toJson((Object)order, (boolean)false));
        if (StringUtils.isEmpty((String)order.getOrderId())) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EspServiceCode testService = EspServiceCode.EXP_RECE_CREATE_ORDER;
        CallExpressServiceTools client = CallExpressServiceTools.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String msgData = JsonUtils.toJson((Object)order, (boolean)false);
        params.put("partnerID", this.shunFenConfig.clientCode);
        params.put("requestID", UUID.randomUUID().toString().replace("-", ""));
        params.put("serviceCode", testService.getCode());
        params.put("timestamp", timeStamp);
        params.put("msgData", msgData);
        try {
            params.put("msgDigest", CallExpressServiceTools.getMsgDigest((String)msgData, (String)timeStamp, (String)this.shunFenConfig.checkword));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u7ec4\u7ec7\u53c2\u6570msgDigest\u5904\u7406\u5f02\u5e38", (Throwable)e);
            return BaseJsonVo.error((String)"\u987a\u4e30\u4e0b\u5355\u7ec4\u7ec7\u53c2\u6570msgDigest\u5904\u7406\u5f02\u5e38");
        }
        long startTime = System.currentTimeMillis();
        this.logger.info("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3,\u53c2\u6570\uff1a{}", (Object)JsonUtils.toJson(params, (boolean)false));
        String result = null;
        try {
            result = HttpClientUtil.post((String)this.shunFenConfig.accessUrl, params);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return BaseJsonVo.error((String)"\u987a\u4e30\u4e0b\u5355\u8c03\u7528\u63a5\u53e3\u5f02\u5e38");
        }
        this.logger.info("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3,\u8fd4\u56de\u503c\uff1a{}", (Object)result);
        try {
            JSONObject jsonobj = JSON.parseObject((String)result);
            JSONObject apiResultData = JSON.parseObject((String)jsonobj.get((Object)"apiResultData").toString());
            if (apiResultData.getBoolean("success").booleanValue()) {
                String waynoStr = apiResultData.getJSONObject("msgData").getJSONArray("waybillNoInfoList").get(0).toString();
                this.logger.info("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3,\u83b7\u53d6\u5230\u7684\u7269\u6d41\u5b57\u7b26\u4e32\uff1a{}", (Object)waynoStr);
                Map map = (Map)JSONObject.parseObject((String)waynoStr, Map.class);
                if (map.containsKey("waybillNo")) {
                    return BaseJsonVo.success(map.get("waybillNo"));
                }
                this.logger.error("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4f46\u662f\u65e0\u6cd5\u622a\u53d6\u5230waybillNo\uff1a{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
                return BaseJsonVo.error((String)"\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4f46\u662f\u65e0\u6cd5\u622a\u53d6\u5230waybillNo");
            }
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u5931\u8d25:{}", (Object)result);
            return BaseJsonVo.error((String)"\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u503c\u5904\u7406\u5f02\u5e38\uff0c\u8fd4\u56de\u503c:{}", (Object)result, (Object)e);
            return BaseJsonVo.error((String)"\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u503c\u5904\u7406\u5f02\u5e38");
        }
    }

    public BaseJsonVo produce(MallOrderEntity order) throws UnsupportedEncodingException {
        EspServiceCode testService = EspServiceCode.EXP_RECE_CREATE_ORDER;
        CallExpressServiceTools client = CallExpressServiceTools.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String msgData = "{\n    \"cargoDetails\":[\n        {          \n            \"count\":2.365,\n\t\t\t\"unit\":\"\u4e2a\",\n\t\t\t\"weight\":6.1,\n\t\t\t\"amount\":100.5111,\n            \"currency\":\"HKD\",\n            \"name\":\"\u62a4\u80a4\u54c11\",           \n            \"sourceArea\":\"CHN\"          \n        }],\n    \"contactInfoList\":\t[\n        {\n            \"address\":\"\u5e7f\u4e1c\u7701\u6df1\u5733\u5e02\u5357\u5c71\u533a\u8f6f\u4ef6\u4ea7\u4e1a\u57fa\u573011\u680b\",\n            \"contact\":\"\u5c0f\u66fe\",\n            \"contactType\":1,\n            \"country\":\"CN\",\n            \"postCode\":\"580058\",\n            \"tel\":\"4006789888\"\n        },\n        {\n            \"address\":\"\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u767d\u4e91\u533a\u6e56\u5317\u5927\u53a6\",\n            \"company\":\"\u987a\u4e30\u901f\u8fd0\",\n            \"contact\":\"\u5c0f\u90b1\",\n            \"contactType\":2,\n            \"country\":\"CN\",\n            \"postCode\":\"580058\",\n            \"tel\":\"18688806017\"\n        }],\n    \"language\":\"zh_CN\",\n    \"orderId\":\"" + UUID.randomUUID().toString() + "\"\n}";
        params.put("partnerID", this.shunFenConfig.clientCode);
        params.put("requestID", UUID.randomUUID().toString().replace("-", ""));
        params.put("serviceCode", testService.getCode());
        params.put("timestamp", timeStamp);
        params.put("msgData", msgData);
        params.put("msgDigest", CallExpressServiceTools.getMsgDigest((String)msgData, (String)timeStamp, (String)this.shunFenConfig.checkword));
        long startTime = System.currentTimeMillis();
        System.out.println("====\u8c03\u7528\u8bf7\u6c42\uff1a" + (String)params.get("msgData"));
        String result = HttpClientUtil.post((String)this.shunFenConfig.accessUrl, params);
        System.out.println("\u54cd\u5e94\u62a5\u6587\uff1a" + result);
        return BaseJsonVo.success((Object)"");
    }

    public List<Route> trace(String expressNumber, String phone) throws UnsupportedEncodingException {
        EspServiceCode testService = EspServiceCode.EXP_RECE_SEARCH_ROUTES;
        CallExpressServiceTools client = CallExpressServiceTools.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String phone4 = StringUtils.isEmpty((String)phone) ? "" : phone.substring(phone.length() - 4, phone.length());
        String msgData = "{\n\t\"language\": \"0\",\n\t\"trackingType\": \"1\",\n\t\"trackingNumber\": [\"" + expressNumber + "\"],\n\t\"methodType\": \"1\",\n\t\"checkPhoneNo\": \"" + phone4 + "\"\n}";
        params.put("partnerID", this.shunFenConfig.clientCode);
        params.put("requestID", UUID.randomUUID().toString().replace("-", ""));
        params.put("serviceCode", testService.getCode());
        params.put("timestamp", timeStamp);
        params.put("msgData", msgData);
        params.put("msgDigest", CallExpressServiceTools.getMsgDigest((String)msgData, (String)timeStamp, (String)this.shunFenConfig.checkword));
        long startTime = System.currentTimeMillis();
        System.out.println("====\u8c03\u7528\u8bf7\u6c42\uff1a" + (String)params.get("msgData"));
        String result = HttpClientUtil.post((String)this.shunFenConfig.accessUrl, params);
        System.out.println("\u54cd\u5e94\u62a5\u6587\uff1a" + result);
        try {
            JSONObject jsonobj = JSON.parseObject((String)result);
            JSONObject apiResultData = JSON.parseObject((String)jsonobj.get((Object)"apiResultData").toString());
            if (apiResultData.getBoolean("success").booleanValue()) {
                JSONArray routes = apiResultData.getJSONObject("msgData").getJSONArray("routeResps").getJSONObject(0).getJSONArray("routes");
                List list = JSONObject.parseArray((String)routes.toJSONString(), Route.class);
                for (int i = 0; i < list.size(); ++i) {
                    Route route = (Route)list.get(i);
                    System.out.println("-----------\u8def\u7531\u6d88\u606f\u7b2c" + i + "\u6761\uff1a-------------");
                    System.out.println("\u53d1\u751f\u65f6\u95f4\uff1a" + route.getAcceptTime());
                    System.out.println("\u8282\u70b9\u64cd\u4f5c\u7801\uff1a" + route.getOpcode());
                    System.out.println("\u5177\u4f53\u63cf\u8ff0\uff1a" + route.getRemark());
                }
                return list.stream().sorted(Comparator.comparing(Route::getAcceptTime).reversed()).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<Route>();
    }

    public List<WaybillRoute> shunFengCallback(SfCallbackRequest request) {
        try {
            if (request != null) {
                ArrayList<WaybillRoute> lst = new ArrayList<WaybillRoute>(Arrays.asList(request.getBody().getWaybillRoute()));
                return lst.stream().sorted(Comparator.comparing(WaybillRoute::getAcceptTime).reversed()).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

