/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.yunda;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.utils.yunda.YundaConfig;
import cc.lechun.utils.yunda.entity.OrderVo;
import cc.lechun.utils.yunda.entity.QueryVo;
import cc.lechun.utils.yunda.entity.ReceiverVO;
import cc.lechun.utils.yunda.entity.ScribeResult;
import com.yundasys.api.DefaultOpenapiClient;
import com.yundasys.api.OpenapiException;
import com.yundasys.api.OpenapiRequest;
import com.yundasys.api.request.OpenApiDefaultRequest;
import com.yundasys.api.response.OpenApiDefaultResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class YundaUtils {
    @Autowired
    private YundaConfig yundaConfig;
    private static final Logger log = LoggerFactory.getLogger(YundaUtils.class);

    public BaseJsonVo scribe(List<MallOrderEntity> mallOrderEntities) {
        ScribeResult scribeResult;
        QueryVo queryVo = this.buildParams(mallOrderEntities);
        OpenApiDefaultResponse response = this.jsonObjResponse(queryVo);
        if (null != response && response.isSuccess() && (scribeResult = (ScribeResult)ObjectConvert.mapConvertToObject((Map)response.getData(), ScribeResult.class)) != null) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u8ba2\u9605\u5f02\u5e38");
    }

    public BaseJsonVo scribe(MallOrderEntity mallOrderEntity) {
        if (mallOrderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        ArrayList<MallOrderEntity> mallOrderEntities = new ArrayList<MallOrderEntity>();
        mallOrderEntities.add(mallOrderEntity);
        return this.scribe(mallOrderEntities);
    }

    private QueryVo buildParams(List<MallOrderEntity> mallOrderEntities) {
        if (mallOrderEntities == null) {
            return null;
        }
        QueryVo queryVo = new QueryVo();
        ArrayList<OrderVo> orders = new ArrayList<OrderVo>();
        for (MallOrderEntity orderEntity : mallOrderEntities) {
            if (!StringUtils.isNotEmpty((String)orderEntity.getWaybillNo())) continue;
            OrderVo orderVo = new OrderVo();
            orderVo.setOrderid(orderEntity.getOrderNo());
            orderVo.setMailno(orderEntity.getWaybillNo());
            ReceiverVO receiverVO = new ReceiverVO();
            receiverVO.setAddress(orderEntity.getConsigneeAddr());
            receiverVO.setCity(orderEntity.getConsigneeCityname());
            receiverVO.setCounty("\u4e2d\u56fd");
            receiverVO.setName(orderEntity.getConsigneeName());
            receiverVO.setPhone(orderEntity.getConsigneePhone());
            receiverVO.setProvince(orderEntity.getConsigneeProvincename());
            orderVo.setReceiver(receiverVO);
            orders.add(orderVo);
        }
        queryVo.setOrders(orders);
        return queryVo;
    }

    private OpenApiDefaultResponse jsonObjResponse(Object paramVo) {
        DefaultOpenapiClient defaultOpenapiClient = new DefaultOpenapiClient(this.yundaConfig.url, this.yundaConfig.app_key, this.yundaConfig.app_secret);
        defaultOpenapiClient.setConnectTimeout(60000);
        defaultOpenapiClient.setReadTimeout(45000);
        String sourceContent = JsonUtils.toJson((Object)paramVo, (boolean)false);
        String sign = defaultOpenapiClient.getSigner().sign(sourceContent, "MD5", "UTF-8");
        OpenApiDefaultRequest defaultRequest = new OpenApiDefaultRequest(this.yundaConfig.app_key, sign);
        defaultRequest.setBizContent(sourceContent);
        defaultRequest.addHeaderMap("Content-Type", "application/json;charset=UTF-8");
        OpenApiDefaultResponse defaultResponse = null;
        try {
            defaultResponse = (OpenApiDefaultResponse)defaultOpenapiClient.excute((OpenapiRequest)defaultRequest);
            if (null != defaultResponse && defaultResponse.isSuccess()) {
                System.out.println("\u8c03\u7528\u6210\u529f");
            } else {
                System.err.println("\u8c03\u7528\u5931\u8d25");
            }
            return defaultResponse;
        }
        catch (OpenapiException e) {
            e.printStackTrace();
            return null;
        }
    }
}

