/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.entity.Cash.CustomerCashVo;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveCashticketRuleEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveTakeTypeEnum;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.form.cash.CustomerCashticketQuaryForm;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCashticketRuleInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActivePvInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.active.cash_rule.ActiveCashticketRuleCheckInterface;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class ActiveCashticketService
extends ActiveBaseService
implements ActiveCashticketInterface {
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private PaySuccessMessageInterface paySuccessMessageInterface;
    @Autowired
    DistributionInviteInterface distributionInviteInterface;
    @Lazy
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private ActivePvInterface activePvService;
    @Lazy
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private ActiveCashticketRuleInterface activeCashticketRuleInterface;
    @Lazy
    @Autowired
    private CustomerInterface customerInterface;
    private Map<String, ActiveCashticketRuleCheckInterface> checkHandl = new ConcurrentHashMap<String, ActiveCashticketRuleCheckInterface>();

    @Autowired
    public ActiveCashticketService(Map<String, ActiveCashticketRuleCheckInterface> checkHandl) {
        this.checkHandl.clear();
        checkHandl.forEach((k, v) -> this.checkHandl.put((String)k, (ActiveCashticketRuleCheckInterface)v));
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, String customerId, CashStatusEnum cashStatusEnum) {
        return this.cashticketCustomerService.updateCashticketStatus(ticketId, customerId, cashStatusEnum);
    }

    @Override
    public BaseJsonVo sendCashticketByTicketBatchId(String customerId, String ticketBatchId, Integer platFormId) {
        return this.cashticketInterface.convertByTicketBatchId(customerId, platFormId == null ? 1 : platFormId, ticketBatchId);
    }

    @Override
    public List<Integer> getCashticketTicketId(String bindCode, String customerId) {
        try {
            return this.cashticketCustomerService.getCashticketTicketId(bindCode, customerId);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u627e\u7528\u6237\u4f18\u60e0\u5238\u5f02\u5e38", (Throwable)e);
            return new ArrayList<Integer>();
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType) {
        return this.activeCashticketMapper.getRedpackageConfigVoList(activeNo, activeType);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=600)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType, @ParameterValueKeyProvider(order=2) Integer shareCount) {
        List<RedpackageConfigDetailVo> list = this.getRedpackageConfigVoList(activeNo, activeType);
        if (list != null) {
            return list.stream().filter(c -> c.getUserType().intValue() == shareCount.intValue()).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketByBindCode", expiration=300)
    public ActiveCashticketVo getCashticketByBindCode(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getCashticketByBindCode(bindCode);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketListByBindCode", expiration=600)
    public BaseJsonVo getCashticketListByBindCode(@ParameterValueKeyProvider String bindCode) {
        return BaseJsonVo.success(this.activeCashticketMapper.getCashticketListByBindCode(bindCode));
    }

    @Override
    public BaseJsonVo sendTicket4CustomerType(String customerId, String bindCode, String versionDetailId, Integer platFormId, Integer platformGroupId, boolean isSendMessage) {
        return this.sendTicket4CustomerType(customerId, bindCode, versionDetailId, platFormId, platformGroupId, isSendMessage, 0, null);
    }

    @Override
    public BaseJsonVo sendTicket4CustomerType(String customerId, String bindCode, String versionDetailId, Integer platFormId, Integer platformGroupId, boolean isSendMessage, Integer orderNum, String code) {
        BaseJsonVo vo;
        boolean flag;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        boolean bl = flag = Objects.equals((int)activeEntity.getActiveType(), 15) || Objects.equals((int)activeEntity.getActiveType(), 41) || Objects.equals((int)activeEntity.getActiveType(), 52) || Objects.equals((int)activeEntity.getActiveType(), 55);
        if (!flag) {
            this.logger.error("\u6d3b\u52a8:{},\u7528\u6237\uff1a{}\u4e0d\u5141\u8bb8\u9886\u53d6\u4f18\u60e0\u5238", (Object)activeEntity.getActiveName(), (Object)customerId);
            return BaseJsonVo.error((String)"\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u65e0\u6548\u7684\u6d3b\u52a8\u7c7b\u578b");
        }
        if (activeEntity.getActiveType() == 52) {
            if (!this.activePvService.getActivePv(bindCode, customerId)) {
                this.logger.error("\u6d3b\u52a8:{},\u7528\u6237\uff1a{}\u6ca1\u6709\u4e2d\u8f6c\u9875\u8bbf\u95ee\u8bb0\u5f55 \u4e0d\u5141\u8bb8\u9886\u53d6\u4f18\u60e0\u5238", (Object)activeEntity.getActiveName(), (Object)customerId);
                return BaseJsonVo.error((String)"\u9886\u53d6\u5931\u8d25!");
            }
            ActiveInviteEntity query = new ActiveInviteEntity();
            query.setCustomerId(customerId);
            query.setBindCode(bindCode);
            ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(query);
            if (activeInviteEntity != null) {
                return BaseJsonVo.error((String)"\u9886\u53d6\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u5df2\u9886\u53d6!");
            }
        }
        if (!(vo = this.activeCashticketService.sendTicket4Base(customerId, bindCode, versionDetailId, platFormId, isSendMessage, code, "")).isSuccess()) {
            return vo;
        }
        Pair map = (Pair)vo.getValue();
        PageForm pageForm = new PageForm();
        int size = 100;
        BaseJsonVo baseJsonVo = this.activeCashticketService.getCashticketListByBindCode(bindCode);
        if (baseJsonVo.isSuccess()) {
            List cashticketVoList = (List)baseJsonVo.getValue();
            size = cashticketVoList.size();
        }
        pageForm.setPageSize(size);
        pageForm.setCurrentPage(1);
        CustomerCashticketQuaryForm customerCashticketQuaryForm = new CustomerCashticketQuaryForm();
        customerCashticketQuaryForm.setBindCode(bindCode);
        customerCashticketQuaryForm.setCustomerId(customerId);
        CustomerCashVo customerCashVo = new CustomerCashVo();
        customerCashVo.setTakedDesc((String)map.getFirst());
        customerCashVo.setTicketAmount(BigDecimal.ZERO);
        if (Objects.equals(map.getSecond(), ActiveTakeTypeEnum.cash.getValue()) || Objects.equals(map.getSecond(), ActiveTakeTypeEnum.cash_balance.getValue())) {
            List<CashticketVo> cashticketVos = this.cashticketCustomerService.getTakedCashticketList(pageForm, platformGroupId, customerId, bindCode);
            customerCashVo.setCashDetailVos(cashticketVos);
            cashticketVos.forEach(c -> {
                if (c.getDiscountMode() == 0) {
                    customerCashVo.setTicketAmount(customerCashVo.getTicketAmount().add(c.getTicketAmount()));
                }
            });
        }
        vo.setValue((Object)customerCashVo);
        if (bindCode.equals("ba5a156234284999956a4fa98413abab")) {
            this.activeCashticketMapper.updateCustomerDomain(customerId);
        }
        return vo;
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, String code, String ncpBat) {
        return this.activeCashticketService.sendTicket4Base(customerId, bindCode, 0.0, versionDetailId, platFormId, isSendMessage, isSendMessage, code, ncpBat);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, String code, String ncpBat) {
        return this.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, true, code, ncpBat);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, String code, String ncpBat) {
        return this.activeCashticketService.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog, true, code, ncpBat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, boolean checkActive, String code, String ncpBat) {
        BaseJsonVo baseJsonVo;
        Optional<ActiveEntity> activeEntityOpt = Optional.ofNullable(this.activeService.getActiveEntityByQrcode(bindCode));
        if (!activeEntityOpt.isPresent()) {
            if (bindCode.length() >= 32) return BaseJsonVo.error((String)"\u7121\u6548\u7684\u512a\u60e0\u5238\u6d3b\u52d5");
            activeEntityOpt = Optional.ofNullable(this.activeService.getActiveEntityByActiveNo(bindCode));
            if (!activeEntityOpt.isPresent()) return BaseJsonVo.error((String)"\u7121\u6548\u7684\u512a\u60e0\u5238\u6d3b\u52d5");
            bindCode = activeEntityOpt.get().getBindCode();
        }
        if (checkActive && !(baseJsonVo = this.activeService.checkActiveEnable((ActiveEntity)activeEntityOpt.orElse(null))).isSuccess()) {
            this.logger.info("\u6d3b\u52a8bindcode={},customerId={},\u6d88\u606f={}", new Object[]{bindCode, customerId, baseJsonVo.getError_msg()});
            return baseJsonVo;
        }
        List<ActiveCashticketEntity> list = this.activeCashticketService.getBindCodeActiveCashticketList(bindCode);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u6ca1\u6709\u7ed1\u5b9a\u4f18\u60e0\u5238\u6279\u6b21,bindcode={},customerId={},versionDetailId={}", new Object[]{bindCode, customerId, versionDetailId});
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6307\u5b9a\u53d1\u653e\u4f18\u60e0\u5238\u6279\u6b21");
        }
        String ticketBatchId = "";
        Integer count = 0;
        ActiveCashticketRuleEntity query = new ActiveCashticketRuleEntity();
        query.setBindCode(bindCode);
        List ruleList = this.activeCashticketRuleInterface.getList(query);
        try {
            if (CollectionUtils.isNotEmpty((Collection)ruleList)) {
                for (ActiveCashticketRuleEntity rule : ruleList) {
                    BaseJsonVo baseJsonVo2;
                    ActiveCashticketRuleCheckInterface ruleCheckInterface = this.checkHandl.get(rule.getRuleType() + "_ActiveCashticketRuleType");
                    if (ruleCheckInterface == null || (baseJsonVo2 = ruleCheckInterface.check(rule, list, customerId)).isSuccess()) continue;
                    return baseJsonVo2;
                }
            }
            String message = "\u4f18\u60e0\u5238\u53d1\u653e\u5931\u8d25";
            BaseJsonVo baseJsonVo3 = BaseJsonVo.success((Object)"");
            String takeDesc = "";
            Integer balance = 0;
            int takeType = ActiveTakeTypeEnum.no_way.getValue();
            boolean sendCashFlag = true;
            for (ActiveCashticketEntity c : list) {
                sendCashFlag = StringUtils.isNotEmpty((String)c.getTicketBatchId());
                if (sendCashFlag) {
                    ticketBatchId = c.getTicketBatchId();
                    count = c.getCount();
                    baseJsonVo3 = this.cashticketCustomerService.sendTicket4Base(customerId, c.getTicketBatchId(), c.getCount(), "", c.getBindCode(), amount, versionDetailId, platFormId, isSendMessage, code, ncpBat);
                }
                String string = message = !baseJsonVo3.isSuccess() ? baseJsonVo3.getMessage() : "";
                if (baseJsonVo3.isSuccess()) {
                    if (c.getBalance() == null || c.getBalance() <= 0) continue;
                    BaseJsonVo chargeResult = this.balanceService.activeChargeAsync(customerId, bindCode, activeEntityOpt.get(), c.getBalance());
                    if (!chargeResult.isSuccess()) {
                        baseJsonVo3 = BaseJsonVo.error((String)chargeResult.getError_msg());
                        continue;
                    }
                    balance = balance + c.getBalance();
                    if (sendCashFlag) continue;
                    this.activeInviteInterface.getActiveInviteEntity(customerId, bindCode);
                    continue;
                }
                if (!message.contains("\u4e0d\u53ef\u4ee5\u91cd\u590d\u9886\u53d6") || !activeEntityOpt.isPresent() || activeEntityOpt.get().getActiveType() != 15) return baseJsonVo3;
                baseJsonVo3.setMessage("\u4f18\u60e0\u5238\u5df2\u9886\u53d6\uff0c\u4e0d\u53ef\u91cd\u590d\u9886\u53d6\u5662~~");
                return baseJsonVo3;
            }
            if (sendCashFlag) {
                takeDesc = "\u4f18\u60e0\u5238";
            }
            if (balance > 0) {
                takeDesc = takeDesc.length() > 0 ? takeDesc + ",\u4f59\u989d:" + PriceUtils.divide((BigDecimal)new BigDecimal(balance), (BigDecimal)new BigDecimal(100)) : "\u4f59\u989d:" + PriceUtils.divide((BigDecimal)new BigDecimal(balance), (BigDecimal)new BigDecimal(100));
            }
            if (StringUtils.isNotEmpty((String)takeDesc)) {
                takeDesc = takeDesc + "\u9886\u53d6\u6210\u529f";
            }
            if (sendCashFlag) {
                takeType = ActiveTakeTypeEnum.cash.getValue();
                if (balance > 0) {
                    takeType = ActiveTakeTypeEnum.cash_balance.getValue();
                }
            } else if (balance > 0) {
                takeType = ActiveTakeTypeEnum.balance.getValue();
            }
            baseJsonVo3.setValue((Object)Pair.of((Object)takeDesc, (Object)takeType));
            return baseJsonVo3;
        }
        catch (Exception e) {
            if (writeLog) {
                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                messageBody.put("customerId", customerId);
                messageBody.put("bindCode", bindCode);
                messageBody.put("versionDetailId", "");
                messageBody.put("ticketBatchId", ticketBatchId);
                messageBody.put("status", 0);
                messageBody.put("message", e.getMessage());
                messageBody.put("count", count);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendCashLog, MessageParam.messageParam((String)customerId, messageBody));
            }
            this.logger.error("\u53d1\u653e\u6d3b\u52a8\u4f18\u60e0\u5238\u5f02\u5e38\uff0c\u53c2\u6570:customerId=[{}],bindCode=[{}],versionDetailId=[{}],platFormId=[{}],\u6d88\u606f:[{}]", new Object[]{customerId, bindCode, versionDetailId, platFormId, e.getMessage()});
            return BaseJsonVo.error((String)e.getMessage());
        }
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, bindCode, versionDetailId, platFormId, isSendMessage, true);
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean checkActive) {
        ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
        activeCashticketMessageVo.setBindCode(bindCode);
        activeCashticketMessageVo.setOpenId("");
        activeCashticketMessageVo.setUserId(customerId);
        activeCashticketMessageVo.setVersionDetailId("");
        activeCashticketMessageVo.setSendMessage(isSendMessage);
        activeCashticketMessageVo.setPlatFormId(platFormId);
        activeCashticketMessageVo.setCheckActive(checkActive);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)customerId, (Object)activeCashticketMessageVo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getBindCodeActiveCashticketList", expiration=600)
    public List<ActiveCashticketEntity> getBindCodeActiveCashticketList(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getBindCodeActiveCashticketList(bindCode);
    }

    @Override
    public BaseJsonVo deleteCouponConfig(Integer id) {
        ActiveCashticketEntity activeCashticketEntity = (ActiveCashticketEntity)this.activeCashticketMapper.selectByPrimaryKey(id);
        this.removeCache(activeCashticketEntity.getBindCode());
        int k = this.activeCashticketMapper.deleteByPrimaryKey(id);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    private void removeCache(String bindCode) {
        this.memcachedService.delete("ActiveCashticketService.getBindCodeActiveCashticketList", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketByBindCode", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketListByBindCode", bindCode);
    }

    @Override
    public BaseJsonVo sendCashticket(HttpServletRequest httpServletRequest, Integer platformGroupId, Integer platformId, Integer subscribe, String bindCode, String customerId, boolean isSendMessage, String code) {
        if (platformId == 1 && subscribe == 0) {
            CustomerCashVo customerCashVo = new CustomerCashVo();
            customerCashVo.setSubscribe(subscribe);
            if (StringUtils.isEmpty((String)bindCode)) {
                return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
            }
            ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
            customerCashVo.setQrcodeUrl(activeQrcodeEntity != null ? this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()) : "");
            return BaseJsonVo.success((Object)customerCashVo);
        }
        BaseJsonVo jsonVo = this.activeCashticketService.sendTicket4CustomerType(customerId, bindCode, "", platformId, platformGroupId, isSendMessage, 0, code);
        if (jsonVo.isSuccess()) {
            CustomerCashVo customerCashVo = (CustomerCashVo)jsonVo.getValue();
            customerCashVo.setSubscribe(1);
            if (customerCashVo != null) {
                this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a" + JsonUtils.toJson((Object)customerCashVo, (boolean)true));
                List<CashticketVo> cashticketVos = customerCashVo.getCashDetailVos();
                if (cashticketVos != null && cashticketVos.size() > 0) {
                    for (CashticketVo v : cashticketVos) {
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a\u5faa\u73af:" + v.getTicketBatchName());
                        String distributorRelationCode = httpServletRequest.getParameter("ncp_bat");
                        if (StringUtils.isEmpty((String)distributorRelationCode)) {
                            distributorRelationCode = httpServletRequest.getParameter("ncpBat");
                        }
                        if (!StringUtils.isNotEmpty((String)distributorRelationCode)) continue;
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a:\u9080\u8bf7\u7801\uff1a" + distributorRelationCode);
                        Boolean bl = this.distributionInviteInterface.invite(distributorRelationCode, customerId, v.getTicketCustomerId().toString(), 2);
                    }
                }
            }
        }
        return jsonVo;
    }
}

