/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveItemMapper;
import cc.lechun.active.dao.active.MallUrlMapper;
import cc.lechun.active.dao.groupon.GrouponMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.entity.active.MallActiveProductItemVo;
import cc.lechun.active.entity.active.MallUrlEntity;
import cc.lechun.active.entity.active.VipIndexActiveVo;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.groupon.ActitveItemVo;
import cc.lechun.active.entity.groupon.GrouponOrder;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveItemInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.api.MessageAPI;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.message.ImageMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.user.User;

@Service
public class ActiveCommonService
extends ActiveBaseService
implements ActiveCommonInterface {
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossService;
    @Autowired
    private MallUrlMapper mallUrlMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    protected MallOrderInterface mallOrderInterface;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private WeiXinMediaInterface weiXinMediaInterface;
    @Autowired
    private ShareInterface shareInterface;
    @Autowired
    CrowdInterface crowdInterface;
    @Autowired
    WeiXinKeywordInterface keywordInterface;
    @Autowired
    private GrouponMapper grouponMapper;
    @Autowired
    private ActiveItemMapper activeItemMapper;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    MallPromotionInterface promotionInterface;
    @Lazy
    @Autowired
    private ActiveInterface activeInterface;
    @Lazy
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Lazy
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private ActiveItemInterface activeItemService;
    @Lazy
    @Autowired
    private ActivePropertyInterface activePropertyInterface;

    @Override
    public BaseJsonVo getPayVip(String bindCode) {
        VipIndexActiveVo vipIndexActiveVo = new VipIndexActiveVo();
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        BaseJsonVo<IndexActiveVo> indexActiveVoBaseJsonVo = this.activeInterface.buildIndexActiveVo(activeEntity.getActiveNo());
        if (!indexActiveVoBaseJsonVo.isSuccess()) {
            return indexActiveVoBaseJsonVo;
        }
        BeanUtils.copyProperties((Object)indexActiveVoBaseJsonVo.getValue(), (Object)vipIndexActiveVo);
        return null;
    }

    @Override
    public void updateProductSaleCount(MallOrderMainEntity orderMainEntity) {
        try {
            OrderListVo orderListVo = this.tradeInterface.getOrderDetail(orderMainEntity);
            orderListVo.getOrderProductVos().forEach(mallOrderProductVo -> {
                this.activeItemService.saveProductSaleCount(orderMainEntity.getBindCode(), mallOrderProductVo.getProductType(), mallOrderProductVo.getItemId(), mallOrderProductVo.getQuantity());
                String key = orderMainEntity.getBindCode() + ":" + mallOrderProductVo.getItemId() + ":" + mallOrderProductVo.getProductType();
                this.redisCacheUtil.increment(key, mallOrderProductVo.getQuantity());
            });
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u8d2d\u4e70\u5546\u54c1\u6570\u91cf\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public boolean checkCanJoin(String bindCode, String customerId) {
        int num = this.mallOrderMainService.getOrderNum(customerId);
        return num < 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCommonService.getActivePicListByBindCode", expiration=300)
    public Map<String, List<String>> getActivePicListByBindCode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return this.getActivePicListByActiveNo(activeEntity.getActiveNo());
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCommonService.getActiveItemList", expiration=300)
    public MallActiveProductItemVo getActiveItemList(@ParameterValueKeyProvider String bindCode) {
        List ls;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        MallActiveProductItemVo mallGroupVo = new MallActiveProductItemVo();
        mallGroupVo.setStatus(activeEntity.getStatus());
        mallGroupVo.setStatusName(Objects.equals(activeEntity.getStatus(), StatusEnum.STATUS_OK.getValue()) ? StatusEnum.STATUS_OK.getName() : StatusEnum.STATUS_FAIL.getName());
        mallGroupVo.setPicMap(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
        mallGroupVo.setOrderSource(this.activeInterface.getOrderSourceByActiveType(activeEntity.getActiveType()));
        mallGroupVo.setSeconds(seconds);
        mallGroupVo.setSecond(seconds / 3600L);
        mallGroupVo.setMinute(seconds % 3600L / 60L);
        mallGroupVo.setHour(seconds % 3600L % 60L);
        mallGroupVo.setCountdown(activeEntity.getCountdown());
        ActiveItemEntity itemQuery = new ActiveItemEntity();
        itemQuery.setBindCode(bindCode);
        itemQuery.setStatus(activeEntity.getStatus());
        List<ActivePropertyEntity> propertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (CollectionUtils.isNotEmpty(propertyList)) {
            this.logger.error("\u6d3b\u52a8bindCode={}\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("title", activePropertyEntity.getPropertyKey())).findFirst();
            if (propertyEntityOptional.isPresent()) {
                try {
                    mallGroupVo.setTitle(propertyEntityOptional.get().getPropertyValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(ls = this.activeItemMapper.getList(itemQuery)))) {
            ls = ls.stream().sorted(Comparator.comparing(ActiveItemEntity::getSequence)).collect(Collectors.toList());
            ArrayList<ActitveItemVo> groupItemVoList = new ArrayList<ActitveItemVo>();
            for (ActiveItemEntity item : ls) {
                BaseJsonVo<MallProductVO> sr;
                ActitveItemVo groupItemVo = new ActitveItemVo();
                groupItemVo.setOriginPrice(item.getOriginPrice());
                groupItemVo.setFactPrice(item.getSalePrice());
                groupItemVo.setPriceList(item.getPriceList());
                BeanUtils.copyProperties((Object)item, (Object)groupItemVo);
                String key = bindCode + ":" + item.getItemId() + ":" + item.getItemType();
                Object num = this.redisCacheUtil.get(key);
                groupItemVo.setSaleCount(num == null ? 0 : Integer.valueOf(num.toString()));
                if (Objects.equals(item.getItemType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                    sr = this.productService.buildProductVO(item.getItemId(), 1, null, null, null, null, true, true, null, null);
                    if (!sr.isSuccess()) continue;
                    if (((MallProductVO)sr.getValue()).getValid().booleanValue()) {
                        groupItemVo.setLimitCount(((MallProductVO)sr.getValue()).getLimitBuyCount());
                        groupItemVo.setItemName(((MallProductVO)sr.getValue()).getProName());
                        groupItemVo.setOtherName(((MallProductVO)sr.getValue()).getProOtherName());
                        groupItemVo.setItemPicMap(((MallProductVO)sr.getValue()).getProductPic());
                        groupItemVoList.add(groupItemVo);
                        continue;
                    }
                    this.logger.error("\u5355\u54c1:{}\u4e0d\u53ef\u7528:{}", (Object)((MallProductVO)sr.getValue()).getProName(), (Object)((MallProductVO)sr.getValue()).getInvalidReason());
                    continue;
                }
                if (!Objects.equals(item.getItemType(), SalesTypeEnum.SALES_PROMOTION.getValue()) || !(sr = this.promotionInterface.buildPromotionVO(item.getItemId(), 1, true)).isSuccess()) continue;
                if (((MallPromotionVO)sr.getValue()).getValid().booleanValue()) {
                    groupItemVo.setLimitCount(((MallPromotionVO)sr.getValue()).getLimitCount());
                    groupItemVo.setItemName(((MallPromotionVO)sr.getValue()).getPromotionName());
                    groupItemVo.setOtherName(((MallPromotionVO)sr.getValue()).getProSummary());
                    groupItemVo.setItemPicMap(((MallPromotionVO)sr.getValue()).getPromotionPic());
                    groupItemVoList.add(groupItemVo);
                    continue;
                }
                this.logger.error("\u4fc3\u9500:{}\u4e0d\u53ef\u7528:{}", (Object)((MallPromotionVO)sr.getValue()).getPromotionName(), (Object)((MallPromotionVO)sr.getValue()).getInvalidReason());
            }
            mallGroupVo.setItemList(groupItemVoList);
        }
        return mallGroupVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCommonService.getActivePicListByActiveNo", expiration=80)
    public Map<String, List<String>> getActivePicListByActiveNo(@ParameterValueKeyProvider String activeNo) {
        return this.picService.getProductPicUrlMap(activeNo, SalesTypeEnum.SALES_ACTIVE.getValue());
    }

    @Override
    public BaseJsonVo checkIsNewUser(String openId, Integer platFormId, String bindCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userStatus", 1);
        map.put("qrcodeUrl", "");
        if (platFormId != 4) {
            User user = null;
            WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(platFormId);
            user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
            if (user != null && Integer.valueOf(1).equals(user.getSubscribe())) {
                map.put("userStatus", 1);
                map.put("qrcodeUrl", "");
            } else {
                ActiveQrcodeEntity activeQrcodeEntity;
                map.put("userStatus", 0);
                String wechat_qrcode = this.dictionaryService.getDictionary(1000, 209, "WECHAT_QRCODE").getDictionaryName();
                map.put("qrcodeUrl", this.ossService.getImageResoure(wechat_qrcode));
                if (StringUtils.isNotEmpty((String)bindCode) && (activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode)) != null) {
                    map.put("qrcodeUrl", this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()));
                }
            }
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo<Map<String, Integer>> checkUserSubscribe(String customerId, Integer platFormId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platFormId);
        if (customerDetailVo == null) {
            map.put("subscribe", 0);
        } else {
            map.put("subscribe", this.checkIsNewUser(customerDetailVo.getOpenId(), platFormId));
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public int checkIsNewUser(String openId, Integer platFormId) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(platFormId);
        User user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
        if (user != null && user.getSubscribe() != null && Integer.valueOf(1).equals(user.getSubscribe())) {
            return user.getSubscribe();
        }
        return 0;
    }

    @Override
    public BaseJsonVo checkIsNewUser(String openId, Integer platFormId, String bindCode, String inviteId) {
        if (StringUtils.isNotEmpty((String)inviteId)) {
            this.logger.info("openid={},bindcode={}", (Object)openId, (Object)bindCode);
            String key = MD5.sign((String)(openId + bindCode));
            this.logger.info("key={},inviteId={}", (Object)key, (Object)inviteId);
            this.memcachedService.set(key, (Object)inviteId);
            try {
                MallUrlEntity mallUrlEntity = new MallUrlEntity();
                mallUrlEntity.setUrlKey(key);
                mallUrlEntity.setUrl(inviteId);
                mallUrlEntity.setCreateTime(DateUtils.now());
                mallUrlEntity.setExpiredTime(mallUrlEntity.getCreateTime());
                this.mallUrlMapper.insert(mallUrlEntity);
            }
            catch (Exception e) {
                this.logger.error("\u68c0\u6d4b\u7528\u6237\u662f\u5426\u662f\u65b0\u7528\u6237\u5f02\u5e38", (Throwable)e);
            }
        }
        return this.checkIsNewUser(openId, platFormId, bindCode);
    }

    @Override
    public void pushActiveMessage(MallOrderMainEntity mallOrderMainEntity) {
        this.logger.info("\u6536\u5230\u6d3b\u52a8\u63a8\u9001\u6210\u529f\u6d88\u606f\u5f00\u59cb...");
        boolean pushFitMessage = true;
        try {
            pushFitMessage = this.pushOrderMessage(mallOrderMainEntity, pushFitMessage);
            if ((mallOrderMainEntity.getOrderClass() == 1 || mallOrderMainEntity.getOrderClass() == 4) && this.mallRedisLock.lock(mallOrderMainEntity.getCustomerId() + ":pushMessage:everyDay:" + DateUtils.date(), "1", 86400L, TimeUnit.SECONDS)) {
                this.pushPicMessage(mallOrderMainEntity, pushFitMessage);
                this.pushSmsMessage(mallOrderMainEntity);
                this.pushActiveMessage2(mallOrderMainEntity);
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u6d3b\u52a8\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean pushOrderMessage(MallOrderMainEntity mallOrderMainEntity, boolean pushFitMessage) {
        if (StringUtils.isNotEmpty((String)mallOrderMainEntity.getActiveNo())) {
            this.logger.info("\u6d3b\u52a8:{}", (Object)mallOrderMainEntity.getActiveNo());
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(mallOrderMainEntity.getActiveNo());
            if (activeEntity != null) {
                if (activeEntity.getPayKeywordId() != null && activeEntity.getPayKeywordId() > 0) {
                    pushFitMessage = false;
                    this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, activeEntity.getPayKeywordId(), mallOrderMainEntity.getCustomerId(), null);
                }
                if (activeEntity.getPaySmsKeywordId() != null && activeEntity.getPaySmsKeywordId() > 0) {
                    pushFitMessage = false;
                    WeiXinKeywordEntity entity = this.keywordInterface.getWeiXinKeywordById(activeEntity.getPaySmsKeywordId());
                    if (entity == null) {
                        return false;
                    }
                    String message = this.keywordInterface.getContent(entity, null, null, null);
                    CustomerEntity customerEntity = this.customerService.getCustomer(mallOrderMainEntity.getCustomerId());
                    if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getMobile()) && StringUtils.isNotEmpty((String)message)) {
                        SmsUtil.sendSms((String)customerEntity.getMobile(), (String)message, (String)IDGenerate.getUniqueIdStr());
                    }
                }
            }
        }
        return pushFitMessage;
    }

    private void pushPicMessage(MallOrderMainEntity mallOrderMainEntity, boolean pushFitMessage) {
        if (pushFitMessage) {
            DictionaryEntity dic = this.dictionaryService.getDictionary(mallOrderMainEntity.getPlatformGroupId(), 28, "1");
            String bindCode = "";
            if (dic != null && !StringUtils.isEmpty((String)dic.getDictionaryName())) {
                bindCode = dic.getDictionaryName();
                this.customerQrcodeService.getSaleQrcodeVo(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId(), bindCode);
            }
        }
    }

    private void pushSmsMessage(MallOrderMainEntity mallOrderMainEntity) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId());
        if (customerDetailVo == null) {
            this.logger.error("\u8ba2\u5355\uff1a{},\u975e\u5fae\u4fe1\u5e73\u53f0\u8ba2\u5355", (Object)mallOrderMainEntity.getOrderMainNo());
            return;
        }
        if (this.customerService.getUserSubscribe(customerDetailVo.getOpenId(), mallOrderMainEntity.getPlatformId()) == 0) {
            String phone = this.mallOrderInterface.getOrderList(mallOrderMainEntity.getOrderMainNo()).get(0).getConsigneePhone();
            if (StringUtils.isNotEmpty((String)phone)) {
                String result = SmsUtil.sendSms((String)phone, (String)"hi\uff0c\u5c0f\u4f19\u4f34\uff5e\u606d\u559c\u4f60\u4e0b\u5355\u6210\u529f\uff01\u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7\u300c\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec\u300d\u5373\u53ef\u81ea\u52a9\u67e5\u8be2\u8ba2\u5355\u7269\u6d41\u60c5\u51b5\u3002\u5982\u6709\u95ee\u9898\u53ef\u5728\u516c\u4f17\u53f7\u300c\u4e2a\u4eba\u4e2d\u5fc3-\u4eba\u5de5\u5ba2\u670d\u300d\u54a8\u8be2\u5728\u7ebf\u5ba2\u670d\u3002\u670d\u52a1\u65f6\u95f4\u6bcf\u5468\u4e00\u81f3\u5468\u65e510:00-22:00", (String)IDGenerate.getUniqueIdStr());
                if (result != null && !"".equals(result) && result.length() > 10) {
                    this.logger.info("\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f,\u624b\u673a\u53f7:{}\u6210\u529f", (Object)mallOrderMainEntity.getCustomerId(), (Object)phone);
                } else {
                    this.logger.info("\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f,\u624b\u673a\u53f7:{}\u5931\u8d25", (Object)mallOrderMainEntity.getCustomerId(), (Object)phone);
                }
            }
        } else {
            this.logger.info("\u672a\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f\uff0c\u7528\u6237\u5df2\u5173\u6ce8\u516c\u4f17\u53f7", (Object)mallOrderMainEntity.getCustomerId());
        }
    }

    private void pushActiveMessage2(MallOrderMainEntity mallOrderMainEntity) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo("3256807432334017999");
        if (activeEntity.getStatus() == 1 && activeEntity.getEndTime().after(DateUtils.now())) {
            String key = String.valueOf((mallOrderMainEntity.getCustomerId() + ":3256807432334017999:" + DateUtils.date()).hashCode());
            if (this.memcachedService.get(key) == null) {
                this.memcachedService.set("", key, (Object)1, 86400);
                String mediaKey = String.valueOf("3256807432334017999:Media");
                String mediaId = "";
                List<MallProductPicEntity> pics = this.picService.getProductPics("3256807432334017999", 151);
                if (pics.size() >= 1) {
                    Integer k = new Random().nextInt(pics.size());
                    MallProductPicEntity productPicEntity = pics.get(k > 0 ? k - 1 : 0);
                    String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(mallOrderMainEntity.getPlatformId()).getAccessToken();
                    if (this.memcachedService.get(mediaKey) == null) {
                        try {
                            URI uri = new URI(productPicEntity.getFullRelativeUrl());
                            Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)uri);
                            if (media != null) {
                                mediaId = media.getMedia_id();
                                this.memcachedService.set("", mediaKey, (Object)mediaId, 300);
                            }
                        }
                        catch (URISyntaxException e) {
                            this.logger.error("\u7d20\u6750\u5904\u7406\u5f02\u5e38", (Throwable)e);
                        }
                    } else {
                        mediaId = this.memcachedService.get(mediaKey).toString();
                    }
                    if (StringUtils.isNotEmpty((String)mediaId)) {
                        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId());
                        ImageMessage message = new ImageMessage(customerDetailVo.getOpenId(), mediaId);
                        MessageAPI.messageCustomSend((String)accessToken, (Message)message);
                    }
                }
            } else {
                this.logger.info("\u7528\u6237\u5f53\u5929\u5df2\u63a8\u9001" + mallOrderMainEntity.getCustomerId());
            }
        } else {
            this.logger.warn("\u975e\u6d3b\u52a8\u8ba2\u5355\u4e0d\u63a8\u9001:" + mallOrderMainEntity.getOrderMainNo());
        }
    }

    @Override
    public BaseJsonVo getActiveShare(String pageUrl, String bindCode, String inviteCode, String customerId, String nickName, String productId, String orderNo, String urlInviteId) {
        WeiXinMediaEntity weiXinMediaEntity = null;
        ActiveQrcodeEntity activeQrcodeEntity = new ActiveQrcodeEntity();
        if (StringUtils.isNotEmpty((String)bindCode)) {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
            if (bindCode.length() < 32) {
                List<ActiveQrcodeEntity> list = this.activeQrcodeService.getQrcodeList(bindCode);
                if (list != null && list.size() >= 1) {
                    activeQrcodeEntity = list.get(0);
                }
            } else {
                activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
            }
            HashedMap shareMap = new HashedMap();
            if (activeQrcodeEntity != null && StringUtils.isNotEmpty((String)activeQrcodeEntity.getShareMedia())) {
                ShareEntity shareEntity;
                Integer mediaId = null;
                try {
                    mediaId = Integer.valueOf(activeQrcodeEntity.getShareMedia());
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u7d20\u6750\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
                ShareEntity shareEntity2 = shareEntity = mediaId == null ? null : (ShareEntity)this.shareInterface.selectByPrimaryKey(Integer.valueOf(activeQrcodeEntity.getShareMedia()));
                if (shareEntity != null && shareEntity.getId() != null) {
                    weiXinMediaEntity = new WeiXinMediaEntity();
                    weiXinMediaEntity.setUrl(shareEntity.getShareUrl());
                    weiXinMediaEntity.setTitle(shareEntity.getShareTitle());
                    weiXinMediaEntity.setDigest(shareEntity.getShareDigest());
                    weiXinMediaEntity.setImageUrl(shareEntity.getShareImageUrl());
                } else {
                    weiXinMediaEntity = this.weiXinMediaInterface.getMediaByMediaId(activeQrcodeEntity.getShareMedia());
                }
                if (weiXinMediaEntity != null) {
                    if (StringUtils.isNotEmpty((String)weiXinMediaEntity.getUrl())) {
                        String url;
                        if (activeEntity != null && (activeEntity.getActiveType() == 43 || activeEntity.getActiveType() == 23)) {
                            GrouponOrder grouponOrder;
                            if (StringUtils.isEmpty((String)urlInviteId) && StringUtils.isNotEmpty((String)orderNo) && (grouponOrder = this.grouponMapper.chaXunGrouponOrderByOrderNo(orderNo)) != null && StringUtils.isNotEmpty((String)grouponOrder.getInviteId())) {
                                urlInviteId = grouponOrder.getInviteId();
                            }
                            if (weiXinMediaEntity.getUrl().indexOf("?") > 0) {
                                if (weiXinMediaEntity.getUrl().indexOf("bindCode") <= 0) {
                                    weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + urlInviteId + "&ncp_bat=" + inviteCode);
                                } else {
                                    url = weiXinMediaEntity.getUrl();
                                    weiXinMediaEntity.setUrl(url.substring(0, url.indexOf("bindCode")) + "bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + urlInviteId + "&ncp_bat=" + inviteCode);
                                }
                            } else {
                                weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "?bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + urlInviteId + "&ncp_bat=" + inviteCode);
                            }
                        } else if (weiXinMediaEntity.getUrl().indexOf("?") > 0) {
                            if (weiXinMediaEntity.getUrl().indexOf("bindCode") <= 0) {
                                weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + customerId + "&ncp_bat=" + inviteCode);
                            } else {
                                url = weiXinMediaEntity.getUrl();
                                weiXinMediaEntity.setUrl(url.substring(0, url.indexOf("bindCode")) + "bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + customerId + "&ncp_bat=" + inviteCode);
                            }
                        } else {
                            weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "?bindCode=" + bindCode + "&source=" + customerId + "&inviteId=" + customerId + "&ncp_bat=" + inviteCode);
                        }
                    } else if (activeEntity != null && (activeEntity.getActiveType() == 19 || activeEntity.getActiveType() == 22)) {
                        pageUrl = pageUrl.replace("source=&", "");
                        weiXinMediaEntity.setUrl(pageUrl + (pageUrl.contains("?") ? "&" : "?") + "source=" + customerId + "&ncp_bat=" + inviteCode);
                    } else if (StringUtils.isNotEmpty((String)pageUrl)) {
                        weiXinMediaEntity.setUrl(pageUrl + (pageUrl.contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode);
                    }
                    if (activeEntity.getActiveType() == 2) {
                        weiXinMediaEntity = this.getRedPackage(orderNo);
                    } else if (activeEntity.getActiveType() == 18) {
                        if (StringUtils.isEmpty((String)productId)) {
                            return BaseJsonVo.error((String)"\u4f17\u7b79\u5206\u4eab\u6ca1\u6709\u4f20productId");
                        }
                        CrowdFundingEntity crowd = this.crowdInterface.getCrowdFundingEntityByActiveNo(activeEntity.getActiveNo(), productId);
                        String inviteId = this.crowdInterface.getInviteId(activeEntity.getActiveNo(), activeEntity.getBindCode(), customerId);
                        this.logger.info("*****\u6211\u770b\u770bactiveEntity.getActiveType().intValue()-1\uff1a" + JsonUtils.toJson((Object)crowd, (boolean)false));
                        this.logger.info("*****\u6211\u770b\u770bactiveEntity.getActiveType().intValue()-2\uff1a" + inviteId);
                        if (StringUtils.isNotEmpty((String)weiXinMediaEntity.getUrl())) {
                            if (weiXinMediaEntity.getUrl().contains("?")) {
                                this.logger.info("*****\u6211\u770b\u770bactiveEntity.getActiveType().intValue()-3-1\uff1a" + inviteId);
                                weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&inviteId=" + inviteId);
                            } else {
                                this.logger.info("*****\u6211\u770b\u770bactiveEntity.getActiveType().intValue()-3-2\uff1a" + inviteId);
                                weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "?inviteId=" + inviteId);
                            }
                            weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl().replace("${crowdId}", String.valueOf(crowd.getId())).replace("${activeNo}", activeEntity.getActiveNo()));
                            this.logger.info("*****\u6211\u770b\u770bactiveEntity.getActiveType().intValue()-4\uff1a" + weiXinMediaEntity.getUrl());
                        }
                        weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&proId=" + productId);
                    }
                    weiXinMediaEntity.setDigest(weiXinMediaEntity.getDigest().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
                    weiXinMediaEntity.setTitle(weiXinMediaEntity.getTitle().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
                    weiXinMediaEntity.setImageUrl(weiXinMediaEntity.getImageUrl().contains("http") ? weiXinMediaEntity.getImageUrl() : this.ossService.getImageResoure(weiXinMediaEntity.getImageUrl()));
                    shareMap.put("title", weiXinMediaEntity.getTitle());
                    shareMap.put("digest", weiXinMediaEntity.getDigest());
                    shareMap.put("url", weiXinMediaEntity.getUrl());
                    shareMap.put("imageUrl", weiXinMediaEntity.getImageUrl());
                    shareMap.put("ncp_bat", inviteCode);
                    return BaseJsonVo.success((Object)shareMap);
                }
                if (activeEntity.getActiveType() == 2) {
                    weiXinMediaEntity = this.getRedPackage(orderNo);
                    weiXinMediaEntity.setDigest(weiXinMediaEntity.getDigest().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
                    weiXinMediaEntity.setTitle(weiXinMediaEntity.getTitle().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
                    weiXinMediaEntity.setImageUrl(weiXinMediaEntity.getImageUrl().contains("http") ? weiXinMediaEntity.getImageUrl() : this.ossService.getImageResoure(weiXinMediaEntity.getImageUrl()));
                    shareMap.put("title", weiXinMediaEntity.getTitle());
                    shareMap.put("digest", weiXinMediaEntity.getDigest());
                    shareMap.put("url", weiXinMediaEntity.getUrl());
                    shareMap.put("imageUrl", weiXinMediaEntity.getImageUrl());
                    shareMap.put("ncp_bat", inviteCode);
                    return BaseJsonVo.success((Object)shareMap);
                }
            }
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u5206\u4eab");
    }

    private WeiXinMediaEntity getRedPackage(String orderNo) {
        WeiXinMediaEntity weiXinMediaEntity = new WeiXinMediaEntity();
        List<DictionaryEntity> list = this.dictionaryService.getValidDictionaryList(217);
        if (list.size() > 0) {
            int sort = 0;
            if (StringUtils.isNotEmpty((String)orderNo)) {
                sort = Math.abs(orderNo.hashCode()) % list.size();
            }
            this.logger.info("\u968f\u673a\u5e8f\u6570:{}", (Object)sort);
            Map<String, List<String>> picUrlMap = this.picService.getProductPicUrlMap("3392696440501367443", SalesTypeEnum.SALES_ACTIVE.getValue());
            weiXinMediaEntity.setImageUrl(picUrlMap.get(ProductPicTypeEnum.ACT_SAMLL.getName()).get(sort));
            if (list.size() >= sort) {
                DictionaryEntity dictionaryEntity = list.get(sort);
                weiXinMediaEntity.setTitle(dictionaryEntity.getDictionaryName());
                weiXinMediaEntity.setDigest(dictionaryEntity.getRemark());
            } else {
                DictionaryEntity dictionaryEntity = list.get(0);
                weiXinMediaEntity.setTitle(dictionaryEntity.getDictionaryName());
                weiXinMediaEntity.setDigest(dictionaryEntity.getRemark());
            }
        }
        return weiXinMediaEntity;
    }
}

