/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveIndexMapper;
import cc.lechun.active.dao.active.ActivePageMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActiveIndexVo;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveIndexService
extends BaseService<ActiveIndexEntity, Integer>
implements ActiveIndexInterface {
    @Resource
    private ActiveIndexMapper activeIndexMapper;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Resource
    private ActivePageMapper activePageMapper;

    @Override
    public PageInfo<ActiveIndexVo> getActiveIndexList(PageForm pageForm, Integer platformGroupId) {
        ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy(" SORT ");
        List<Object> userGroupVos = new ArrayList();
        List list = this.activeIndexMapper.getList(activeIndexEntity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            userGroupVos = list.stream().filter(activeIndex -> {
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(activeIndex.getActiveNo());
                return this.activeInterface.checkActiveEnable(activeEntity).isSuccess() && activeEntity.getActiveType() != 28;
            }).map(activeIndex -> {
                ActiveIndexVo activeIndexVo = new ActiveIndexVo();
                this.logger.info("\u6d3b\u52a8\u9879:{}", (Object)activeIndexVo.toString());
                BeanUtils.copyProperties((Object)activeIndex, (Object)activeIndexVo);
                activeIndexVo.setPicMap(this.picInterface.getProductPicUrlMap(activeIndex.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
                return activeIndexVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        pg.setTotal((long)userGroupVos.size());
        return pg;
    }

    @Override
    public List<ActiveIndexVo> getActiveIndexList(Integer platformGroupId, Integer activeType) {
        ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
        List<ActiveIndexVo> userGroupVos = new ArrayList<ActiveIndexVo>();
        List list = this.activeIndexMapper.getList(activeIndexEntity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            userGroupVos = list.stream().sorted((a, b) -> a.getSort() - b.getSort()).filter(activeIndex -> {
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(activeIndex.getActiveNo());
                return this.activeInterface.checkActiveEnable(activeEntity).isSuccess() && Objects.equals(activeEntity.getActiveType(), activeType);
            }).map(activeIndex -> {
                ActiveIndexVo activeIndexVo = new ActiveIndexVo();
                this.logger.info("\u6d3b\u52a8\u9879:{}", (Object)activeIndexVo.toString());
                BeanUtils.copyProperties((Object)activeIndex, (Object)activeIndexVo);
                activeIndexVo.setPicMap(this.picInterface.getProductPicUrlMap(activeIndex.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
                if (StringUtils.isEmpty((String)activeIndex.getActiveUrl())) {
                    ActivePageEntity query = new ActivePageEntity();
                    query.setActiveNo(activeIndex.getActiveNo());
                    ActivePageEntity activePageEntity = (ActivePageEntity)this.activePageMapper.getSingle(query);
                    if (activeIndexEntity != null) {
                        activeIndexVo.setActiveUrl(activeIndexEntity.getActiveUrl());
                    }
                }
                return activeIndexVo;
            }).collect(Collectors.toList());
        }
        return userGroupVos;
    }
}

