/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActivePvMapper;
import cc.lechun.active.entity.active.ActivePvEntity;
import cc.lechun.active.iservice.active.ActivePvInterface;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ActivePvService
extends BaseService
implements ActivePvInterface {
    @Autowired
    private ActivePvMapper activePvMapper;

    @Override
    @Async
    public boolean saveActivePv(ActivePvEntity activePvEntity) {
        return this.activePvMapper.insertSelective(activePvEntity) >= 1;
    }

    @Override
    @CachePut(value={"getActivePv"}, key="#bindCode + '_' + #customerId")
    public boolean saveActivePv(String referrer, String page, String bindCode, String customerId) {
        ActivePvEntity activePvEntity = new ActivePvEntity();
        activePvEntity.setCustomerId(customerId);
        activePvEntity.setBindCode(bindCode);
        activePvEntity.setPage(referrer);
        activePvEntity.setReferrer(referrer);
        activePvEntity.setCreateTime(new Date());
        return this.activePvMapper.insertSelective(activePvEntity) >= 1;
    }

    @Override
    @Cacheable(value={"getActivePv"}, key="#bindCode + '_' + #customerId")
    public boolean getActivePv(String bindCode, String customerId) {
        ActivePvEntity query = new ActivePvEntity();
        query.setBindCode(bindCode);
        query.setCustomerId(customerId);
        return this.activePvMapper.existsByEntity(query) > 0;
    }
}

