/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.dao.active.ActiveRuleMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveRuleService
extends ActiveBaseService
implements ActiveRuleInterface {
    @Autowired
    private ActiveRuleMapper activeRuleMapper;
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;

    @Override
    public BaseJsonVo saveActiveRule(ActiveRuleEntity activeRuleEntity, List<ActiveCashticketEntity> activeCashTickets) {
        this.removeCache(activeRuleEntity);
        BaseJsonVo result = this.deleteActiveRule(activeRuleEntity, activeCashTickets);
        if (result.isSuccess()) {
            boolean temp;
            activeRuleEntity.setCreateTime(DateUtils.now());
            if (activeRuleEntity.getInviteQuantityMin() == null) {
                activeRuleEntity.setInviteQuantityMin(1);
            }
            if (activeRuleEntity.getInviteQuantityMax() == null) {
                activeRuleEntity.setInviteQuantityMax(100);
            }
            boolean bl = temp = this.activeRuleMapper.insert(activeRuleEntity) >= 1;
            if (!temp) {
                result.setError_msg("\u6d3b\u52a8\u89c4\u5219\u4fdd\u5b58\u5931\u8d25");
                return result;
            }
        } else {
            return result;
        }
        this.activeCashticketMapper.insertActiveCashticketBatch(activeCashTickets);
        return result;
    }

    private BaseJsonVo deleteActiveRule(ActiveRuleEntity activeRuleEntity, List<ActiveCashticketEntity> activeCashTickets) {
        BaseJsonVo result = this.checkSaveActiveRule(activeRuleEntity, activeCashTickets);
        if (result.isSuccess()) {
            ActiveRuleEntity temp;
            ActiveRuleEntity parameterActiveRule = new ActiveRuleEntity();
            parameterActiveRule.setActiveNo(activeRuleEntity.getActiveNo());
            if (activeRuleEntity.getInviteQuantityMin() != null) {
                parameterActiveRule.setInviteQuantityMin(activeRuleEntity.getInviteQuantityMin());
            }
            if (StringUtils.isNotEmpty((String)activeRuleEntity.getProId())) {
                parameterActiveRule.setProId(activeRuleEntity.getProId());
            }
            if ((temp = (ActiveRuleEntity)this.activeRuleMapper.getSingle(parameterActiveRule)) != null) {
                this.removeCache(activeRuleEntity);
                activeRuleEntity.setBindCode(temp.getBindCode());
                this.activeRuleMapper.deleteByPrimaryKey(temp.getActiveRuleId());
                this.activeCashticketMapper.deleteCashticketByBindCode(activeRuleEntity.getBindCode());
            } else if (StringUtils.isEmpty((String)activeRuleEntity.getBindCode())) {
                activeRuleEntity.setBindCode(String.valueOf(RandomUtils.generateId()));
            }
        }
        return result;
    }

    private BaseJsonVo checkSaveActiveRule(ActiveRuleEntity rule, List<ActiveCashticketEntity> activeCashTickets) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (activeCashTickets != null) {
            if (rule == null) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u6b63\u786e");
            }
            if (activeCashTickets.size() == 0) {
                return BaseJsonVo.error((String)"\u5fc5\u987b\u9009\u62e9\u4f18\u60e0\u5238");
            }
            if (rule.getActiveNo().isEmpty()) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u6b63\u786e");
            }
        } else {
            return BaseJsonVo.error((String)"\u5fc5\u987b\u9009\u62e9\u4f18\u60e0\u5238");
        }
        return result;
    }

    private BaseJsonVo checkSaveActiveRule(ActiveRuleEntity rule) {
        if (rule == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u5151\u5956\u89c4\u5219");
        }
        if (rule.getInviteQuantityMin() == null || rule.getInviteQuantityMin() == 0) {
            return BaseJsonVo.error((String)"\u8d77\u59cb\u9080\u8bf7\u6570\u91cf\u6709\u8bef");
        }
        if (rule.getInviteQuantityMax() == null || rule.getInviteQuantityMax() == 0) {
            return BaseJsonVo.error((String)"\u622a\u6b62\u9080\u8bf7\u6570\u91cf\u6709\u8bef");
        }
        if (rule.getInviteQuantityMax() < rule.getInviteQuantityMin()) {
            return BaseJsonVo.error((String)"\u622a\u6b62\u9080\u8bf7\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u9080\u8bf7\u6570\u91cf");
        }
        if (StringUtils.isEmpty((String)rule.getActiveNo())) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleByQuantity", expiration=300)
    public ActiveRuleEntity getRuleByQuantity(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer count) {
        return this.activeRuleMapper.getRuleByQuantity(activeNo, count);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleByQuantity")
    public ActiveRuleEntity getRuleByQuantity(@ParameterValueKeyProvider String activeNo) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setActiveNo(activeNo);
        List list = this.activeRuleMapper.getList(activeRule);
        if (list != null && list.size() >= 1) {
            return list.stream().sorted(Comparator.comparing(ActiveRuleEntity::getInviteQuantityMin)).findFirst().get();
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleList", expiration=300)
    public List<ActiveRuleEntity> getRuleList(@ParameterValueKeyProvider String activeNo) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setActiveNo(activeNo);
        return this.activeRuleMapper.getList(activeRule);
    }

    private void removeCache(ActiveRuleEntity activeRuleEntity) {
        if (activeRuleEntity != null) {
            this.memcachedService.delete("ActiveRuleService.getRuleList", activeRuleEntity.getActiveNo());
        }
    }

    @Override
    public List<ActiveRuleEntity> getRuleListByBindCodeAndProId(String bindCode, String proId) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setBindCode(bindCode);
        activeRule.setProId(proId);
        return this.activeRuleMapper.getList(activeRule);
    }
}

