/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active.cash_rule;

import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveCashticketRuleEntity;
import cc.lechun.active.service.active.cash_rule.ActiveCashticketRuleCheckInterface;
import cc.lechun.apiinvoke.baseservice.UserInvoke;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="2_ActiveCashticketRuleType")
public class ResignedEmployCheck
implements ActiveCashticketRuleCheckInterface {
    @Lazy
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private UserInvoke userInvoke;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    @Override
    public BaseJsonVo check(ActiveCashticketRuleEntity rule, List<ActiveCashticketEntity> list, String customerId) {
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        if (StringUtils.isEmpty((String)customerEntity.getMobile())) {
            throw new RuntimeException("\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        BaseJsonVo<Map<String, Object>> userMapResult = this.userInvoke.getUserInfoByMobile(customerEntity.getMobile());
        if (userMapResult.isSuccess()) {
            Integer cashStatus;
            Integer status = Integer.valueOf(((Map)userMapResult.getValue()).get("status").toString());
            if (Objects.equals(status, -1) && Objects.equals(cashStatus = Integer.valueOf(((Map)userMapResult.getValue()).get("cashStatus").toString()), 1)) {
                LocalDate localDate = LocalDate.of(LocalDate.now().getYear(), LocalDate.now().getMonth(), 1);
                Date date = this.LocalDateTodate(localDate);
                for (ActiveCashticketEntity cashticketEntity : list) {
                    List<CashticketCustomerEntity> cashList = this.cashticketCustomerMapper.getCashticketListByCreateDate(date, customerId, cashticketEntity.getTicketBatchId());
                    if (!CollectionUtils.isNotEmpty(cashList)) continue;
                    throw new RuntimeException("\u9886\u53d6\u5931\u8d25,\u5f53\u6708\u4f18\u60e0\u5238\u5df2\u9886\u53d6");
                }
                return BaseJsonVo.success((Object)"");
            }
            throw new RuntimeException(StringUtils.isNotEmpty((String)rule.getDescText()) ? rule.getDescText() : "\u6ca1\u6709\u9886\u53d6\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return userMapResult;
    }
}

