/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.crowd;

import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.dao.active.ActiveQrcodeMapper;
import cc.lechun.active.dao.crowd.CrowdActiveConfigMapper;
import cc.lechun.active.dao.crowd.CrowdCommonConfigMapper;
import cc.lechun.active.dao.crowd.CrowdFundingForumLikeMapper;
import cc.lechun.active.dao.crowd.CrowdFundingForumMapper;
import cc.lechun.active.dao.crowd.CrowdFundingMapper;
import cc.lechun.active.dao.crowd.CrowdPicMapper;
import cc.lechun.active.dao.invite.ActiveInviteMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.entity.crowd.CrowdActiveConfigEntity;
import cc.lechun.active.entity.crowd.CrowdActiveVo;
import cc.lechun.active.entity.crowd.CrowdCommonConfigEntity;
import cc.lechun.active.entity.crowd.CrowdCommonConfigPicVo;
import cc.lechun.active.entity.crowd.CrowdCouponVo;
import cc.lechun.active.entity.crowd.CrowdFundingDetailVo;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.crowd.CrowdFundingForumEntity;
import cc.lechun.active.entity.crowd.CrowdFundingForumLikeEntity;
import cc.lechun.active.entity.crowd.CrowdFundingListVo;
import cc.lechun.active.entity.crowd.CrowdInviteVo;
import cc.lechun.active.entity.crowd.CrowdPicEntity;
import cc.lechun.active.entity.crowd.InviteCustomerVo;
import cc.lechun.active.entity.crowd.MallCrowFundingForumNoticeVo;
import cc.lechun.active.entity.crowd.MallCrowdFundingForumVo;
import cc.lechun.active.entity.crowd.MallCrowdfundingListVo;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.sales.MallProductPicMapper;
import cc.lechun.mall.dao.trade.MallOrderMainMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainActiveVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrowdService
extends ActiveBaseService
implements CrowdInterface {
    @Autowired
    private CrowdCommonConfigMapper crowdCommonConfigMapper;
    @Autowired
    private CrowdFundingMapper crowdFundingMapper;
    @Autowired
    private ActiveRuleInterface activeRuleInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CrowdActiveConfigMapper crowdActiveConfigMapper;
    @Autowired
    private CrowdPicMapper crowdPicMapper;
    @Autowired
    private MallOrderMainMapper mallOrderMainMapper;
    @Autowired
    private MallProductPicMapper mallProductPicMapper;
    @Autowired
    private OssService ossInterface;
    @Autowired
    DictionaryInterface dictionaryService;
    @Autowired
    private ActiveMapper activeMapper;
    @Autowired
    private CrowdFundingForumMapper crowdFundingForumMapper;
    @Autowired
    private CrowdFundingForumLikeMapper crowdFundingForumLikeMapper;
    @Autowired
    private ActiveQrcodeMapper activeQrcodeMapper;
    @Autowired
    private ActiveInviteMapper activeInviteMapper;

    @Override
    public BaseJsonVo checkCanJoinCrowdActive(String customerId, String activeNo) {
        return null;
    }

    @Override
    public BaseJsonVo getCrowdInfo() {
        CrowdCommonConfigEntity commonConfigEntity = new CrowdCommonConfigEntity();
        List crowdCommonConfigEntityList = this.crowdCommonConfigMapper.getList(commonConfigEntity);
        CrowdCommonConfigPicVo crowdCommonConfigPicVo = new CrowdCommonConfigPicVo();
        if (crowdCommonConfigEntityList != null && crowdCommonConfigEntityList.size() > 0) {
            List<CrowdPicEntity> crowdPicList = this.crowdCommonConfigMapper.getCrowdCommonConfigPic(((CrowdCommonConfigEntity)crowdCommonConfigEntityList.get(0)).getId().toString(), "1");
            crowdCommonConfigPicVo.setId(((CrowdCommonConfigEntity)crowdCommonConfigEntityList.get(0)).getId());
            crowdCommonConfigPicVo.setRuleDesc(((CrowdCommonConfigEntity)crowdCommonConfigEntityList.get(0)).getRuleDesc());
            crowdCommonConfigPicVo.setCreateTime(((CrowdCommonConfigEntity)crowdCommonConfigEntityList.get(0)).getCreateTime());
            if (crowdPicList != null && crowdPicList.size() > 0) {
                for (CrowdPicEntity crowdPicEntity : crowdPicList) {
                    if (crowdPicEntity.getType() == 3) {
                        crowdCommonConfigPicVo.setPicRuleUrl(crowdPicEntity.getPicUrl());
                    }
                    if (crowdPicEntity.getType() != 1) continue;
                    crowdCommonConfigPicVo.setPicBannerUrl(crowdPicEntity.getPicUrl());
                }
            }
        }
        return BaseJsonVo.success((Object)crowdCommonConfigPicVo);
    }

    @Override
    public BaseJsonVo getCrowdActiveList(int type, CustomerDetailVo customerDetailVo) {
        List<CrowdActiveVo> crowdActiveList = this.crowdActiveConfigMapper.getCrowdActiveList(type);
        Iterator<CrowdActiveVo> iterator = crowdActiveList.iterator();
        while (iterator.hasNext()) {
            List<MallOrderMainActiveVo> orderMainActiveVoList;
            CrowdActiveVo crowdActiveVo;
            CrowdPicEntity crowdPicEntity = this.crowdPicMapper.getCrowdPicByProId((crowdActiveVo = iterator.next()).getId());
            crowdActiveVo.setPicUrl(crowdPicEntity != null ? crowdPicEntity.getPicUrl() : "");
            int joinPeople = 0;
            int tarperProple = 100;
            crowdActiveVo.setJoinPeople(joinPeople);
            crowdActiveVo.setTargerProple(tarperProple);
            crowdActiveVo.setCrowdJoinCrowdId(0);
            List<CrowdFundingEntity> crowdFundingEntityList = this.crowdFundingMapper.getCrowdIdByCustomerId(customerDetailVo.getCustomerId(), crowdActiveVo.getActiveNo());
            if (crowdFundingEntityList != null && crowdFundingEntityList.size() > 0) {
                crowdActiveVo.setCrowdJoinCrowdId(crowdFundingEntityList.get(0).getId());
            }
            if ((orderMainActiveVoList = this.mallOrderMainMapper.getActiveInfo(crowdActiveVo.getActiveNo())) == null || orderMainActiveVoList.size() <= 0) continue;
            MallOrderMainActiveVo mallOrderMainActiveVo = orderMainActiveVoList.get(0);
            if (mallOrderMainActiveVo != null && StringUtils.isNotEmpty((String)mallOrderMainActiveVo.getProductId())) {
                List<CrowdFundingEntity> crowdFundingList = this.crowdFundingMapper.getCrowdFundingByProduct(crowdActiveVo.getActiveNo(), mallOrderMainActiveVo.getProductId());
                if (crowdFundingList != null && crowdFundingList.size() > 0) {
                    joinPeople = mallOrderMainActiveVo.getActiveNum() + crowdFundingList.get(0).getPeopleCount();
                    tarperProple = crowdFundingList.get(0).getTargerPeople();
                    crowdActiveVo.setJoinPeople(joinPeople);
                }
            } else {
                List<CrowdFundingEntity> list = this.crowdFundingMapper.getCrowdFundingActiveByActiveNo(crowdActiveVo.getActiveNo());
                if (list != null && list.size() > 0) {
                    tarperProple = list.get(0).getTargerPeople();
                }
            }
            crowdActiveVo.setTargerProple(tarperProple);
        }
        return BaseJsonVo.success(crowdActiveList);
    }

    @Override
    public PageInfo getCrowdProductList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdCommonConfigMapper.getCrowdProductList();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveCrowProduct(CrowdFundingEntity crowdFundingEntity) {
        int temp = 0;
        temp = crowdFundingEntity.getId() == null || crowdFundingEntity.getId() == 0 ? this.crowdFundingMapper.insert(crowdFundingEntity) : this.crowdFundingMapper.updateByPrimaryKeySelective(crowdFundingEntity);
        return temp >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getSelectCrowdProductCouponList(String proId) {
        List<CrowdCouponVo> list = this.crowdCommonConfigMapper.getSelectCrowdProductCouponList(proId);
        return list != null && list.size() >= 1 ? BaseJsonVo.success(list) : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo getAllCrowdProductCouponList() {
        return BaseJsonVo.success(this.crowdCommonConfigMapper.getAllCrowdProductCouponList());
    }

    @Override
    @Transactional
    public BaseJsonVo saveCrowdCouponConfig(String proId, String activeNo, String listCoupon) throws UnsupportedEncodingException {
        String items = URLDecoder.decode(listCoupon, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List list = JsonUtils.getListByArray(CrowdCouponVo.class, (String)items);
        int k = this.crowdCommonConfigMapper.deleteCrowdCoupon(proId);
        ActiveRuleEntity activeRuleEntity = new ActiveRuleEntity();
        activeRuleEntity.setActiveNo(activeNo);
        activeRuleEntity.setProId(proId);
        activeRuleEntity.setCreateTime(DateUtils.now());
        activeRuleEntity.setBindCode(UUID.randomUUID().toString().replace("-", ""));
        ArrayList<ActiveCashticketEntity> list2 = new ArrayList<ActiveCashticketEntity>();
        list.forEach(c -> {
            ActiveCashticketEntity activeCashticketEntity = new ActiveCashticketEntity();
            activeCashticketEntity.setBindCode(activeRuleEntity.getBindCode());
            activeCashticketEntity.setTicketBatchId(c.getBacthId());
            activeCashticketEntity.setTackType(3);
            activeCashticketEntity.setSource(0);
            activeCashticketEntity.setOnlyNewCashticket(0);
            activeCashticketEntity.setCount(1);
            list2.add(activeCashticketEntity);
        });
        this.activeRuleInterface.saveActiveRule(activeRuleEntity, list2);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendMessage() {
        return null;
    }

    @Override
    public BaseJsonVo getCrowdInviteList(Integer crowdId, String customerId) {
        CrowdInviteVo crowdInviteVo = new CrowdInviteVo();
        CrowdFundingEntity crowdFundingEntity = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(crowdId);
        this.logger.info(crowdFundingEntity.toString());
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(crowdFundingEntity.getActiveNo());
        crowdInviteVo.setStatus(1);
        if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(DateUtils.now())) {
            crowdInviteVo.setStatus(3);
            if (this.getCrowdNum(crowdFundingEntity.getProId(), crowdFundingEntity.getActiveNo(), crowdFundingEntity.getPeopleCount()) >= crowdFundingEntity.getTargerPeople()) {
                crowdInviteVo.setStatus(2);
            }
        }
        Integer total = 0;
        List<InviteCustomerVo> list = this.crowdCommonConfigMapper.getCrowdInvite(crowdFundingEntity.getProId(), customerId, crowdFundingEntity.getActiveNo());
        if (list != null) {
            crowdInviteVo.setInviteList(list);
            for (InviteCustomerVo invite : list) {
                if (invite.getNewUser() == 1) {
                    invite.setCrowdAmout(crowdFundingEntity.getNewUserAmout());
                    total = total + crowdFundingEntity.getNewUserAmout();
                    continue;
                }
                invite.setCrowdAmout(crowdFundingEntity.getOldUserAmout());
                total = total + crowdFundingEntity.getOldUserAmout();
            }
            BigDecimal inviteTotal = new BigDecimal(total).add(new BigDecimal(crowdFundingEntity.getBaseAmount()));
            if (inviteTotal.compareTo(new BigDecimal(crowdFundingEntity.getMaxAmout())) == 1) {
                inviteTotal = new BigDecimal(crowdFundingEntity.getMaxAmout());
            }
            crowdInviteVo.setTotal(inviteTotal);
        }
        crowdInviteVo.setMaxAmout(crowdFundingEntity.getMaxAmout());
        return BaseJsonVo.success((Object)crowdInviteVo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo) {
        return this.crowdCommonConfigMapper.getCrowdNum(proId, activeNo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo, Integer peopleCount) {
        Integer num = this.getCrowdNum(proId, activeNo);
        return num == null ? (peopleCount == null ? 0 : peopleCount) : num + (peopleCount == null ? 0 : peopleCount);
    }

    @Override
    public PageInfo getMyCrowd(String customerId, Integer currentPage, Integer pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallCrowdfundingListVo> list = this.crowdCommonConfigMapper.getMyCrowd(customerId);
        PageInfo pg = page.toPageInfo();
        list.forEach(c -> {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(c.getActivNo());
            if (activeEntity != null) {
                c.setBeginTime(activeEntity.getBeginTime());
                c.setEndTime(activeEntity.getEndTime());
                List<String> pics = this.picService.getProductPicUrl(c.getProId() == null ? "" : c.getProId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                c.setSmallImages(pics);
                Integer num = this.getCrowdNum(c.getProId(), c.getActivNo(), c.getPeopleCount());
                double scale = MathUtils.mul((Number)MathUtils.div((Double)((Object)num), (Double)Double.valueOf(c.getTargerProple()), (Integer)4), (Number)100);
                c.setPropleScale(scale);
                if (c.getEndTime().before(DateUtils.now()) || activeEntity.getStatus() == 0) {
                    c.setCrowdStatus(3);
                    if (c.getTargerProple() <= num) {
                        c.setCrowdStatus(2);
                    }
                } else {
                    c.setCrowdStatus(1);
                }
                MallProductEntity product = this.mallProductInterface.getProduct(c.getProId());
                String pro_price = "\u96f6\u552e\u4ef7\u00a5" + c.getProPrice() + "/" + product.getProDw();
                if (product.getProPrice1() != null && !"".equals(product.getProPrice1()) && Double.parseDouble(product.getProPrice1()) > 0.0 && !product.getProPrice1().equals(product.getProPrice())) {
                    pro_price = "\u96f6\u552e\u4ef7\u00a5" + product.getProPrice() + "-" + product.getProPrice1() + "/" + product.getProDw();
                }
                c.setProPriceDesc(pro_price);
                c.setProMemo(product.getMemo());
                int surplus_date = CrowdService.getDateDiff(activeEntity.getEndTime());
                c.setSurplusDate(surplus_date);
                c.setJoinPeople(num);
            }
            c.setCrowdJoinCrowdId(c.getCrowdId());
        });
        return pg;
    }

    @Override
    public List<Map<String, Object>> getCrowdOrderList(Integer orderClass, String activeNo, String bindCode, String date) {
        return this.orderMainInterface.getOrderInfo(orderClass, activeNo, bindCode, date);
    }

    @Override
    public BaseJsonVo deleteCrowdCoupon(String proId) {
        Integer id = this.crowdCommonConfigMapper.getCrowdCoupon(proId);
        if (id != null && id > 0) {
            return this.activeCashticketInterface.deleteCouponConfig(id);
        }
        return BaseJsonVo.success((Object)"");
    }

    private static int getDateDiff(Date sdate) {
        Date now = new Date();
        if (now.after(sdate)) {
            return 0;
        }
        int day = 0;
        try {
            day = (int)((sdate.getTime() - now.getTime()) / 86400000L);
        }
        catch (Exception e) {
            return 0;
        }
        return day > 0 ? day + 1 : 1;
    }

    @Override
    public BaseJsonVo getCrowdSuccessDetail(String activeNo, String orderMainNo, String crowdId) {
        CrowdFundingEntity crowdFundingEntity = new CrowdFundingEntity();
        crowdFundingEntity = StringUtils.isNotEmpty((String)crowdId) ? (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(Integer.valueOf(crowdId)) : this.crowdFundingMapper.getCrowdSuccessDetail(orderMainNo).get(0);
        Object mallProductPicEntityList = null;
        String wechat_qrcode = this.dictionaryService.getDictionary(1000, 209, "WECHAT_LOGO").getDictionaryName();
        String picStr = this.ossInterface.getImageResoure(wechat_qrcode);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("paybackDesc", crowdFundingEntity.getPaybackDesc());
        resultMap.put("crowdPrice", crowdFundingEntity.getCrowdPrice().toString());
        resultMap.put("picUrl", picStr);
        resultMap.put("productId", crowdFundingEntity.getProId());
        resultMap.put("bindCode", this.activeService.getActiveEntityByActiveNo(activeNo).getBindCode());
        resultMap.put("orderSource", String.valueOf(OrderSourceEnum.CROWD.getValue()));
        return BaseJsonVo.success(resultMap);
    }

    @Override
    public BaseJsonVo getCrowdList(String customerId, String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        CrowdFundingListVo crowdFundingListVo = null;
        if (activeEntity != null) {
            CrowdActiveConfigEntity crowdActiveConfigEntity;
            List<CrowdPicEntity> crowdPicEntityList;
            int crowdJoinCrowdId = 0;
            int crowdStatus = 1;
            crowdFundingListVo = new CrowdFundingListVo();
            List<CrowdFundingEntity> crowdFundingEntityList = this.crowdFundingMapper.getCrowdIdByCustomerId(customerId, activeNo);
            if (crowdFundingEntityList != null && crowdFundingEntityList.size() > 0) {
                crowdJoinCrowdId = crowdFundingEntityList.get(0).getId();
            }
            int surplus_date = CrowdService.getDateDiff(activeEntity.getEndTime());
            crowdFundingListVo.setActiveNo(activeNo);
            crowdFundingListVo.setBindcode(activeEntity.getBindCode());
            crowdFundingListVo.setEndTime(DateUtils.formatDate((Date)activeEntity.getEndTime(), (String)""));
            crowdFundingListVo.setBeginTime(DateUtils.formatDate((Date)activeEntity.getBeginTime(), (String)""));
            crowdFundingListVo.setSurplusDate(surplus_date);
            if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(new Date())) {
                crowdStatus = 2;
            }
            if ((crowdPicEntityList = this.crowdPicMapper.getCrowdPicByParam(activeNo, 2, 1)) != null && crowdPicEntityList.size() > 0) {
                crowdFundingListVo.setBannerUrl(crowdPicEntityList.get(0).getPicUrl());
            }
            if ((crowdActiveConfigEntity = this.crowdActiveConfigMapper.getCrowdActiveConfigByNo(activeNo)) != null) {
                crowdFundingListVo.setIssue(crowdActiveConfigEntity.getIssue());
                crowdFundingListVo.setTitle(crowdActiveConfigEntity.getTitle());
                crowdFundingListVo.setNotice(crowdActiveConfigEntity.getNotice());
            }
            CrowdFundingDetailVo crowdFundingDetailVo = null;
            ArrayList<CrowdFundingDetailVo> crowdFundingDetailVoList = new ArrayList<CrowdFundingDetailVo>();
            List<CrowdFundingEntity> crowdFundingList = this.crowdFundingMapper.getCrowdFundingActiveByActiveNo(activeNo);
            if (crowdFundingList != null && crowdFundingList.size() > 0) {
                for (CrowdFundingEntity crowdFundingEntity : crowdFundingList) {
                    MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(crowdFundingEntity.getProId());
                    if (mallProductEntity == null) continue;
                    crowdFundingDetailVo = new CrowdFundingDetailVo();
                    String pro_price = mallProductEntity.getProPrice();
                    crowdFundingDetailVo.setCrowdJoinCrowdId(crowdJoinCrowdId);
                    crowdFundingDetailVo.setActivNo(activeNo);
                    crowdFundingDetailVo.setBeginTime(DateUtils.formatDate((Date)activeEntity.getBeginTime(), (String)""));
                    crowdFundingDetailVo.setEndTime(DateUtils.formatDate((Date)activeEntity.getEndTime(), (String)""));
                    crowdFundingDetailVo.setSurplusDate(surplus_date);
                    crowdFundingDetailVo.setCrowdPrice(crowdFundingEntity.getCrowdPrice().doubleValue());
                    crowdFundingDetailVo.setCrowdId(crowdFundingEntity.getId());
                    crowdFundingDetailVo.setProId(crowdFundingEntity.getProId());
                    crowdFundingDetailVo.setProMemo(mallProductEntity.getMemo());
                    crowdFundingDetailVo.setProName(mallProductEntity.getProName());
                    crowdFundingDetailVo.setProPrice(pro_price);
                    LinkedHashMap<String, String> productPicList = new LinkedHashMap<String, String>();
                    crowdFundingDetailVo.setProImage(this.picService.getProductPic(crowdFundingEntity.getProId(), productPicList, 0));
                    int joinPeople = this.getJoinPeopleCount(activeNo, crowdFundingEntity.getProId(), crowdFundingEntity.getPeopleCount());
                    crowdFundingDetailVo.setJoinPeople(joinPeople);
                    crowdFundingDetailVo.setTargerProple(crowdFundingEntity.getTargerPeople());
                    if (crowdStatus == 2) {
                        crowdStatus = joinPeople >= crowdFundingDetailVo.getTargerProple() ? 2 : 3;
                    }
                    crowdFundingDetailVo.setCrowdStatus(crowdStatus);
                    double scale = MathUtils.mul((Number)MathUtils.div((Double)Double.valueOf(crowdFundingDetailVo.getJoinPeople()), (Double)Double.valueOf(crowdFundingDetailVo.getTargerProple()), (Integer)4), (Number)100);
                    crowdFundingDetailVo.setPropleScale(scale);
                    crowdFundingDetailVoList.add(crowdFundingDetailVo);
                }
                crowdFundingListVo.setCrowdJoinCrowdId(crowdJoinCrowdId);
                crowdFundingListVo.setCrowdStatus(crowdStatus);
                crowdFundingListVo.setProList(crowdFundingDetailVoList);
            }
        }
        return BaseJsonVo.success(crowdFundingListVo);
    }

    public int getJoinPeopleCount(String activeNo, String proId, int peopleCount) {
        List<MallOrderMainEntity> orderMainEntityList = this.mallOrderMainMapper.getMainNoActiveByParam(activeNo, proId);
        return orderMainEntityList.size() + peopleCount;
    }

    @Override
    public BaseJsonVo saveCrowdForum(CustomerDetailVo customerDetailVo, CrowdFundingForumEntity crowdFundingForumEntity) {
        crowdFundingForumEntity.setCrowdType(1);
        crowdFundingForumEntity.setForumType(1);
        crowdFundingForumEntity.setParentId(Long.valueOf("0"));
        crowdFundingForumEntity.setForumMsgType(1);
        crowdFundingForumEntity.setNickName(customerDetailVo.getNickName());
        crowdFundingForumEntity.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
        int i = this.crowdFundingForumMapper.insert(crowdFundingForumEntity);
        if (crowdFundingForumEntity.getParentId() != 0L) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", crowdFundingForumEntity.getNickName());
            map.put("contnet", crowdFundingForumEntity.getForumMsgContnet());
            this.crowdFundingForumMapper.updateCrowdFundingForumInfo(crowdFundingForumEntity.getParentId(), map.toString());
        }
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u8bc4\u8bba\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u8bc4\u8bba\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveCrowdProductForum(CustomerDetailVo customerDetailVo, CrowdFundingForumEntity crowdFundingForumEntity) {
        crowdFundingForumEntity.setCrowdType(1);
        crowdFundingForumEntity.setForumMsgType(1);
        crowdFundingForumEntity.setForumType(2);
        crowdFundingForumEntity.setNickName(customerDetailVo.getNickName());
        crowdFundingForumEntity.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
        if (crowdFundingForumEntity.getParentId() != 0L) {
            crowdFundingForumEntity.setForumMsgType(2);
        }
        crowdFundingForumEntity.setStatus(1);
        crowdFundingForumEntity.setForumLikeCount(0);
        crowdFundingForumEntity.setCreateTime(new Date());
        crowdFundingForumEntity.setCustomerId(customerDetailVo.getCustomerId());
        int i = this.crowdFundingForumMapper.insert(crowdFundingForumEntity);
        if (crowdFundingForumEntity.getParentId() != 0L) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", crowdFundingForumEntity.getNickName());
            map.put("contnet", crowdFundingForumEntity.getForumMsgContnet());
            this.crowdFundingForumMapper.updateCrowdFundingForumInfo(crowdFundingForumEntity.getParentId(), map.toString());
        }
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u8bc4\u8bba\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u8bc4\u8bba\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getCrowdListDetail(String customerId, int crowdId) {
        CrowdFundingDetailVo crowdFundingDetailVo = null;
        CrowdFundingEntity crowdFundingEntity = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(Integer.valueOf(crowdId));
        if (crowdFundingEntity != null) {
            ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)crowdFundingEntity.getActiveNo()));
            MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(crowdFundingEntity.getProId());
            if (mallProductEntity != null && activeEntity != null) {
                crowdFundingDetailVo = new CrowdFundingDetailVo();
                int crowdJoinCrowdId = 0;
                int crowdStatus = 1;
                List<CrowdFundingEntity> crowdFundingEntityList = this.crowdFundingMapper.getCrowdIdByCustomerId(customerId, crowdFundingEntity.getActiveNo());
                if (crowdFundingEntityList != null && crowdFundingEntityList.size() > 0) {
                    crowdJoinCrowdId = crowdFundingEntityList.get(0).getId();
                    crowdFundingDetailVo.setCrowdJoinCrowdId(crowdJoinCrowdId);
                }
                if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(new Date())) {
                    crowdStatus = 2;
                }
                crowdFundingDetailVo.setCrowdStatus(crowdStatus);
                int surplus_date = CrowdService.getDateDiff(activeEntity.getEndTime());
                crowdFundingDetailVo.setSurplusDate(surplus_date);
                crowdFundingDetailVo.setActivNo(crowdFundingEntity.getActiveNo());
                crowdFundingDetailVo.setEndTime(DateUtils.formatDate((Date)activeEntity.getEndTime(), (String)""));
                crowdFundingDetailVo.setBeginTime(DateUtils.formatDate((Date)activeEntity.getBeginTime(), (String)""));
                crowdFundingDetailVo.setCrowdPrice(crowdFundingEntity.getCrowdPrice().doubleValue());
                crowdFundingDetailVo.setCrowdId(crowdFundingEntity.getId());
                crowdFundingDetailVo.setProId(crowdFundingEntity.getProId());
                crowdFundingDetailVo.setProMemo(mallProductEntity.getMemo());
                crowdFundingDetailVo.setProName(mallProductEntity.getProName());
                crowdFundingDetailVo.setSuccessNotice(crowdFundingEntity.getSuccessNotice());
                crowdFundingDetailVo.setPaybackDesc(crowdFundingEntity.getPaybackDesc());
                crowdFundingDetailVo.setNotice(crowdFundingEntity.getNotice());
                String proPrice = "\u96f6\u552e\u4ef7\u00a5" + mallProductEntity.getProPrice() + "/" + mallProductEntity.getProDw();
                if (mallProductEntity.getProPrice1() != null && !"".equals(mallProductEntity.getProPrice1()) && Double.parseDouble(mallProductEntity.getProPrice1()) > 0.0 && !mallProductEntity.getProPrice1().equals(mallProductEntity.getProPrice())) {
                    proPrice = "\u96f6\u552e\u4ef7\u00a5" + mallProductEntity.getProPrice() + "-" + mallProductEntity.getProPrice1() + "/" + mallProductEntity.getProDw();
                }
                crowdFundingDetailVo.setProPrice(proPrice);
                LinkedHashMap<String, String> productPicList = new LinkedHashMap<String, String>();
                crowdFundingDetailVo.setProImage(this.picService.getProductPic(crowdFundingEntity.getProId(), productPicList, 0));
                crowdFundingDetailVo.setProDetailImages(this.picService.getProPicInfo(mallProductEntity.getProId(), 7));
                int joinPeople = this.getJoinPeopleCount(crowdFundingEntity.getActiveNo(), crowdFundingEntity.getProId(), crowdFundingEntity.getPeopleCount());
                crowdFundingDetailVo.setJoinPeople(joinPeople);
                crowdFundingDetailVo.setTargerProple(crowdFundingEntity.getTargerPeople());
                if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(new Date())) {
                    if (crowdFundingDetailVo.getTargerProple() <= joinPeople) {
                        crowdFundingDetailVo.setCrowdStatus(2);
                    } else {
                        crowdFundingDetailVo.setCrowdStatus(3);
                    }
                }
                double scale = MathUtils.mul((Number)MathUtils.div((Double)Double.valueOf(crowdFundingDetailVo.getJoinPeople()), (Double)Double.valueOf(crowdFundingDetailVo.getTargerProple()), (Integer)4), (Number)100);
                crowdFundingDetailVo.setPropleScale(scale);
                crowdFundingDetailVo.setForum_count(this.crowdFundingForumMapper.getCrowdFundingCountByParam(crowdId, 1));
            }
        }
        return BaseJsonVo.success(crowdFundingDetailVo);
    }

    @Override
    public BaseJsonVo getCrowdForumList(String customerId, int crowdId, String forumSource, int currentPage, int pageSize) {
        this.logger.info("forumSource1:" + forumSource);
        if (StringUtils.isEmpty((String)forumSource)) {
            forumSource = "1";
        }
        this.logger.info("forumSource1:" + forumSource);
        int crowdType = 1;
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallCrowdFundingForumVo> mallCrowdFundingForumVoList = this.crowdFundingForumMapper.getCrowdFundingListByParam(crowdId, crowdType, forumSource, customerId);
        if (mallCrowdFundingForumVoList != null && mallCrowdFundingForumVoList.size() > 0) {
            List<CrowdFundingForumLikeEntity> crowdFundingForumLikeEntityList = this.crowdFundingForumLikeMapper.getCrowdForumLikeInfoByCustomeId(customerId);
            ArrayList<String> ls = new ArrayList<String>();
            if (crowdFundingForumLikeEntityList != null && crowdFundingForumLikeEntityList.size() > 0) {
                for (CrowdFundingForumLikeEntity crowdFundingForumLikeEntity : crowdFundingForumLikeEntityList) {
                    ls.add(crowdFundingForumLikeEntity.getForumId().toString());
                }
            }
            for (MallCrowdFundingForumVo vo : mallCrowdFundingForumVoList) {
                vo.setDiffDate(CrowdService.getDateTimeDiff(vo.getCreateTime()));
                if (ls.contains(vo.getId() + "")) {
                    vo.setIsLike(2);
                }
                if (vo.getReturnList() == null || vo.getReturnList().size() <= 0) {
                    vo.setReturnList(new ArrayList<HashMap<String, String>>());
                }
                if (!StringUtils.isNotEmpty((String)vo.getForumMsgReturnContnet())) continue;
                String str = vo.getForumMsgReturnContnet();
                str = str.replaceAll("nickName=", "\"nickName\":\"");
                str = str.replaceAll(", contnet=", "\", \"contnet\":\"");
                str = str.replaceAll("\\}\\{", "\"},{");
                str = "[" + str.substring(0, str.length() - 1) + "\"}]";
                this.logger.info(str);
                try {
                    List hashMap = (List)JsonUtils.fromJson((String)str, ArrayList.class);
                    vo.setReturnList(hashMap);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(mallCrowdFundingForumVoList);
        MallCrowFundingForumNoticeVo mallCrowFundingForumNoticeVo = new MallCrowFundingForumNoticeVo();
        mallCrowFundingForumNoticeVo.setCrowdFundingForumVoList((PageInfo<MallCrowdFundingForumVo>)pg);
        mallCrowFundingForumNoticeVo.setNotice("");
        CrowdFundingEntity crowdFundingEntity = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(Integer.valueOf(crowdId));
        if (crowdFundingEntity != null) {
            mallCrowFundingForumNoticeVo.setNotice(crowdFundingEntity.getNotice());
        }
        return BaseJsonVo.success((Object)mallCrowFundingForumNoticeVo);
    }

    private static String getDateTimeDiff(Date d1) {
        Calendar cal_now = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d1);
        long fz = (cal_now.getTimeInMillis() - cal.getTimeInMillis()) / 60000L;
        long l = fz = fz < 1L ? 1L : fz;
        if (fz < 60L) {
            return fz + "\u5206\u949f\u524d";
        }
        if (fz < 1440L) {
            return fz / 60L + "\u5c0f\u65f6\u524d";
        }
        if (fz < 43200L) {
            return fz / 1440L + "\u5929\u524d";
        }
        int now_y = cal_now.get(1);
        int y = cal.get(1);
        int now_m = cal_now.get(2);
        int m = cal.get(2);
        return (now_y - y) * 12 + now_m - m + "\u6708\u524d";
    }

    @Override
    public BaseJsonVo saveLike(String customerId, String forumId) {
        List<CrowdFundingForumLikeEntity> crowdFundingForumLikeEntityList = this.crowdFundingForumLikeMapper.getCustomerLikeInfo(customerId, forumId);
        if (crowdFundingForumLikeEntityList == null || crowdFundingForumLikeEntityList.size() == 0) {
            CrowdFundingForumLikeEntity crowdFundingForumLikeEntity = new CrowdFundingForumLikeEntity();
            crowdFundingForumLikeEntity.setForumId(Long.valueOf(forumId));
            crowdFundingForumLikeEntity.setCustomerId(customerId);
            crowdFundingForumLikeEntity.setCreateTime(new Date());
            this.crowdFundingForumLikeMapper.insert(crowdFundingForumLikeEntity);
            this.crowdFundingForumMapper.updateForumLikeCountInfo(forumId);
        }
        return BaseJsonVo.success((Object)"\u70b9\u8d5e\u6210\u529f");
    }

    @Override
    public BaseJsonVo getCrowdShareSubQrcode(CustomerDetailVo customerDetailVo, String activeNo) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("qrcode_image_url", "");
        dataMap.put("bindcode", "");
        List<ActiveQrcodeEntity> activeQrcodeEntityList = this.activeQrcodeMapper.getActiveQrCodeByActiveNo(activeNo);
        if (activeQrcodeEntityList != null && activeQrcodeEntityList.size() > 0) {
            dataMap.put("qrcode_image_url", this.ossInterface.getImageResoure(activeQrcodeEntityList.get(0).getQrcodeImageUrl()));
            dataMap.put("bindcode", activeQrcodeEntityList.get(0).getBindCode());
        }
        dataMap.put("IsNewCustomer", 0);
        dataMap.put("IsNewCustomer", customerDetailVo.getSubscribe());
        WeiXinMediaEntity weiXinMediaEntity = this.activeQrcodeMapper.getShareParam4Acitve(activeQrcodeEntityList.get(0).getBindCode());
        dataMap.put("share_data", weiXinMediaEntity);
        dataMap.put("inviteId", this.getInviteId(activeNo, activeQrcodeEntityList.get(0).getBindCode(), customerDetailVo.getCustomerId()));
        dataMap.put("source", customerDetailVo.getCustomerId());
        this.logger.error("getCrowdShareSubQrcode:" + JsonUtils.toJson(dataMap, (boolean)false));
        return BaseJsonVo.success(dataMap);
    }

    @Override
    public String getInviteId(String activeNo, String bindCode, String customerId) {
        String inviteId1 = "";
        ActiveInviteEntity activeInviteEntity = this.activeInviteMapper.getInviteId(customerId, activeNo);
        if (activeInviteEntity != null && StringUtils.isNotEmpty((String)activeInviteEntity.getInviteId())) {
            inviteId1 = activeInviteEntity.getInviteId();
        }
        return inviteId1;
    }

    @Override
    public CrowdFundingEntity getCrowdFundingEntityByBindCode(String bindCode, String proId) {
        List<CrowdFundingEntity> crowdFunding;
        List<ActiveRuleEntity> rules = this.activeRuleInterface.getRuleListByBindCodeAndProId(bindCode, proId);
        if (rules != null && rules.size() > 0 && (crowdFunding = this.crowdFundingMapper.getCrowdFundingByProduct(rules.get(0).getActiveNo(), proId)) != null && crowdFunding.size() > 0) {
            return crowdFunding.get(0);
        }
        String activeNo = this.activeService.getActiveNoByBindCode(bindCode);
        List<CrowdFundingEntity> crowdFunding2 = this.crowdFundingMapper.getCrowdFundingByProduct(activeNo, proId);
        if (crowdFunding2 != null && crowdFunding2.size() > 0) {
            return crowdFunding2.get(0);
        }
        return null;
    }

    @Override
    public CrowdFundingEntity getCrowdFundingEntityByActiveNo(String activeNo, String proId) {
        List<CrowdFundingEntity> crowdFunding = this.crowdFundingMapper.getCrowdFundingByProduct(activeNo, proId);
        if (crowdFunding != null && crowdFunding.size() > 0) {
            return crowdFunding.get(0);
        }
        return null;
    }
}

