/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.fit;

import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.entity.active.PrizeCouponVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.fit.FitServiceContext;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.active.vo.FitActiveInviteResultVo;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.User;

@Service
public class FitService
extends ActiveBaseService
implements FitInterface {
    @Autowired
    private ActiveCustomerInterface activeCustomerInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private ActiveRuleInterface activeRuleInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private WeiXinMediaInterface weiXinMediaInterface;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private FitServiceContext fitServiceContext;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private CustomerInterface customerService;

    @Override
    public BaseJsonVo canJoinActive(String customerId, String bindCode) {
        return this.canJoinActive(customerId, bindCode, "");
    }

    @Override
    public BaseJsonVo canJoinActive(String customerId, String bindCode, String source) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        return this.fitServiceContext.canJoinActive(customerId, activeEntity, bindCode, source);
    }

    @Override
    public BaseJsonVo<FitActiveInviteResultVo> getActiveInvite(String bindCode, String customerId) {
        FitActiveInviteResultVo inviteResultVo = new FitActiveInviteResultVo();
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            Integer defaultCount = 0;
            defaultCount = this.getInviteNum(customerId, bindCode);
            ActiveRuleEntity activeRule = this.getPrizeRule(defaultCount, activeEntity);
            inviteResultVo.setPrizeStatus(0);
            ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
            activeCustomerEntity.setCustomerId(customerId);
            activeCustomerEntity.setBindCode(activeEntity.getBindCode());
            int baseCount = this.activeCustomerInterface.getInviteNum(activeCustomerEntity);
            if (baseCount == 0) {
                baseCount = activeEntity.getInviteNum();
            }
            inviteResultVo.setBaseCount(baseCount);
            if (activeRule != null) {
                this.logger.info("\u67e5\u8be2\u7528\u6237\u9080\u8bf7\u4eba\u6570\u4e3a:" + defaultCount);
                inviteResultVo.setPrizeStatus(1);
            }
            inviteResultVo.setCount(defaultCount);
            int needCount = baseCount - defaultCount >= 0 ? baseCount - defaultCount : 0;
            inviteResultVo.setInviteText(inviteResultVo.getInviteText().replace("{num}", String.valueOf(needCount)));
            inviteResultVo.setCityName("");
            this.logger.info("\u76ee\u6807\u4eba\u6570:" + inviteResultVo.getBaseCount());
            inviteResultVo.setEndTime(activeEntity.getEndTime());
            return BaseJsonVo.success((Object)inviteResultVo);
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
    }

    @Override
    public BaseJsonVo getActiveInvite(String bindCode, String customerId, String openId, Integer platFormId) {
        BaseJsonVo<FitActiveInviteResultVo> baseJsonVo = this.getActiveInvite(bindCode, customerId);
        if (baseJsonVo.isSuccess()) {
            FitActiveInviteResultVo inviteResultVo = (FitActiveInviteResultVo)baseJsonVo.getValue();
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, 1);
            if (customerDetailVo == null) {
                inviteResultVo.setIssubscribe(0);
            } else {
                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(1);
                User user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
                inviteResultVo.setIssubscribe(user.getSubscribe());
            }
        }
        return baseJsonVo;
    }

    private ActiveRuleEntity getPrizeRule(String customerId, ActiveEntity activeEntity, Integer defaultCount) {
        return this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), defaultCount);
    }

    private ActiveRuleEntity getPrizeRule(Integer defaultCount, ActiveEntity activeEntity) {
        return this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), defaultCount);
    }

    private Integer getInviteNum(String customerId, String bindCode) {
        ActiveCustomerEntity result;
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setBindCode(bindCode);
        List<ActiveCustomerEntity> list = this.activeCustomerInterface.getActiveCustomerEntityList(activeCustomerEntity);
        Integer defaultCount = 0;
        if (list != null && list.size() > 0 && (result = list.stream().filter(c -> c.getStatus() >= 1).findFirst().get()) != null) {
            defaultCount = defaultCount + result.getGiveShareCount();
        }
        Integer inviteNum = this.activeInviteInterface.getInviteNum(customerId, bindCode);
        defaultCount = defaultCount + (inviteNum == null ? 0 : inviteNum);
        return defaultCount;
    }

    private ActiveRuleEntity getPrizeRule(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        Integer defaultCount = this.getInviteNum(customerId, bindCode);
        return activeEntity != null ? this.getPrizeRule(customerId, activeEntity, defaultCount) : null;
    }

    @Override
    public BaseJsonVo prizeActive(String bindCode, String customerId, Integer platformId) {
        this.logger.info("\u7528\u6237\u5f00\u59cb\u5151\u5956:{},{}", (Object)bindCode, (Object)customerId);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            boolean lock = this.mallRedisLock.lock(customerId + bindCode + ":prize", "", 60L, TimeUnit.SECONDS);
            if (lock) {
                Integer status = this.activeCustomerInterface.getJoinActiveStatus(customerId, bindCode);
                if (status != null) {
                    if (status >= 2) {
                        return BaseJsonVo.error((String)"\u5df2\u5151\u5956");
                    }
                } else {
                    return BaseJsonVo.error((String)"\u672a\u53c2\u4e0e\u6d3b\u52a8,\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
                }
            }
            Integer inviteNum = this.getInviteNum(customerId, bindCode);
            ActiveRuleEntity activeRuleEntity = this.activeRuleInterface.getRuleByQuantity(activeEntity.getActiveNo(), inviteNum);
            if (activeRuleEntity == null) {
                return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
            }
            this.logger.info("\u5f00\u59cb\u53d1\u4f18\u60e0\u5238:{},{}", (Object)bindCode, (Object)customerId);
            BaseJsonVo baseJsonVo = this.activeCashticketInterface.sendTicket4Base(customerId, activeRuleEntity.getBindCode(), 0.0, "", platformId, true, true, null, "");
            if (baseJsonVo.isSuccess()) {
                this.logger.info("\u5151\u5956\u6210\u529f:{},{}", (Object)bindCode, (Object)customerId);
                baseJsonVo = this.activeCustomerInterface.prizeActive(customerId, bindCode);
                this.activeInviteInterface.setPrize(customerId, bindCode);
                return BaseJsonVo.success((Object)"");
            }
            return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
    }

    @Override
    public BaseJsonVo autoPrizeActive(String bindCode, String customerId, Integer platformId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            ActiveRuleEntity ruleEntity;
            BaseJsonVo baseJsonVo;
            boolean lock = this.mallRedisLock.lock(customerId + bindCode + ":prize", "", 60L, TimeUnit.SECONDS);
            if (lock) {
                Integer status = this.activeCustomerInterface.getJoinActiveStatus(customerId, bindCode);
                if (status != null) {
                    if (status >= 2) {
                        return BaseJsonVo.error((String)"\u5df2\u5151\u5956");
                    }
                } else {
                    return BaseJsonVo.error((String)"\u672a\u53c2\u4e0e\u6d3b\u52a8,\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
                }
            }
            Integer inviteNum = this.getInviteNum(customerId, bindCode);
            List<ActiveRuleEntity> list = this.activeRuleInterface.getRuleList(activeEntity.getActiveNo());
            if (list.size() == 0) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u5151\u5956\u89c4\u5219");
            }
            if (list != null && list.size() >= 1) {
                list.sort((c1, c2) -> c1.getInviteQuantityMin() - c2.getInviteQuantityMin());
            }
            if (list.stream().anyMatch(rule -> rule.getInviteQuantityMin().intValue() == inviteNum.intValue()) && (baseJsonVo = this.activeCashticketInterface.sendTicket4Base(customerId, (ruleEntity = (ActiveRuleEntity)list.stream().filter(rule -> rule.getInviteQuantityMin().intValue() == inviteNum.intValue()).collect(Collectors.toList()).get(0)).getBindCode(), "", platformId, true, null, "")).isSuccess()) {
                baseJsonVo = this.activeCustomerInterface.prizeActive(customerId, bindCode);
                return baseJsonVo;
            }
            return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
    }

    @Override
    public BaseJsonVo getShareByBindCode(String bindCode, String nickName, String customerId) {
        WeiXinMediaEntity weiXinMediaEntity;
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
        if (activeQrcodeEntity != null && StringUtils.isNotEmpty((String)activeQrcodeEntity.getShareMedia()) && (weiXinMediaEntity = this.weiXinMediaInterface.getMediaByMediaId(activeQrcodeEntity.getShareMedia())) != null) {
            if (StringUtils.isNotEmpty((String)weiXinMediaEntity.getUrl())) {
                if (weiXinMediaEntity.getUrl().indexOf("?") > 0) {
                    if (weiXinMediaEntity.getUrl().indexOf("bindCode") <= 0) {
                        weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "&bindCode=" + bindCode + "&source=" + customerId);
                    } else {
                        String url = weiXinMediaEntity.getUrl();
                        weiXinMediaEntity.setUrl(url.substring(0, url.indexOf("bindCode")) + "bindCode=" + bindCode + "&source=" + customerId);
                    }
                } else {
                    weiXinMediaEntity.setUrl(weiXinMediaEntity.getUrl() + "?bindCode=" + bindCode + "&source=" + customerId);
                }
            }
            weiXinMediaEntity.setDigest(weiXinMediaEntity.getDigest().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
            weiXinMediaEntity.setTitle(weiXinMediaEntity.getTitle().replace("{nickName}", StringUtils.isEmpty((String)nickName) ? "" : nickName));
            weiXinMediaEntity.setImageUrl(this.ossService.getImageResoure(weiXinMediaEntity.getImageUrl()));
            return BaseJsonVo.success((Object)weiXinMediaEntity);
        }
        return BaseJsonVo.success((Object)"\u672a\u7ed1\u5b9a\u5206\u4eab\u8fde\u63a5");
    }

    @Override
    public List<PrizeCouponVo> getActiveRuleList(String bindCode) {
        ArrayList<PrizeCouponVo> ruleVoList = new ArrayList<PrizeCouponVo>();
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        List<ActiveRuleEntity> list = this.activeRuleInterface.getRuleList(activeEntity.getActiveNo());
        if (list != null && list.size() >= 1) {
            list.sort((c1, c2) -> c1.getInviteQuantityMin() - c2.getInviteQuantityMin());
            list.forEach(c -> {
                PrizeCouponVo vo = new PrizeCouponVo();
                vo.setInviteQuantityMin(c.getInviteQuantityMin());
                ActiveCashticketVo activeCashticketVo = this.activeCashticketInterface.getCashticketByBindCode(c.getBindCode());
                if (activeCashticketVo != null) {
                    vo.setTicketBatchName(activeCashticketVo.getTicketBatchName());
                    CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(activeCashticketVo.getTicketBatchId());
                    vo.setAmount(cashticketBatchEntity.getAmount());
                }
                ruleVoList.add(vo);
            });
            return ruleVoList;
        }
        return null;
    }
}

