/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.groupon;

import cc.lechun.active.dao.groupon.GrouponConfigMapper;
import cc.lechun.active.dao.groupon.GrouponDetailMapper;
import cc.lechun.active.dao.groupon.GrouponMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.LevelPriceVo;
import cc.lechun.active.entity.groupon.ActitveItemVo;
import cc.lechun.active.entity.groupon.GroupTypeEnum;
import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponDetailEntity;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponOrder;
import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.entity.groupon.JoinOrderVo;
import cc.lechun.active.entity.groupon.MallGroupVo;
import cc.lechun.active.entity.groupon.StartGrouponItemVo;
import cc.lechun.active.entity.groupon.SuccessJoinOrderVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveItemInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.groupon.GrouponMessageContext;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.utils.LocationUtils;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GrouponService
extends ActiveBaseService
implements GrouponInterface {
    @Autowired
    private GrouponMapper grouponMapper;
    @Autowired
    private GrouponDetailMapper grouponDetailMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private GrouponConfigMapper configMapper;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private GrouponMessageContext grouponMessageContext;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveItemInterface activeItemService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    MallPromotionInterface promotionInterface;
    @Autowired
    ActivePropertyInterface activePropertyInterface;
    @Autowired
    private CustomerAddressInterface addressInterface;
    @Lazy
    @Autowired
    private MallTradeInterface tradeInterface;

    @Override
    public void updateProductSaleCount(MallOrderMainEntity orderMainEntity) {
        OrderListVo orderListVo = this.tradeInterface.getOrderDetail(orderMainEntity);
        GrouponOrder grouponOrder = this.grouponMapper.chaXunGrouponOrderByOrderNo(orderMainEntity.getOrderMainNo());
        orderListVo.getOrderProductVos().forEach(mallOrderProductVo -> {
            this.activeItemService.saveProductSaleCount(orderMainEntity.getBindCode(), mallOrderProductVo.getProductType(), mallOrderProductVo.getItemId(), mallOrderProductVo.getQuantity());
            if (grouponOrder != null && StringUtils.isNotEmpty((String)grouponOrder.getInviteId())) {
                String key = grouponOrder.getInviteId() + ":" + mallOrderProductVo.getItemId() + ":" + mallOrderProductVo.getProductType();
                this.redisCacheUtil.increment(key, mallOrderProductVo.getQuantity());
            }
        });
    }

    @Override
    public BaseJsonVo getDistance(String inviteId, String addressId) {
        String result = "";
        try {
            CustomerAddressEntity customerAddressEntity = this.addressInterface.getCustomerAddress(addressId);
            GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
            Double dis = LocationUtils.getDistance(customerAddressEntity.getProvinceName() + customerAddressEntity.getCityName() + customerAddressEntity.getAreaName() + customerAddressEntity.getAddress(), grouponEntity.getAddress());
            if (dis != null) {
                this.logger.info("\u8ddd\u79bb:{}", (Object)dis);
                result = dis.compareTo(1.0) >= 1 ? "\u8ddd\u63d0\u8d27\u5730\u5740" + dis.intValue() + "\u516c\u91cc" : "";
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u8ddd\u79bb\u51fa\u9519", (Throwable)e);
        }
        return BaseJsonVo.success((Object)result);
    }

    @Override
    public ActiveItemEntity getPrice(String bindCode, String itemId, Integer itemType, Integer count) {
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u5546\u54c1\u4ef7\u683c:\u5546\u54c1:{},\u6570\u91cf:{}", (Object)itemId, (Object)count);
        ActiveItemEntity itemQuery = new ActiveItemEntity();
        itemQuery.setBindCode(bindCode);
        itemQuery.setStatus(1);
        itemQuery.setItemId(itemId);
        itemQuery.setItemType(itemType);
        ActiveItemEntity itemEntity = (ActiveItemEntity)this.activeItemService.getSingle(itemQuery, 0L);
        if (itemEntity == null) {
            this.logger.error("\u5546\u54c1:{}\u672a\u542f\u7528\uff0c\u6216\u672a\u914d\u7f6e", (Object)itemId);
            throw new RuntimeException("\u65e0\u6548\u7684\u5546\u54c1");
        }
        if (StringUtils.isNotEmpty((String)itemEntity.getPriceList())) {
            List levelPriceVoList = JsonUtils.getListByArray(LevelPriceVo.class, (String)itemEntity.getPriceList());
            Optional<LevelPriceVo> LevelPriceVoOption = levelPriceVoList.stream().filter(d -> d.getStart() <= count && count <= d.getEnd()).findFirst();
            this.logger.info("\u67e5\u8be2\u5546\u54c1:{},\u6570\u91cf:{} \u4ef7\u683c:{}", new Object[]{itemId, count, LevelPriceVoOption.isPresent() ? LevelPriceVoOption.get().getPrice() : itemEntity.getSalePrice()});
            itemEntity.setSalePrice(LevelPriceVoOption.isPresent() ? LevelPriceVoOption.get().getPrice() : itemEntity.getSalePrice());
        }
        return itemEntity;
    }

    @Override
    public BaseJsonVo<MallGroupVo> getGrouponByInviteId(String bindCode, String inviteId) {
        if (StringUtils.isEmpty((String)inviteId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u56e2");
        }
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        return this.getGroupon(bindCode, grouponEntity);
    }

    @Override
    public BaseJsonVo<MallGroupVo> getGrouponByOrderNo(String bindCode, String orderMainNo) {
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8ba2\u5355\u53f7");
        }
        GrouponOrder grouponOrder = this.grouponMapper.chaXunGrouponOrderByOrderNo(orderMainNo);
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponOrder.getInviteId()));
        return this.getGroupon(bindCode, grouponEntity);
    }

    private BaseJsonVo<MallGroupVo> getGroupon(String bindCode, GrouponEntity grouponEntity) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        MallGroupVo mallGroupVo = new MallGroupVo();
        GrouponDetailEntity query = new GrouponDetailEntity();
        query.setInviteId(grouponEntity.getInviteId());
        List detailList = this.grouponDetailMapper.getList(query);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList<JoinOrderVo> joinOrderVoList = new ArrayList<JoinOrderVo>();
            detailList.forEach(detail -> {
                CustomerEntity customerEntity;
                if ((detail.getStatus() == 0 || detail.getStatus() == 1) && (customerEntity = this.customerService.getCustomer(detail.getAcceptCustomerId())) != null) {
                    JoinOrderVo joinOrderVo = new JoinOrderVo();
                    joinOrderVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
                    joinOrderVo.setNickName(customerEntity.getNickName());
                    joinOrderVoList.add(joinOrderVo);
                }
            });
            mallGroupVo.setJoinOrderVoList(joinOrderVoList);
        }
        BeanUtils.copyProperties((Object)grouponEntity, (Object)mallGroupVo);
        mallGroupVo.setPicMap(this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        long seconds = 0L;
        seconds = grouponEntity.getEndTime() != null ? DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)grouponEntity.getEndTime()) : DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
        mallGroupVo.setSeconds(seconds);
        mallGroupVo.setSecond(seconds / 3600L);
        mallGroupVo.setMinute(seconds % 3600L / 60L);
        mallGroupVo.setHour(seconds % 3600L % 60L);
        mallGroupVo.setGroupName(grouponEntity.getGroupName());
        ActiveItemEntity itemQuery = new ActiveItemEntity();
        itemQuery.setBindCode(bindCode);
        itemQuery.setStatus(1);
        List ls = this.activeItemService.getList(itemQuery);
        if (CollectionUtils.isNotEmpty((Collection)ls)) {
            ls = ls.stream().sorted(Comparator.comparing(ActiveItemEntity::getSequence)).collect(Collectors.toList());
            ArrayList<ActitveItemVo> groupItemVoList = new ArrayList<ActitveItemVo>();
            for (ActiveItemEntity item : ls) {
                BaseJsonVo<MallProductVO> sr;
                ActitveItemVo groupItemVo = new ActitveItemVo();
                groupItemVo.setOriginPrice(item.getOriginPrice());
                groupItemVo.setFactPrice(item.getSalePrice());
                BeanUtils.copyProperties((Object)item, (Object)groupItemVo);
                String key = grouponEntity.getInviteId() + ":" + item.getItemId() + ":" + item.getItemType();
                Object num = this.redisCacheUtil.get(key);
                groupItemVo.setSaleCount(num == null ? 0 : Integer.valueOf(num.toString()));
                if (Objects.equals(item.getItemType(), 4)) {
                    sr = this.productService.buildProductVO(item.getItemId(), 1, null, null, null, null, true, true, null, null);
                    if (!sr.isSuccess()) continue;
                    if (((MallProductVO)sr.getValue()).getValid().booleanValue()) {
                        groupItemVo.setLimitCount(((MallProductVO)sr.getValue()).getLimitBuyCount());
                        groupItemVo.setItemName(((MallProductVO)sr.getValue()).getProName());
                        groupItemVo.setOtherName(((MallProductVO)sr.getValue()).getProOtherName());
                        groupItemVo.setItemPicMap(((MallProductVO)sr.getValue()).getProductPic());
                        groupItemVoList.add(groupItemVo);
                        continue;
                    }
                    this.logger.info("\u4fc3\u9500:{}\u4e0d\u53ef\u7528:{}", (Object)((MallProductVO)sr.getValue()).getProName(), (Object)((MallProductVO)sr.getValue()).getInvalidReason());
                    continue;
                }
                if (!Objects.equals(item.getItemType(), 1) || !(sr = this.promotionInterface.buildPromotionVO(item.getItemId(), 1, true)).isSuccess()) continue;
                if (((MallPromotionVO)sr.getValue()).getValid().booleanValue()) {
                    groupItemVo.setLimitCount(((MallPromotionVO)sr.getValue()).getLimitCount());
                    groupItemVo.setItemName(((MallPromotionVO)sr.getValue()).getPromotionName());
                    groupItemVo.setOtherName(((MallPromotionVO)sr.getValue()).getProSummary());
                    groupItemVo.setItemPicMap(((MallPromotionVO)sr.getValue()).getPromotionPic());
                    groupItemVoList.add(groupItemVo);
                    continue;
                }
                this.logger.info("\u4fc3\u9500:{}\u4e0d\u53ef\u7528:{}", (Object)((MallPromotionVO)sr.getValue()).getPromotionName(), (Object)((MallPromotionVO)sr.getValue()).getInvalidReason());
            }
            mallGroupVo.setItemList(groupItemVoList);
        }
        return BaseJsonVo.success((Object)mallGroupVo);
    }

    @Override
    public List<JoinOrderVo> getJoinOrderVoList(String inviteId) {
        ArrayList<JoinOrderVo> list = new ArrayList<JoinOrderVo>();
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(grouponEntity.getCustomerId(), grouponEntity.getPlatformId());
        JoinOrderVo joinOrderVo = new JoinOrderVo();
        joinOrderVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
        joinOrderVo.setNickName(customerDetailVo.getNickName());
        list.add(joinOrderVo);
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        grouponDetailEntity.setInviteId(inviteId);
        List detailEntityList = this.grouponDetailMapper.getList(grouponDetailEntity);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            detailEntityList.stream().filter(d -> d.getStatus() >= 0).forEach(d -> {
                CustomerDetailVo customerDetailVo2 = this.customerService.getCustomerDetail(d.getAcceptCustomerId(), grouponEntity.getPlatformId());
                JoinOrderVo joinOrderVo2 = new JoinOrderVo();
                joinOrderVo2.setHeadImageUrl(customerDetailVo2.getHeadImageUrl());
                joinOrderVo2.setNickName(customerDetailVo2.getNickName());
                list.add(joinOrderVo2);
            });
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfigByBindCode")
    public GrouponConfigEntity getGrouponConfigByBindCode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return this.getGrouponConfig(activeEntity.getActiveNo());
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getSuccessGrouponList", expiration=300)
    public List<SuccessJoinOrderVo> getSuccessGrouponList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer num, @ParameterValueKeyProvider(order=2) Integer platformId) {
        ArrayList<SuccessJoinOrderVo> successJoinOrderVoArrayList = new ArrayList<SuccessJoinOrderVo>();
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        grouponDetailEntity.setStatus(1);
        grouponDetailEntity.setBindCode(bindCode);
        List<GrouponDetailEntity> dettailList = this.grouponDetailMapper.getSuccessGrouponList(bindCode, num, 1);
        if (dettailList != null && dettailList.size() >= 1) {
            dettailList.forEach(g -> {
                SuccessJoinOrderVo successJoinOrderVo = new SuccessJoinOrderVo();
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(g.getAcceptCustomerId(), platformId);
                if (customerDetailVo != null) {
                    BeanUtils.copyProperties((Object)customerDetailVo, (Object)successJoinOrderVo);
                }
                successJoinOrderVoArrayList.add(successJoinOrderVo);
            });
        }
        return successJoinOrderVoArrayList;
    }

    @Override
    public BaseJsonVo checkCanJoin(String bindCode, String customerId, String inviteId) {
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (grouponEntity == null) {
            return BaseJsonVo.error((String)"\u554a\u5662~\u672a\u77e5\u7684\u56e2\u8d2d\u6d3b\u52a8");
        }
        if (Objects.equals(grouponEntity.getGroupType(), GroupTypeEnum.common_group.getValue()) || Objects.equals(grouponEntity.getGroupType(), null)) {
            if (grouponEntity.getIsPrize() == 1) {
                return BaseJsonVo.success((Object)3);
            }
            if (grouponEntity.getEndTime().before(DateUtils.now())) {
                return BaseJsonVo.success((Object)6);
            }
            GrouponConfigEntity grouponConfigEntity = this.getGrouponConfig(grouponEntity.getActiveNo());
            if (grouponConfigEntity.getAllowUserType() == 2) {
                if (customerId.equals(grouponEntity.getCustomerId())) {
                    return BaseJsonVo.success((Object)7);
                }
            } else {
                int num = this.mallOrderMainService.getOrderNum(customerId);
                if (num >= 1) {
                    return BaseJsonVo.success((Object)5);
                }
            }
        } else if (Objects.equals(grouponEntity.getGroupType(), GroupTypeEnum.community_group.getValue())) {
            if (grouponEntity.getIsPrize() == 1) {
                return BaseJsonVo.success((Object)3);
            }
            if (grouponEntity.getEndTime() != null && grouponEntity.getEndTime().before(DateUtils.now())) {
                return BaseJsonVo.success((Object)6);
            }
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(grouponEntity.getBindCode());
            BaseJsonVo checkResult = this.activeService.checkActiveEnable(activeEntity);
            if (!checkResult.isSuccess()) {
                return BaseJsonVo.success((Object)6);
            }
        }
        return BaseJsonVo.success((Object)1);
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponList", expiration=60)
    public List<StartGrouponItemVo> getGrouponList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer num, @ParameterValueKeyProvider(order=2) Integer groupType) {
        ArrayList<StartGrouponItemVo> listStart = new ArrayList<StartGrouponItemVo>();
        GrouponEntity grouponEntity = new GrouponEntity();
        grouponEntity.setIsPrize(0);
        grouponEntity.setBindCode(bindCode);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        List<GrouponEntity> list = this.grouponMapper.getStartOrderList(bindCode, 0, num, groupType);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(g -> {
                StartGrouponItemVo startGrouponItemVo = new StartGrouponItemVo();
                startGrouponItemVo.setGroupTypeName(GroupTypeEnum.getName(groupType));
                BeanUtils.copyProperties((Object)g, (Object)startGrouponItemVo);
                if (Objects.equals(g.getGroupType(), GroupTypeEnum.common_group.getValue())) {
                    CustomerDetailVo customerDetailVo;
                    if (g.getEndTime() != null && g.getEndTime().after(DateUtils.now()) && (customerDetailVo = this.customerService.getCustomerDetail(g.getCustomerId(), g.getPlatformId())) != null) {
                        startGrouponItemVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
                        startGrouponItemVo.setNickName(customerDetailVo.getNickName());
                        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)g.getEndTime());
                        startGrouponItemVo.setSecond(seconds);
                        startGrouponItemVo.setShortNum(g.getJoinNum() - g.getInviteCount());
                        listStart.add(startGrouponItemVo);
                    }
                } else if (Objects.equals(g.getGroupType(), GroupTypeEnum.community_group.getValue()) && activeEntity != null) {
                    Map<String, List<String>> picList = this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue());
                    startGrouponItemVo.setHeadImageUrl(picList.containsKey("picActiveHead") ? picList.get("picActiveHead").get(0) : "");
                    startGrouponItemVo.setNickName(g.getGroupName());
                    long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
                    startGrouponItemVo.setSecond(seconds);
                    listStart.add(startGrouponItemVo);
                }
            });
        }
        return listStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveGrouponOrder(GrouponOrderVo grouponOrderVo) {
        try {
            if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNPAY.getValue()) {
                this.logger.info("\u63d0\u4ea4\u4e86\u53c2\u56e2\u8ba2\u5355:{}", (Object)grouponOrderVo.toString());
                this.joinGroupon(grouponOrderVo);
                return;
            }
            if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNCONFIRM.getValue()) {
                String productName = this.getProductName(grouponOrderVo.getOrderMainNo());
                grouponOrderVo.setProductName(productName);
                GrouponOrder grouponOrder = this.grouponMapper.chaXunGrouponOrderByOrderNo(grouponOrderVo.getOrderMainNo());
                if (grouponOrder == null) {
                    if (!Objects.equals(grouponOrder.getOrderType(), GroupTypeEnum.common_group.getValue())) return;
                    this.createGroupon(grouponOrderVo);
                    return;
                } else {
                    this.logger.info("\u62fc\u56e2\u8ba2\u5355\u4e0b\u76f4\u63a5\u652f\u4ed8:{}", (Object)grouponOrderVo.toString());
                    if (StringUtils.isEmpty((String)grouponOrderVo.getInviteId())) {
                        grouponOrderVo.setInviteId(grouponOrder.getInviteId());
                    }
                    if (Objects.equals(grouponOrderVo.getGroupType(), GroupTypeEnum.community_group.getValue())) {
                        GrouponEntity grouponEntity;
                        this.logger.info("\u5f00\u59cb\u589e\u52a0\u53c2\u56e2\u8ba2\u5355\u91d1\u989d:{}", (Object)grouponOrderVo.getPrice());
                        int k = this.grouponDetailMapper.updateJoinGrouponStatusByOrder(grouponOrderVo.getOrderMainNo(), 0);
                        this.logger.info("\u8ba2\u5355\u53f7:{}\u53c2\u56e2\u72b6\u6001\u66f4\u65b0:{}", (Object)grouponOrderVo.getOrderMainNo(), (Object)(k > 0 ? 1 : 0));
                        if (k > 0) {
                            k = this.grouponMapper.saveGroupAmout(grouponOrder.getInviteId(), grouponOrderVo.getPrice());
                            this.logger.info("\u53c2\u56e2\u8ba2\u5355\u91d1\u989d\u589e\u52a0:{}", (Object)(k > 0 ? 1 : 0));
                        }
                        if ((grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponOrder.getInviteId()))).getIsPrize() != 1) return;
                        this.mallOrderMainService.updateOrderMainStatus(grouponOrderVo.getOrderMainNo(), OrderStatusEnum.PAYCONFIRM.getName(), OrderStatusEnum.UNCONFIRM.getValue());
                        return;
                    } else {
                        this.joinGroupon(grouponOrderVo);
                    }
                }
                return;
            }
            if (grouponOrderVo.getStatus().intValue() != OrderStatusEnum.COMPLETION.getValue()) return;
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u8d2d\u8ba2\u5355\u51fa\u9519:{}", (Object)grouponOrderVo.toString(), (Object)e);
        }
    }

    @Override
    public void saveGrouponOrder(MallOrderMainEntity mallOrderEntity) {
        GrouponOrderVo grouponOrderVo = new GrouponOrderVo();
        grouponOrderVo.setOrderMainNo(mallOrderEntity.getOrderMainNo());
        grouponOrderVo.setCustomerId(mallOrderEntity.getCustomerId());
        grouponOrderVo.setPlatFormId(mallOrderEntity.getPlatformId());
        grouponOrderVo.setStatus(OrderStatusEnum.UNCONFIRM.getValue());
        grouponOrderVo.setBindCode(mallOrderEntity.getBindCode());
        grouponOrderVo.setInviteId("");
        grouponOrderVo.setActiveNo(mallOrderEntity.getActiveNo());
        grouponOrderVo.setPrice(mallOrderEntity.getTotalAmount());
        BaseJsonVo<Integer> typeResult = this.getGrouponTypeByBindCode(mallOrderEntity.getBindCode());
        if (typeResult.isSuccess()) {
            grouponOrderVo.setGroupType((Integer)typeResult.getValue());
        }
        this.saveGrouponOrder(grouponOrderVo);
    }

    @Override
    public GrouponOrder getGrouponOrderByOrderNo(String orderMainNo) {
        return this.grouponMapper.chaXunGrouponOrderByOrderNo(orderMainNo);
    }

    @Override
    public GrouponEntity getGrouponInfoByInviteId(String inviteid) {
        return (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteid));
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponHourByBindCode")
    public Integer getGrouponHourByBindCode(@ParameterValueKeyProvider String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveQrcode(bindCode).getActiveNo();
        GrouponConfigEntity grouponConfigEntity = this.getGrouponConfig(activeNo);
        return grouponConfigEntity == null ? null : Integer.valueOf(grouponConfigEntity.getGrouponHour() + 1);
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfig")
    public GrouponConfigEntity getGrouponConfig(@ParameterValueKeyProvider String activeNo) {
        GrouponConfigEntity grouponConfigEntity = new GrouponConfigEntity();
        grouponConfigEntity.setActiveNo(activeNo);
        return (GrouponConfigEntity)this.configMapper.getSingle(grouponConfigEntity);
    }

    private void paySucessGroupon(GrouponOrderVo grouponOrderVo) {
        String keyNum = grouponOrderVo.getInviteId() + ":joinedGrouponKey:Num";
        grouponOrderVo.setProductType(this.getGrouponType(grouponOrderVo.getBindCode()));
        this.memcachedService.incr("", keyNum, 1, 1L, 172800);
        this.grouponMessageContext.startGrouponNotice(grouponOrderVo);
    }

    private void createGroupon(GrouponOrderVo grouponOrderVo) {
        boolean temp;
        GrouponEntity grouponEntity = new GrouponEntity();
        grouponEntity.setCreateTime(DateUtils.now());
        grouponEntity.setCustomerId(grouponOrderVo.getCustomerId());
        grouponEntity.setInviteId(String.valueOf(RandomUtils.generateId()));
        BaseJsonVo<Integer> groupTypeResult = this.getGrouponTypeByBindCode(grouponOrderVo.getBindCode());
        grouponEntity.setIsPrize(0);
        grouponEntity.setOrderMainNo(grouponOrderVo.getOrderMainNo());
        grouponEntity.setBindCode(grouponOrderVo.getBindCode());
        grouponEntity.setOrderType(1);
        if (groupTypeResult.isSuccess()) {
            // empty if block
        }
        grouponEntity.setInviteCount(1);
        grouponEntity.setPrizeTime(DateUtils.now());
        grouponEntity.setPlatformId(grouponOrderVo.getPlatFormId());
        grouponEntity.setActiveNo(grouponOrderVo.getActiveNo());
        grouponEntity.setJoinNum(this.getJoinNum(grouponOrderVo.getBindCode()));
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55:\u56e2\u8d2d\u62fc\u56e2\u65f6\u95f4\u8bbe\u7f6e:{}", (Object)this.getGrouponConfig(grouponEntity.getActiveNo()).getGrouponHour());
        grouponEntity.setEndTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(this.getGrouponConfig(grouponEntity.getActiveNo()).getGrouponHour() * 60 * 60)));
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55:{}", (Object)grouponOrderVo.toString());
        boolean bl = temp = this.grouponMapper.insertSelective(grouponEntity) >= 1;
        if (temp) {
            grouponOrderVo.setEndTime(grouponEntity.getEndTime());
            grouponOrderVo.setInviteId(grouponEntity.getInviteId());
            grouponOrderVo.setTotal(grouponEntity.getJoinNum());
            grouponOrderVo.setOnly(grouponEntity.getInviteCount());
            grouponOrderVo.setGrouponRoleType(1);
            String nick = this.customerService.getCustomer(grouponEntity.getCustomerId()).getNickName();
            grouponOrderVo.setGrouponerNick(StringUtils.isEmpty((String)nick) ? "" : nick);
            this.paySucessGroupon(grouponOrderVo);
        }
        this.logger.info("\u5199\u5f00\u56e2\u8bb0\u5f55\u72b6\u6001:{},{}", (Object)temp, (Object)grouponOrderVo.toString());
    }

    private void joinGroupon(GrouponOrderVo grouponOrderVo) {
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNPAY.getValue()) {
            this.createJoinGroupon(grouponOrderVo, grouponDetailEntity);
        } else if (grouponOrderVo.getStatus().intValue() == OrderStatusEnum.UNCONFIRM.getValue()) {
            this.paySuccessJoinGroupon(grouponOrderVo);
        }
    }

    @Override
    public void paySuccessJoinGroupon(GrouponOrderVo grouponOrderVo) {
        if (Objects.equals(grouponOrderVo.getGroupType(), GroupTypeEnum.common_group.getValue())) {
            GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
            String keyNum = grouponOrderVo.getInviteId() + ":joinedGrouponKey:Num";
            Long num = this.memcachedService.incr("", keyNum, 1, 1L, 172800);
            this.logger.info("\u56e2\u8d2dId:{} ,\u4eba\u6570:{}", (Object)grouponOrderVo.getInviteId(), (Object)num.intValue());
            GrouponDetailEntity tempGroupon = this.getGrouponDetailByOrder(grouponOrderVo.getOrderMainNo());
            grouponDetailEntity.setInviteDetailId(tempGroupon.getInviteDetailId());
            GrouponEntity updateGrouponEntity = new GrouponEntity();
            updateGrouponEntity.setInviteId(tempGroupon.getInviteId());
            GrouponEntity tempGrouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)tempGroupon.getInviteId()));
            if (tempGrouponEntity.getInviteCount() > num.intValue()) {
                num = (long)tempGrouponEntity.getInviteCount();
            }
            grouponDetailEntity.setCustomerId(tempGrouponEntity.getCustomerId());
            tempGroupon.setCustomerId(tempGrouponEntity.getCustomerId());
            Integer totalNum = tempGrouponEntity.getJoinNum();
            grouponOrderVo.setTotal(totalNum);
            if (num < (long)totalNum.intValue()) {
                grouponDetailEntity.setStatus(0);
                updateGrouponEntity.setInviteCount(num.intValue());
                grouponOrderVo.setGrouponRoleType(2);
                grouponOrderVo.setOnly(num.intValue());
                grouponOrderVo.setEndTime(tempGrouponEntity.getEndTime());
                grouponOrderVo.setInviteId(tempGroupon.getInviteId());
                this.grouponMessageContext.startGrouponNotice(grouponOrderVo);
                this.grouponMessageContext.noticeGrouponerShare(grouponOrderVo, tempGroupon);
            } else {
                grouponDetailEntity.setStatus(1);
                grouponDetailEntity.setPrizeTime(DateUtils.now());
                updateGrouponEntity.setInviteCount(totalNum);
                updateGrouponEntity.setIsPrize(1);
                updateGrouponEntity.setPrizeTime(DateUtils.now());
            }
            this.updateGrouponOrderInfo(grouponDetailEntity, updateGrouponEntity);
            if (num >= (long)totalNum.intValue()) {
                HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
                messageBody2.put("userId", grouponOrderVo.getCustomerId());
                messageBody2.put("dataFrom", "\u6210\u56e2");
                messageBody2.put("bindCode", grouponOrderVo.getBindCode());
                messageBody2.put("activeNo", grouponOrderVo.getActiveNo());
                messageBody2.put("versionName", "");
                messageBody2.put("createTime", DateUtils.now());
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)grouponOrderVo.getOrderMainNo(), messageBody2));
                String key = tempGroupon.getInviteId() + ":success:notice";
                if (this.memcachedService.get("", key) == null) {
                    this.memcachedService.set("", key, (Object)1, 300);
                    grouponOrderVo.setEndTime(tempGrouponEntity.getEndTime());
                    grouponOrderVo.setProductType(this.getGrouponType(tempGrouponEntity.getBindCode()));
                    String nick = "";
                    if (grouponOrderVo.getGroupType().intValue() == GroupTypeEnum.common_group.getValue()) {
                        nick = this.customerService.getCustomer(tempGrouponEntity.getCustomerId()).getNickName();
                    } else if (grouponOrderVo.getGroupType().intValue() == GroupTypeEnum.community_group.getValue()) {
                        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponOrderVo.getInviteId()));
                        nick = "";
                    }
                    this.logger.info("\u56e2\u957f\u6635\u79f0:{},\u56e2\u957fcustomerId={}", (Object)nick, (Object)tempGroupon.getCustomerId());
                    grouponOrderVo.setGrouponerNick(StringUtils.isNotEmpty((String)nick) ? nick : "");
                    this.pushGrouponedSuccessNotice(grouponOrderVo, tempGrouponEntity, totalNum);
                } else {
                    int grouponType = this.getGrouponType(tempGrouponEntity.getBindCode());
                    String orderStatusName = grouponType == 1 ? OrderStatusEnum.PAYCONFIRM.getName() : OrderStatusEnum.COMPLETION.getName();
                    this.mallOrderMainService.updateOrderMainStatus(grouponOrderVo.getOrderMainNo(), orderStatusName, OrderStatusEnum.UNCONFIRM.getValue());
                }
            }
        }
    }

    @Override
    @Transactional
    public void updateGrouponOrderInfo(GrouponDetailEntity grouponDetailEntity, GrouponEntity updateGrouponEntity) {
        this.grouponMapper.updateByPrimaryKeySelective(updateGrouponEntity);
        this.grouponDetailMapper.updateByPrimaryKeySelective(grouponDetailEntity);
    }

    @Override
    public String getProductName(String orderNo) {
        Map<String, Object> proMap = this.grouponMapper.getGroupInfoByOrderNo(orderNo);
        return (String)proMap.getOrDefault("PRODUCT_NAME", "");
    }

    private void pushGrouponedSuccessNotice(GrouponOrderVo grouponOrderVo, GrouponEntity tempGrouponEntity, Integer totalNum) {
        List<GrouponOrder> grouponOrderList = this.grouponMapper.chaXunGrouponOrderList(tempGrouponEntity.getInviteId());
        int grouponType = this.getGrouponType(tempGrouponEntity.getBindCode());
        String orderStatusName = grouponType == 1 ? OrderStatusEnum.PAYCONFIRM.getName() : OrderStatusEnum.COMPLETION.getName();
        boolean setJoinFlag = false;
        for (GrouponOrder m : grouponOrderList) {
            MallOrderMainEntity orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(m.getOrderMainNo());
            if (orderMainEntity.getStatus() == 2) {
                this.logger.info("\u66f4\u65b0\u4e3b\u8ba2\u5355\u72b6\u6001:{},\u72b6\u6001\u4e3a:{},\u8001\u72b6\u6001\u4e3a:{}", new Object[]{grouponOrderVo.getOrderMainNo(), orderStatusName, orderMainEntity.getStatus()});
                this.mallOrderMainService.updateOrderMainStatus(m.getOrderMainNo(), orderStatusName, OrderStatusEnum.UNCONFIRM.getValue());
                if (null != m.getOrderType()) {
                    this.logger.info("\u6210\u56e2\u8ba2\u5355\u4fe1\u606f:{}", (Object)m.toString());
                    if (1 == m.getOrderType()) {
                        GrouponEntity tempGroupon2 = new GrouponEntity();
                        tempGroupon2.setInviteId(tempGrouponEntity.getInviteId());
                        tempGroupon2.setOrderMainNo(m.getOrderMainNo());
                        tempGroupon2.setIsPrize(1);
                        tempGroupon2.setPrizeTime(DateUtils.now());
                        tempGroupon2.setInviteCount(totalNum);
                        this.grouponMapper.updateByPrimaryKeySelective(tempGroupon2);
                        this.logger.info("\u5df2\u8bbe\u7f6e\u5f00\u56e2\u8ba2\u5355\u4e3a\u5df2\u6210\u56e2:{}", (Object)tempGroupon2.toString());
                    } else if (2 == m.getOrderType() && !setJoinFlag) {
                        boolean tempStatus;
                        GrouponDetailEntity tempGrouponDetailEntity = new GrouponDetailEntity();
                        tempGrouponDetailEntity.setStatus(1);
                        tempGrouponDetailEntity.setPrizeTime(DateUtils.now());
                        tempGrouponDetailEntity.setInviteId(m.getInviteId());
                        boolean bl = tempStatus = this.grouponDetailMapper.updateGrouponOrderInfoByInviteId(tempGrouponDetailEntity) >= 1;
                        if (tempStatus) {
                            setJoinFlag = true;
                            this.logger.info("\u5df2\u8bbe\u7f6e\u62fc\u56e2\u8ba2\u5355\u4e3a\u5df2\u6210\u56e2:{}", (Object)tempGrouponDetailEntity.toString());
                        }
                    }
                }
                if (grouponType == GroupTypeEnum.community_group.getValue()) {
                    this.logger.info("\u5f00\u59cb\u53d1\u653e\u4f18\u60e0\u5238:customerId={},bincode={}", (Object)m.getCustomerId(), (Object)grouponOrderVo.getBindCode());
                    this.activeCashticketService.sendTicket4BaseAsynchronous(m.getCustomerId(), grouponOrderVo.getBindCode(), "", grouponOrderVo.getPlatFormId(), true);
                }
                grouponOrderVo.setCustomerId(orderMainEntity.getCustomerId());
                this.grouponMessageContext.joinGrouponNoticeSuccess(grouponOrderVo);
                continue;
            }
            this.logger.info("\u56e2\u8d2d\u8ba2\u5355\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u5f85\u53d1\u8d27:{},\u8ba2\u5355\u72b6\u6001\u4e3a:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getStatus());
            this.logger.info("\u56e2\u8d2d\u8ba2\u5355:{}", (Object)orderMainEntity.toString());
        }
    }

    private void createJoinGroupon(GrouponOrderVo grouponOrderVo, GrouponDetailEntity grouponDetailEntity) {
        this.logger.info("\u63d0\u4ea4\u62fc\u56e2\u8ba2\u5355:{}", (Object)grouponDetailEntity.toString());
        GrouponEntity tempGrouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponOrderVo.getInviteId()));
        grouponDetailEntity.setCreateTime(DateUtils.now());
        grouponDetailEntity.setCustomerId(tempGrouponEntity.getCustomerId());
        grouponDetailEntity.setInviteId(grouponOrderVo.getInviteId());
        grouponDetailEntity.setStatus(-1);
        grouponDetailEntity.setAcceptCustomerId(grouponOrderVo.getCustomerId());
        grouponDetailEntity.setBindCode(grouponOrderVo.getBindCode());
        grouponDetailEntity.setPlatformId(grouponOrderVo.getPlatFormId());
        grouponDetailEntity.setOrderMainNo(grouponOrderVo.getOrderMainNo());
        boolean temp = this.grouponDetailMapper.insertSelective(grouponDetailEntity) >= 1;
        this.logger.info("\u521b\u5efa\u62fc\u56e2\u8ba2\u5355\u72b6\u6001:{},{}", (Object)temp, (Object)grouponDetailEntity.toString());
    }

    public Integer getJoinNum(String bindCode) {
        String activeNo = this.activeQrcodeService.getActiveQrcode(bindCode).getActiveNo();
        if ("".equals(bindCode)) {
            return 3;
        }
        return this.getGrouponConfig(activeNo).getJoinNum();
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponType")
    public Integer getGrouponType(@ParameterValueKeyProvider String bindCode) {
        List<ActivePropertyEntity> propertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (CollectionUtils.isNotEmpty(propertyList)) {
            // empty if block
        }
        String activeNo = this.activeQrcodeService.getActiveNoQrcode(bindCode);
        return this.getGrouponConfig(activeNo).getGrouponType();
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponType")
    public BaseJsonVo<Integer> getGrouponTypeByBindCode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        Integer groupType = Objects.equals(activeEntity.getActiveType(), 43) ? 2 : 1;
        return BaseJsonVo.success((Object)groupType);
    }

    private GrouponDetailEntity getGrouponDetailByOrder(String orderNo) {
        GrouponDetailEntity temp = new GrouponDetailEntity();
        temp.setOrderMainNo(orderNo);
        return (GrouponDetailEntity)this.grouponDetailMapper.getSingle(temp);
    }

    @Override
    public List<GrouponRefundOrderVo> getUnRefundApplyOrders(Date date) {
        List<GrouponRefundOrderVo> unknownList;
        List<GrouponRefundOrderVo> joinList;
        ArrayList<GrouponRefundOrderVo> orderList = new ArrayList<GrouponRefundOrderVo>();
        List<GrouponRefundOrderVo> startList = this.starerRefund(date);
        if (startList != null && startList.size() >= 1) {
            orderList.addAll(startList);
        }
        if ((joinList = this.joinRefund(date)) != null && joinList.size() >= 1) {
            orderList.addAll(joinList);
        }
        if ((unknownList = this.unknowRefund(date)) != null && unknownList.size() >= 1) {
            orderList.addAll(unknownList);
        }
        return orderList;
    }

    @Override
    public BaseJsonVo updateGrouponOrderStatus(GrouponRefundOrderVo grouponRefundOrderVo) {
        this.logger.info("\u8d85\u65f6\u8ba2\u5355\u4e3a:{}", (Object)grouponRefundOrderVo.toString());
        if (grouponRefundOrderVo.getGrouponRoleType() != null) {
            if (grouponRefundOrderVo.getGrouponRoleType() == 1) {
                GrouponEntity grouponEntity = new GrouponEntity();
                grouponEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponEntity.setIsPrize(2);
                int k = this.grouponMapper.updateGrouponOrderInfoByOrderNo(grouponEntity);
                this.logger.info("\u8bbe\u7f6e\u5f00\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            } else if (grouponRefundOrderVo.getGrouponRoleType() == 2) {
                GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
                grouponDetailEntity.setOrderMainNo(grouponRefundOrderVo.getOrderMainNo());
                grouponDetailEntity.setStatus(2);
                int k = this.grouponDetailMapper.updateGrouponOrderInfoByOrderNo(grouponDetailEntity);
                this.logger.info("\u8bbe\u7f6e\u62fc\u56e2\u72b6\u6001\u4e3a\u62fc\u56e2\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},\u8bbe\u7f6e\u72b6\u6001\uff1a{}", (Object)grouponRefundOrderVo.getOrderMainNo(), (Object)(k >= 1 ? 1 : 0));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public GrouponEntity getGrouponById(String inviteId) {
        return (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
    }

    private List<GrouponRefundOrderVo> starerRefund(Date date) {
        List<GrouponEntity> list = this.grouponMapper.getUnrefundStartOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getIsPrize() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(1);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> joinRefund(Date date) {
        List<GrouponDetailEntity> list = this.grouponDetailMapper.getUnrefundJoinOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getStatus() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setCustomerId(c.getAcceptCustomerId());
                grouponRefundOrderVo.setGrouponRoleType(2);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> unknowRefund(Date date) {
        List<MallOrderMainEntity> list = this.mallOrderMainService.getTeamSaleOrderList(date);
        if (list != null && list.size() >= 1) {
            return list.stream().map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(3);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void removeCache(GrouponConfigEntity grouponConfigEntity) {
        if (grouponConfigEntity != null) {
            this.memcachedService.delete("GrouponService.getGrouponConfig", grouponConfigEntity.getActiveNo());
            List<ActiveQrcodeEntity> list = this.activeQrcodeService.getQrcodeListByActiveNo(grouponConfigEntity.getActiveNo());
            if (list != null && list.size() >= 1) {
                list.forEach(q -> {
                    this.memcachedService.delete("GrouponService.getGrouponHourByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponConfigByBindCode", q.getBindCode());
                    this.memcachedService.delete("GrouponService.getGrouponType", q.getBindCode());
                });
            }
        }
    }
}

