/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.luckydraw;

import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawUserMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawPrizeEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawUserEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawPrizeInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawUserInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveLuckyDrawUserService
extends BaseService<ActiveLuckyDrawUserEntity, Integer>
implements ActiveLuckyDrawUserInterface {
    @Resource
    private ActiveLuckyDrawUserMapper activeLuckyDrawUserMapper;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActiveLuckyDrawInterface drawInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveLuckyDrawPrizeInterface prizeInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;

    @Override
    public BaseJsonVo getCurrentLucky(String bindCode, String customerId) {
        boolean flag;
        BaseJsonVo jsonVo = this.checkLucky(bindCode, 0, customerId);
        boolean bl = flag = Objects.equals(bindCode, "1790229688092987393") || Objects.equals(bindCode, "1790044345192288257") || Objects.equals(bindCode, "1742031918795591680") || Objects.equals(bindCode, "1742031612435238912");
        if (jsonVo.isSuccess()) {
            ActiveEntity activeEntity;
            ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)jsonVo.getValue();
            Object result = new HashedMap();
            if (drawEntity != null) {
                Integer baseCount = drawEntity.getBaseCount() == null ? 0 : drawEntity.getBaseCount();
                drawEntity.setBaseCount(baseCount + this.getCurrentSubscribeCount(drawEntity.getId()));
                result = ObjectConvert.beanToMap((Object)drawEntity);
                Boolean b = this.isScribe(drawEntity.getId(), customerId);
                result.put("reserveStatus", b != false ? 1 : 0);
                String notice = "\u9650\u65f6\u62bd\u53d61\u4f4d\u5fae\u4fe1\u8001\u7528\u6237,\u672c\u6708\u5df2\u53d1\u751f\u8ba2\u5355\u514d\u5355";
                if (StringUtils.isNotEmpty((String)drawEntity.getRemark())) {
                    notice = drawEntity.getRemark();
                }
                if (flag) {
                    notice = "";
                }
                result.put("desc", notice);
                ArrayList<HashedMap> prizes = new ArrayList<HashedMap>();
                List<ActiveLuckyDrawPrizeEntity> prizeList = this.prizeInterface.getDrawPrizeList(drawEntity.getId());
                for (ActiveLuckyDrawPrizeEntity p : prizeList) {
                    HashedMap map = new HashedMap();
                    map.put("prizeName", p.getPrizeName());
                    map.put("prizeDesc", p.getPrizeDesc());
                    map.put("prizeLevel", this.drawInterface.getDrawLevelName(p.getLevel(), flag));
                    prizes.add(map);
                }
                result.put("prizes", prizes);
            }
            if ((activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) == null) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            result.put("picMap", this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
            return BaseJsonVo.success((Object)result);
        }
        return jsonVo;
    }

    @Override
    public BaseJsonVo reserveLucky(String bindCode, String customerId, Integer subscribe) {
        if (StringUtil.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"\u9884\u7ea6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        BaseJsonVo jsonVo = this.checkLucky(bindCode, 1, customerId);
        if (jsonVo.isSuccess()) {
            ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)jsonVo.getValue();
            ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
            drawUserEntity.setBindCode(bindCode);
            drawUserEntity.setCreateTime(new Date());
            drawUserEntity.setCustomerId(customerId);
            drawUserEntity.setIsUsed(0);
            if (this.isScribe(drawEntity.getId(), customerId).booleanValue()) {
                return BaseJsonVo.success((Object)"\u5df2\u7ecf\u9884\u7ea6\uff0c\u656c\u8bf7\u7b49\u5f85\u5f00\u5956");
            }
            drawUserEntity.setLuckyDrawId(drawEntity.getId());
            drawUserEntity.setLuckyNumber(RandomUtils.generateRandomNumberString((int)8));
            drawUserEntity.setPrizeId(null);
            drawUserEntity.setSubscribeContinuousCount(0);
            drawUserEntity.setSubscribeTotalCount(this.getSubscribeCount(bindCode, customerId) + 1);
            drawUserEntity.setUsedTime(null);
            drawUserEntity.setPeriod(drawEntity.getPeriod());
            if (subscribe != null) {
                drawUserEntity.setSubscribe(subscribe);
            }
            this.activeLuckyDrawUserMapper.insertSelective(drawUserEntity);
            return BaseJsonVo.success((Object)"\u9884\u7ea6\u6210\u529f");
        }
        return jsonVo;
    }

    @Override
    public BaseJsonVo getLuckyPrize(String luckyDrawId, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setCustomerId(customerId);
        drawUserEntity = (ActiveLuckyDrawUserEntity)this.activeLuckyDrawUserMapper.getSingle(drawUserEntity);
        ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)this.drawInterface.selectByPrimaryKey((Serializable)((Object)luckyDrawId), 0L);
        if (drawEntity != null) {
            ActiveLuckyDrawPrizeEntity prizeEntity;
            String prize = "";
            Integer prizeType = 0;
            String prizeDesc = "";
            if (drawUserEntity != null && Integer.valueOf(1).equals(drawUserEntity.getIsUsed()) && (prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeInterface.selectByPrimaryKey((Serializable)((Object)drawUserEntity.getPrizeId()))) != null) {
                prizeType = prizeEntity.getPrizeType();
                prize = prizeEntity.getPrizeName();
                prizeDesc = prizeEntity.getPrizeDesc();
            }
            String drawResult = "";
            boolean flag = Objects.equals(drawEntity.getBindCode(), "1742073997980864513") || Objects.equals(drawEntity.getBindCode(), "1742073258604892161") || Objects.equals(drawEntity.getBindCode(), "1742031918795591680") || Objects.equals(drawEntity.getBindCode(), "1742031612435238912");
            String prizeLevel = this.drawInterface.getDrawLevelName(drawUserEntity != null ? drawUserEntity.getLevel() : null, flag);
            drawResult = !Integer.valueOf(2).equals(drawEntity.getStatus()) ? "\u6682\u672a\u5f00\u5956" : (drawUserEntity == null ? "\u60a8\u672a\u9884\u7ea6\u672c\u6b21\u62bd\u5956" : (drawUserEntity.getIsUsed() == 1 ? prizeLevel + "\uff1a" + prize : "\u672c\u6b21\u672a\u4e2d\u5956"));
            HashedMap map = new HashedMap();
            map.put("bindCode", drawEntity.getBindCode());
            map.put("subscribeTime", drawUserEntity != null ? drawUserEntity.getCreateTime() : null);
            map.put("subscribeTotalCount", drawUserEntity != null ? drawUserEntity.getSubscribeTotalCount() : 0);
            map.put("drawName", drawEntity.getLuckyDrawName());
            map.put("isDrawPrize", drawUserEntity != null ? drawUserEntity.getIsUsed() : 0);
            map.put("drawPrizeTime", drawUserEntity != null ? drawUserEntity.getUsedTime() : null);
            map.put("prizeName", prize);
            map.put("prizeType", prizeType);
            map.put("prizeDesc", prizeDesc);
            map.put("prizeLevel", prizeLevel);
            map.put("period", "\u7b2c" + drawEntity.getPeriod() + "\u671f");
            map.put("drawResult", drawResult);
            map.put("drawStatus", drawEntity.getStatus());
            CustomerEntity customerEntity = this.drawOneLuckyCustomer(luckyDrawId);
            String drawFirstPrize = "";
            if (customerEntity != null) {
                drawFirstPrize = "\u672c\u5468\u514d\u5355\u7528\u6237\uff1a@" + customerEntity.getNickName();
                map.put("drawFirstPrizeCustomerImage", customerEntity.getHeadImageUrl());
            } else {
                map.put("drawFirstPrizeCustomerImage", "");
            }
            map.put("drawFirstPrize", drawFirstPrize);
            BaseJsonVo jsonVo = this.getCurrentLucky(drawEntity.getBindCode(), customerId);
            map.put("nextluckyDraw", jsonVo.isSuccess() ? jsonVo.getValue() : new HashedMap());
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(drawEntity.getBindCode());
            if (activeEntity == null) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            map.put("picMap", this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
            return BaseJsonVo.success((Object)map);
        }
        return BaseJsonVo.error((String)"\u62bd\u5956\u4e0d\u5b58\u5728");
    }

    @Override
    public BaseJsonVo takeLuckyPrize(HttpServletRequest servletRequest, String luckyDrawId, CustomerDetailVo customerDetailVo) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setCustomerId(customerDetailVo.getCustomerId());
        drawUserEntity = (ActiveLuckyDrawUserEntity)this.activeLuckyDrawUserMapper.getSingle(drawUserEntity);
        if (drawUserEntity != null) {
            if (Integer.valueOf(1).equals(drawUserEntity.getIsUsed())) {
                ActiveLuckyDrawPrizeEntity prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeInterface.selectByPrimaryKey((Serializable)((Object)drawUserEntity.getPrizeId()));
                if (prizeEntity != null) {
                    if (Integer.valueOf(1).equals(prizeEntity.getPrizeType())) {
                        if (Integer.valueOf(0).equals(drawUserEntity.getIsTake()) && StringUtil.isNotEmpty((String)prizeEntity.getPrizeData())) {
                            BaseJsonVo js = this.activeCashticketInterface.sendCashticket(servletRequest, customerDetailVo.getPlatformGroupId(), customerDetailVo.getPlatformId(), customerDetailVo.getSubscribe(), prizeEntity.getPrizeData(), customerDetailVo.getCustomerId(), true, null);
                            if (js.isSuccess()) {
                                drawUserEntity.setTakeTime(new Date());
                                drawUserEntity.setIsTake(1);
                                drawUserEntity.setTakeType("\u7ebf\u4e0a\u81ea\u884c\u9886\u53d6:" + customerDetailVo.getCustomerId());
                                this.activeLuckyDrawUserMapper.updateByPrimaryKeySelective(drawUserEntity);
                                return BaseJsonVo.success((Object)"\u5956\u54c1\u9886\u53d6\u6210\u529f");
                            }
                            this.logger.error("\u62bd\u5956\u5956\u54c1\u9886\u53d6\uff1a" + js.getMessage());
                            return BaseJsonVo.error((String)"\u5956\u54c1\u9886\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                        }
                        return BaseJsonVo.success((Object)"\u5956\u54c1\u5df2\u9886\u53d6\uff0c\u8bf7\u5728\u4e2a\u4eba\u4e2d\u5fc3\u67e5\u770b");
                    }
                    return BaseJsonVo.success((Object)"\u8bf7\u8054\u7cfb\u5ba2\u670d\u9886\u5956");
                }
                return BaseJsonVo.error((String)"\u60a8\u672a\u4e2d\u5956\uff0c\u518d\u63a5\u518d\u5389");
            }
            return BaseJsonVo.error((String)"\u60a8\u672a\u4e2d\u5956\uff0c\u518d\u63a5\u518d\u5389");
        }
        return BaseJsonVo.error((String)"\u4e0d\u80fd\u9886\u53d6\u5956\u54c1\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    public BaseJsonVo checkLucky(String bindCode, Integer isReserve, String customerId) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u9884\u7ea6\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (activeEntity.getBeginTime().after(new Date())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5c1a\u672a\u5f00\u59cb");
        }
        if (activeEntity.getEndTime().before(new Date())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f");
        }
        if (activeEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u672a\u4e0a\u7ebf");
        }
        if (Integer.valueOf(39).equals(activeEntity.getActiveType())) {
            List<ActiveEntity> activeEntityList;
            ActiveLuckyDrawEntity drawEntity = this.drawInterface.getCurrentLuckyDraw(bindCode);
            if (isReserve == 0) {
                return BaseJsonVo.success((Object)drawEntity);
            }
            if (drawEntity == null) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            if (drawEntity.getBeginTime().after(new Date())) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u5c1a\u672a\u5f00\u59cb");
            }
            if (drawEntity.getEndTime().before(new Date())) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u5df2\u7ed3\u675f");
            }
            if (!Integer.valueOf(0).equals(drawEntity.getStatus())) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u4e0d\u53ef\u7528");
            }
            if (Integer.valueOf(1).equals(drawEntity.getUserType()) || Integer.valueOf(2).equals(drawEntity.getUserType())) {
                Integer count = this.mallOrderMainInterface.getOrderCount(customerId, 3, 16);
                if (Integer.valueOf(1).equals(drawEntity.getUserType()) && count <= 0) {
                    return BaseJsonVo.error((String)"\u60a8\u4e0d\u662f\u8001\u7528\u6237\uff0c\u65e0\u6cd5\u9884\u7ea6");
                }
                if (Integer.valueOf(2).equals(drawEntity.getUserType()) && count > 0) {
                    return BaseJsonVo.error((String)"\u60a8\u4e0d\u662f\u65b0\u7528\u6237\uff0c\u65e0\u6cd5\u9884\u7ea6");
                }
            }
            if ((Objects.equals(bindCode, "1790044345192288257") || Objects.equals(bindCode, "1790229688092987393")) && CollectionUtils.isNotEmpty(activeEntityList = this.activeInterface.getActiveList4ActiveType(1000, 39)) && CollectionUtils.isNotEmpty(activeEntityList = activeEntityList.stream().filter(a -> Objects.equals(a.getBindCode(), "1790044345192288257") || Objects.equals(a.getBindCode(), "1790229688092987393")).collect(Collectors.toList()))) {
                for (ActiveEntity active : activeEntityList) {
                    this.logger.info("\u67e5\u8be2\u62bd\u5956activeBindCode:{},bindCode={}", (Object)active.getBindCode(), (Object)bindCode);
                    if (Objects.equals(active.getBindCode(), bindCode) || this.getSubscribeCount(active.getBindCode(), customerId) <= 0) continue;
                    this.logger.info("\u7528\u6237:{},\u5df2\u9884\u7ea6:{}", (Object)customerId, (Object)active.getActiveName());
                    return BaseJsonVo.error((String)"\u9884\u7ea6\u5931\u8d25,\u53ea\u80fd\u53c2\u4e0e\u4e00\u4e2a\u5662~~");
                }
            }
            return BaseJsonVo.success((Object)drawEntity);
        }
        return BaseJsonVo.error((String)"\u975e\u62bd\u5956\u6d3b\u52a8");
    }

    public Integer getSubscribeCount(String bindCode, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setBindCode(bindCode);
        drawUserEntity.setCustomerId(customerId);
        return this.existsByEntity(drawUserEntity, 0L);
    }

    public Integer getCurrentSubscribeCount(String luckyDrawId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        return this.existsByEntity(drawUserEntity);
    }

    public Boolean isScribe(String luckyDrawId, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setCustomerId(customerId);
        return this.existsByEntity(drawUserEntity) > 0;
    }

    public Boolean isDrawOneLucky(String bindCode, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setBindCode(bindCode);
        drawUserEntity.setCustomerId(customerId);
        drawUserEntity.setLevel(1);
        drawUserEntity.setIsUsed(1);
        return this.existsByEntity(drawUserEntity) > 0;
    }

    public CustomerEntity drawOneLuckyCustomer(String luckyDrawId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setLevel(1);
        drawUserEntity.setIsUsed(1);
        drawUserEntity = (ActiveLuckyDrawUserEntity)this.activeLuckyDrawUserMapper.getSingle(drawUserEntity);
        if (drawUserEntity != null) {
            return this.customerInterface.getCustomer(drawUserEntity.getCustomerId());
        }
        return null;
    }

    public Boolean isDrawLucky(String luckyDrawId, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setCustomerId(customerId);
        drawUserEntity.setIsUsed(1);
        return this.existsByEntity(drawUserEntity) > 0;
    }
}

