/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.redpackage;

import cc.lechun.active.dao.redpackage.ActiveOrderRecordMapper;
import cc.lechun.active.entity.redpackage.ActiveOrderRecordEntity;
import cc.lechun.active.iservice.active.ActiveOrderRecordInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveOrderRecordService
extends ActiveBaseService
implements ActiveOrderRecordInterface {
    @Autowired
    private ActiveOrderRecordMapper activeOrderRecordMapper;

    @Override
    @ReadThroughSingleCache(namespace="ActiveOrderRecordService.existsByOrderMainNo", expiration=300)
    public boolean existsByOrderMainNo(@ParameterValueKeyProvider(order=0) String orderMainNo, @ParameterValueKeyProvider(order=1) int status) {
        ActiveOrderRecordEntity activeOrderRecordEntity = new ActiveOrderRecordEntity();
        activeOrderRecordEntity.setOrderMainNo(orderMainNo);
        activeOrderRecordEntity.setStatus(status);
        return this.activeOrderRecordMapper.existsByEntity(activeOrderRecordEntity) > 0;
    }

    @Override
    public ActiveOrderRecordEntity getActiveOrderRecordEntityByOrderNo(String orderMainNo, String activeNo) {
        ActiveOrderRecordEntity temp = new ActiveOrderRecordEntity();
        temp.setOrderMainNo(orderMainNo);
        temp.setActiveNo(activeNo);
        return (ActiveOrderRecordEntity)this.activeOrderRecordMapper.getSingle(temp);
    }

    @Override
    public boolean saveActiveOrderRecord(String activeNo, Integer inviteNum, String orderMainNo, String inviteId) {
        ActiveOrderRecordEntity activeOrderRecordEntity = new ActiveOrderRecordEntity();
        activeOrderRecordEntity.setActiveNo(activeNo);
        activeOrderRecordEntity.setOrderMainNo(orderMainNo);
        activeOrderRecordEntity.setBalance("0");
        activeOrderRecordEntity.setNum(inviteNum);
        activeOrderRecordEntity.setVersionDetailId("");
        activeOrderRecordEntity.setStatus(0);
        activeOrderRecordEntity.setCreateTime(DateUtils.now());
        activeOrderRecordEntity.setInviteId(inviteId);
        return this.activeOrderRecordMapper.insertSelective(activeOrderRecordEntity) >= 1;
    }
}

