/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.reserve;

import cc.lechun.active.dao.active.ActiveReserveMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.entity.active.ReserveIndexVo;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawUserInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.SubscribeMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.SubscribeMessageInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.User;

@Service
public class ReserveService
extends ActiveBaseService
implements ReserveInterface {
    @Autowired
    private ActiveReserveMapper reserveMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private FitInterface fitInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveLuckyDrawUserInterface drawUserInterface;
    @Autowired
    private SubscribeMessageInterface subscribeMessageInterface;

    @Override
    @ReadThroughSingleCache(namespace="ReserveService.getReserveCount", expiration=3600)
    public int getReserveCount(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) int proType) {
        return this.reserveMapper.getReserveCount(bindCode, proType);
    }

    @Override
    public BaseJsonVo reserveAll(String customerId, String reserveType, Integer platformGroupId, Integer platFormId) {
        PageInfo<ReserveIndexVo> pageInfo = this.getReserveIndexList(customerId, platformGroupId);
        if (pageInfo.getTotal() > 0L) {
            pageInfo.getList().forEach(reserveIndexVo -> {
                if (reserveIndexVo.getStatus() == 2) {
                    this.reserve(customerId, reserveIndexVo.getBindCode(), "5", platFormId, 1);
                }
            });
            return BaseJsonVo.success((Object)"\u6210\u529f\u9884\u7ea6\u6240\u6709\u6d3b\u52a8");
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u53ef\u9884\u7ea6\u7684\u6d3b\u52a8");
    }

    @Override
    public PageInfo<ReserveIndexVo> getReserveIndexList(String customerId, Integer platformGroupId) {
        List<ActiveEntity> activeList = this.activeInterface.getActiveList4ActiveType(platformGroupId, 28);
        ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
        List activeIndexEntityList = this.activeIndexInterface.getList(activeIndexEntity, 0L);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(0L);
        ArrayList<ReserveIndexVo> list = new ArrayList<ReserveIndexVo>();
        activeIndexEntityList.sort((d1, d2) -> d1.getSort().compareTo(d2.getSort()));
        if (CollectionUtils.isNotEmpty(activeList)) {
            for (ActiveIndexEntity activeIndex : activeIndexEntityList) {
                for (ActiveEntity active : activeList) {
                    if (!this.activeInterface.checkActiveEnable(active).isSuccess() || !activeIndex.getActiveNo().equals(active.getActiveNo())) continue;
                    BaseJsonVo getReserve = this.getReserve(customerId, active.getBindCode());
                    ReserveIndexVo reserveIndexVo = new ReserveIndexVo();
                    reserveIndexVo.setBindCode(active.getBindCode());
                    reserveIndexVo.setPicMap(this.picInterface.getProductPicUrlMap(active.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
                    if (getReserve.isSuccess() && "1".equals(((HashMap)getReserve.getValue()).get("code"))) {
                        reserveIndexVo.setStatus(1);
                    } else if (getReserve.isSuccess() && "0".equals(((HashMap)getReserve.getValue()).get("code"))) {
                        reserveIndexVo.setStatus(2);
                    }
                    list.add(reserveIndexVo);
                }
            }
        }
        pageInfo.setList(list);
        pageInfo.setTotal((long)list.size());
        return pageInfo;
    }

    @Override
    public BaseJsonVo reserve(String customerId, String bindCode, String reserveType, Integer platFormId, Integer subscribe) {
        ActiveEntity activeEntity;
        SubscribeMessageEntity subscribeMessageEntity;
        BaseJsonVo getReserve = this.getReserve(customerId, bindCode);
        if (subscribe == null && (subscribeMessageEntity = this.subscribeMessageInterface.getSubscribe(StringUtils.isEmpty((String)reserveType) ? "5" : reserveType, bindCode, customerId)) != null) {
            subscribe = subscribeMessageEntity.getStatus();
        }
        if (Objects.equals(reserveType, SalesTypeEnum.SALES_ACTIVE.getValue()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) == null) {
            return BaseJsonVo.error((String)"\u9884\u7ea6\u5931\u8d25,\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        if (getReserve.isSuccess() && "0".equals(((HashMap)getReserve.getValue()).get("code"))) {
            ActiveReserveEntity reserve = new ActiveReserveEntity();
            reserve.setCustomerId(customerId);
            reserve.setProId(bindCode);
            reserve.setProType(StringUtils.isEmpty((String)reserveType) ? "5" : reserveType);
            reserve.setIsSend("0");
            reserve.setCreateTime(DateUtils.now());
            reserve.setPlatformId(platFormId);
            if (subscribe != null) {
                reserve.setSubscribe(subscribe);
            }
            this.reserveMapper.insert(reserve);
        }
        if ((activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null && Integer.valueOf(39).equals(activeEntity.getActiveType())) {
            return this.drawUserInterface.reserveLucky(bindCode, customerId, subscribe);
        }
        return BaseJsonVo.success((Object)"\u9884\u7ea6\u6210\u529f");
    }

    @Override
    public BaseJsonVo reserve(String customerId, String nickName, String bindCode, String reserveType, String inviteId, Integer platFormId, Integer subscribe) {
        ActiveEntity activeEntity;
        BaseJsonVo reserveResult = this.reserve(customerId, bindCode, reserveType, platFormId, subscribe);
        String resultInviteId = "";
        boolean isActive = (StringUtils.isEmpty((String)reserveType) ? "5" : reserveType).equals("5");
        if (isActive && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null) {
            BaseJsonVo<ActiveInviteEntity> result = this.activeInviteService.saveActiveInvite(activeEntity, bindCode, customerId, platFormId);
            String string = resultInviteId = reserveResult.isSuccess() ? ((ActiveInviteEntity)result.getValue()).getInviteId() : "";
            if (StringUtils.isNotEmpty((String)inviteId)) {
                boolean canInvite;
                CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
                boolean bl = canInvite = customerEntity != null && activeEntity.getJoinNum() != null && (activeEntity.getJoinNum() == 0 || activeEntity.getJoinNum() == 1 && customerEntity.getIsNew() == 1);
                if (canInvite) {
                    ActiveInviteEntity activeInviteEntity = this.activeInviteService.getActiveInviteEntity(inviteId);
                    if (activeInviteEntity != null && !activeInviteEntity.getCustomerId().equals(customerId)) {
                        this.activeInviteService.saveActiveInviteDetail(inviteId, activeInviteEntity.getCustomerId(), customerId, activeInviteEntity.getBindCode(), 1);
                        this.fitInterface.autoPrizeActive(bindCode, activeInviteEntity.getCustomerId(), platFormId);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("nickName", nickName);
                        if (activeEntity.getKeywordId() != null && activeEntity.getKeywordId() != 0) {
                            this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, activeEntity.getKeywordId(), activeInviteEntity.getCustomerId(), map);
                        }
                    }
                } else {
                    this.logger.info("\u8001\u7528\u6237:{},\u9080\u8bf7:{}\u4e0d\u8ba1\u6570:{}", (Object)customerId, (Object)inviteId);
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", reserveResult.isSuccess() ? "\u9884\u7ea6\u6210\u529f" : reserveResult.getMessage());
        map.put("inviteId", resultInviteId);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo getReserve(String customerId, String bindCode) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(bindCode);
        reserve.setCustomerId(customerId);
        reserve.setIsSend("0");
        List reserves = this.reserveMapper.getList(reserve);
        if (reserves != null && reserves.size() > 0) {
            return BaseJsonVo.success((Object)new HashMap<String, String>(){
                {
                    this.put("code", "1");
                    this.put("message", "\u60a8\u5df2\u9884\u7ea6");
                }
            });
        }
        return BaseJsonVo.success((Object)new HashMap<String, String>(){
            {
                this.put("code", "0");
                this.put("message", "\u60a8\u8fd8\u672a\u9884\u7ea6");
            }
        });
    }

    @Override
    public int getReserve(String customerId, String bindCode, int proType) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(bindCode);
        reserve.setCustomerId(customerId);
        reserve.setProType(String.valueOf(proType));
        reserve.setIsSend("0");
        ActiveReserveEntity temp = (ActiveReserveEntity)this.reserveMapper.getSingle(reserve);
        if (temp != null && temp.getId() != null && temp.getId() > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public BaseJsonVo getReserve(String customerId, String bindCode, String openId, Integer platFormId, String inviteId) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(bindCode);
        reserve.setCustomerId(customerId);
        reserve.setIsSend("0");
        List reserves = this.reserveMapper.getList(reserve);
        if (reserves.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("code", "1");
            map.put("message", "\u60a8\u5df2\u9884\u7ea6");
            map.put("inviteId", "");
            map.put("canShare", 0);
            if (((ActiveReserveEntity)reserves.get(0)).getProType().equals("5")) {
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
                BaseJsonVo<ActiveInviteEntity> result = this.activeInviteService.saveActiveInvite(activeEntity, bindCode, customerId, activeEntity.getPlatformId());
                inviteId = result.isSuccess() ? ((ActiveInviteEntity)result.getValue()).getInviteId() : "";
                map.put("inviteId", inviteId);
                map.put("canShare", 1);
                map.put("qrcodeUrl", "");
                if (platFormId == 1) {
                    ActiveQrcodeEntity activeQrcodeEntity;
                    WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(platFormId);
                    User user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
                    map.put("subscribe", user.getSubscribe());
                    if (user != null && user.getSubscribe() == 0 && (activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode)) != null) {
                        map.put("qrcodeUrl", this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()));
                    }
                } else {
                    map.put("subscribe", 1);
                }
            }
            return BaseJsonVo.success(map);
        }
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            ActiveQrcodeEntity activeQrcodeEntity;
            WeiXinBaseEntity weiXinBaseEntity;
            User user;
            ActiveInviteEntity activeInviteEntity;
            if (StringUtils.isNotEmpty((String)inviteId) && !(activeInviteEntity = this.activeInviteService.getActiveInviteEntity(inviteId)).getCustomerId().equals(customerId)) {
                this.activeInviteService.saveActiveInviteDetail(inviteId, activeInviteEntity.getCustomerId(), customerId, activeInviteEntity.getBindCode(), 0);
            }
            if (platFormId == 1 && (user = UserAPI.userInfo((String)(weiXinBaseEntity = this.weiXinBaseService.getWeixinBaseByFlatformId(platFormId)).getAccessToken(), (String)openId)).getSubscribe() == 0 && (activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode)) != null) {
                return BaseJsonVo.success((Object)new HashMap<String, Object>(){
                    {
                        this.put("code", "0");
                        this.put("message", "\u60a8\u8fd8\u672a\u9884\u7ea6");
                        this.put("inviteId", "");
                        this.put("canShare", "0");
                        this.put("qrcodeUrl", ReserveService.this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()));
                        this.put("subscribe", user.getSubscribe());
                    }
                });
            }
            return BaseJsonVo.success((Object)new HashMap<String, Object>(){
                {
                    this.put("code", "0");
                    this.put("message", "\u60a8\u8fd8\u672a\u9884\u7ea6");
                    this.put("inviteId", "");
                    this.put("canShare", "0");
                    this.put("qrcodeUrl", "");
                    this.put("subscribe", 1);
                }
            });
        }
        return BaseJsonVo.success((Object)new HashMap<String, Object>(){
            {
                this.put("code", "0");
                this.put("message", "\u60a8\u8fd8\u672a\u9884\u7ea6");
                this.put("inviteId", "");
                this.put("canShare", "1");
                this.put("qrcodeUrl", "");
                this.put("subscribe", "1");
            }
        });
    }

    @Override
    @ReadThroughSingleCache(namespace="ReserveService.getActiveReserve", expiration=120)
    public BaseJsonVo getActiveReserve(@ParameterValueKeyProvider String bindCode) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(bindCode);
        reserve.setIsSend("0");
        List reserves = this.reserveMapper.getList(reserve);
        return BaseJsonVo.success((Object)(reserves == null ? 0 : reserves.size()));
    }
}

