/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveSaleContext {
    private final Map<String, ActiveSaleHandle> activeSaleHandle = new ConcurrentHashMap<String, ActiveSaleHandle>();

    @Autowired
    public ActiveSaleContext(Map<String, ActiveSaleHandle> activeSaleHandle) {
        this.activeSaleHandle.clear();
        activeSaleHandle.forEach((k, v) -> this.activeSaleHandle.put((String)k, (ActiveSaleHandle)v));
    }

    public BaseJsonVo confirmOrder(Integer activeType, MallOrderMainEntity orderMain) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.confirmOrder(orderMain);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo checkCanJoin(Integer activeType, String customerId, String bindCode) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.checkCanJoin(customerId, bindCode);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo checkCanJoin(int platFormId, Integer activeType, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.beforeSetCacheCheck(platFormId, customerId, mallOrderCacheInVo);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo checkCanJoin(Integer activeType, String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.checkCanJoin(customerId, bindCode, mainOrderVo);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo afterCreateOrder(Integer activeType, MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.afterCreateOrder(orderCacheVo, mainOrderVo);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo afterPay(Integer activeType, MallOrderMainEntity orderMain) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                try {
                    return activeSale.afterPay(orderMain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo updateActiveJoinStatus(Integer activeType, MallOrderMainEntity orderMain) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.updateActiveJoinStatus(orderMain);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo refund(Integer activeType, MallOrderMainEntity orderMain) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.refund(orderMain);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo toPayPage(Integer activeType, MallMainOrderVo mainOrderVo) {
        if (activeType != null) {
            ActiveSaleHandle activeSale = this.activeSaleHandle.get("activeType_" + activeType);
            if (activeSale != null) {
                return activeSale.toPayPage(mainOrderVo);
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }
}

