/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.groupon.GroupTypeEnum;
import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="activeType_43")
public class CommunityGroupHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    @Lazy
    private GrouponInterface grouponService;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return super.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo toPayPage(MallMainOrderVo mainOrderVo) {
        return super.toPayPage(mainOrderVo);
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        try {
            if (StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField())) {
                this.logger.info("\u63a5\u53d7:json:{}", (Object)mainOrderVo.getMallOrderVos().get(0).getDefineField());
                String inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString();
                if (StringUtils.isNotEmpty((String)inviteId)) {
                    String key = inviteId + ":Success";
                    if (this.redisCacheUtil.get(key) != null) {
                        return BaseJsonVo.error((String)"\u4e0d\u80fd\u53c2\u56e2\u4e86\uff0c\u56e2\u6ee1\u4e86\u5662\u54e6~~");
                    }
                    BaseJsonVo baseJsonVo = this.grouponService.checkCanJoin(bindCode, customerId, inviteId);
                    if (baseJsonVo.isSuccess() && (Integer)baseJsonVo.getValue() > 1) {
                        return BaseJsonVo.error((String)"\u4e0d\u80fd\u53c2\u56e2\u4e86\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u4e86\u5662~~");
                    }
                }
                this.logger.info("mainOrderVo.getMallOrderVos().get(0).getDefineField() \u4e3a\u7a7a, \u8ba2\u5355{}", (Object)mainOrderVo.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        GrouponOrderVo grouponOrderVo = new GrouponOrderVo();
        grouponOrderVo.setOrderMainNo(mainOrderVo.getMainOrderNo());
        grouponOrderVo.setCustomerId(mainOrderVo.getCustomerId());
        grouponOrderVo.setPlatFormId(mainOrderVo.getPlatFormId());
        grouponOrderVo.setStatus(OrderStatusEnum.UNPAY.getValue());
        grouponOrderVo.setBindCode(orderCacheVo.getBindCode());
        if (StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField())) {
            this.logger.info("\u63a5\u53d7:json:{}", (Object)mainOrderVo.getMallOrderVos().get(0).getDefineField());
            try {
                String inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString();
                if (StringUtils.isNotEmpty((String)inviteId)) {
                    grouponOrderVo.setInviteId(inviteId);
                    grouponOrderVo.setGrouponRoleType(2);
                    grouponOrderVo.setGroupType(GroupTypeEnum.community_group.getValue());
                    this.grouponService.saveGrouponOrder(grouponOrderVo);
                } else {
                    this.logger.info("\u5f00\u56e2\u8ba2\u5355:{}", (Object)mainOrderVo.getMainOrderNo());
                }
                this.logger.info("mainOrderVo.getMallOrderVos().get(0).getDefineField() \u4e3a\u7a7a, \u8ba2\u5355\u53f7{}", (Object)mainOrderVo.getMainOrderNo());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity mallOrderEntity) {
        try {
            this.grouponService.saveGrouponOrder(mallOrderEntity);
            this.grouponService.updateProductSaleCount(mallOrderEntity);
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u8d2d\u8ba2\u5355\u51fa\u9519:{},{}", (Object)mallOrderEntity.getOrderMainNo(), (Object)e.getMessage());
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }
}

