/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.apiinvoke.cms.CorpTagInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activeType_33")
public class InviteGiftHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    private DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    CorpTagInvoke corpTagInvoke;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setCustomerId(customerId);
        orderMainEntity.setBindCode(bindCode);
        List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
        if (CollectionUtils.isNotEmpty(list)) {
            List tt = list.stream().filter(c -> c.getStatus() == 1).collect(Collectors.toList());
            if (tt != null && tt.size() >= 1) {
                return BaseJsonVo.error((String)"\u5b58\u5728\u5f85\u652f\u4ed8\u8ba2\u5355");
            }
            if (list.stream().anyMatch(o -> o.getStatus() >= 3 && o.getStatus() < 20)) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u6d3b\u52a8\u4e86\u5662~~");
            }
        }
        return this.distributorGrowthActiveInterface.takedGift("", bindCode, customerId);
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return super.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        String sourceCustomerId = "";
        String orderMainNo = mainOrderVo.getMainOrderNo();
        try {
            sourceCustomerId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("source").toString();
            this.logger.info("\u9080\u8bf7sourceCustomerId={}", (Object)(StringUtils.isNotEmpty((String)sourceCustomerId) ? sourceCustomerId : ""));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u89e3\u7801\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u8bbe\u7f6e\u9080\u8bf7\u6210\u529f\u53c2\u6570:{},customerId={},bindCode={}", new Object[]{sourceCustomerId, mainOrderVo.getCustomerId(), orderCacheVo.getBindCode()});
        BaseJsonVo baseJsonVo = this.distributorGrowthActiveInterface.setInviteOrder(sourceCustomerId, orderCacheVo.getBindCode(), mainOrderVo.getCustomerId(), orderMainNo, mainOrderVo.getPlatFormId());
        if (!baseJsonVo.isSuccess()) {
            throw new RuntimeException(baseJsonVo.getMessage());
        }
        this.logger.info("\u8bbe\u7f6e\u8ba2\u5355{}\u9080\u8bf7\u72b6\u6001:{}", (Object)orderMainNo, (Object)baseJsonVo.isSuccess());
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.logger.info("\u9080\u8bf7\u793c\u7269\u8ba2\u5355:{}", (Object)orderMain.getOrderMainNo());
        BaseJsonVo baseJsonVo = this.distributorGrowthActiveInterface.updateInvite(orderMain.getBindCode(), orderMain.getCustomerId(), orderMain.getOrderMainNo());
        this.logger.info("\u66f4\u65b0\u66f4\u65b0\u6b21\u6570 \u8ba2\u5355:{}\u9080\u8bf7\u72b6\u6001:{}", (Object)orderMain.getOrderMainNo(), (Object)baseJsonVo.isSuccess());
        try {
            this.corpTagInvoke.markTag(orderMain.getCustomerId(), 97, DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"));
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u6807\u7b7e\u5931\u8d25", (Throwable)e);
        }
        return baseJsonVo;
    }
}

