/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component(value="activeType_21")
public class LimitBuyHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        List<ActiveQrcodeEntity> qrcodeList = this.activeQrcodeService.getQrcodeListByActiveNo(activeEntity.getActiveNo());
        if (CollectionUtils.isEmpty(qrcodeList)) {
            this.logger.error("\u6d3b\u52a8:{}\u672a\u914d\u7f6e\u4e8c\u7ef4\u7801\u53ca\u5173\u8054\u4f18\u60e0\u5238", (Object)activeEntity.getActiveName());
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38");
        }
        List<ActiveCashticketEntity> ticketList = this.activeCashticketService.getBindCodeActiveCashticketList(qrcodeList.get(0).getBindCode());
        if (CollectionUtils.isEmpty(ticketList)) {
            this.logger.error("\u6d3b\u52a8:{} \u4e8c\u7ef4\u7801\u5173\u8054\u4f18\u60e0\u5238", (Object)activeEntity.getActiveName());
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38");
        }
        if (!this.checkIsWhite(customerId)) {
            List tt;
            MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
            orderMainEntity.setCustomerId(customerId);
            orderMainEntity.setBindCode(bindCode);
            List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
            if (list == null || list.size() < 1 || (tt = list.stream().filter(c -> c.getStatus() >= 3 && c.getStatus() < 20).collect(Collectors.toList())) == null || tt.size() >= 1) {
                // empty if block
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return super.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        return super.afterCreateOrderBase(mainOrderVo);
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        super.afterPayBase(orderMain);
        this.logger.info("{},\u6570\u636e\u57cb\u70b9\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        if (StringUtils.isNotEmpty((String)orderMain.getBindCode())) {
            this.sendCoupon(orderMain.getCustomerId(), orderMain.getBindCode(), orderMain.getPlatformId(), orderMain.getNcpBat());
            this.logger.info("{},\u53d1\u653e\u4f18\u60e0\u5238\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        }
        this.updateOrderComplete(orderMain, OrderStatusEnum.COMPLETION.getName());
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5b8c\u6210,\u8ba2\u5355\u53f7={}", (Object)orderMain.getOrderMainNo());
        return BaseJsonVo.success((Object)"");
    }
}

