/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activeType_18")
public class NewProCrowdHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    CrowdInterface crowdInterface;
    @Autowired
    MallOrderProductInterface orderProductInterface;
    @Autowired
    CustomerInterface customerInterface;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        List tt;
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setCustomerId(customerId);
        orderMainEntity.setBindCode(bindCode);
        List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getStatus() >= 3 && c.getStatus() < 20).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return BaseJsonVo.error((String)"\u5df2\u53c2\u4e0e\u8fc7\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return super.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        return super.afterCreateOrderBase(orderCacheVo, mainOrderVo, 0);
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.collectionActiveOrderData(orderMain);
        if (StringUtils.isNotEmpty((String)orderMain.getBindCode()) && orderMain.getBindCode().length() >= 32) {
            this.sendCoupon(orderMain.getCustomerId(), orderMain.getBindCode(), orderMain.getPlatformId(), "");
        }
        this.updateOrderComplete(orderMain, OrderStatusEnum.COMPLETION.getName());
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5b8c\u6210," + orderMain.getOrderMainNo());
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        List<MallOrderProductEntity> orderProducts = this.orderProductInterface.getOrderProductInfoByOrderMianNo(orderMain.getOrderMainNo());
        if (orderProducts == null || orderProducts.size() == 0) {
            this.logger.error("\u8ba2\u5355{}\u8bb0\u5f55\u4f17\u7b79\u9080\u8bf7\u5173\u7cfb\u5931\u8d25", (Object)orderMain.getOrderMainNo());
            return BaseJsonVo.success((Object)"");
        }
        activeInviteDetailEntity.setProId(orderProducts.get(0).getProductId());
        CrowdFundingEntity crowd = this.crowdInterface.getCrowdFundingEntityByActiveNo(orderMain.getActiveNo(), orderProducts.get(0).getProductId());
        if (crowd == null) {
            this.logger.error("\u8ba2\u5355{}\u8bb0\u5f55\u4f17\u7b79\u9080\u8bf7\u5173\u7cfb\u5931\u8d25", (Object)orderMain.getOrderMainNo());
            return BaseJsonVo.success((Object)"");
        }
        CustomerEntity customer = this.customerInterface.getCustomer(orderMain.getCustomerId());
        if (customer.getIsNew() == 1) {
            activeInviteDetailEntity.setGiveBalance(crowd.getNewUserAmout());
            activeInviteDetailEntity.setBalance(crowd.getNewUserAmout());
            activeInviteDetailEntity.setIsnew(1);
        } else {
            activeInviteDetailEntity.setGiveBalance(crowd.getOldUserAmout());
            activeInviteDetailEntity.setBalance(crowd.getOldUserAmout());
            activeInviteDetailEntity.setIsnew(0);
        }
        int funds = 2;
        activeInviteDetailEntity.setFundsStatus(funds);
        this.activeInviteService.addActiveInviteNum(activeInviteDetailEntity);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
        this.activeInviteService.saveActiveInvite(activeEntity, orderMain.getBindCode(), orderMain.getCustomerId());
        return BaseJsonVo.success((Object)"");
    }
}

