/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="activeType_45")
public class UserCutHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    protected ActiveCustomerInterface activeCustomerService;
    @Lazy
    @Autowired
    private ActivePropertyInterface activePropertyInterface;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        List<ActivePropertyEntity> propertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (CollectionUtils.isEmpty(propertyList)) {
            this.logger.error("\u6d3b\u52a8bindCode={}\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            return BaseJsonVo.success((Object)"");
        }
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("orderNum", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            try {
                boolean canJoin;
                Integer orderNum = Integer.valueOf(propertyEntityOptional.get().getPropertyValue());
                if (orderNum == 0 && !(canJoin = this.activeCommonService.checkCanJoin(bindCode, customerId))) {
                    return BaseJsonVo.error((String)"\u4ec5\u9650\u65b0\u7528\u6237\u4e13\u4eab\u5662~~");
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("\u6d3b\u52a8:{}\u6709\u8bef\u8bf7\u8054\u7cfb\u5ba2\u670d", (Object)bindCode, (Object)e);
                throw new RuntimeException("\u6d3b\u52a8\u6709\u8bef\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return this.checkCanJoin(customerId, mallOrderCacheInVo.getBindCode());
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return this.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        boolean canJoin = this.activeCommonService.checkCanJoin(bindCode, customerId);
        if (!canJoin) {
            return BaseJsonVo.error((String)"\u4ec5\u9650\u65b0\u7528\u6237\u4e13\u4eab\u5662~~");
        }
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        return super.afterCreateOrderBase(mainOrderVo);
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity mallOrderEntity) {
        return super.afterPayBase(mallOrderEntity);
    }
}

