/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.shortlink;

import cc.lechun.active.dao.active.MallUrlMapper;
import cc.lechun.active.entity.active.MallUrlEntity;
import cc.lechun.active.iservice.shortlink.ShortLinkInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkService
extends ActiveBaseService
implements ShortLinkInterface {
    @Autowired
    private MallUrlMapper mallUrlMapper;

    @Override
    @ReadThroughSingleCache(namespace="ShortLinkService.getMallUrlNew", expiration=600)
    public String getMallUrl(@ParameterValueKeyProvider String urlKey) {
        MallUrlEntity mallUrlEntity = (MallUrlEntity)this.mallUrlMapper.selectByPrimaryKey((Serializable)((Object)urlKey));
        return mallUrlEntity == null ? "" : mallUrlEntity.getUrl();
    }

    @Override
    public MallUrlEntity getMallUrlEntity(String urlKey) {
        return (MallUrlEntity)this.mallUrlMapper.selectByPrimaryKey((Serializable)((Object)urlKey));
    }

    @Override
    public BaseJsonVo saveMallUrl(String urlKey, String longUrl, Date expiredTime) {
        MallUrlEntity mallUrlEntity = new MallUrlEntity();
        mallUrlEntity.setUrl(longUrl);
        mallUrlEntity.setUrlKey(urlKey);
        mallUrlEntity.setExpiredTime(expiredTime);
        mallUrlEntity.setCreateTime(DateUtils.now());
        return this.mallUrlMapper.insertSelective(mallUrlEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo saveMallUrl(String urlKey, String longUrl, Date expiredTime, String urlName) {
        MallUrlEntity mallUrlEntity = new MallUrlEntity();
        mallUrlEntity.setUrl(longUrl);
        mallUrlEntity.setUrlKey(urlKey);
        mallUrlEntity.setExpiredTime(expiredTime);
        mallUrlEntity.setCreateTime(DateUtils.now());
        mallUrlEntity.setUrlName(urlName);
        return this.mallUrlMapper.insertSelective(mallUrlEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public String getShorterUrl(String longUrl, String urlKey, String urlName) {
        this.logger.info("\u4fdd\u5b58\u77ed\u8fde\u63a5:{},{},{}", new Object[]{longUrl, urlKey, urlName});
        MallUrlEntity query = new MallUrlEntity();
        query.setUrl(longUrl);
        if (StringUtils.isNotEmpty((String)urlKey)) {
            query.setUrlKey(urlKey);
        }
        if ((query = (MallUrlEntity)this.mallUrlMapper.getSingle(query)) != null) {
            return "http://t.lechun.cc/" + query.getUrlKey();
        }
        if (StringUtils.isEmpty((String)urlKey)) {
            String key = "";
            String temp = ".lechun.cc";
            for (int i = 0; i < 4; ++i) {
                key = this.shortUrl(longUrl, i, i + temp);
                BaseJsonVo vo = this.saveMallUrl(key, longUrl, DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30), urlName);
                if (!vo.isSuccess()) continue;
                MallUrlEntity urlEntity = new MallUrlEntity();
                urlEntity.setUrlKey(key);
                urlEntity.setUrl(longUrl);
                this.removeCache(urlEntity);
                this.setCache(urlEntity);
                break;
            }
            return "http://t.lechun.cc/" + key;
        }
        MallUrlEntity urlEntity = new MallUrlEntity();
        urlEntity.setUrlKey(urlKey);
        urlEntity.setUrl(longUrl);
        if (StringUtils.isNotEmpty((String)urlName)) {
            urlEntity.setUrlName(urlName);
        }
        urlEntity.setUpdateTime(DateUtils.now());
        urlEntity.setExpiredTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30));
        this.removeCache(urlEntity);
        this.logger.info(urlEntity.toString());
        return this.mallUrlMapper.updateByPrimaryKeySelective(urlEntity) > 0 ? "http://t.lechun.cc/" + urlKey : "";
    }

    private void removeCache(MallUrlEntity urlEntity) {
        if (urlEntity != null) {
            this.memcachedService.delete("ShortLinkService.getMallUrl", urlEntity.getUrlKey());
        }
    }

    private void setCache(MallUrlEntity urlEntity) {
        if (urlEntity != null) {
            this.memcachedService.set("ShortLinkService.getMallUrl:" + urlEntity.getUrlKey(), (Object)urlEntity.getUrl());
        }
    }

    private String shortUrl(String url, int i) {
        String sMD5EncryptResult;
        String key = "";
        String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        String hex = sMD5EncryptResult = DigestUtils.md5Hex((String)(key + url));
        String sTempSubString = hex.substring(i * 8, i * 8 + 8);
        long lHexLong = 0x3FFFFFFFL & Long.parseLong(sTempSubString, 16);
        String outChars = "";
        for (int j = 0; j < 7; ++j) {
            long index = 0x3DL & lHexLong;
            outChars = outChars + chars[(int)index];
            lHexLong >>= 5;
        }
        return outChars;
    }

    private String shortUrl(String url, int i, String key) {
        String sMD5EncryptResult;
        String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        String hex = sMD5EncryptResult = DigestUtils.md5Hex((String)(key + url));
        String sTempSubString = hex.substring(i * 8, i * 8 + 8);
        long lHexLong = 0x3FFFFFFFL & Long.parseLong(sTempSubString, 16);
        String outChars = "";
        for (int j = 0; j < 7; ++j) {
            long index = 0x3DL & lHexLong;
            outChars = outChars + chars[(int)index];
            lHexLong >>= 5;
        }
        return outChars;
    }

    @Override
    public String getShorterUrl(String longUrl) {
        String key = "";
        for (int i = 0; i < 4; ++i) {
            key = this.shortUrl(longUrl, i);
            BaseJsonVo vo = this.saveMallUrl(key, longUrl, DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30));
            if (!vo.isSuccess()) continue;
            MallUrlEntity urlEntity = new MallUrlEntity();
            urlEntity.setUrlKey(key);
            urlEntity.setUrl(longUrl);
            this.removeCache(urlEntity);
            this.setCache(urlEntity);
            break;
        }
        return "http://t.lechun.cc/" + key;
    }
}

