/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.tempqrcode;

import cc.lechun.active.dao.active.CustomerQrcodeMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.entity.tempCode.FundVo;
import cc.lechun.active.entity.tempCode.SaleQrcodeVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.tempqrcode.ImageMerge;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.qrcode.QrcodeUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.entity.version.VersionDetailEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.api.MessageAPI;
import weixin.popular.api.QrcodeAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.message.ImageMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.qrcode.QrcodeTicket;

@Service
public class CustomerQrcodeService
extends ActiveBaseService
implements CustomerQrcodeInterface {
    @Autowired
    private CustomerQrcodeMapper customerQrcodeMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    private MallOrderMainInterface orderMainService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private ImageMerge imageMerge;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DictionaryInterface dictionaryService;
    private Integer width = 150;
    private Integer height = 150;

    @Override
    public BaseJsonVo getFunds(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        FundVo fundVo = this.activeInviteService.getFund(customerId, bindCode);
        return fundVo == null ? BaseJsonVo.error((String)"\u65e0\u6548\u7684\u57fa\u91d1") : BaseJsonVo.success((Object)fundVo);
    }

    @Override
    public BaseJsonVo prize(String customerId, Integer platformId, String bindCode) {
        boolean lock = this.mallRedisLock.lock(customerId + bindCode + ":prize", "1", 60L, TimeUnit.SECONDS);
        if (lock) {
            BaseJsonVo baseJsonVo = this.activeInviteService.updatePrizeFund(customerId, bindCode);
            if (baseJsonVo.isSuccess()) {
                return this.activeCashticketInterface.sendTicket4Base(customerId, bindCode, new Double(((Integer)baseJsonVo.getValue()).intValue()), "", platformId, true, true, null, "");
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u5151\u5956\u6761\u4ef6");
    }

    @Override
    public BaseJsonVo getSaleQrcodeVo(String customerId, Integer platformId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo<ActiveInviteEntity> baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId);
        CustomerQrcodeEntity qrcode = this.getCustomerQrcode(customerDetailVo, activeEntity.getActiveNo());
        if (qrcode == null) {
            String shareKeyworld = activeEntity.getKeywordId() == null || activeEntity.getKeywordId() == 0 ? "293" : activeEntity.getKeywordId().toString();
            String buyworld = activeEntity.getPayKeywordId() == null || activeEntity.getPayKeywordId() == 0 ? "292" : activeEntity.getPayKeywordId().toString();
            qrcode = this.generateQrcode(customerId, activeEntity.getActiveNo(), "", "", platformId, this.width, this.height, buyworld, shareKeyworld);
            baseJsonVo = this.activeInviteService.saveActiveInvite(activeEntity, bindCode, customerId, platformId);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{},\u9080\u8bf7\u5bf9\u8c61\u4fdd\u5b58\u5931\u8d25.activeNo={}", (Object)customerId, (Object)activeEntity.getActiveNo());
                return baseJsonVo;
            }
        }
        SaleQrcodeVo saleQrcodeVo = new SaleQrcodeVo();
        saleQrcodeVo.setAmount(new BigDecimal(10));
        saleQrcodeVo.setFreeCount(9);
        saleQrcodeVo.setQrcodeUrl(this.ossService.getImageResoure(qrcode.getQrcodeImageUrl()));
        List<MallProductPicEntity> pics = this.picService.getProductPics(activeEntity.getActiveNo(), ProductPicTypeEnum.ACT_HEAD.getValue());
        saleQrcodeVo.setBackPicUrl("");
        if (pics != null && pics.size() >= 1) {
            Integer k = new Random().nextInt(pics.size());
            MallProductPicEntity productPicEntity = pics.get(k > 0 ? k - 1 : 0);
            saleQrcodeVo.setBackPicUrl(productPicEntity.getFullRelativeUrl());
        } else {
            this.logger.info("\u672a\u914d\u7f6e\u6d3b\u52a8\u8be6\u60c5\u9875\u56fe");
        }
        this.pushMessage(qrcode, bindCode, customerDetailVo.getNickName());
        return BaseJsonVo.success((Object)saleQrcodeVo);
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode(String ticket, String bindCode) {
        CustomerQrcodeEntity customerQrcodeEntity = new CustomerQrcodeEntity();
        customerQrcodeEntity.setTicket(ticket);
        customerQrcodeEntity.setSceneStr(bindCode);
        return this.getCustomerQrcode(customerQrcodeEntity);
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode(String openId, String activeNo, Integer platformId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(openId, platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u67e5\u627e\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,openId={}", (Object)openId);
            return null;
        }
        return this.getCustomerQrcode(customerDetailVo, activeNo);
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode(CustomerDetailVo customerDetailVo, String ticket, String bindCode, Integer platformId) {
        CustomerQrcodeEntity tempQrcode = this.getCustomerQrcode(ticket, bindCode);
        if (tempQrcode == null) {
            this.logger.error("\u672a\u77e5\u7684\u4e8c\u7ef4\u7801");
            throw new RuntimeException("\u672a\u77e5\u7684\u4e8c\u7ef4\u7801");
        }
        return this.getCustomerQrcode(customerDetailVo, tempQrcode.getActiveNo());
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode(CustomerDetailVo customerDetailVo, String activeNo) {
        CustomerQrcodeEntity customerQrcodeEntity = new CustomerQrcodeEntity();
        customerQrcodeEntity.setCustomerId(customerDetailVo.getCustomerId());
        customerQrcodeEntity.setActiveNo(activeNo);
        return this.getCustomerQrcode(customerQrcodeEntity);
    }

    @Override
    public Integer getActiveType(String ticket, String bindCode, Integer platformId) {
        CustomerQrcodeEntity customerQrcodeEntity = this.getCustomerQrcode(ticket, bindCode);
        if (customerQrcodeEntity == null) {
            this.logger.error("ticket={},bindCode={}", (Object)ticket, (Object)bindCode);
            this.logger.error("\u672a\u77e5\u7684\u4e8c\u7ef4\u7801");
            throw new RuntimeException("\u672a\u77e5\u7684\u4e8c\u7ef4\u7801");
        }
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(customerQrcodeEntity.getActiveNo());
        return activeEntity == null ? null : activeEntity.getActiveType();
    }

    @Override
    public BaseJsonVo pushMessage(CustomerQrcodeEntity qrcode, String nickName) {
        ActiveQrcodeEntity temp = new ActiveQrcodeEntity();
        temp.setActiveNo(qrcode.getActiveNo());
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(temp);
        this.pushMessage(qrcode, activeQrcodeEntity.getBindCode(), nickName);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void pushMessage(final CustomerQrcodeEntity qrcode, final String bindCode, final String nickName) {
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                DictionaryEntity dic;
                String fileName;
                if (StringUtils.isNotEmpty((String)qrcode.getKeywordId())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("bindCode", bindCode);
                    map.put("nickName", nickName);
                    BaseJsonVo baseJsonVo = CustomerQrcodeService.this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, Integer.valueOf(qrcode.getKeywordId()), qrcode.getCustomerId(), map);
                }
                if ((fileName = qrcode.getQrcodeImageUrl().replace("imgStorage/qrcode", "").substring(1)).startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                if (fileName.contains("?")) {
                    fileName = fileName.substring(0, fileName.indexOf("?"));
                }
                String postpath = "";
                List<MallProductPicEntity> pics = CustomerQrcodeService.this.picService.getProductPics(qrcode.getActiveNo(), ProductPicTypeEnum.ACT_HEAD.getValue());
                if (pics != null && pics.size() >= 1) {
                    if (StringUtils.isNotEmpty((String)pics.get(0).getFullRelativeUrl())) {
                        postpath = pics.get(0).getFullRelativeUrl();
                        postpath = postpath.replace("http://", "").replace("https://", "");
                        postpath = postpath.substring(postpath.indexOf("/") + 1);
                    }
                } else {
                    postpath = AliyunOSSDir.TEMP_IMG_STORAGE.getPath() + qrcode.getActiveNo() + ".jpg";
                }
                if ((dic = CustomerQrcodeService.this.dictionaryService.getDictionary(1000, 28, bindCode.substring(0, 20))) == null || StringUtils.isEmpty((String)dic.getDictionaryName())) {
                    CustomerQrcodeService.this.logger.info("\u5b57\u5178\u672a\u914d\u7f6e\u63a8\u9001\u4e8c\u7ef4\u7801\u6d3b\u52a8");
                    return;
                }
                String offset = dic.getDictionaryName();
                int x = Integer.valueOf(offset.split(",")[0]);
                int y = Integer.valueOf(offset.split(",")[1]);
                try {
                    boolean temp;
                    if (qrcode.getUpdateTime().before(DateUtils.now()) && !(temp = CustomerQrcodeService.this.updateQrcode(qrcode, CustomerQrcodeService.this.width, CustomerQrcodeService.this.height))) {
                        CustomerQrcodeService.this.logger.error("\u4e34\u65f6\u4e8c\u7ef4\u7801\u8fc7\u671f\uff0c\u66f4\u65b0\u5931\u8d25");
                        return;
                    }
                    CustomerQrcodeService.this.logger.info("postpath:{}", (Object)postpath);
                    if (postpath.contains("?")) {
                        postpath = postpath.substring(0, postpath.indexOf("?"));
                    }
                    String posterUrl = CustomerQrcodeService.this.imageMerge.composePic(postpath, AliyunOSSDir.QRCODE_IMG_ROOT_STORAGE.getPath() + fileName, qrcode.getPoster(), x, y);
                    CustomerQrcodeService.this.logger.info(" merge pic url....{}", (Object)posterUrl);
                    URI uri = new URI(posterUrl);
                    String accessToken = CustomerQrcodeService.this.weiXinBaseService.getAccessTokenValueByPlatformId(qrcode.getPlatformId());
                    Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)uri);
                    if (media == null) {
                        CustomerQrcodeService.this.logger.error("\u4e0a\u4f20\u4e34\u65f6\u7d20\u6750\u51fa\u9519,{}", (Object)qrcode.toString());
                        return;
                    }
                    CustomerQrcodeService.this.logger.info("\u4e0a\u4f20\u7d20\u6750:{}", (Object)media.toString());
                    CustomerDetailVo customerDetailVo = CustomerQrcodeService.this.customerService.getCustomerDetail(qrcode.getCustomerId(), qrcode.getPlatformId());
                    ImageMessage message = new ImageMessage(customerDetailVo.getOpenId(), media.getMedia_id());
                    BaseResult baseResult = MessageAPI.messageCustomSend((String)accessToken, (Message)message);
                    CustomerQrcodeService.this.logger.info("\u6d77\u62a5\u63a8\u9001:{}", (Object)baseResult.toString());
                }
                catch (IOException e) {
                    CustomerQrcodeService.this.logger.error("\u63a8\u9001\u6d77\u62a5\u51fa\u9519:{},{}", new Object[]{qrcode.getCustomerId(), qrcode.getActiveNo(), e});
                }
                catch (URISyntaxException e) {
                    CustomerQrcodeService.this.logger.error("\u63a8\u9001\u6d77\u62a5\u51fa\u9519:{},{}", new Object[]{qrcode.getCustomerId(), qrcode.getActiveNo(), e});
                }
            }
        });
    }

    @Override
    public BaseJsonVo pushMessage(CustomerDetailVo customerDetailVo, String activeNo, Integer platformId) {
        CustomerQrcodeEntity customerQrcodeEntity = new CustomerQrcodeEntity();
        customerQrcodeEntity.setCustomerId(customerDetailVo.getCustomerId());
        customerQrcodeEntity.setActiveNo(activeNo);
        customerQrcodeEntity.setPlatformId(platformId);
        CustomerQrcodeEntity result = this.getCustomerQrcode(customerQrcodeEntity);
        if (result == null) {
            result = this.generateQrcode(customerDetailVo.getCustomerId(), activeNo, "", "", platformId, this.width, this.height, "1352", "1351");
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(activeNo);
            BaseJsonVo<ActiveInviteEntity> baseJsonVo = this.activeInviteService.saveActiveInvite(activeEntity, result.getBindCode(), customerDetailVo.getCustomerId(), platformId);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{},\u9080\u8bf7\u5bf9\u8c61\u4fdd\u5b58\u5931\u8d25.activeNo={}", (Object)customerDetailVo.getCustomerId(), (Object)activeNo);
                return baseJsonVo;
            }
        }
        return this.pushMessage(result, customerDetailVo.getNickName());
    }

    @Override
    public BaseJsonVo pushMessage(String openId, String bindCode, Integer platformId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(openId, platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u67e5\u627e\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,openId={}", (Object)openId);
            return BaseJsonVo.error((String)"\u65e0\u6548\u7528\u6237");
        }
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
        if (activeQrcodeEntity == null) {
            this.logger.error("\u67e5\u627e\u4e8c\u7ef4\u7801\u4fe1\u606f\u4e0d\u5b58\u5728,bindCode={}", (Object)bindCode);
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4e8c\u7ef4\u7801");
        }
        return this.pushMessage(customerDetailVo, activeQrcodeEntity.getActiveNo(), platformId);
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode(CustomerQrcodeEntity customerQrcode) {
        return (CustomerQrcodeEntity)this.customerQrcodeMapper.getSingle(customerQrcode);
    }

    @Override
    public String getBuyLinkMessage(CustomerQrcodeEntity customerQrcodeEntity, VersionDetailEntity versionDetailEntity, ActiveQrcodeEntity activeQrcodeEntity, CustomerEntity customerEntity) {
        WeiXinKeywordEntity keyword = this.weiXinKeywordService.getWeiXinKeywordById(Integer.valueOf(customerQrcodeEntity.getBuyKeywordId()));
        String outContent = "";
        String url = "";
        if (keyword != null) {
            if (StringUtils.isNotEmpty((String)keyword.getContent())) {
                url = keyword.getUrl() + "?self_code=" + customerQrcodeEntity.getBindCode() + "&bindcode=" + activeQrcodeEntity.getBindCode() + "&version=" + versionDetailEntity.getVersion() + "&versiondetailid=" + versionDetailEntity.getVersionDetailId();
                outContent = MessageFormat.format(keyword.getContent(), customerEntity.getNickName()) + "<a href='" + url + "'>" + keyword.getTitle() + "</a>";
                this.logger.info("content={},url={}", (Object)outContent, (Object)url);
            } else {
                this.logger.error("\u626b\u7801\u540e\u63a8\u9001\u8d2d\u4e70\u8fde\u63a5\u6d88\u606f\u5173\u952e\u5b57\u6ca1\u6709\u914d\u7f6e\u6216\u914d\u7f6e\u51fa\u9519,\u8bf7\u68c0\u67e5.");
            }
        } else {
            this.logger.error("\u626b\u7801\u540e\u63a8\u9001\u8d2d\u4e70\u8fde\u63a5\u6d88\u606f\u5173\u952e\u5b57\u6ca1\u6709\u914d\u7f6e\u6216\u914d\u7f6e\u51fa\u9519 \u63a8\u9001\u6587\u672c\u51fa\u9519,\u8bf7\u68c0\u67e5.");
        }
        return outContent;
    }

    private boolean updateQrcode(CustomerQrcodeEntity customerQrcodeEntity, int width, int height) {
        QrcodeTicket qrcodeTicket = this.generateQrcodeByZxing(customerQrcodeEntity, width, height);
        if (qrcodeTicket != null) {
            CustomerQrcodeEntity updateQrcode = new CustomerQrcodeEntity();
            updateQrcode.setTicket(qrcodeTicket.getTicket());
            updateQrcode.setUpdateTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)29));
            updateQrcode.setId(customerQrcodeEntity.getId());
            customerQrcodeEntity.setTicket(qrcodeTicket.getTicket());
            customerQrcodeEntity.setUpdateTime(updateQrcode.getUpdateTime());
            boolean temp = this.customerQrcodeMapper.updateByPrimaryKeySelective(updateQrcode) >= 1;
            this.logger.info("\u4e34\u65f6\u4e8c\u7ef4\u7801\u66f4\u65b0{}", (Object)temp);
            return temp;
        }
        return false;
    }

    private QrcodeTicket generateQrcodeByZxing(CustomerQrcodeEntity customerQrcodeEntity, int width, int height) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(customerQrcodeEntity.getPlatformId());
        if (weiXinBaseEntity == null) {
            throw new RuntimeException("\u83b7\u53d6AccessToken\u5931\u8d25.");
        }
        String accessToken = weiXinBaseEntity.getAccessToken();
        QrcodeTicket qrcodeTicket = QrcodeAPI.qrcodeCreateTemp((String)accessToken, (int)2592000, (long)Long.valueOf(customerQrcodeEntity.getSceneStr()));
        String path = customerQrcodeEntity.getQrcodeImageUrl();
        if (qrcodeTicket != null && StringUtils.isNotEmpty((String)qrcodeTicket.getTicket())) {
            try {
                InputStream is = QrcodeUtils.gen((String)qrcodeTicket.getUrl(), (String)customerQrcodeEntity.getQrcodeImageUrl(), (int)width, (int)height);
                this.ossService.uploadFile(path, is);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return qrcodeTicket;
    }

    @Override
    public CustomerQrcodeEntity generateQrcode(CustomerQrcodeEntity qrcode, int width, int height) {
        boolean lock = this.mallRedisLock.tryLock(qrcode.getCustomerId() + ":" + qrcode.getActiveNo() + ":qrcode", 10000L);
        if (lock) {
            boolean saveStatus;
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(qrcode.getCustomerId(), qrcode.getPlatformId());
            CustomerQrcodeEntity tempQrcode = this.getCustomerQrcode(customerDetailVo, qrcode.getActiveNo());
            if (tempQrcode != null) {
                return tempQrcode;
            }
            boolean genStatus = true;
            String qrCodeUrl = "";
            qrcode.setSceneStr(String.valueOf(Math.abs((qrcode.getCustomerId() + qrcode.getActiveNo()).hashCode())));
            qrcode.setCreateTime(DateUtils.now());
            qrcode.setBindCode(UUID.randomUUID().toString().replace("-", ""));
            qrcode.setQrcodeType(1);
            qrcode.setShareCount(0);
            qrcode.setPayType(2);
            qrcode.setUpdateTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)29));
            qrcode.setQrcodeClass(1);
            qrcode.setPoster(UUID.randomUUID().toString().replace("-", "") + ".png");
            String fileName = UUID.randomUUID().toString().replace("-", "") + ".png";
            long temp = 0L;
            String qrcodeImageUrl = AliyunOSSDir.QRCODE_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
            qrcode.setQrcodeImageUrl(qrcodeImageUrl);
            QrcodeTicket qrcodeTicket = this.generateQrcodeByZxing(qrcode, width, height);
            qrcode.setTicket(qrcodeTicket.getTicket());
            qrcode.setQrcodeUrl(qrcodeTicket.getUrl());
            boolean bl = saveStatus = this.customerQrcodeMapper.insertSelective(qrcode) >= 1;
            if (!saveStatus) {
                this.logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25 {}", (Object)qrcode.toString());
                throw new RuntimeException("\u751f\u6210\u7528\u6237\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
            return qrcode;
        }
        return null;
    }

    @Override
    public CustomerQrcodeEntity generateQrcode(String customerId, String activeNo, String qrcodeName, Integer platFormId, int width, int height) {
        return this.generateQrcode(customerId, activeNo, qrcodeName, "", platFormId, width, height);
    }

    @Override
    public CustomerQrcodeEntity generateQrcode(String customerId, String activeNo, String qrcodeName, String versionDetailId, Integer platFormId, int width, int height) {
        return this.generateQrcode(customerId, activeNo, qrcodeName, versionDetailId, platFormId, width, height, "", "");
    }

    @Override
    public CustomerQrcodeEntity generateQrcode(String customerId, String activeNo, String qrcodeName, String versionDetailId, Integer platFormId, int width, int height, String buyWordId, String keyWordId) {
        CustomerQrcodeEntity qrcode = new CustomerQrcodeEntity();
        qrcode.setCustomerId(customerId);
        qrcode.setActiveNo(activeNo);
        qrcode.setQrcodeName(qrcodeName);
        qrcode.setPlatformId(platFormId);
        qrcode.setBuyKeywordId(buyWordId);
        qrcode.setKeywordId(keyWordId);
        return this.generateQrcode(qrcode, width, height);
    }

    @Override
    public CustomerQrcodeEntity getCustomerQrcode4notUsed(int keywordId) {
        return this.customerQrcodeMapper.getCustomerQrcode4notUsed(keywordId);
    }

    @Override
    public boolean deleteCustomerQrcodeById(int id) {
        return this.customerQrcodeMapper.deleteByPrimaryKey(Integer.valueOf(id)) >= 1;
    }
}

