/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.tempqrcode;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.tempqrcode.TempQrcodeHandle;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component(value="qrcode_16")
public class SubcriptQrcode
extends ActiveBaseService
implements TempQrcodeHandle {
    @Autowired
    private CustomerQrcodeInterface customerQrcodeInterface;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MessageInterface messageService;

    @Override
    @Async
    public BaseJsonVo scanTempQrcode(String ticket, String openId, String scence, int platformId, Integer type) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(openId, platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u67e5\u627e\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,openId={}", (Object)openId);
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        CustomerQrcodeEntity sourceQrcode = this.customerQrcodeInterface.getCustomerQrcode(ticket, scence);
        if (sourceQrcode == null) {
            this.logger.error("\u672a\u77e5\u7684\u4e34\u65f6\u4e8c\u7ef4\u7801\uff0cticket={},scence={}", (Object)ticket, (Object)scence);
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u4e34\u65f6\u4e8c\u7ef4\u7801");
        }
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(sourceQrcode.getActiveNo());
        if (activeEntity == null && (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(DateUtils.now()))) {
            this.logger.info("{}\u6d3b\u52a8\u5df2\u7ed3\u675f", (Object)activeEntity.getActiveName());
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (type == 1) {
            HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
            messageBody2.put("userId", customerDetailVo.getCustomerId());
            messageBody2.put("dataFrom", "\u9080\u8bf7\u5173\u6ce8");
            messageBody2.put("bindCode", scence);
            messageBody2.put("activeNo", activeEntity.getActiveNo());
            messageBody2.put("versionName", "");
            messageBody2.put("createTime", DateUtils.now());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, new MessageParam(customerDetailVo.getCustomerId(), messageBody2));
            CustomerQrcodeEntity customerQrcodeEntity = this.customerQrcodeInterface.getCustomerQrcode(customerDetailVo, ticket, scence, platformId);
            if (customerQrcodeEntity == null) {
                BaseJsonVo baseJsonVo = this.activeInviteService.saveActiveInvite(activeEntity, sourceQrcode.getCustomerId(), scence, customerDetailVo, platformId);
                if (!baseJsonVo.isSuccess()) {
                    return baseJsonVo;
                }
                Long num = this.redisService.increment(sourceQrcode.getCustomerId() + ":" + sourceQrcode.getActiveNo() + ":Num", 1L);
                if (num.intValue() == 0) {
                    ActiveInviteEntity queryActiveInvite = new ActiveInviteEntity();
                    queryActiveInvite.setActiveNo(sourceQrcode.getActiveNo());
                    queryActiveInvite.setCustomerId(sourceQrcode.getCustomerId());
                    ActiveInviteEntity activeInviteEntity = this.activeInviteService.getActiveInviteEntity(queryActiveInvite);
                    if (activeInviteEntity != null) {
                        num = activeEntity.getInviteNum() == null ? 0L : (long)activeEntity.getInviteNum().intValue();
                    }
                }
                this.logger.info("\u7528\u6237:{},\u5df2\u9080\u8bf7\u4eba\u6570:{}", (Object)sourceQrcode.getCustomerId(), (Object)num);
                int inviteNum = num.intValue() % activeEntity.getInviteNum();
                if (num > 0L && inviteNum == 0) {
                    ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(activeEntity.getBindCode(), 1);
                    if (activeQrcodeEntity == null) {
                        this.logger.error("\u6d3b\u52a8\u4e8c\u7ef4\u7801\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5.\u6d3b\u52a8:{}", (Object)activeEntity.toString());
                        return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8\u4e8c\u7ef4\u7801");
                    }
                    this.activeCashticketInterface.sendTicket4BaseAsynchronous(sourceQrcode.getCustomerId(), activeQrcodeEntity.getBindCode(), "", platformId, true);
                } else {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u533f\u540d\u4f19\u4f34");
                    map.put("num", String.valueOf(activeEntity.getInviteNum() - inviteNum));
                    this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, Integer.valueOf(sourceQrcode.getBuyKeywordId()), sourceQrcode.getCustomerId(), map);
                }
            } else {
                this.messageService.sendCustomerTextMessage(openId, platformId, "\u4f60\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u6d3b\u52a8\u4e86,\u4e0d\u53ef\u4ee5\u91cd\u590d\u53c2\u4e0e!", 0);
            }
        }
        HashMap<String, Object> messageBody = new HashMap<String, Object>();
        messageBody.put("customerId", customerDetailVo.getCustomerId());
        messageBody.put("openId", openId);
        messageBody.put("nickName", customerDetailVo.getNickName());
        messageBody.put("activeNo", activeEntity.getActiveNo());
        messageBody.put("platformId", platformId);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.pushTempQrcode, new MessageParam("", messageBody));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Async
    public BaseJsonVo scanTempQrcode(String openId, String scence, int platformId) {
        return this.customerQrcodeInterface.pushMessage(openId, scence, (Integer)platformId);
    }
}

