/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.tempqrcode;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.tempqrcode.TempQrcodeHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TempQrcodeContext
extends ActiveBaseService {
    @Autowired
    private CustomerQrcodeInterface customerQrcodeInterface;
    private Map<String, TempQrcodeHandle> messageHandle = new ConcurrentHashMap<String, TempQrcodeHandle>();

    @Autowired
    public TempQrcodeContext(Map<String, TempQrcodeHandle> messageHandle) {
        this.messageHandle.clear();
        messageHandle.forEach((k, v) -> this.messageHandle.put((String)k, (TempQrcodeHandle)v));
    }

    public BaseJsonVo scanTempQrcode(String ticket, String openId, String scence, int platformId, Integer type) {
        TempQrcodeHandle tempQrcodeHandle;
        CustomerQrcodeEntity customerQrcodeEntity = this.customerQrcodeInterface.getCustomerQrcode(ticket, scence);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(customerQrcodeEntity.getActiveNo());
        if (activeEntity != null && (tempQrcodeHandle = this.messageHandle.get("qrcode_" + activeEntity.getActiveType())) != null) {
            return tempQrcodeHandle.scanTempQrcode(ticket, openId, scence, platformId, type);
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo scanTempQrcode(String openId, String scence, int platformId) {
        TempQrcodeHandle tempQrcodeHandle;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(scence);
        if (activeEntity != null && (tempQrcodeHandle = this.messageHandle.get("qrcode_" + activeEntity.getActiveType())) != null) {
            return tempQrcodeHandle.scanTempQrcode(openId, scence, platformId);
        }
        return BaseJsonVo.success((Object)"");
    }
}

