/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.apiinvoke.balance;

import cc.lechun.apiinvoke.config.FeignConfig;
import cc.lechun.apiinvoke.fallback.balance.BalanceAccountFallback;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="lechun-balance", url="${feign.bind.url.balance}", fallbackFactory=BalanceAccountFallback.class, configuration={FeignConfig.class})
public interface BalanceAccountInvoke {
    @RequestMapping(value={"/api/getUserBalance"}, method={RequestMethod.GET})
    public BaseJsonVo<UserBalanceDTO> getUserBalance(@RequestParam(value="customerId") String var1);

    @RequestMapping(value={"/api/getUserBalanceDetail"}, method={RequestMethod.GET})
    public BaseJsonVo<UserBalanceDetailDTO> getUserBalanceDetail(@RequestParam(value="customerId") String var1);

    @RequestMapping(value={"/api/charge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> charge(@RequestParam(value="customerId") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="productId") String var3);

    @RequestMapping(value={"/api/purchaseSpecialCard"}, method={RequestMethod.GET})
    public BaseJsonVo<SpecialCardDTO> purchaseSpecialCard(@RequestParam(value="mallCardId") String var1, @RequestParam(value="customerId") String var2, @RequestParam(value="orderMainNo") String var3, @RequestParam(value="chargeAmount") BigDecimal var4, @RequestParam(value="batchType") Integer var5, @RequestParam(value="cardType") Integer var6, @RequestParam(value="saleValue") BigDecimal var7, @RequestParam(value="rate") BigDecimal var8);

    @RequestMapping(value={"/api/getSpecialTotal"}, method={RequestMethod.GET})
    public BaseJsonVo<BigDecimal> getSpecialTotal(@RequestParam(value="customerId") String var1, @RequestParam(value="cardType") Integer var2);

    @RequestMapping(value={"/specialCard/getSpecialAccount2"}, method={RequestMethod.GET})
    public List<Map<String, Object>> getSpecialAccount2(@RequestParam(value="customerId") String var1, @RequestParam(value="cardType") String var2);

    @RequestMapping(value={"/api/cardCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> cardCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="cardNo") String var2);

    @RequestMapping(value={"/api/payOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> payOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="orderAmount") BigDecimal var3);

    @RequestMapping(value={"/api/payOrderWithSpecialCard"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> payOrderWithSpecialCard(@RequestParam(value="customerId") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="cardNo") String var3, @RequestParam(value="orderAmount") BigDecimal var4, @RequestParam(value="cardType") Integer var5);

    @RequestMapping(value={"/api/cancleOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> cancleOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2);

    @RequestMapping(value={"/api/refundOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2, @RequestParam(value="refundAmount") BigDecimal var3, @RequestParam(value="operator") String var4);

    @RequestMapping(value={"/api/cancelDirectionCardOrder"}, method={RequestMethod.POST})
    public BaseJsonVo<BalanceChangeDTO> cancelDirectionCardOrder(@RequestParam(value="orderMainNo") String var1, @RequestParam(value="cancelAmount") BigDecimal var2, @RequestParam(value="operator") String var3);

    @RequestMapping(value={"/api/refundSpecialCardOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundSpecialCardOrder(@RequestParam(value="cardNo") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="refundAmount") BigDecimal var3, @RequestParam(value="operator") String var4);

    @RequestMapping(value={"/api/refundCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2, @RequestParam(value="operator") String var3);

    @RequestMapping(value={"/api/activeCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> activeCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="increaseAmount") BigDecimal var2, @RequestParam(value="detailSubTypeDesc") String var3, @RequestParam(value="notice") Boolean var4, @RequestParam(value="noticeText") String var5, @RequestParam(value="remark") String var6);

    @RequestMapping(value={"/api/increaseManual"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> increaseManual(@RequestParam(value="customerId") String var1, @RequestParam(value="increaseAmount") BigDecimal var2, @RequestParam(value="operator") String var3, @RequestParam(value="detailSubTypeDesc") String var4);

    @RequestMapping(value={"/api/reduceManual"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> reduceManual(@RequestParam(value="customerId") String var1, @RequestParam(value="reduceAmount") BigDecimal var2, @RequestParam(value="operator") String var3, @RequestParam(value="detailSubTypeDesc") String var4);

    @RequestMapping(value={"/storage/findStorageCards"}, method={RequestMethod.GET})
    public BaseJsonVo<List<StorageCardDTO>> findStorageCards();

    @RequestMapping(value={"/api/cancelSpecialCardOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> cancelSpecialCardOrder(@RequestParam(value="cardNo") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="refundAmount") BigDecimal var3, @RequestParam(value="operator") String var4);

    @RequestMapping(value={"/api/getSpecialCardRemain"}, method={RequestMethod.GET})
    public Map<String, BigDecimal> getSpecialCardRemain(@RequestParam(value="cardNo") String var1);

    @RequestMapping(value={"/api/getOrderPayDetail"})
    @ResponseBody
    public BaseJsonVo<Map<String, BigDecimal>> getOrderPayDetail(@RequestParam(value="orderMainNo") String var1);

    @RequestMapping(value={"/specialCard/changeSpecialCardOwner"})
    @ResponseBody
    public BaseJsonVo changeSpecialCardOwner(@RequestParam(value="cardNo") String var1, @RequestParam(value="exCustomerId") String var2, @RequestParam(value="newCustomerId") String var3);

    @RequestMapping(value={"/specialCard/getSpecialAccount"})
    @ResponseBody
    public Map<String, BigDecimal> getSpecialAccount(@RequestParam(value="customerId") String var1, @RequestParam(value="cardType") Integer var2);

    @RequestMapping(value={"specialCard/getSpecialCardSave"})
    @ResponseBody
    public BaseJsonVo getSpecialCardSave(@RequestParam(value="customerId") String var1, @RequestParam(value="orderAmount") BigDecimal var2, @RequestParam(value="cardType") Integer var3);

    @RequestMapping(value={"specialCard/getUsableSpecialList"})
    @ResponseBody
    public BaseJsonVo<List<Map<String, Object>>> getUsableSpecialList(@RequestParam(value="customerId") String var1, @RequestParam(value="cardType") Integer var2);

    @RequestMapping(value={"specialCard/delSpecialCardAndLog"})
    @ResponseBody
    public BaseJsonVo delSpecialCardAndLog(@RequestParam(value="orderNo") String var1);
}

