/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.apiInterceptor;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ApiInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ApiInterceptor.class);
    @Value(value="${edb2.signUrl}")
    private String signUrl;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        httpServletResponse.setCharacterEncoding("utf-8");
        httpServletResponse.setContentType("text/html; charset=utf-8");
        Enumeration paramNames = httpServletRequest.getParameterNames();
        String sign = httpServletRequest.getParameter("sign");
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String paramValue;
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = httpServletRequest.getParameterValues(paramName);
            if (paramValues.length <= 0 || (paramValue = paramValues[0]).length() == 0) continue;
            paramsMap.put(paramName, paramValue);
        }
        paramsMap.put("sign", sign);
        String paramString = JsonUtils.toJson(paramsMap, (boolean)false);
        logger.info("********\u62e6\u622a\u5668ApiInterceptor\u63a5\u53e3\u53c2\u6570\u503c******map={},signUrl={}", (Object)JSON.toJSONString(paramsMap), (Object)this.signUrl);
        String signResult = "";
        signResult = HttpRequest.post((String)this.signUrl, (String)("paramString=" + URLEncoder.encode(paramString, "UTF-8")));
        logger.info("********\u62e6\u622a\u5668ApiInterceptor\u63a5\u53e3\u9a8c\u7b7e\u8fd4\u56de\u7ed3\u679c******signResult={}", (Object)signResult);
        if (StringUtils.isNotBlank((CharSequence)signResult)) {
            JSONObject signJson = JSON.parseObject((String)signResult);
            logger.info("********\u62e6\u622a\u5668ApiInterceptor\u63a5\u53e3\u9a8c\u7b7e\u8fd4\u56de\u7ed3\u679c******signJson={}", (Object)signJson);
            String signStatus = signJson.getString("status");
            if ("200".equals(signStatus)) {
                return true;
            }
            PrintWriter pw = httpServletResponse.getWriter();
            pw.print(signResult);
            pw.flush();
            pw.close();
            return false;
        }
        PrintWriter pw = httpServletResponse.getWriter();
        pw.print(JSONUtils.toJSONString((Object)BaseJsonVo.error((String)"\u7b7e\u540d\u4e0d\u6b63\u786e")));
        pw.flush();
        pw.close();
        return false;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

