/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.enums.trade;

import cc.lechun.mall.entity.common.MallSelectDataVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum DeliveryTypeEnum {
    ONLY_ONE_DELIVERY(0, "\u4e0d\u91cd\u590d\u4ec5\u4e00\u6b21", 0),
    ERVERY_WEEK_DELIVERY(1, "\u6bcf\u5468", 7),
    EVERY_TWO_WEEK_DELIVERY(2, "\u6bcf\u53cc\u5468", 14),
    EVERY_THREE_WEEK_DELIVERY(3, "\u6bcf\u4e09\u5468", 21),
    EVERY_MONTH_DELIVERY(4, "\u6bcf\u6708", 30);

    private int value;
    private String name;
    private int day;

    public static List<DeliveryTypeEnum> getList() {
        return Arrays.asList(DeliveryTypeEnum.values());
    }

    public static List<MallSelectDataVo> getSelectDataList() {
        DeliveryTypeEnum[] ls = DeliveryTypeEnum.values();
        ArrayList<MallSelectDataVo> selectDataVos = new ArrayList<MallSelectDataVo>();
        for (DeliveryTypeEnum rs : ls) {
            MallSelectDataVo selectDataVo = new MallSelectDataVo();
            selectDataVo.setId(String.valueOf(rs.getValue()));
            selectDataVo.setName(rs.getName());
            selectDataVos.add(selectDataVo);
        }
        return selectDataVos;
    }

    public static String getName(int value) {
        DeliveryTypeEnum[] ls;
        for (DeliveryTypeEnum rs : ls = DeliveryTypeEnum.values()) {
            if (rs.getValue() != value) continue;
            return rs.getName();
        }
        return "";
    }

    public static int getDay(int value) {
        DeliveryTypeEnum[] ls;
        for (DeliveryTypeEnum rs : ls = DeliveryTypeEnum.values()) {
            if (rs.getValue() != value) continue;
            return rs.getDay();
        }
        return 0;
    }

    public static int getValue(String name) {
        DeliveryTypeEnum[] ls;
        for (DeliveryTypeEnum rs : ls = DeliveryTypeEnum.values()) {
            if (!rs.getName().equals(name)) continue;
            return rs.getValue();
        }
        return 0;
    }

    private DeliveryTypeEnum(int value, String name, int day) {
        this.value = value;
        this.name = name;
        this.day = day;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String toString() {
        return "DeliveryTypeEnum{value=" + this.value + ", name='" + this.name + '\'' + ", day=" + this.day + '}';
    }
}

