/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.entity.vip;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class MembershipOrder {
    private String orderNo;
    private BigDecimal orderAmount;
    private LocalDate startDate;
    private LocalDate endDate;
    private String customerId;

    public boolean isWithinRefundPeriod() {
        return LocalDate.now().isBefore(this.startDate.plusDays(30L));
    }

    public int getUsedDays() {
        return new Long(ChronoUnit.DAYS.between(this.startDate, LocalDate.now())).intValue();
    }

    public int getTotalDays() {
        return new Long(ChronoUnit.DAYS.between(this.startDate, this.endDate)).intValue();
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String toString() {
        return "MembershipOrder{orderNo='" + this.orderNo + '\'' + ", orderAmount=" + this.orderAmount + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", customerId='" + this.customerId + '\'' + '}';
    }
}

