/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.ask;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.ask.MallAnswerMapper;
import cc.lechun.mall.dao.ask.MallCustomerAnswerMapper;
import cc.lechun.mall.dao.ask.MallQuestionnewMapper;
import cc.lechun.mall.entity.ask.AnswerItem;
import cc.lechun.mall.entity.ask.MallAnswerEntity;
import cc.lechun.mall.entity.ask.MallCustomerAnswerEntity;
import cc.lechun.mall.entity.ask.MallQuestionAnswerVo;
import cc.lechun.mall.entity.ask.MallQuestionnewEntity;
import cc.lechun.mall.entity.ask.NaireStatusEnum;
import cc.lechun.mall.entity.ask.QuestionnaireStatisticsEntity;
import cc.lechun.mall.entity.ask.QuestionnaireVo;
import cc.lechun.mall.entity.ask.QuestionnewVo;
import cc.lechun.mall.entity.ask.ScoreStatusEnum;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.iservice.ask.MallAskInterface;
import cc.lechun.mall.iservice.ask.QuestionnaireStatisticsInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MallAskService
extends BaseService
implements MallAskInterface {
    @Autowired
    private MallQuestionnewMapper mallQuestionnewMapper;
    @Autowired
    private MallAnswerMapper mallAnswerMapper;
    @Autowired
    private MallCustomerAnswerMapper mallCustomerAnswerMapper;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private QuestionnaireStatisticsInterface questionnaireStatisticsInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;

    @Override
    public void close(String bindCode, String customerId) {
        String key = customerId + ":" + bindCode;
        this.logger.info("key={}", (Object)key);
        Boolean result = this.memcachedService.set(key, (Object)1);
        this.logger.info("cache:{}", this.memcachedService.get(key));
        this.logger.info("\u8bbe\u7f6e\u7f13\u5b58:{}", (Object)result);
    }

    @Override
    public BaseJsonVo commitAnswer(List<QuestionnaireVo> list, String bindCode, String orderNo, String customerId, Integer platformId, Integer platformGroupId) {
        ArrayList answerEntityList = new ArrayList();
        list.forEach(questionnaireVo -> {
            if (questionnaireVo.getQuestionnewVoList() != null && questionnaireVo.getQuestionnewVoList().size() > 0) {
                questionnaireVo.getQuestionnewVoList().forEach(questionnewVo -> {
                    questionnewVo.getAnswerItemList().forEach(answerItem -> {
                        if (answerItem.getCheck() == 1) {
                            MallCustomerAnswerEntity mallCustomerAnswerEntity = new MallCustomerAnswerEntity();
                            mallCustomerAnswerEntity.setCustomerId(customerId);
                            mallCustomerAnswerEntity.setQuestionId(questionnewVo.getQuestionId());
                            mallCustomerAnswerEntity.setSequence(99);
                            mallCustomerAnswerEntity.setAnswerId(answerItem.getAnswerId());
                            mallCustomerAnswerEntity.setCreateTime(DateUtils.now());
                            mallCustomerAnswerEntity.setIsSendCashticket(1);
                            mallCustomerAnswerEntity.setQuestionBindCode(bindCode);
                            answerEntityList.add(mallCustomerAnswerEntity);
                        }
                    });
                    if (questionnewVo.getChildren().size() > 0) {
                        questionnewVo.getChildren().forEach(questionnewVo1 -> questionnewVo1.getAnswerItemList().forEach(answerItem -> {
                            if (answerItem.getCheck() == 1) {
                                MallCustomerAnswerEntity mallCustomerAnswerEntity = new MallCustomerAnswerEntity();
                                mallCustomerAnswerEntity.setCustomerId(customerId);
                                mallCustomerAnswerEntity.setQuestionId(questionnewVo1.getQuestionId());
                                mallCustomerAnswerEntity.setSequence(0);
                                mallCustomerAnswerEntity.setAnswerId(answerItem.getAnswerId());
                                mallCustomerAnswerEntity.setCreateTime(DateUtils.now());
                                mallCustomerAnswerEntity.setIsSendCashticket(1);
                                mallCustomerAnswerEntity.setQuestionBindCode(bindCode);
                                answerEntityList.add(mallCustomerAnswerEntity);
                            }
                        }));
                    }
                });
            }
        });
        if (this.mallCustomerAnswerMapper.batchInsert(answerEntityList) > 0) {
            return this.activeCashticketInterface.sendTicket4CustomerType(customerId, bindCode, "", platformId, platformGroupId, true);
        }
        return BaseJsonVo.error((String)"\u53cd\u9988\u5931\u8d25");
    }

    @Override
    public void saveAire(String bindCode, String orderNo, String customerId, Integer platformId, String nickName, String feedBack, BigDecimal score) {
        QuestionnaireStatisticsEntity questionnaireStatisticsEntity = new QuestionnaireStatisticsEntity();
        questionnaireStatisticsEntity.setNickName(nickName);
        questionnaireStatisticsEntity.setCustomerId(customerId);
        questionnaireStatisticsEntity.setActiveNo(this.activeInterface.getActiveEntityByQrcode(bindCode).getActiveNo());
        questionnaireStatisticsEntity.setBindCode(bindCode);
        questionnaireStatisticsEntity.setCreateTime(DateUtils.now());
        questionnaireStatisticsEntity.setFirstOrderTime(DateUtils.now());
        questionnaireStatisticsEntity.setLastBuyTime(DateUtils.now());
        questionnaireStatisticsEntity.setOrderMainNo(orderNo);
        MallVipEntity mallVipEntity = this.vipService.getUserVipInfo(customerId);
        questionnaireStatisticsEntity.setLevel(mallVipEntity.getLevel() == null ? 0 : mallVipEntity.getLevel());
        this.customerInterface.getCustomerOpenidList(customerId);
        List<CustomerOpenidEntity> ls_new_openids = this.customerInterface.getCustomerOpenidList(customerId);
        ArrayList ls_new_openids_platforms = new ArrayList();
        if (ls_new_openids != null && ls_new_openids.size() > 0) {
            for (CustomerOpenidEntity customerOpenidEntity : ls_new_openids) {
                if (!platformId.equals(customerOpenidEntity.getPlatformId())) continue;
                questionnaireStatisticsEntity.setSubscribeTime(customerOpenidEntity.getSubscribeTime());
                break;
            }
        }
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        questionnaireStatisticsEntity.setFirstOrderTime(customerEntity.getFirstOrderTime());
        questionnaireStatisticsEntity.setFeedBack(feedBack);
        questionnaireStatisticsEntity.setProvince(customerEntity.getProvince());
        questionnaireStatisticsEntity.setCity(customerEntity.getCity());
        questionnaireStatisticsEntity.setArea(customerEntity.getArea());
        questionnaireStatisticsEntity.setTotalAmount(this.mallOrderMainInterface.getOrderAmount(customerId));
        questionnaireStatisticsEntity.setOrderNum(this.mallOrderInterface.getUserOrderCount(customerId));
        List<MallOrderProductEntity> productEntityList = this.orderProductInterface.getOrderProductInfoByOrderMianNo(orderNo);
        HashSet transportSet = new HashSet();
        questionnaireStatisticsEntity.setScore(score);
        HashSet productCategorySet = new HashSet();
        List<MallProductCategoryEntity> categoryEntityList = this.productCategoryInterface.getCategoryList();
        productEntityList.forEach(product -> {
            block5: {
                MallPromotionVO promotionVO;
                block6: {
                    MallProductCategoryEntity categoryEntity;
                    MallProductEntity productEntity;
                    BaseJsonVo sr;
                    block4: {
                        List tempList;
                        MallProductCategoryEntity categoryEntity2;
                        if (product.getGroupType().intValue() != SalesTypeEnum.SALES_PRODUCT.getValue()) break block4;
                        MallProductEntity productEntity2 = this.productInterface.getProduct(product.getProductId());
                        if (productEntity2 == null) break block5;
                        if (!transportSet.contains(TransportTypeEnum.getName(productEntity2.getTransportType()))) {
                            transportSet.add(TransportTypeEnum.getName(productEntity2.getTransportType()));
                        }
                        MallProductCategoryEntity mallProductCategoryEntity = categoryEntity2 = (tempList = categoryEntityList.stream().filter(category -> category.getCategoryId().equals(productEntity2.getProductCategoryId())).collect(Collectors.toList())).size() > 0 ? (MallProductCategoryEntity)tempList.get(0) : null;
                        if (categoryEntity2 == null || productCategorySet.contains(categoryEntity2.getCategoryName())) break block5;
                        productCategorySet.add(categoryEntity2.getCategoryName());
                        break block5;
                    }
                    if (product.getGroupType().intValue() != SalesTypeEnum.SALES_PROMOTION.getValue() || !StringUtils.isNotEmpty((String)product.getPromotionId())) break block5;
                    int transport = this.promotionInterface.getPromotionDeliveryType(product.getPromotionId());
                    if (!transportSet.contains(TransportTypeEnum.getName(transport))) {
                        transportSet.add(TransportTypeEnum.getName(transport));
                    }
                    if (!(sr = this.promotionInterface.buildPromotionVO(product.getProductId(), 1, false)).isSuccess()) break block5;
                    promotionVO = (MallPromotionVO)sr.getValue();
                    if (SalesTypeEnum.SALES_PRODUCT.getValue() != Integer.valueOf(promotionVO.getProductType()).intValue()) break block6;
                    if (promotionVO.getProduct() == null || (productEntity = this.productInterface.getProduct(product.getProductId())) == null) break block5;
                    List tempList = categoryEntityList.stream().filter(category -> category.getCategoryId().equals(productEntity.getProductCategoryId())).collect(Collectors.toList());
                    MallProductCategoryEntity mallProductCategoryEntity = categoryEntity = tempList.size() > 0 ? (MallProductCategoryEntity)tempList.get(0) : null;
                    if (categoryEntity == null || productCategorySet.contains(categoryEntity.getCategoryName())) break block5;
                    productCategorySet.add(categoryEntity.getCategoryName());
                    break block5;
                }
                if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue() && promotionVO.getGroup() != null) {
                    for (MallProductVO proVO : promotionVO.getGroup().getProductList()) {
                        MallProductCategoryEntity categoryEntity;
                        MallProductEntity productEntity = this.productInterface.getProduct(product.getProductId());
                        if (productEntity == null || (categoryEntity = (MallProductCategoryEntity)categoryEntityList.stream().filter(category -> category.getCategoryId().equals(productEntity.getProductCategoryId())).collect(Collectors.toList()).get(0)) == null || productCategorySet.contains(categoryEntity.getCategoryName())) continue;
                        productCategorySet.add(categoryEntity.getCategoryName());
                    }
                }
            }
        });
        String transport = "";
        for (String feed : transportSet) {
            transport = feed + "|";
        }
        if (transport.endsWith("|")) {
            transport = transport.substring(0, transport.length() - 1);
        }
        String category = "";
        for (String feed : productCategorySet) {
            category = feed + "|";
        }
        if (category.endsWith("|")) {
            category = category.substring(0, category.length() - 1);
        }
        questionnaireStatisticsEntity.setTransportType(transport);
        questionnaireStatisticsEntity.setProductCategory(category);
        this.questionnaireStatisticsInterface.insert(questionnaireStatisticsEntity);
    }

    @Override
    @Async
    public void saveAire(String bindCode, String orderNo, String customerId, Integer platformId, String nickName, List<QuestionnaireVo> list) {
        BigDecimal score = new BigDecimal(0);
        HashSet<String> feedBackSet = new HashSet<String>();
        for (QuestionnaireVo questionnaireVo : list) {
            if (StringUtils.isEmpty((String)orderNo)) {
                orderNo = questionnaireVo.getOrderNo();
            }
            for (QuestionnewVo questionnewVo : questionnaireVo.getQuestionnewVoList()) {
                List scoreList = questionnewVo.getAnswerItemList().stream().filter(answerItem -> answerItem.getCheck() == 1).map(AnswerItem::getAnswer).collect(Collectors.toList());
                ArrayList<BigDecimal> scoreDecList = new ArrayList<BigDecimal>();
                if (scoreList != null && scoreList.size() > 0) {
                    for (String scoreStr : scoreList) {
                        try {
                            if (!(Double.valueOf(scoreStr) > 0.0)) continue;
                            scoreDecList.add(new BigDecimal(scoreStr));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    if (scoreDecList.size() > 0) {
                        score = (BigDecimal)scoreDecList.stream().max(BigDecimal::compareTo).get();
                    }
                }
                for (QuestionnewVo child : questionnewVo.getChildren()) {
                    for (AnswerItem answerItem2 : child.getAnswerItemList()) {
                        if (StringUtils.isNotEmpty((String)answerItem2.getOtherRemark()) && !feedBackSet.contains(answerItem2.getOtherRemark())) {
                            feedBackSet.add(answerItem2.getOtherRemark());
                        }
                        if (answerItem2.getCheck() != 1 || feedBackSet.contains(answerItem2.getAnswer())) continue;
                        feedBackSet.add(answerItem2.getAnswer());
                    }
                }
            }
        }
        String feedBack = "";
        for (String feed : feedBackSet) {
            feedBack = feed + "|";
        }
        if (feedBack.endsWith("|")) {
            feedBack = feedBack.substring(0, feedBack.length() - 1);
        }
        this.saveAire(bindCode, orderNo, customerId, platformId, nickName, feedBack, score);
    }

    @Override
    public BaseJsonVo getQuestionList(String customerId, String bindCode, String orderNo) {
        this.logger.info("customerId={},bindCode={},order={}", new Object[]{customerId, bindCode, orderNo});
        ArrayList<QuestionnaireVo> list = new ArrayList<QuestionnaireVo>();
        QuestionnaireVo questionnaireVo = new QuestionnaireVo();
        questionnaireVo.setNaireStatus(0);
        list.add(questionnaireVo);
        questionnaireVo.setNaireName(NaireStatusEnum.getName(questionnaireVo.getNaireStatus()));
        String key = customerId + ":" + bindCode;
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (baseJsonVo.isSuccess()) {
            List<MallOrderEntity> orderList;
            this.logger.info("key={},value={}", (Object)key, this.memcachedService.get(key));
            if (this.memcachedService.get(key) == null && (orderList = this.mallOrderInterface.getOrderListByPickTime(customerId)).size() > 0) {
                questionnaireVo.setOrderNo(orderList.get(0).getOrderMainNo());
                if (this.questionnaireStatisticsInterface.getCount(customerId, 30) <= 0) {
                    questionnaireVo.setNaireStatus(2);
                    questionnaireVo.setNaireName(NaireStatusEnum.getName(questionnaireVo.getNaireStatus()));
                    QuestionnewVo questionnewVo = new QuestionnewVo();
                    List<MallQuestionnewEntity> mallQuestionnewList = this.mallQuestionnewMapper.getQuestionnewInfo(bindCode);
                    this.logger.info("mallQuestionnewList={}", (Object)mallQuestionnewList.size());
                    List<MallQuestionnewEntity> tempQuestionList = mallQuestionnewList.stream().filter(question -> StringUtils.isEmpty((String)question.getParentId())).collect(Collectors.toList());
                    tempQuestionList.forEach(quetion -> {
                        BeanUtils.copyProperties((Object)quetion, (Object)questionnewVo);
                        this.getQuestionVo(questionnewVo, (MallQuestionnewEntity)quetion, mallQuestionnewList);
                        questionnaireVo.getQuestionnewVoList().add(questionnewVo);
                    });
                }
            }
        }
        return BaseJsonVo.success(list);
    }

    private void getQuestionVo(QuestionnewVo questionnewVo, MallQuestionnewEntity quetion, List<MallQuestionnewEntity> mallQuestionnewList) {
        List<MallQuestionnewEntity> childQuetionnewList;
        questionnewVo.setQuestionId(quetion.getId());
        questionnewVo.setFlagScore(quetion.getMaxScore().compareTo(quetion.getMiniScore()) == 0 ? quetion.getMaxScore() : new BigDecimal(0));
        List<MallAnswerEntity> mallAnswerEntityList = this.mallAnswerMapper.getAnswerByQuestionId(quetion.getId());
        if (mallAnswerEntityList.size() > 0) {
            mallAnswerEntityList.forEach(mallAnswerEntity -> {
                AnswerItem answerVo = new AnswerItem();
                BeanUtils.copyProperties((Object)mallAnswerEntity, (Object)answerVo);
                answerVo.setCheck(0);
                answerVo.setOtherRemark("");
                questionnewVo.getAnswerItemList().add(answerVo);
            });
        }
        if ((childQuetionnewList = mallQuestionnewList.stream().filter(questionnew -> questionnew.getParentId().equals(questionnewVo.getQuestionId())).collect(Collectors.toList())).size() > 0) {
            childQuetionnewList.forEach(question -> {
                QuestionnewVo questionnewVo2 = new QuestionnewVo();
                questionnewVo2.setQuestionId(question.getId());
                BeanUtils.copyProperties((Object)question, (Object)questionnewVo2);
                if (question.getMaxScore().compareTo(questionnewVo.getFlagScore()) > 0) {
                    questionnewVo2.setStatus(ScoreStatusEnum.Lagger.getValue());
                } else {
                    questionnewVo2.setStatus(ScoreStatusEnum.Smaller.getValue());
                }
                questionnewVo2.setStatusName(ScoreStatusEnum.getName(questionnewVo2.getStatus()));
                questionnewVo2.setFlagScore(question.getMaxScore().compareTo(question.getMiniScore()) == 0 ? question.getMaxScore() : new BigDecimal(0));
                questionnewVo2.setChildren(null);
                List<MallAnswerEntity> mallAnswerEntityList2 = this.mallAnswerMapper.getAnswerByQuestionId(question.getId());
                if (mallAnswerEntityList2.size() > 0) {
                    mallAnswerEntityList2.forEach(mallAnswerEntity -> {
                        AnswerItem answerVo = new AnswerItem();
                        BeanUtils.copyProperties((Object)mallAnswerEntity, (Object)answerVo);
                        answerVo.setCheck(0);
                        answerVo.setOtherRemark("");
                        questionnewVo2.getAnswerItemList().add(answerVo);
                    });
                }
                questionnewVo.getChildren().add(questionnewVo2);
            });
        }
    }

    @Override
    public BaseJsonVo getNextQuestion(String customerId, String bindCode) {
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.getNextQuestion+++start++++customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.getNextQuestion:customerId or bindCode is empty++++");
            map.put("status", 0);
            map.put("questionArray", "");
            map.put("answerNo", "");
            map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898");
            return BaseJsonVo.success(map);
        }
        this.memcachedService.delete("lechun_12question_" + customerId + bindCode);
        Object objectSequence = null;
        int curCount = 0;
        List<MallQuestionnewEntity> mallQuestionnewList = this.mallQuestionnewMapper.getQuestionnewInfo(bindCode);
        if (objectSequence == null || StringUtils.isEmpty((String)objectSequence.toString())) {
            Set<MallCustomerAnswerEntity> mallCustomerAnswerEntitySet = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerIdSet(customerId, bindCode);
            if (mallCustomerAnswerEntitySet.size() == mallQuestionnewList.size()) {
                map.put("status", 2);
                map.put("questionArray", "");
                map.put("answerNo", "");
                map.put("message", "");
                return BaseJsonVo.success(map);
            }
            List<MallCustomerAnswerEntity> mallCustomerAnswerList = this.mallCustomerAnswerMapper.getAnswerByTime(customerId, bindCode);
            curCount = mallCustomerAnswerList.size() == 0 ? 1 : mallCustomerAnswerList.size() + 1;
        } else {
            curCount = Integer.parseInt(objectSequence.toString());
        }
        long num = mallQuestionnewList.size();
        if ((long)curCount > num) {
            map.put("status", 2);
            map.put("questionArray", "");
            map.put("answerNo", "");
            map.put("message", "");
            return BaseJsonVo.success(map);
        }
        map.put("answerNo", curCount);
        if (mallQuestionnewList.size() > 0) {
            ArrayList<MallQuestionAnswerVo> mallQuestionAnswerVoList = new ArrayList<MallQuestionAnswerVo>();
            for (MallQuestionnewEntity mallQuestionnewEntity : mallQuestionnewList) {
                MallQuestionAnswerVo mallQuestionAnswerVo = new MallQuestionAnswerVo();
                List<MallAnswerEntity> mallAnswerEntityList = this.mallAnswerMapper.getAnswerByQuestionId(mallQuestionnewEntity.getId());
                if (mallAnswerEntityList.size() <= 0) {
                    map.put("status", 0);
                    map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898\u7b54\u6848");
                    return BaseJsonVo.success(map);
                }
                mallQuestionAnswerVo.setQuestion(mallQuestionnewEntity.getQuestion());
                mallQuestionAnswerVo.setQuestionId(mallQuestionnewEntity.getId());
                mallQuestionAnswerVo.setSequence(mallQuestionnewEntity.getSequence());
                mallQuestionAnswerVo.setAnswerList(mallAnswerEntityList);
                mallQuestionAnswerVoList.add(mallQuestionAnswerVo);
            }
            map.put("status", 1);
            map.put("message", "");
            map.put("questionArray", mallQuestionAnswerVoList);
            return BaseJsonVo.success(map);
        }
        map.put("status", 0);
        map.put("questionArray", "");
        map.put("answerNo", "");
        map.put("message", "\u6ca1\u6709\u53ef\u7528\u7684\u95ee\u9898");
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo commitAnswer(CustomerDetailVo customerDetailVo, String questionId, String answerId, String bindCode, String feedBack) {
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.commitAnswer+++start++++questionId={},answerId={},bindCode={}", new Object[]{questionId, answerId, bindCode});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)questionId) || StringUtils.isEmpty((String)answerId) || StringUtils.isEmpty((String)customerDetailVo.getCustomerId()) || StringUtils.isEmpty((String)bindCode)) {
            map.put("status", 0);
            map.put("message", "\u95ee\u9898\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        MallQuestionnewEntity mallQuestionnewEntity = this.mallQuestionnewMapper.getQuestionnewById(questionId);
        if (mallQuestionnewEntity == null) {
            map.put("status", 0);
            map.put("message", "\u95ee\u9898\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        MallAnswerEntity mallAnswerEntity = this.mallAnswerMapper.getRightAnswerByQuestionId(questionId);
        if (mallAnswerEntity == null) {
            map.put("status", 0);
            map.put("message", "\u7b54\u6848\u4e0d\u5b58\u5728");
            return BaseJsonVo.success(map);
        }
        if (!answerId.equals(mallAnswerEntity.getAnswerId())) {
            map.put("status", -1);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        MallCustomerAnswerEntity mallCustomerAnswerEntity = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerId(customerDetailVo.getCustomerId(), questionId, answerId, bindCode);
        if (mallCustomerAnswerEntity != null) {
            map.put("status", 1);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        mallCustomerAnswerEntity = new MallCustomerAnswerEntity();
        mallCustomerAnswerEntity.setCustomerId(customerDetailVo.getCustomerId());
        mallCustomerAnswerEntity.setQuestionId(questionId);
        mallCustomerAnswerEntity.setSequence(mallQuestionnewEntity.getSequence());
        mallCustomerAnswerEntity.setAnswerId(answerId);
        mallCustomerAnswerEntity.setCreateTime(DateUtils.now());
        mallCustomerAnswerEntity.setIsSendCashticket(0);
        mallCustomerAnswerEntity.setQuestionBindCode(bindCode);
        int i = this.mallCustomerAnswerMapper.insertCustomerAnswerInfo(mallCustomerAnswerEntity);
        this.logger.info("+++cc.lechun.mall.service.ask.MallAskService.insertCustomerAnswerInfo+++start++++questionId={},answerId={},bindCode={}", new Object[]{questionId, answerId, bindCode});
        if (i > 0) {
            // empty if block
        }
        List<MallQuestionnewEntity> mallQuestionnewList = this.mallQuestionnewMapper.getQuestionnewInfo(bindCode);
        Set<MallCustomerAnswerEntity> mallCustomerAnswerEntitySet = this.mallCustomerAnswerMapper.getCustomerAnswerByCustomerIdSet(customerDetailVo.getCustomerId(), bindCode);
        if (mallCustomerAnswerEntitySet.size() == mallQuestionnewList.size() && i > 0) {
            this.activeCashticketInterface.sendTicket4Base(customerDetailVo.getCustomerId(), bindCode, "", customerDetailVo.getPlatformId(), true, null, "");
            this.vipService.finishTask(customerDetailVo.getCustomerId(), "3164420955670229136");
            map.put("status", 2);
            map.put("message", mallAnswerEntity.getDescription());
            return BaseJsonVo.success(map);
        }
        map.put("status", 1);
        map.put("message", mallAnswerEntity.getDescription());
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo commitQuestionnaireAnswer(CustomerDetailVo customerDetailVo, String questionId, String answerId, String bindCode, String feedBack) {
        return null;
    }
}

