/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.mall.entity.cashticket.CashItemVo;
import cc.lechun.mall.entity.sales.MallUseCashItemVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BestChooseCash {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public CashCompose get(List<CashItemVo> canComposeList, List<CashItemVo> unComposetList) {
        int composeSize = canComposeList.size();
        int unComposeSize = unComposetList.size();
        ArrayList<CashCompose> list = new ArrayList<CashCompose>();
        boolean flag = false;
        for (int i = 0; i < composeSize; ++i) {
            this.logger.info("\u53ef\u53e0\u52a0\u5238:{}", (Object)canComposeList.get(i).toString());
            ArrayList<MallUseCashItemVO> tempList = new ArrayList<MallUseCashItemVO>();
            for (int j = 0; j < unComposeSize; ++j) {
                CashComposeItem cashComposeItem;
                this.logger.info("\u4e0d\u53ef\u53e0\u52a0\u5238:{}", (Object)unComposetList.get(j).toString());
                HashSet<MallUseCashItemVO> useCashItemSet = new HashSet<MallUseCashItemVO>();
                tempList.addAll(canComposeList.get(i).getUseCashItemVOList());
                tempList.addAll(unComposetList.get(j).getUseCashItemVOList());
                useCashItemSet.addAll(tempList);
                BigDecimal total_use_cash_amonut = new BigDecimal(0);
                for (MallUseCashItemVO itemVO : useCashItemSet) {
                    total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)itemVO.getCount(), (Number)itemVO.getDeliverCount()).multiply(itemVO.getFactPrice()).subtract(itemVO.getFullcutAmount()));
                }
                CashCompose cashCompose = new CashCompose();
                cashCompose.setTotalUseCashAmount(total_use_cash_amonut);
                if (unComposetList.get(j).getEnableCashticketAmount().compareTo(total_use_cash_amonut) >= 0) {
                    this.logger.info("\u4e0d\u53ef\u53e0\u52a0\u5238{},\u53ef\u8db3\u989d\u62b5\u6263{}", (Object)unComposetList.get(j).toString(), (Object)total_use_cash_amonut);
                    flag = true;
                    cashComposeItem = new CashComposeItem();
                    cashComposeItem.setComPoseType(CashComposeUseEnum.unavailable.getValue());
                    cashComposeItem.setTicketCustomerId(unComposetList.get(j).getTicketCustomerId());
                    cashCompose.getItemList().add(cashComposeItem);
                    cashCompose.setEnableCashticketAmount(total_use_cash_amonut);
                } else if (canComposeList.get(i).getEnableCashticketAmount().compareTo(total_use_cash_amonut) >= 0) {
                    this.logger.info("\u53ef\u53e0\u52a0\u5238{},\u53ef\u8db3\u989d\u62b5\u6263{}", (Object)canComposeList.get(i).toString(), (Object)total_use_cash_amonut);
                    flag = true;
                    cashComposeItem = new CashComposeItem();
                    cashComposeItem.setComPoseType(CashComposeUseEnum.unavailable.getValue());
                    cashComposeItem.setTicketCustomerId(canComposeList.get(i).getTicketCustomerId());
                    cashCompose.getItemList().add(cashComposeItem);
                    cashCompose.setEnableCashticketAmount(total_use_cash_amonut);
                }
                if (!flag) {
                    cashComposeItem = new CashComposeItem();
                    cashComposeItem.setComPoseType(CashComposeUseEnum.unavailable.getValue());
                    cashComposeItem.setTicketCustomerId(unComposetList.get(j).getTicketCustomerId());
                    cashCompose.getItemList().add(cashComposeItem);
                    CashComposeItem cashComposeItem2 = new CashComposeItem();
                    cashComposeItem2.setComPoseType(CashComposeUseEnum.available.getValue());
                    cashComposeItem2.setTicketCustomerId(canComposeList.get(i).getTicketCustomerId());
                    cashCompose.getItemList().add(cashComposeItem2);
                    if (total_use_cash_amonut.compareTo(canComposeList.get(i).getEnableCashticketAmount().add(unComposetList.get(j).getEnableCashticketAmount())) < 0) {
                        cashCompose.setEnableCashticketAmount(total_use_cash_amonut);
                        if (canComposeList.get(i).getEnableCashticketAmount().compareTo(unComposetList.get(j).getEnableCashticketAmount()) > 0) {
                            unComposetList.get(j).setEnableCashticketAmount(total_use_cash_amonut.subtract(canComposeList.get(i).getEnableCashticketAmount()));
                        } else {
                            canComposeList.get(i).setEnableCashticketAmount(total_use_cash_amonut.subtract(unComposetList.get(j).getEnableCashticketAmount()));
                        }
                        this.logger.info("\u91cd\u65b0\u8ba1\u7b97\u7ec4\u5408\u5238\u62b5\u6263\u91d1\u989d,\u53ef\u53e0\u52a0\u5238:{}\u62b5\u6263\u91d1\u989d:{},\u4e0d\u53ef\u53e0\u52a0\u5238:{}\u62b5\u6263\u91d1\u989d:{}", new Object[]{canComposeList.get(i).getTicketCustomerId(), canComposeList.get(i).getEnableCashticketAmount(), unComposetList.get(j).getTicketCustomerId(), unComposetList.get(j).getEnableCashticketAmount()});
                    } else {
                        cashCompose.setEnableCashticketAmount(canComposeList.get(i).getEnableCashticketAmount().add(unComposetList.get(j).getEnableCashticketAmount()));
                    }
                    this.logger.info("\u7ec4\u5408\u5238\u53ef\u4f7f\u7528\u5546\u54c1\u91d1\u989d:total_use_cash_amonut={},\u53ef\u53e0\u52a0\u5238:{},\u4e0d\u53ef\u53e0\u52a0\u5238:{}", new Object[]{total_use_cash_amonut, canComposeList.get(i).getEnableCashticketAmount(), unComposetList.get(j).getEnableCashticketAmount()});
                }
                list.add(cashCompose);
                this.logger.info("\u6700\u4f18\u5238:{}", (Object)cashCompose.toString());
            }
        }
        list.stream().sorted((c1, c2) -> {
            int i = c2.getEnableCashticketAmount().compareTo(c1.getEnableCashticketAmount());
            if (i == 0) {
                i = c1.getItemList().size() - ((CashCompose)c2).itemList.size();
            }
            return i;
        });
        return (CashCompose)list.get(0);
    }

    static class CashComposeItem {
        private Integer ticketCustomerId;
        private int comPoseType = 0;

        CashComposeItem() {
        }

        public Integer getTicketCustomerId() {
            return this.ticketCustomerId;
        }

        public void setTicketCustomerId(Integer ticketCustomerId) {
            this.ticketCustomerId = ticketCustomerId;
        }

        public int getComPoseType() {
            return this.comPoseType;
        }

        public void setComPoseType(int comPoseType) {
            this.comPoseType = comPoseType;
        }

        public String toString() {
            return "CashComposeItem{ticketCustomerId=" + this.ticketCustomerId + ", comPoseType=" + this.comPoseType + '}';
        }
    }

    static class CashCompose {
        private List<CashComposeItem> itemList = new ArrayList<CashComposeItem>();
        private BigDecimal totalUseCashAmount = BigDecimal.ZERO;
        private BigDecimal enableCashticketAmount = BigDecimal.ZERO;

        CashCompose() {
        }

        public List<CashComposeItem> getItemList() {
            return this.itemList;
        }

        public void setItemList(List<CashComposeItem> itemList) {
            this.itemList = itemList;
        }

        public BigDecimal getTotalUseCashAmount() {
            return this.totalUseCashAmount;
        }

        public void setTotalUseCashAmount(BigDecimal totalUseCashAmount) {
            this.totalUseCashAmount = totalUseCashAmount;
        }

        public BigDecimal getEnableCashticketAmount() {
            return this.enableCashticketAmount;
        }

        public void setEnableCashticketAmount(BigDecimal enableCashticketAmount) {
            this.enableCashticketAmount = enableCashticketAmount;
        }

        public String toString() {
            return "CashCompose{itemList=" + this.itemList + ", totalUseCashAmount=" + this.totalUseCashAmount + ", enableCashticketAmount=" + this.enableCashticketAmount + '}';
        }
    }
}

