/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.form.cash.CashticketBatchQuaryForm;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketBatchService
extends BaseService
implements CashticketBatchInterface {
    @Autowired
    private CashticketBatchMapper cashticketBatchMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public CashticketBatchEntity getCashticketBatchByTicketNo(String ticketNo) {
        CashticketBatchEntity temp = new CashticketBatchEntity();
        temp.setTicketNo(ticketNo);
        return (CashticketBatchEntity)this.cashticketBatchMapper.getSingle(temp);
    }

    @Override
    public CashticketBatchEntity getCashticketBatch(String ticketBatchId) {
        return (CashticketBatchEntity)this.cashticketBatchMapper.selectByPrimaryKey((Serializable)((Object)ticketBatchId));
    }

    @Override
    public boolean updateCashticketBatchAlreadyQuantity(String ticketBatchId, int already_quantity) {
        boolean flag;
        boolean bl = flag = this.cashticketBatchMapper.updateCashticketBatchAlreadyQuantity(ticketBatchId, already_quantity) > 0;
        if (flag) {
            this.removeCache(ticketBatchId);
        }
        return flag;
    }

    @Override
    public PageInfo<CashticketBatchVo> getCashticketBatchList(PageForm pageForm, CashticketBatchQuaryForm cashticketBatchQuaryForm, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        this.cashticketBatchMapper.getCashticketBatchList(cashticketBatchQuaryForm, platformGroupId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                o.setCreateTypeName(CashCreateTypeEnum.getName(o.getCreateType().shortValue()));
                o.setDiscountModeName(CashDiscountModeEnum.getName(o.getDiscountMode().shortValue()));
                o.setDiscountOrAmount(o.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() ? o.getAmount() + "" : o.getDiscountAmount() + "");
            });
        }
        return pg;
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashticketBatch", ticketBatchId);
    }
}

