/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.form.cash.CustomerCashticketQuaryForm;
import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashPeriodTypeEnum;
import cc.lechun.common.enums.cashticket.CashRuleStatusEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.enums.cashticket.CashTicketTypeEnum;
import cc.lechun.common.enums.cashticket.MallCashUseStatusEnum;
import cc.lechun.common.enums.cashticket.MallItemConfigUseStatusEnum;
import cc.lechun.common.enums.cashticket.ProductCashRuleTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.dao.cashticket.CashticketSendLogMapper;
import cc.lechun.mall.entity.cashticket.CanUseCashticketVo;
import cc.lechun.mall.entity.cashticket.CashItemVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketSendLogEntity;
import cc.lechun.mall.entity.cashticket.CashticketSimpleVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.cashticket.SelectCashVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallUseCashItemVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.cashticket.CashticketClassInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketNoticeInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.cashticket.BestChooseCash;
import cc.lechun.mall.service.cashticket.CashticketBatchNewRuleService;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketService;
import cc.lechun.mall.service.customer.CustomerService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.MessageService;
import cc.lechun.mall.service.youshu.CouponService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketCustomerService
extends BaseService
implements CashticketCustomerInterface {
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketSendLogMapper cashticketSendLogMapper;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private CashticketBatchNewRuleService cashticketBatchNewRuleService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    @Lazy
    private MessageService messageService;
    @Autowired
    private PlatFormService platformService;
    @Autowired
    private CashticketClassInterface cashticketClassService;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;
    @Autowired
    private CashticketNoticeInterface cashticketNoticeInterface;
    @Autowired
    private BestChooseCash bestChooseCash;
    @Autowired
    CouponService couponService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;

    @Override
    public PageInfo<CashticketCustomerEntity> getCustomerCashticketList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        this.cashticketCustomerMapper.getCustomerCashticketList();
        return page.toPageInfo();
    }

    @Override
    public Page<CashticketCustomerEntity> getCustomerCashticketList(PageForm pageForm, CustomerCashticketQuaryForm customerCashticketQuaryForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setCustomerId(customerCashticketQuaryForm.getCustomerId());
        this.cashticketCustomerMapper.getList(cashticketCustomerEntity);
        return page;
    }

    @Override
    @Transactional
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(CashStatusEnum.yijihuo.getValue());
            }
            if (this.cashticketService.updateByPrimaryKeySelective(cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, String customerId, CashStatusEnum cashStatusEnum) {
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setTicketId(ticketId);
        cashticketCustomerEntity.setCustomerId(customerId);
        cashticketCustomerEntity.setStatus(cashStatusEnum.getValue());
        if (cashStatusEnum.getValue() != CashStatusEnum.yijihuo.getValue()) {
            if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketCustomerEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                // empty if block
            }
        }
        this.updateCashticketStatus(ticketId, cashStatusEnum);
        return this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity) > 0;
    }

    @Override
    public List<Integer> getCashticketTicketId(String bindCode, String customerId) {
        return this.cashticketCustomerMapper.getCashticketTicketId(customerId, bindCode);
    }

    @Override
    public List<CashticketCustomerEntity> getCashticketTicketList(String bindCode, String customerId) {
        CashticketCustomerEntity query = new CashticketCustomerEntity();
        query.setBindCode(bindCode);
        query.setCustomerId(customerId);
        return this.cashticketCustomerMapper.getList(query);
    }

    @Override
    @Transactional
    public boolean insertCashticketCustomer(CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, Integer platformId) {
        String message = "";
        CashticketEntity cash = this.cashticketService.addCashTicketNos(cashticketBatchEntity);
        if (cash == null) {
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        this.logger.info("\u4f18\u60e0\u5238ticketNo\u8bb0\u5f55:{}", (Object)cash.getTicketNo());
        cash = this.cashticketService.getCashticket4No(cash.getTicketNo());
        if (cash == null) {
            this.logger.error("\u67e5\u8be2\u5df2\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        cashticketCustomerEntity.setTicketId(cash.getTicketId());
        this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u8bb0\u5f55:{}", (Object)cash.toString());
        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
            this.logger.error("\u4f18\u60e0\u5238\u9886\u53d6\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        this.logger.info("\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f,{}", (Object)cashticketCustomerEntity.toString());
        if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue() && cashticketBatchEntity.getAmount().compareTo(cashticketCustomerEntity.getTicketAmount()) > 0 && !this.cashticketService.updateCashticketAmount(cash.getTicketId(), cashticketCustomerEntity.getTicketAmount())) {
            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25,\u66f4\u65b0\u91d1\u989d\u5931\u8d25";
            throw new RuntimeException(message);
        }
        return true;
    }

    @Override
    public CashticketCustomerEntity getCashticketCustomer(int ticketCustomerId) {
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.selectByPrimaryKey(Integer.valueOf(ticketCustomerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo useCashTicketCustomer(String customerId, int ticketCustomerId, String orderMainNo, BigDecimal realyDeduction, String appId, Integer platformId) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        if (!cashticketCustomerEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u4f18\u60e0\u52b5");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getAllCashticketList4Status(cashticketBatchEntity.getPlatformGroupId(), customerId, ticketCustomerId, 1);
        if (ls == null || ls.size() == 0) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u5df2\u5931\u6548");
        }
        if (this.cashticketCustomerMapper.updateCustomerCashStasusUse(customerId, orderMainNo, realyDeduction, ticketCustomerId) > 0) {
            this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yishiyong);
            cashticketCustomerEntity.setUsedTime(DateUtils.now());
            ExecutorService pool = Executors.newFixedThreadPool(1);
            try {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    this.logger.info("\u5f00\u59cb\u4e0a\u62a5\u7528\u6237:{}\u4f18\u60e0\u5238:{}\u6838\u9500", (Object)customerId, (Object)cashticketBatchEntity.getTicketBatchName());
                    CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId);
                    this.logger.info("\u5f00\u59cb\u4e0a\u62a5\u7528\u6237:{}\u4f18\u60e0\u5238:{} appId:{},openId:{}\u6838\u9500", new Object[]{customerId, cashticketBatchEntity.getTicketBatchName(), appId, customerDetailVo.getOpenId()});
                    this.couponService.consume(cashticketCustomerEntity, appId, customerDetailVo.getOpenId());
                }, pool);
            }
            catch (Exception e) {
                this.logger.error("\u4e0a\u62a5\u4f18\u60e0\u5238\u4f7f\u7528\u51fa\u9519", (Throwable)e);
            }
            finally {
                pool.shutdown();
            }
        } else {
            return BaseJsonVo.paramError((String)"\u4f18\u60e0\u52b5\u65e0\u6cd5\u4f7f\u7528");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo returnCashTicketCustomer(int ticketCustomerId, String orderMainNo) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            CashticketCustomerEntity query = new CashticketCustomerEntity();
            query.setTicketId(ticketCustomerId);
            query.setOrderMainNo(orderMainNo);
            query.setStatus(CashStatusEnum.yishiyong.getValue());
            cashticketCustomerEntity = (CashticketCustomerEntity)CollectionUtils.listToEntiy((List)this.cashticketCustomerMapper.getList(query));
        }
        cashticketCustomerEntity.setOrderMainNo("");
        cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity);
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yijihuo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<CashticketCustomerEntity> getCashticketCustomerList(String customerId, String ticketBatchId) {
        CashticketCustomerEntity param = new CashticketCustomerEntity();
        param.setCustomerId(customerId);
        param.setTicketBatchId(ticketBatchId);
        return this.cashticketCustomerMapper.getList(param);
    }

    @Override
    public CashticketCustomerEntity getEnableCashticketCustomerList(String customerId, String ticketBatchId) {
        CashticketCustomerEntity param = new CashticketCustomerEntity();
        param.setCustomerId(customerId);
        param.setTicketBatchId(ticketBatchId);
        param.setStatus(1);
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.getSingle(param);
    }

    @Override
    public BaseJsonVo sendTicket4Code(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, int ticketId, int platformId, boolean isSendMessage) {
        return ((CashticketCustomerService)AopContext.currentProxy()).sendTicket(customerId, cashticketBatchEntity, count, "", "", "", ticketId, platformId, isSendMessage, 0.0, null, "");
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, int platformId, boolean isSendMessage, String code, String ncpBat) {
        return ((CashticketCustomerService)AopContext.currentProxy()).sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, 0.0, platformId, isSendMessage, code, ncpBat);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, double amount, String versionDetailId, int platformId, boolean isSendMessage, String code, String ncpBat) {
        return ((CashticketCustomerService)AopContext.currentProxy()).sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, amount, platformId, isSendMessage, code, ncpBat);
    }

    @Override
    public BaseJsonVo sendChangeAmountTicket(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, double amount, int platformId, boolean isSendMessage, String code, String ncpBat) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        return ((CashticketCustomerService)AopContext.currentProxy()).sendTicket(customerId, cashticketBatchEntity, count, activeNo, bindCode, versionDetailId, 0, platformId, isSendMessage, amount, code, ncpBat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo sendTicket(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, String activeNo, String bindCode, String versionDetailId, int ticketId, int platformId, boolean sendMessage, double amount, String code, String ncpBat) {
        boolean isActivite;
        this.logger.info("\u4f18\u60e0\u5238\u53d1\u653e customerId={},\u6279\u6b21:{},\u6570\u91cf:{},activeNo={},ticketId={},platformId={},sendMessage={},amount={},code={}", new Object[]{customerId, cashticketBatchEntity.getTicketBatchName(), count, activeNo, ticketId, platformId, sendMessage, amount, code});
        String message = "";
        if (cashticketBatchEntity == null) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21";
            throw new RuntimeException(message);
        }
        if (count < 1) {
            message = "\u53d1\u9001\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getStatus() == 0) {
            message = "\u4f18\u60e0\u52b5\u5df2\u5931\u6548";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getQuantity() > 0 && cashticketBatchEntity.getAlreadyQuantity() >= cashticketBatchEntity.getQuantity()) {
            message = "\u5662~\u6765\u8fdf\u4e86,\u4f18\u60e0\u5238\u88ab\u9886\u5149\u4e86";
            this.logger.info(cashticketBatchEntity.getTicketBatchName() + message);
            throw new RuntimeException(message);
        }
        if (amount > 0.0 && cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() && new BigDecimal(amount).compareTo(cashticketBatchEntity.getAmount()) == 1) {
            message = "\u5151\u6362\u91d1\u989d\u8d85\u8fc7\u5141\u8bb8\u5151\u6362\u6700\u5927\u91d1\u989d";
            throw new RuntimeException(message);
        }
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (customerEntity == null) {
            message = "\u65e0\u6548\u7684\u7528\u6237";
            throw new RuntimeException(message);
        }
        if (StringUtils.isEmpty((String)ncpBat)) {
            ncpBat = "";
            HttpServletRequest httpServletRequest = RequestDetail.getCurrentRequest();
            if (httpServletRequest != null && StringUtils.isEmpty((String)(ncpBat = httpServletRequest.getParameter("ncp_bat")))) {
                ncpBat = httpServletRequest.getParameter("ncpBat");
            }
        }
        boolean bl = isActivite = ticketId == 0;
        if (!customerEntity.getPlatformGroupId().equals(cashticketBatchEntity.getPlatformGroupId())) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6240\u5c5e\u516c\u53f8";
            throw new RuntimeException(message);
        }
        int j = 0;
        for (int i = 0; i < count; ++i) {
            boolean isSuccess = false;
            while (!isSuccess) {
                if (j > 10) {
                    message = "\u4f18\u60e0\u52b5\u53d1\u653e\u5f02\u5e38";
                    throw new RuntimeException(message);
                }
                List<CashticketCustomerEntity> ls = this.getCashticketCustomerList(customerId, cashticketBatchEntity.getTicketBatchId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ls)) {
                    if (cashticketBatchEntity.getUserTackCount() > 0 && ls.size() >= cashticketBatchEntity.getUserTackCount()) {
                        message = cashticketBatchEntity.getTicketBatchName() + " \u8d85\u51fa\u9886\u53d6\u6570\u91cf\u9650\u5236~";
                        this.logger.info("\u4f18\u60e0\u5238:{},{}", (Object)cashticketBatchEntity.getTicketBatchName(), (Object)message);
                        if (cashticketBatchEntity.getUserVisible() != null && cashticketBatchEntity.getUserVisible() == 1) {
                            this.messageService.sendCustomerTextMessage4CustmoerId(customerId, platformId, message, 0);
                        }
                        throw new RuntimeException(message);
                    }
                    if (StringUtils.isNotEmpty((String)code) && ls.stream().anyMatch(c -> Objects.equals(c.getCode(), code))) {
                        message = "\u9886\u53d6\u5931\u8d25!\u8bf7\u8054\u7cfb\u5ba2\u670d\u91cd\u65b0\u5206\u4eab";
                        this.logger.error("\u5ba2\u6237\uff1a{}\u4f18\u60e0\u5238:{},{},\u540c\u4e00\u4e2a\u8fde\u63a5\u5df2\u9886\u53d6\u8fc7\u4e00\u6b21", new Object[]{customerId, cashticketBatchEntity.getTicketBatchName(), message});
                        throw new RuntimeException(message);
                    }
                }
                CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
                cashticketCustomerEntity.setTicketId(ticketId);
                cashticketCustomerEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
                cashticketCustomerEntity.setCustomerId(customerId);
                cashticketCustomerEntity.setSourceActiveNo(activeNo);
                cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
                cashticketCustomerEntity.setBindCode(bindCode);
                cashticketCustomerEntity.setVersionDetailId(versionDetailId);
                cashticketCustomerEntity.setNcpBat(ncpBat);
                cashticketCustomerEntity.setCode(StringUtils.isEmpty((String)code) ? null : code);
                if (cashticketBatchEntity.getPeriodType().intValue() == CashPeriodTypeEnum.tianshu.getValue()) {
                    cashticketCustomerEntity.setBeginTime(DateUtils.currentDate());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(cashticketBatchEntity.getDays() + 1)));
                } else {
                    cashticketCustomerEntity.setBeginTime(cashticketBatchEntity.getBeginTime());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)cashticketBatchEntity.getEndTime(), (int)1));
                }
                cashticketCustomerEntity.setCreateTime(DateUtils.now());
                cashticketCustomerEntity.setTicketAmount(cashticketBatchEntity.getAmount());
                if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.static_cash.getValue()) {
                    cashticketCustomerEntity.setTicketAmount(cashticketBatchEntity.getAmount());
                } else if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue()) {
                    cashticketCustomerEntity.setTicketAmount(new BigDecimal(amount));
                } else {
                    message = "\u5238\u91d1\u989d\u7c7b\u578b\u6709\u8bef";
                    throw new RuntimeException(message);
                }
                if (this.cashticketBatchService.updateCashticketBatchAlreadyQuantity(cashticketBatchEntity.getTicketBatchId(), 1)) {
                    this.logger.info("\u67e5\u770b\u4f18\u60e0\u5238\u53d1\u653e\u6765\u6e90:{}", (Object)isActivite);
                    if (isActivite) {
                        isSuccess = ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).insertCashticketCustomer(cashticketBatchEntity, cashticketCustomerEntity, platformId);
                    } else if (this.cashticketService.updateCashticketStatus(ticketId, CashStatusEnum.yijihuo, cashticketBatchEntity)) {
                        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        cashticketBatchEntity.setAlreadyQuantity(cashticketBatchEntity.getAlreadyQuantity() + 1);
                        if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue() && cashticketBatchEntity.getAmount().compareTo(cashticketCustomerEntity.getTicketAmount()) > 0 && !this.cashticketService.updateCashticketAmount(ticketId, cashticketCustomerEntity.getTicketAmount())) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        isSuccess = true;
                    }
                } else {
                    message = "\u5662~\u6765\u8fdf\u4e86,\u4f18\u60e0\u5238\u88ab\u9886\u5149\u4e86";
                    throw new RuntimeException(message);
                }
                LocalTime time = LocalTime.now();
                int hour = time.getHour();
                if (isSuccess) {
                    ExecutorService pool = Executors.newFixedThreadPool(1);
                    boolean pushMessage = sendMessage && cashticketBatchEntity.getUserVisible() != null && cashticketBatchEntity.getUserVisible() == 1 && hour >= 8 && hour <= 20;
                    try {
                        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                            if (pushMessage) {
                                this.sendCashMessage(customerId, cashticketBatchEntity, cashticketCustomerEntity, platformId);
                            }
                            if (platformId == 4) {
                                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId);
                                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(platformId);
                                this.couponService.getCoupon(cashticketCustomerEntity, weiXinBaseEntity.getAppid(), customerDetailVo.getOpenId());
                            }
                        }, pool);
                    }
                    catch (Exception e) {
                        this.logger.error("\u53d1\u9001\u4f18\u60e0\u5238\u6d88\u606f\u5f02\u5e38:" + e);
                    }
                    finally {
                        pool.shutdown();
                    }
                }
                ++j;
            }
        }
        return BaseJsonVo.success((Object)"\u5151\u6362\u6210\u529f");
    }

    private void sendCashMessage(String customerId, CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, int platformId) {
        this.cashticketNoticeInterface.sendMessage(customerId, cashticketBatchEntity.getTicketBatchName(), cashticketCustomerEntity.getCreateTime(), cashticketCustomerEntity.getEndTime(), cashticketBatchEntity.getRemark());
        PlatFormEntity platFormEntity = this.platformService.getPlatForm(platformId);
        HashMap map = this.getMssageCashSendSuccess(cashticketBatchEntity, cashticketCustomerEntity.getTicketAmount(), cashticketCustomerEntity.getEndTime(), platFormEntity.getDomainPage());
        this.messageService.sendWechatMessage(platFormEntity.getPlatformGroupId(), MessageActionConstants.cashSendSuccess, customerId, (Map<String, String>)map);
    }

    private HashMap getMssageCashSendSuccess(CashticketBatchEntity cashticketBatchEntity, BigDecimal amount, Date endTime, String domin_page) {
        HashMap<String, String> map = new HashMap<String, String>();
        String pre = "";
        pre = cashticketBatchEntity.getMinUseamount().doubleValue() == 0.0 ? "\u65e0\u95e8\u69db" : "\u6ee1" + cashticketBatchEntity.getMinUseamount().doubleValue();
        if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
            pre = pre + "\u51cf" + amount;
        } else if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            pre = pre + "\u4eab" + MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2) + "\u6298";
        }
        map.put("cashTitle", pre);
        map.put("cashName", cashticketBatchEntity.getTicketBatchName());
        map.put("cashdDomin", domin_page);
        map.put("cashEndTime", DateUtils.formatDate((Date)endTime, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        return map;
    }

    @Override
    public void saveSendLog(String customerId, CashticketBatchEntity cashticketBatchEntity, String ticketBatchId, String bindCode, String versionDetailId, BaseJsonVo vo, int ticketId, String ticketNo, int count) {
        try {
            vo.setMessage(count + ":" + vo.getMessage());
            CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
            if (cashticketBatchEntity != null) {
                cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
                cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
                cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
            } else {
                cashticketSendLogEntity.setTicketBatchId(ticketBatchId);
            }
            cashticketSendLogEntity.setTicketNo(ticketNo);
            cashticketSendLogEntity.setTicketId(ticketId);
            cashticketSendLogEntity.setBindCode(bindCode);
            cashticketSendLogEntity.setCustomerId(customerId);
            cashticketSendLogEntity.setCreateTime(DateUtils.now());
            cashticketSendLogEntity.setMessage(JSON.toJSONString((Object)vo));
            cashticketSendLogEntity.setVersionDetailId(versionDetailId);
            cashticketSendLogEntity.setStatus(vo.isSuccess() ? 1 : 0);
            this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public void saveSendLog(String customerId, String ticketBatchId, String status, String bindCode, String versionDetailId, String message, String count) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
        if (cashticketBatchEntity != null) {
            cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
            cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
            cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        }
        cashticketSendLogEntity.setTicketNo("");
        cashticketSendLogEntity.setTicketId(0);
        cashticketSendLogEntity.setBindCode(bindCode);
        cashticketSendLogEntity.setCustomerId(customerId);
        cashticketSendLogEntity.setCreateTime(DateUtils.now());
        cashticketSendLogEntity.setMessage(message + ",\u4f18\u60e0\u5238\u6570\u91cf:" + count);
        cashticketSendLogEntity.setVersionDetailId(versionDetailId);
        cashticketSendLogEntity.setStatus(Integer.valueOf(status));
        this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
    }

    @Override
    public BaseJsonVo getCashticketList(int platformGroupId, String customerId, Integer type, Integer useType) {
        List<Object> voList = new ArrayList();
        if (type == 1) {
            voList = ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).getValidCashticketList(platformGroupId, customerId, useType);
        } else if (type == 2) {
            voList = ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).getInvalidCashticketList(platformGroupId, customerId);
        } else if (type == 3) {
            voList = ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).getUseCashticketList(platformGroupId, customerId);
        } else if (type == 4) {
            voList = ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).getUseCashticketList(platformGroupId, customerId);
        } else {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7c7b\u578b");
        }
        voList.forEach(c -> c.setTicketAmount(Objects.equals(c.getFreeCash(), 1) ? BigDecimal.ZERO : c.getTicketAmount()));
        return BaseJsonVo.success(voList);
    }

    @Override
    public List<CashticketVo> getValidCashticketList(int platformGroupId, String customerId, Integer userType) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 1);
        if (ls != null && ls.size() > 0) {
            List<DictionaryEntity> cashClassList = this.cashticketClassService.getCashticketClass(platformGroupId);
            for (CashticketSimpleVo simpleVo : ls) {
                this.getCashticketVo(rs, cashClassList, simpleVo);
            }
            rs.sort(new Comparator<CashticketVo>(){

                @Override
                public int compare(CashticketVo o1, CashticketVo o2) {
                    return o2.getTicketCustomerId() - o1.getTicketCustomerId();
                }
            });
        }
        return rs;
    }

    @Override
    @WriteDataSource
    public List<CashticketVo> getTakedCashticketList(PageForm pageForm, int platformGroupId, String customerId, String bindCode) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        this.cashticketCustomerMapper.getCashticketList4BindCode(platformGroupId, customerId, bindCode);
        PageInfo pg = page.toPageInfo();
        if (pg != null && pg.getList() != null) {
            ArrayList<DictionaryEntity> cashClassList = new ArrayList<DictionaryEntity>();
            for (CashticketSimpleVo simpleVo : pg.getList()) {
                this.getCashticketVo(rs, cashClassList, simpleVo);
            }
        }
        return rs;
    }

    private void getCashticketVo(List<CashticketVo> rs, List<DictionaryEntity> cashClassList, CashticketSimpleVo simpleVo) {
        CashticketVo cashticketVo = this.getCashticketVo(simpleVo, true, BigDecimal.ZERO);
        cashticketVo.setTicetClass(simpleVo.getTicetClass());
        if (simpleVo.getTicetClass() != null) {
            cashticketVo.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, simpleVo.getTicetClass()));
        } else {
            cashticketVo.setTicetClassName("");
        }
        rs.add(cashticketVo);
    }

    @Override
    public List<CashticketVo> getUseCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 3);
        ls.forEach(cashticketSimpleVo -> rs.add(this.getCashticketVo((CashticketSimpleVo)cashticketSimpleVo, false, new BigDecimal(0))));
        return rs;
    }

    @Override
    public List<CashticketVo> getInvalidCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 2);
        if (ls != null && ls.size() > 0) {
            for (CashticketSimpleVo simpleVo : ls) {
                rs.add(this.getCashticketVo(simpleVo, false, new BigDecimal(0)));
            }
        }
        return rs;
    }

    @Override
    public CanUseCashticketVo getEnabledCashticketList(int cacheType, int platformGroupId, List<Integer> selectCashticketList, String customerId, List<MallOrderVo> orderVos) {
        CanUseCashticketVo canUseCashticketVo = new CanUseCashticketVo();
        List<Object> ls = new ArrayList();
        this.logger.info("\u9009\u62e9\u7684\u4f18\u60e0\u5238 cacheType={} platformGroupId={},customerId={},checkCashticketVoList={},select_status_valid={},orderVos={}", new Object[]{cacheType, platformGroupId, customerId, selectCashticketList, 1, orderVos.toString()});
        ls = cacheType == 2 ? this.cashticketCustomerMapper.getCashticketList4cashList(platformGroupId, customerId, selectCashticketList, 1) : this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 1);
        if (ls.size() == 0) {
            canUseCashticketVo.setNum(0);
            return canUseCashticketVo;
        }
        ArrayList<CashticketVo> unUseList = new ArrayList<CashticketVo>();
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        this.logger.info("customerId={},[rs]-before-build:{}", (Object)customerId, (Object)JsonUtils.toJson(ls, (boolean)false));
        ArrayList<CashItemVo> cashItemVoList = new ArrayList<CashItemVo>();
        List<DictionaryEntity> cashClassList = this.cashticketClassService.getCashticketClass(platformGroupId);
        List<MallProductCategoryEntity> categoryList = this.productCategoryInterface.getCategoryList();
        List<CashticketBatchNewRuleVo> productCashRuleList = null;
        List<CashticketBatchNewRuleVo> promotionCashRuleList = null;
        ArrayList<String> productIdList = new ArrayList<String>();
        ArrayList<String> promotionList = new ArrayList<String>();
        for (MallOrderVo mallOrderVo : orderVos) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mallOrderVo.getProducts())) {
                productIdList.addAll(mallOrderVo.getProducts().stream().map(MallProductEntity::getProId).collect(Collectors.toList()));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(mallOrderVo.getPromotions())) continue;
            promotionList.addAll(mallOrderVo.getPromotions().stream().map(MallPromotionEntity::getPromotionId).collect(Collectors.toList()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productIdList)) {
            productCashRuleList = this.cashticketBatchNewRuleService.getCashRule(productIdList, (Integer)SalesTypeEnum.SALES_PRODUCT.getValue());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(promotionList)) {
            promotionCashRuleList = this.cashticketBatchNewRuleService.getCashRule(promotionList, (Integer)SalesTypeEnum.SALES_PROMOTION.getValue());
        }
        for (CashticketSimpleVo cashticketSimpleVo : ls) {
            CashItemVo cashItemVo2 = new CashItemVo();
            cashItemVo2.setTicketAmount(cashticketSimpleVo.getAmount());
            cashItemVo2.setTicketCustomerId(cashticketSimpleVo.getTicketCustomerId());
            cashItemVo2.setComposeUse(cashticketSimpleVo.getComposeUse());
            cashItemVo2.setTicketBatchName(cashticketSimpleVo.getTicketBatchName());
            boolean productCashFlag = false;
            List<CashticketBatchNewRuleVo> rule_ls = this.cashticketBatchNewRuleService.getCashRule(cashticketSimpleVo.getTicketBatchId(), (Integer)ProductCashRuleTypeEnum.cash.getValue());
            BigDecimal total_use_cash_amonut = BigDecimal.ZERO;
            for (MallOrderVo mallOrderVo : orderVos) {
                if (mallOrderVo.getProducts() != null) {
                    total_use_cash_amonut = this.caclUseCash4Product(cashticketSimpleVo, total_use_cash_amonut, mallOrderVo, productCashRuleList, cashItemVo2, categoryList, rule_ls);
                }
                if (mallOrderVo.getPromotions() == null) continue;
                total_use_cash_amonut = this.caclUseCash4Promotion(cashticketSimpleVo, total_use_cash_amonut, mallOrderVo, promotionCashRuleList, cashItemVo2, categoryList, rule_ls, cacheType);
            }
            if (total_use_cash_amonut.compareTo(BigDecimal.ZERO) > 0) {
                if (total_use_cash_amonut.compareTo(cashticketSimpleVo.getMinUseamount()) >= 0) {
                    BigDecimal enableCashticketAmount = null;
                    if (cashticketSimpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                        enableCashticketAmount = total_use_cash_amonut.compareTo(cashticketSimpleVo.getAmount()) >= 0 ? cashticketSimpleVo.getAmount() : total_use_cash_amonut;
                    } else if (cashticketSimpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                        enableCashticketAmount = MathUtils.divBigDecimal((Double)MathUtils.mulBigDecimal((Number)total_use_cash_amonut, (Number)(100 - cashticketSimpleVo.getDiscountAmount())).doubleValue(), (Double)100.0, (Integer)2);
                    }
                    this.logger.info("\u4f18\u60e0\u5238:{} simpleVo.getMinUseamount()={},\u7528\u6237:{},\u5546\u54c1\u53ef\u7528\u5238\u91d1\u989d total_use_cash_amonut ={},\u62b5\u6263\u91d1\u989d:{}", new Object[]{cashticketSimpleVo.getTicketBatchName(), cashticketSimpleVo.getMinUseamount(), customerId, total_use_cash_amonut, enableCashticketAmount});
                    cashItemVo2.setEnableCashticketAmount(enableCashticketAmount);
                    cashItemVo2.setTotal_use_cash_amonut(total_use_cash_amonut);
                    if (enableCashticketAmount == null) continue;
                    CashticketVo cashticketVo3 = this.getCashticketVo(cashticketSimpleVo, true, enableCashticketAmount, productCashFlag);
                    cashticketVo3.setTicetClass(cashticketSimpleVo.getTicetClass());
                    cashticketVo3.setTotalUseCashAmonut(total_use_cash_amonut);
                    cashticketVo3.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
                    rs.add(cashticketVo3);
                    cashItemVoList.add(cashItemVo2);
                    continue;
                }
                this.logger.info("\u4f18\u60e0\u5238:{}, \u5546\u54c1\u53ef\u7528\u5238\u91d1\u989d:{},\u4f18\u60e0\u5238\u6700\u4f4e\u7528\u5238\u91d1\u989d:{}", new Object[]{cashticketSimpleVo.getTicketBatchName(), total_use_cash_amonut, cashticketSimpleVo.getMinUseamount()});
                if (cacheType == 2) continue;
                CashticketVo cashticketVo2 = this.getCashticketVo(cashticketSimpleVo, true, BigDecimal.ZERO, productCashFlag);
                cashticketVo2.setTicetClass(cashticketSimpleVo.getTicetClass());
                cashticketVo2.setTotalUseCashAmonut(total_use_cash_amonut);
                cashticketVo2.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
                cashticketVo2.setUseNotice("\u5dee" + PriceUtils.subtract((BigDecimal)cashticketSimpleVo.getMinUseamount(), (BigDecimal)total_use_cash_amonut) + "\u5143\u53ef\u7528");
                unUseList.add(cashticketVo2);
                continue;
            }
            if (cacheType == 2) continue;
            CashticketVo cashticketVo2 = this.getCashticketVo(cashticketSimpleVo, true, BigDecimal.ZERO, productCashFlag);
            cashticketVo2.setTicetClass(cashticketSimpleVo.getTicetClass());
            cashticketVo2.setTotalUseCashAmonut(total_use_cash_amonut);
            cashticketVo2.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
            cashticketVo2.setUseNotice("\u4e0d\u53ef\u7528,\u6ca1\u6709\u7b26\u5408\u4f7f\u7528\u6761\u4ef6\u7684\u5546\u54c1");
            unUseList.add(cashticketVo2);
        }
        this.setNoUseCash(cacheType, selectCashticketList, orderVos, cashItemVoList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rs)) {
            if (cacheType == 1) {
                Collections.sort(rs);
                Collections.sort(cashItemVoList);
            }
            try {
                ArrayList<CashticketVo> rs1 = new ArrayList<CashticketVo>();
                ArrayList arrayList = new ArrayList();
                ArrayList cashItemVoList1 = new ArrayList();
                ArrayList cashItemVoList2 = new ArrayList();
                if (selectCashticketList.size() > 0) {
                    rs.forEach(cashticketVo -> {
                        if (selectCashticketList.stream().filter(ticketCustomerId2 -> ticketCustomerId2.intValue() == cashticketVo.getTicketCustomerId().intValue()).findAny().isPresent()) {
                            rs1.add((CashticketVo)cashticketVo);
                            this.logger.info("YES:{}", (Object)JsonUtils.toJson((Object)cashticketVo, (boolean)false));
                        } else {
                            rs2.add(cashticketVo);
                            this.logger.info("NO:{}", (Object)JsonUtils.toJson((Object)cashticketVo, (boolean)false));
                        }
                    });
                    canUseCashticketVo.setList(rs1);
                    this.logger.info("after-filter-canUseCashticketVo:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                } else {
                    canUseCashticketVo.setList(rs);
                    this.logger.info("after-no-filter-canUseCashticketVo:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                }
                if (cashItemVoList.size() > 0) {
                    cashItemVoList.forEach(cashItemVo -> {
                        if (selectCashticketList.stream().filter(ticketCustomerId2 -> ticketCustomerId2.intValue() == cashItemVo.getTicketCustomerId().intValue()).findAny().isPresent()) {
                            cashItemVoList1.add(cashItemVo);
                        } else {
                            cashItemVoList2.add(cashItemVo);
                        }
                    });
                }
                this.logger.info("before-getDefaultUseCash,canUseCashticketVo={},cashItemVoList={},cashItemVoList1={},cashItemVoList2={}", new Object[]{JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), JsonUtils.toJson(cashItemVoList, (boolean)false), JsonUtils.toJson(cashItemVoList1, (boolean)false), JsonUtils.toJson(cashItemVoList2, (boolean)false)});
                canUseCashticketVo.setSelectCashVo(this.getDefaultUseCash(canUseCashticketVo, cashItemVoList1.size() == 0 ? cashItemVoList : cashItemVoList1));
                if (cacheType != 2) {
                    canUseCashticketVo.getList().addAll(arrayList);
                }
                Collections.sort(canUseCashticketVo.getList());
                this.logger.info("almost-over-[canUseCashticketVo]:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                if (cacheType == 1 || cacheType == 2 || cacheType == 3) {
                    this.calculateCashUseAmount(canUseCashticketVo, orderVos);
                }
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u4f18\u60e0\u5238\u6700\u4f18\u7ec4\u5408\u51fa\u9519error", (Throwable)e);
            }
        } else {
            canUseCashticketVo.setList(null);
            canUseCashticketVo.setNum(0);
            canUseCashticketVo.setSelectCashVo(null);
        }
        canUseCashticketVo.setUnUseList(unUseList);
        return canUseCashticketVo;
    }

    private void setNoUseCash(int cacheType, List<Integer> selectCashticketList, List<MallOrderVo> orderVos, List<CashItemVo> cashItemVoList) {
        if (cacheType == 2 && !selectCashticketList.isEmpty()) {
            this.logger.info("[setNoUseCash]-start cashItemVoList={}", (Object)JsonUtils.toJson(cashItemVoList, (boolean)false));
            ArrayList<MallProductVO> mallProductVOList = new ArrayList<MallProductVO>();
            ArrayList<MallPromotionVO> mallPromotionVOList = new ArrayList<MallPromotionVO>();
            for (MallOrderVo mallOrderVo : orderVos) {
                if (!mallOrderVo.getProducts().isEmpty()) {
                    mallProductVOList.addAll(mallOrderVo.getProducts());
                }
                if (mallOrderVo.getPromotions().isEmpty()) continue;
                mallPromotionVOList.addAll(mallOrderVo.getPromotions());
            }
            if (mallProductVOList.size() > 0) {
                mallProductVOList.forEach(mallProductVO -> {
                    mallProductVO.setUseCoupon(0);
                    boolean useCoupon = cashItemVoList.stream().flatMap(cashItemVo -> cashItemVo.getUseCashItemVOList().stream()).anyMatch(useCashItemVO -> Objects.equals(useCashItemVO.getItemId(), mallProductVO.getProId()) && Objects.equals(useCashItemVO.getProductType(), SalesTypeEnum.SALES_PRODUCT.getValue()));
                    if (useCoupon) {
                        mallProductVO.setUseCoupon(1);
                    }
                    this.logger.info("\u5546\u54c1:{},\u80fd\u5426\u4f7f\u7528\u4f18\u60e0\u5238:{}", (Object)mallProductVO.getProName(), (Object)mallProductVO.getUseCoupon());
                });
            }
            if (mallPromotionVOList.size() > 0) {
                mallPromotionVOList.forEach(mallPromotionVO -> {
                    mallPromotionVO.setUseCoupon(0);
                    boolean useCoupon = cashItemVoList.stream().flatMap(cashItemVo -> cashItemVo.getUseCashItemVOList().stream()).anyMatch(useCashItemVO -> Objects.equals(useCashItemVO.getItemId(), mallPromotionVO.getPromotionId()) && Objects.equals(useCashItemVO.getProductType(), SalesTypeEnum.SALES_PROMOTION.getValue()));
                    if (useCoupon) {
                        mallPromotionVO.setUseCoupon(1);
                    }
                });
            }
        }
    }

    private BigDecimal caclUseCash4Product(CashticketSimpleVo simpleVo, BigDecimal total_use_cash_amonut, MallOrderVo mallOrderVo, List<CashticketBatchNewRuleVo> productCashRuleList, CashItemVo cashItemVo, List<MallProductCategoryEntity> categoryList, List<CashticketBatchNewRuleVo> rule_ls) {
        for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
            List<CashticketBatchNewRuleVo> tempRuleList;
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u5546\u54c1:{},\u4f18\u60e0\u5238:{},{}\uff0c{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), mallProductVO.getUseCoupon(), simpleVo.getFreeCash()});
            if (mallProductVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.use.getValue() && mallProductVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.only_free_use.getValue() && mallProductVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.only_item_use.getValue()) continue;
            boolean canUse = false;
            if (Objects.equals(simpleVo.getFreeCash(), 1)) {
                if (mallProductVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.use.getValue() || mallProductVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.only_free_use.getValue()) {
                    canUse = true;
                }
            } else if (mallProductVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.use.getValue() || mallProductVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.only_item_use.getValue()) {
                canUse = true;
            }
            this.logger.info("\u5546\u54c1:{} \u7528\u5238\u7c7b\u578b:{},\u4f18\u60e0\u5238:{},\u5238\u7c7b\u578b:{},\u662f\u5426\u53ef\u7528\u5238:{}", new Object[]{mallProductVO.getProName(), mallProductVO.getUseCoupon(), simpleVo.getTicketBatchName(), simpleVo.getFreeCash(), canUse});
            if (!canUse) continue;
            if (!(productCashRuleList.isEmpty() || (tempRuleList = productCashRuleList.stream().filter(r -> Objects.equals(r.getTicketBatchId(), mallProductVO.getProId())).collect(Collectors.toList())).isEmpty() || this.canUseCash(tempRuleList, simpleVo))) {
                this.logger.info("\u5355\u54c1\u5546\u54c1:{}\u4e0d\u80fd\u4f7f\u7528:{}\u4f18\u60e0\u5238", (Object)mallProductVO.getProName(), (Object)simpleVo.getTicketBatchName());
                continue;
            }
            BaseJsonVo<Boolean> baseJsonVo = this.getCashUseStatus(rule_ls, mallProductVO.getProId(), CashRuleTypeEnum.danpin.getValue(), mallOrderVo.getPlatFormId());
            boolean flag = (Boolean)baseJsonVo.getValue();
            this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), flag});
            if (!flag) {
                if (rule_ls != null && StringUtils.isNotEmpty((String)mallProductVO.getProductCategoryId())) {
                    if (rule_ls.stream().anyMatch(r -> Objects.equals(r.getRuleType(), CashRuleTypeEnum.product_class.getValue()))) {
                        flag = this.getCashUseStatus(rule_ls, mallProductVO.getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                        this.logger.info("\u5546\u54c1:{},\u7c7b\u76ee:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallProductVO.getProName(), mallProductVO.getProductCategoryId(), flag});
                    } else {
                        this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u672a\u914d\u7f6e\u5546\u54c1\u7c7b\u76ee\u89c4\u5219", (Object)mallProductVO.getProName(), (Object)simpleVo.getTicketBatchName());
                    }
                } else {
                    this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u89c4\u5219\u914d\u7f6e\u4e3a\u7a7a\u6216\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a", (Object)mallProductVO.getProName(), (Object)simpleVo.getTicketBatchName());
                }
            }
            this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), flag});
            if (!flag) continue;
            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallProductVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallProductVO.getFactPrice()).subtract(mallProductVO.getFullcutAmount()));
            this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{},\u53ef\u7528\u91d1\u989d:{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), flag, total_use_cash_amonut});
            MallUseCashItemVO mallUseCashItemVO = new MallUseCashItemVO();
            mallUseCashItemVO.setCount(mallProductVO.getCount());
            mallUseCashItemVO.setFactPrice(mallProductVO.getFactPrice());
            mallUseCashItemVO.setDeliverCount(mallOrderVo.getDeliverCount());
            mallUseCashItemVO.setItemId(mallProductVO.getProId());
            mallUseCashItemVO.setItemName(mallProductVO.getProName());
            mallUseCashItemVO.setProductType(SalesTypeEnum.SALES_PRODUCT.getValue());
            mallUseCashItemVO.setFullcutAmount(mallProductVO.getFullcutAmount());
            cashItemVo.getUseCashItemVOList().add(mallUseCashItemVO);
            this.logger.info("\u4f18\u60e0\u5238:{},\u53ef\u7528\u5546\u54c1:{},{}", new Object[]{simpleVo.getTicketBatchName(), mallProductVO.getProName(), JsonUtils.toJson((Object)mallUseCashItemVO, (boolean)false)});
        }
        return total_use_cash_amonut;
    }

    private BigDecimal caclUseCash4Promotion(CashticketSimpleVo simpleVo, BigDecimal total_use_cash_amonut, MallOrderVo mallOrderVo, List<CashticketBatchNewRuleVo> promotionCashRuleList, CashItemVo cashItemVo, List<MallProductCategoryEntity> categoryList, List<CashticketBatchNewRuleVo> rule_ls, int cacheType) {
        for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
            List<CashticketBatchNewRuleVo> tempRuleList;
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},{}\uff0c{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), mallPromotionVO.getUseCoupon(), simpleVo.getFreeCash()});
            if (mallPromotionVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.use.getValue() && mallPromotionVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.only_item_use.getValue() && mallPromotionVO.getUseCoupon().intValue() != MallItemConfigUseStatusEnum.only_free_use.getValue()) continue;
            boolean canUse = false;
            if (Objects.equals(simpleVo.getFreeCash(), 1)) {
                if (mallPromotionVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.use.getValue() || mallPromotionVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.only_free_use.getValue()) {
                    canUse = true;
                }
            } else if (mallPromotionVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.use.getValue() || mallPromotionVO.getUseCoupon().intValue() == MallItemConfigUseStatusEnum.only_item_use.getValue()) {
                canUse = true;
            }
            this.logger.info("\u5546\u54c1:{} \u7528\u5238\u7c7b\u578b:{},\u4f18\u60e0\u5238:{},\u5238\u7c7b\u578b:{}\uff0c\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), mallPromotionVO.getUseCoupon(), simpleVo.getTicketBatchName(), simpleVo.getFreeCash(), canUse});
            if (!canUse) continue;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(promotionCashRuleList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(tempRuleList = promotionCashRuleList.stream().filter(r -> Objects.equals(r.getTicketBatchId(), mallPromotionVO.getPromotionId())).collect(Collectors.toList())) && !this.canUseCash(tempRuleList, simpleVo)) {
                this.logger.info("\u4fc3\u9500:{}\u4e0d\u80fd\u4f7f\u7528:{}\u4f18\u60e0\u5238 \u4e0d\u6ee1\u8db3\u4ea7\u54c1\u5238\u4f7f\u7528\u6761\u4ef6", (Object)mallPromotionVO.getPromotionName(), (Object)simpleVo.getTicketBatchName());
                continue;
            }
            BaseJsonVo<Boolean> baseJsonVo = this.getCashUseStatus(rule_ls, mallPromotionVO.getPromotionId(), CashRuleTypeEnum.cuxiao.getValue(), mallOrderVo.getPlatFormId());
            boolean useFlag = (Boolean)baseJsonVo.getValue();
            this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), useFlag});
            if (!useFlag) {
                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                    useFlag = this.getCashUseStatus(rule_ls, mallPromotionVO.getProduct().getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                    for (MallProductVO productVO : mallPromotionVO.getGroup().getProductList()) {
                        useFlag = this.getCashUseStatus(rule_ls, productVO.getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                        if (useFlag) continue;
                        this.logger.info("\u4fc3\u9500:{},\u5546\u54c1:{}\u4e0d\u80fd\u4f7f\u7528\u5238:{} \u4e0d\u7b26\u5408\u7c7b\u76ee\u9650\u5236\u4f7f\u7528\u6761\u4ef6", new Object[]{mallPromotionVO.getPromotionName(), productVO.getProName(), simpleVo.getTicketBatchName()});
                        break;
                    }
                }
                this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), useFlag});
            }
            if (!useFlag) continue;
            BigDecimal fullCutAmount = mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount();
            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallPromotionVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallPromotionVO.getFactPrice()).subtract(fullCutAmount));
            MallUseCashItemVO mallUseCashItemVO = new MallUseCashItemVO();
            mallUseCashItemVO.setCount(mallPromotionVO.getCount());
            mallUseCashItemVO.setFactPrice(mallPromotionVO.getFactPrice());
            mallUseCashItemVO.setDeliverCount(mallOrderVo.getDeliverCount());
            mallUseCashItemVO.setItemId(mallPromotionVO.getPromotionId());
            mallUseCashItemVO.setItemName(mallPromotionVO.getPromotionName());
            mallUseCashItemVO.setProductType(SalesTypeEnum.SALES_PROMOTION.getValue());
            mallUseCashItemVO.setFullcutAmount(fullCutAmount);
            cashItemVo.getUseCashItemVOList().add(mallUseCashItemVO);
        }
        return total_use_cash_amonut;
    }

    private boolean canUseCash(List<CashticketBatchNewRuleVo> productCashList, CashticketSimpleVo simpleVo) {
        List cashList;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productCashList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(cashList = productCashList.stream().map(CashticketBatchNewRuleVo::getDetailIds).collect(Collectors.toList()))) {
            return cashList.stream().anyMatch(c -> c.contains(simpleVo.getTicketBatchId()));
        }
        return false;
    }

    private SelectCashVo getDefaultUseCash(CanUseCashticketVo canUseCashticketVo, List<CashItemVo> cashItemVoList) {
        SelectCashVo selectCashVo = new SelectCashVo();
        ArrayList<Integer> selectCashticketList = new ArrayList<Integer>();
        if (canUseCashticketVo.getList().size() == 1) {
            this.logger.info("1-getDefaultUseCash:canUseCashticketVo={},selectCashticketList={}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), (Object)JsonUtils.toJson(selectCashticketList, (boolean)false));
            return this.getSelectCashVo(canUseCashticketVo, selectCashticketList);
        }
        List<CashItemVo> unComposeCashticketVos = cashItemVoList.stream().filter(mallCashticketVo -> mallCashticketVo.getComposeUse().intValue() == CashComposeUseEnum.unavailable.getValue() && mallCashticketVo.getEnableCashticketAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<CashItemVo> composeCashticketVos = cashItemVoList.stream().filter(mallCashticketVo -> mallCashticketVo.getComposeUse().intValue() == CashComposeUseEnum.available.getValue() && mallCashticketVo.getEnableCashticketAmount().compareTo(BigDecimal.ZERO) >= 0).collect(Collectors.toList());
        if (unComposeCashticketVos.size() == 0 || composeCashticketVos.size() == 0) {
            this.logger.info("2-getDefaultUseCash:canUseCashticketVo={},selectCashticketList={}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), (Object)JsonUtils.toJson(selectCashticketList, (boolean)false));
            return this.getSelectCashVo(canUseCashticketVo, selectCashticketList);
        }
        BestChooseCash.CashCompose cashCompose = this.bestChooseCash.get(composeCashticketVos, unComposeCashticketVos);
        this.logger.info("\u67e5\u770bcashCompose:{}", (Object)cashCompose.toString());
        if (cashCompose.getItemList().size() >= 2) {
            selectCashticketList.addAll(cashCompose.getItemList().stream().map(BestChooseCash.CashComposeItem::getTicketCustomerId).collect(Collectors.toList()));
            for (BestChooseCash.CashComposeItem cashComposeItem : cashCompose.getItemList()) {
                Optional<CashticketVo> result = canUseCashticketVo.getList().stream().filter(cash -> cash.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst();
                if (!result.isPresent()) continue;
                this.logger.info("\u5238\u7c7b\u578b:{}, TicketCustomerId={},\u62b5\u6263\u91d1\u989d:{}", new Object[]{CashComposeUseEnum.getName(cashComposeItem.getComPoseType()), result.get().getTicketCustomerId(), result.get().getEnableCashticketAmount()});
                if (cashComposeItem.getComPoseType() == CashComposeUseEnum.available.getValue()) {
                    result.get().setEnableCashticketAmount(composeCashticketVos.stream().filter(cashItemVo -> cashItemVo.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst().get().getEnableCashticketAmount());
                }
                if (cashComposeItem.getComPoseType() == CashComposeUseEnum.unavailable.getValue()) {
                    result.get().setEnableCashticketAmount(unComposeCashticketVos.stream().filter(cashItemVo -> cashItemVo.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst().get().getEnableCashticketAmount());
                }
                this.logger.info("\u5238\u7c7b\u578b:{} TicketCustomerId={},\u8ba1\u7b97\u540e\u62b5\u6263\u91d1\u989d:{}", new Object[]{CashComposeUseEnum.getName(cashComposeItem.getComPoseType()), result.get().getTicketCustomerId(), result.get().getEnableCashticketAmount()});
            }
        } else {
            selectCashticketList.add(cashItemVoList.get(0).getTicketCustomerId());
            selectCashVo.setDescName(cashItemVoList.get(0).getTicketBatchName());
            this.logger.info("\u4f7f\u7528\u5355\u4e2a\u5238:{}", (Object)selectCashVo.toString());
        }
        selectCashVo.setCashAmout(cashCompose.getEnableCashticketAmount());
        selectCashVo.setDescName("\u63a8\u8350\u4f18\u60e0\u7ec4\u5408");
        selectCashVo.setSelectCashList(selectCashticketList);
        this.logger.info("\u63a8\u8350\u4f18\u60e0\u7ec4\u5408:{}", (Object)selectCashVo.toString());
        return selectCashVo;
    }

    private SelectCashVo getSelectCashVo(CanUseCashticketVo canUseCashticketVo, List<Integer> selectCashticketList) {
        SelectCashVo selectCashVo = new SelectCashVo();
        canUseCashticketVo.setNum(1);
        selectCashVo.setFreeCash(canUseCashticketVo.getList().get(0).getFreeCash());
        selectCashticketList.add(canUseCashticketVo.getList().get(0).getTicketCustomerId());
        selectCashVo.setDescName(canUseCashticketVo.getList().get(0).getTicketBatchName());
        selectCashVo.setCashAmout(canUseCashticketVo.getList().get(0).getEnableCashticketAmount());
        selectCashVo.setSelectCashList(selectCashticketList);
        return selectCashVo;
    }

    private void calculateCashUseAmount(CanUseCashticketVo canUseCashticketVo, List<MallOrderVo> orderVos) {
        block13: {
            MallOrderVo mallOrderVo;
            BigDecimal diff_amount;
            block15: {
                block14: {
                    BigDecimal totalAmout = orderVos.stream().map(MallShoppingcartVO::getFactPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    for (CashticketVo cashticketVo : canUseCashticketVo.getList()) {
                        BigDecimal total_use_cash_amonut = cashticketVo.getTotalUseCashAmonut();
                        this.logger.info("\u4f18\u60e0\u5238:{}\u62b5\u6263\u91d1\u989d:{},\u603b\u7684\u53ef\u7528\u5238\u5546\u54c1\u91d1\u989d:{}", new Object[]{cashticketVo.getTicketBatchName(), cashticketVo.getEnableCashticketAmount(), total_use_cash_amonut});
                        for (MallOrderVo mallOrderVo2 : orderVos) {
                            BigDecimal single_amount;
                            BigDecimal couponAmount = BigDecimal.ZERO;
                            boolean order_use_cash = false;
                            if (mallOrderVo2.getProducts() != null) {
                                for (MallProductVO mallProductVO : mallOrderVo2.getProducts()) {
                                    this.logger.info("\u5546\u54c1:{},\u662f\u5426\u53ef\u7528\u4f18\u60e0\u5238:{}", (Object)mallProductVO.getProName(), (Object)mallProductVO.getUseCoupon());
                                    if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    single_amount = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)mallProductVO.getFactPrice(), (BigDecimal)mallProductVO.getFullcutAmount()), (Integer)(mallProductVO.getQuantity() * mallOrderVo2.getDeliverCount())), (BigDecimal)totalAmout, (int)6, (Integer)4).multiply(cashticketVo.getEnableCashticketAmount());
                                    mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(single_amount));
                                    this.logger.info("\u5546\u54c1:{},\u5206\u63a8\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallProductVO.getProName(), (Object)mallProductVO.getCouponAmount());
                                    couponAmount = couponAmount.add(single_amount);
                                }
                            }
                            if (mallOrderVo2.getGroups() != null) {
                                for (MallGroupVO mallGroupVO : mallOrderVo2.getGroups()) {
                                    if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    single_amount = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)mallGroupVO.getFactPrice(), (BigDecimal)mallGroupVO.getFullcutAmount()), (Integer)(mallGroupVO.getCount() * mallOrderVo2.getDeliverCount())), (BigDecimal)totalAmout, (int)6, (Integer)4).multiply(cashticketVo.getEnableCashticketAmount());
                                    mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(single_amount));
                                    couponAmount = couponAmount.add(single_amount);
                                }
                            }
                            if (mallOrderVo2.getPromotions() != null) {
                                for (MallPromotionVO mallPromotionVO : mallOrderVo2.getPromotions()) {
                                    this.logger.info("\u5546\u54c1:{},\u662f\u5426\u53ef\u7528\u4f18\u60e0\u5238:{}", (Object)mallPromotionVO.getPromotionName(), (Object)mallPromotionVO.getUseCoupon());
                                    if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    BigDecimal fullCutAmount = PriceUtils.divide((BigDecimal)(mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount()), (BigDecimal)BigDecimal.valueOf(mallPromotionVO.getCount().intValue()), (int)6, (Integer)4);
                                    BigDecimal single_amount2 = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)mallPromotionVO.getFactPrice(), (BigDecimal)mallPromotionVO.getFullcutAmount()), (Integer)(mallPromotionVO.getQuantity() * mallOrderVo2.getDeliverCount())), (BigDecimal)totalAmout, (int)6, (Integer)4).multiply(cashticketVo.getEnableCashticketAmount());
                                    mallPromotionVO.setCouponAmount(single_amount2);
                                    this.logger.info("\u5546\u54c1:{},\u5206\u63a8\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallPromotionVO.getPromotionName(), (Object)mallPromotionVO.getCouponAmount());
                                    couponAmount = couponAmount.add(single_amount2);
                                }
                            }
                            mallOrderVo2.setUseCoupon(order_use_cash);
                            if (canUseCashticketVo.getSelectCashVo() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(canUseCashticketVo.getSelectCashVo().getSelectCashList())) {
                                for (Integer ticketId : canUseCashticketVo.getSelectCashVo().getSelectCashList()) {
                                    if (!Objects.equals(ticketId, cashticketVo.getTicketCustomerId())) continue;
                                    mallOrderVo2.setCouponAmount(mallOrderVo2.getCouponAmount().add(couponAmount));
                                }
                            }
                            this.logger.info("\u5b50\u5355\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallOrderVo2.getCouponAmount());
                        }
                    }
                    BigDecimal orderCouponAmount = BigDecimal.valueOf(orderVos.stream().mapToDouble(c -> MathUtils.mulBigDecimal((Number)c.getCouponAmount(), (Number)c.getDeliverCount()).doubleValue()).sum());
                    BigDecimal enableCouponAmount = canUseCashticketVo.getList().stream().filter(cash -> canUseCashticketVo.getSelectCashVo() != null && canUseCashticketVo.getSelectCashVo().getSelectCashList().stream().anyMatch(selectTiceket -> Objects.equals(selectTiceket, cash.getTicketCustomerId()))).map(CashticketVo::getEnableCashticketAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    diff_amount = enableCouponAmount.subtract(orderCouponAmount);
                    this.logger.info("\u8ba2\u5355\u7528\u6237\u5238\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u5dee\u989d:{}", new Object[]{orderCouponAmount, enableCouponAmount, diff_amount});
                    if (diff_amount.doubleValue() == 0.0) break block13;
                    mallOrderVo = orderVos.get(0);
                    mallOrderVo.setCouponAmount(mallOrderVo.getCouponAmount().add(diff_amount));
                    this.logger.info("\u5b50\u5355\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallOrderVo.getCouponAmount());
                    if (mallOrderVo.getProducts() == null) break block14;
                    for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(diff_amount));
                        break block13;
                    }
                    break block13;
                }
                if (mallOrderVo.getPromotions() == null) break block15;
                for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                    if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallPromotionVO.setCouponAmount(mallPromotionVO.getCouponAmount().add(diff_amount));
                    break block13;
                }
                break block13;
            }
            if (mallOrderVo.getGroups() == null) break block13;
            for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(diff_amount));
                break;
            }
        }
    }

    @Override
    public Boolean getCustomerHasTicket(String customerId, String ticketBatchId) {
        Integer hasAndUsedTicket = this.getCustomerHasAndUsedTicket(customerId, ticketBatchId);
        if (hasAndUsedTicket == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Integer getCustomerHasAndUsedTicket(String customerId, String ticketBatchId) {
        CashticketCustomerEntity entity = new CashticketCustomerEntity();
        entity.setCustomerId(customerId);
        entity.setTicketBatchId(ticketBatchId);
        List entities = this.cashticketCustomerMapper.getList(entity);
        if (entities != null && entities.size() > 0) {
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 1) {
                Date now = DateUtils.now();
                if (now.after(((CashticketCustomerEntity)entities.get(0)).getBeginTime()) && now.before(((CashticketCustomerEntity)entities.get(0)).getEndTime())) {
                    return 1;
                }
                return 3;
            }
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 2) {
                return 2;
            }
        }
        return 0;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount, boolean productCashFlag) {
        CashticketVo vo = new CashticketVo();
        vo.setTicketCustomerId(simpleVo.getTicketCustomerId());
        vo.setTicketBatchName(simpleVo.getTicketBatchName());
        vo.setTimes(DateUtils.formatDate((Date)simpleVo.getBeginTime(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)simpleVo.getEndTime(), (String)"yyyy.MM.dd"));
        vo.setEnable(this.getCashStatus(simpleVo, status));
        vo.setTicketAmount(simpleVo.getAmount());
        vo.setDiscountMode(simpleVo.getDiscountMode().shortValue());
        vo.setDiscountAmount(MathUtils.divBigDecimal((Number)simpleVo.getDiscountAmount(), (Number)10, (Integer)2));
        vo.setRemark(simpleVo.getRemark());
        vo.setEnableCashticketAmount(enableCashticketAmount);
        vo.setProductType(productCashFlag ? 2 : 1);
        vo.setComposeUse(simpleVo.getComposeUse());
        vo.setFreeCash(simpleVo.getFreeCash());
        if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            vo.setTicketAmount(enableCashticketAmount);
        }
        if (simpleVo.getMinUseamount().compareTo(BigDecimal.ZERO) == 0) {
            vo.setCutDesc("\u65e0\u95e8\u69db");
        } else if (new BigDecimal(simpleVo.getMinUseamount().intValue()).compareTo(simpleVo.getMinUseamount()) == 0) {
            vo.setCutDesc("\u6ee1" + simpleVo.getMinUseamount().intValue() + "\u53ef\u7528");
        } else {
            vo.setCutDesc("\u6ee1" + simpleVo.getMinUseamount().doubleValue() + "\u53ef\u7528");
        }
        vo.setUseType(simpleVo.getUseType());
        vo.setMinUseamount(simpleVo.getMinUseamount());
        vo.setTicketBatchId(simpleVo.getTicketBatchId());
        if (StringUtils.isEmpty((String)simpleVo.getCashUseUrl())) {
            vo.setGoType(2);
            vo.setProId("");
            vo.setUseUrl("");
            vo.setUseProductType(0);
            boolean flag = false;
            if (simpleVo.getUseType() == 1) {
                vo.setGoType(1);
                vo.setProId("");
                vo.setUseUrl("");
            }
            if (simpleVo.getUseType() == 2) {
                String[] arr;
                List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
                if (list != null && list.size() == 1 && ((arr = list.get(0).getDetailIds().split(",")).length == 1 && list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() || list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue())) {
                    flag = true;
                }
                if (flag) {
                    vo.setGoType(4);
                    vo.setProId(list.get(0).getDetailIds());
                    vo.setUseUrl("");
                    vo.setUseProductType(list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() ? 4 : (list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue() ? 1 : CashRuleTypeEnum.taozhuang.getValue()));
                }
            }
        } else {
            String[] arr;
            vo.setGoType(3);
            vo.setProId("");
            boolean flag = false;
            List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
            if (list != null && list.size() == 1 && ((arr = list.get(0).getDetailIds().split(",")).length == 1 && list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() || list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue())) {
                flag = true;
            }
            if (flag) {
                vo.setProId(list.get(0).getDetailIds());
                vo.setUseProductType(list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() ? 4 : (list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue() ? 1 : CashRuleTypeEnum.taozhuang.getValue()));
            }
            vo.setUseUrl(simpleVo.getCashUseUrl());
        }
        vo.setTicketStatus(simpleVo.getTicketStatus());
        vo.setUseTypeName(simpleVo.getUseType() == 1 ? "\u901a\u7528\u5238" : "\u5546\u54c1\u5238");
        return vo;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount) {
        return this.getCashticketVo(simpleVo, status, enableCashticketAmount, false);
    }

    private int getCashStatus(CashticketSimpleVo simpleVo, boolean status) {
        if (status) {
            return CashStatusEnum.yijihuo.getValue();
        }
        if (simpleVo.getBatchStatus().intValue() == CashBathStatusEnum.jinyong.getValue()) {
            return CashStatusEnum.jinyong.getValue();
        }
        if (simpleVo.getTicketStatus().intValue() == CashStatusEnum.yishiyong.getValue()) {
            return CashStatusEnum.yishiyong.getValue();
        }
        return CashStatusEnum.guoqi.getValue();
    }

    private BaseJsonVo<Boolean> getCashUseStatus(List<CashticketBatchNewRuleVo> rule_ls, String detail_id, int cash_rule_type, int platFormId) {
        boolean productCash = false;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rule_ls)) {
            List<String> rule_detail_list;
            List templist = rule_ls.stream().filter(d -> Objects.equals(d.getRuleType(), CashRuleTypeEnum.pingtai.getValue())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(templist)) {
                if (templist.size() == 1) {
                    productCash = !Objects.equals(((CashticketBatchNewRuleVo)templist.get(0)).getStats(), CashRuleStatusEnum.unable.getValue());
                    return BaseJsonVo.success((Object)productCash);
                }
                for (CashticketBatchNewRuleVo cashticketBatchNewRuleVo : templist) {
                    if (cashticketBatchNewRuleVo.getStats().intValue() == CashRuleStatusEnum.quanbu.getValue()) continue;
                    if (StringUtils.isEmpty((String)cashticketBatchNewRuleVo.getDetailIds())) {
                        productCash = false;
                        return BaseJsonVo.success((Object)productCash);
                    }
                    rule_detail_list = Arrays.asList(cashticketBatchNewRuleVo.getDetailIds().split(","));
                    if (rule_detail_list.contains(platFormId + "")) continue;
                    productCash = false;
                    return BaseJsonVo.success((Object)productCash);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(templist = rule_ls.stream().filter(d -> Objects.equals(cash_rule_type, d.getRuleType())).collect(Collectors.toList()))) {
                productCash = false;
                this.logger.info("\u4f18\u60e0\u5238\u4f7f\u7528\u89c4\u5219:{}\u4e3a\u7a7a,", (Object)CashRuleTypeEnum.getName(cash_rule_type));
                return BaseJsonVo.success((Object)productCash);
            }
            for (CashticketBatchNewRuleVo rule_vo : templist) {
                List<MallProductCategoryEntity> enableCategoryList;
                ArrayList<MallProductCategoryEntity> resultList;
                List<MallProductCategoryEntity> list;
                if (rule_vo.getStats().intValue() == CashRuleStatusEnum.bufen.getValue()) {
                    productCash = false;
                    if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) continue;
                    rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
                    if (!rule_detail_list.contains(detail_id)) {
                        if (CashRuleTypeEnum.product_class.getValue() != cash_rule_type) {
                            productCash = false;
                            return BaseJsonVo.success((Object)productCash);
                        }
                        list = this.productCategoryInterface.getCategoryList();
                        resultList = new ArrayList<MallProductCategoryEntity>();
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) continue;
                        for (String item : rule_detail_list) {
                            enableCategoryList = this.getCategoryChildrenList(detail_id, resultList, list);
                            for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                                if (!Objects.equals(categoryEntity.getCategoryId(), detail_id)) continue;
                                productCash = true;
                                return BaseJsonVo.success((Object)productCash);
                            }
                        }
                        continue;
                    }
                    productCash = true;
                    return BaseJsonVo.success((Object)productCash);
                }
                if (rule_vo.getStats().intValue() != CashRuleStatusEnum.unable.getValue()) continue;
                productCash = true;
                this.logger.info("\u5224\u65ad\u4f18\u60e0\u52b5\uff1a{}\u4e0d\u53ef\u7528\u5546\u54c1", (Object)rule_vo.getTicketBatchId());
                if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) {
                    this.logger.error("\u5224\u65ad\u4f18\u60e0\u52b5\uff1a{}\u4e0d\u53ef\u7528\u5546\u54c1\u89c4\u5219\u4e3a\u7a7a", (Object)rule_vo.getTicketBatchId());
                    continue;
                }
                rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
                if (!rule_detail_list.contains(detail_id)) {
                    if (CashRuleTypeEnum.product_class.getValue() != cash_rule_type) {
                        this.logger.error("\u5224\u65ad\u4f18\u60e0\u52b5\uff1a{}\u4e0d\u53ef\u7528\u54c1\u7c7b\u89c4\u5219\u4e3a\u7a7a", (Object)rule_vo.getTicketBatchId());
                        continue;
                    }
                    list = this.productCategoryInterface.getCategoryList();
                    resultList = new ArrayList();
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) continue;
                    for (String item : rule_detail_list) {
                        enableCategoryList = this.getCategoryChildrenList(detail_id, resultList, list);
                        for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                            if (!Objects.equals(categoryEntity.getCategoryId(), detail_id)) continue;
                            productCash = false;
                            return BaseJsonVo.success((Object)productCash);
                        }
                    }
                    continue;
                }
                productCash = false;
                return BaseJsonVo.success((Object)productCash);
            }
        } else {
            this.logger.info("\u4f18\u60e0\u5238\u4f7f\u7528\u89c4\u5219\u4e3a\u7a7a,\u4f7f\u7528\u4e0d\u53d7\u9650\u5236");
            productCash = true;
        }
        return BaseJsonVo.success((Object)productCash);
    }

    private boolean getCashUseStatus(List<CashticketBatchNewRuleVo> rule_ls, String detail_id, int cash_rule_type, List<MallProductCategoryEntity> list) {
        List tempList = rule_ls.stream().filter(r -> Objects.equals(r.getRuleType(), cash_rule_type)).collect(Collectors.toList());
        this.logger.info("\u4f18\u60e0\u5238\u4f7f\u7528\u89c4\u5219\u7c7b\u578b:{},\u89c4\u5219:{}", (Object)cash_rule_type, (Object)JsonUtils.toJson(tempList, (boolean)false));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tempList)) {
            return false;
        }
        for (CashticketBatchNewRuleVo cashticketBatchNewRuleVo : tempList) {
            if (StringUtils.isEmpty((String)cashticketBatchNewRuleVo.getDetailIds())) continue;
            List<String> rule_detail_list = Arrays.asList(cashticketBatchNewRuleVo.getDetailIds().split(","));
            ArrayList<MallProductCategoryEntity> resultList = new ArrayList<MallProductCategoryEntity>();
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) continue;
            for (String item : rule_detail_list) {
                if (!StringUtils.isNotEmpty((String)item)) continue;
                List<MallProductCategoryEntity> enableCategoryList = this.getCategoryChildrenList(item, resultList, list);
                for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                    if (!Objects.equals(categoryEntity.getCategoryId(), detail_id)) continue;
                    return cashticketBatchNewRuleVo.getStats().intValue() != CashRuleStatusEnum.unable.getValue();
                }
            }
        }
        return false;
    }

    @Override
    public Integer getCashticketCount(String customerId, Integer enable) {
        return this.cashticketCustomerMapper.getCashticketCount(customerId, enable);
    }

    private List<MallProductCategoryEntity> getMallProductCategoryEntityList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> categoryEntityOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst();
        if (categoryEntityOptional.isPresent()) {
            String tempCategoryId = categoryEntityOptional.get().getParentId();
            Optional<MallProductCategoryEntity> tempCategoryEntityOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), tempCategoryId)).findFirst();
            if (categoryEntityOptional.isPresent()) {
                resultList.add(tempCategoryEntityOptional.get());
                return this.getMallProductCategoryEntityList(tempCategoryEntityOptional.get().getCategoryId(), resultList, list);
            }
        }
        return resultList;
    }

    private List<MallProductCategoryEntity> getCategoryChildrenList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> selfOptional;
        List tempList = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), categoryId)).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tempList)) {
            resultList.addAll(tempList);
            Iterator iterator = tempList.iterator();
            if (iterator.hasNext()) {
                MallProductCategoryEntity categoryEntity = (MallProductCategoryEntity)iterator.next();
                return this.getCategoryChildrenList(categoryEntity.getCategoryId(), resultList, list);
            }
        }
        if ((selfOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst()).isPresent()) {
            resultList.add(selfOptional.get());
        }
        return resultList;
    }
}

