/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.apiinvoke.balance.GiftCardInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketMapper;
import cc.lechun.mall.entity.cashticket.CashticketActivTionVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketService
extends BaseService
implements CashticketInterface {
    @Autowired
    private CashticketMapper cashticketMapper;
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketCustomerService cashticketCustomerService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private GiftCardInvoke giftCardInvoke;

    @Override
    @ReadThroughSingleCache(namespace="getCashticket")
    public CashticketEntity getCashticket(@ParameterValueKeyProvider int ticketId) {
        return (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId));
    }

    @Override
    public CashticketEntity getCashticket4No(String ticketNo) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketNo(ticketNo);
        List ls = this.cashticketMapper.getList(cashticketEntity);
        if (ls != null && ls.size() > 0) {
            if (ls.size() == 1) {
                return (CashticketEntity)ls.get(0);
            }
            Optional<CashticketEntity> cash = ls.stream().filter(cashticket -> Objects.equals(cashticket.getTicketNo(), ticketNo)).findFirst();
            if (cash.isPresent()) {
                return cash.get();
            }
        }
        return null;
    }

    @Override
    public CashticketActivTionVo getWaitActivtionCashticketList(String ticketBatchId) {
        return this.cashticketMapper.getWaitActivtionCashticketList(ticketBatchId);
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(CashStatusEnum.yijihuo.getValue());
            }
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum, CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(cashticketEntity.getActivtionCount() + 1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            }
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                if (this.cashticketMapper.updateStatusByPrimaryKeySelective(cashticketEntity) == 1) {
                    return true;
                }
            } else {
                this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketAmount(int ticketId, BigDecimal amount) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketAmount(amount);
            return this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) == 1;
        }
        return false;
    }

    private void addCashTicketNos(CashticketBatchEntity cashticketBatchEntity, int ticketNoNum) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.weijihuo.getValue());
        cashticketEntity.setActivtionCount(0);
        int k = 0;
        long new_ticketNoNum = MathUtils.mulBigDecimal((Number)ticketNoNum, (Number)3).longValue();
        int i = 0;
        while ((long)i < new_ticketNoNum && k < ticketNoNum) {
            cashticketEntity.setCreateTime(DateUtils.now());
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                cashticketEntity.setTicketNo(this.getTicketNo(cashticketBatchEntity.getTicketPosition()));
            } else {
                cashticketEntity.setTicketNo(this.getTicketNo());
            }
            try {
                int l = this.cashticketMapper.insertSelective(cashticketEntity);
                if (l > 0 && cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                    this.redisService.sadd("ticketNo", cashticketEntity.getTicketNo());
                    ++k;
                }
            }
            catch (Exception e) {
                this.logger.error("\u5151\u6362\u7801\u91cd\u590d \u4e0d\u9700\u8981\u5904\u7406", (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public CashticketEntity addCashTicketNos(CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        cashticketEntity.setActivtionCount(1);
        int k = 0;
        cashticketEntity.setCreateTime(DateUtils.now());
        cashticketEntity.setTicketNo(this.getTicketNo());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        try {
            this.logger.info("\u751f\u6210\u4f18\u60e0\u5238:{}", (Object)cashticketEntity.toString());
            int l = this.cashticketMapper.insertSelective(cashticketEntity);
            if (l > 0) {
                this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u6210\u529f:{}", (Object)cashticketEntity.toString());
                return cashticketEntity;
            }
            if (++k < 10) {
                this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u5f00\u59cb\u91cd\u65b0\u751f\u6210:{}", (Object)cashticketEntity.toString());
                return this.addCashTicketNos(cashticketBatchEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketEntity.toString());
        }
        return null;
    }

    @Override
    public BaseJsonVo convertTicketNo(String customerId, int platformId, String ticketNo) {
        this.logger.info("\u7528\u6237:{},\u5e73\u53f0:{},\u5151\u6362\u7801:{}", new Object[]{customerId, platformId, ticketNo});
        try {
            BaseJsonVo vo = ((CashticketService)AopContext.currentProxy()).convertTicketNoLog(customerId, platformId, ticketNo);
            this.cashticketCustomerService.saveSendLog(customerId, null, "", "", "", vo, 0, ticketNo, 1);
            return vo;
        }
        catch (Exception e) {
            this.cashticketCustomerService.saveSendLog(customerId, null, "", "", "", BaseJsonVo.error((String)e.getMessage()), 0, ticketNo, 1);
            this.logger.error("\u4f18\u60e0\u5238\u5151\u6362\u5931\u8d25,\u7528\u6237:{},\u5e73\u53f0:{},\u5151\u6362\u7801:{}", new Object[]{customerId, platformId, ticketNo, e});
            return BaseJsonVo.error((String)("\u5151\u6362\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    @RedisLock(key="CASH_EXCHANGE", expire=7L, waitTime=60L)
    public BaseJsonVo convertTicketNo4Channel(String customerId, String ticketNo) {
        Integer errTimes = null;
        if (this.redisCacheUtil.exists(ticketNo + customerId) && (errTimes = (Integer)this.redisCacheUtil.get(ticketNo + customerId)) >= 5) {
            this.logger.error("\u5151\u6362\u8d85\u51fa\u9650\u5236\u6b21\u6570\uff1a" + errTimes + ",customerId:" + customerId + ",\u5238\u7801\uff1a" + ticketNo);
            return BaseJsonVo.error((String)"\u60a8\u4eca\u65e5\u5df2\u8f93\u95195\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
        }
        CashticketEntity query = new CashticketEntity();
        query.setTicketNo(ticketNo);
        CashticketEntity cashticketEntity = (CashticketEntity)this.cashticketMapper.getSingle(query);
        if (cashticketEntity == null) {
            errTimes = this.redisCacheUtil.increment(ticketNo + customerId, 1);
            if (errTimes <= 1) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.set(10, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                long dateDiffSecond = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)calendar.getTime());
                this.redisCacheUtil.set(ticketNo + customerId, (Object)errTimes, Long.valueOf(dateDiffSecond));
            }
            if (errTimes >= 5) {
                return BaseJsonVo.error((String)"\u5361\u5bc6\u9519\u8bef\uff0c\u60a8\u4eca\u65e5\u5df2\u8f93\u95195\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
            }
            return BaseJsonVo.error((String)"\u5361\u5bc6\u9519\u8bef");
        }
        if (cashticketEntity.getStatus() != 0) {
            return BaseJsonVo.error((String)"\u8be5\u5238\u5bc6\u5df2\u88ab\u6fc0\u6d3b");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo convertByTicketBatchId(String customerId, int platformId, String ticketBatchId) {
        CashticketActivTionVo cashticketActivTionVo = this.getWaitActivtionCashticketList(ticketBatchId);
        if (cashticketActivTionVo == null) {
            CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
            this.addCashTicketNos(cashticketBatchEntity, 1);
            cashticketActivTionVo = this.getWaitActivtionCashticketList(ticketBatchId);
            if (cashticketActivTionVo == null) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            }
        }
        return this.convertTicketNoLog(customerId, platformId, cashticketActivTionVo.getTicketNo());
    }

    public BaseJsonVo convertTicketNoLog(String customerId, int platformId, String ticketNo) {
        BaseJsonVo<Boolean> giftCardResult;
        ticketNo = ticketNo.trim();
        boolean flag = false;
        String message = "";
        CashticketBatchEntity cashticketBatchEntity = null;
        CashticketEntity cashticketEntity = this.getCashticket4No(ticketNo);
        if (cashticketEntity == null) {
            message = "\u65e0\u6548\u7684\u5151\u6362\u7801";
            CashticketBatchEntity temp = new CashticketBatchEntity();
            temp.setTicketNo(ticketNo);
            cashticketBatchEntity = this.cashticketBatchService.getCashticketBatchByTicketNo(ticketNo);
            if (cashticketBatchEntity == null) {
                return BaseJsonVo.paramError((String)message);
            }
        } else {
            cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketEntity.getTicketBatchId());
        }
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5151\u6362\u7801\u6279\u6b21");
        }
        if (cashticketEntity != null) {
            if (cashticketEntity.getActivtionCount() >= 1) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u5931\u8d25,\u5151\u6362\u7801\u5df2\u5151\u6362");
            }
            if (cashticketEntity.getStatus().intValue() == CashStatusEnum.jinyong.getValue()) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u7801\u5df2\u7981\u7528");
            }
        }
        if (Objects.equals(cashticketBatchEntity.getTicetClass(), 29) && !(giftCardResult = this.giftCardInvoke.checkExchange(ticketNo)).isSuccess()) {
            return BaseJsonVo.error((String)"\u5151\u6362\u5931\u8d25,\u5361\u672a\u9500\u552e,\u8bf7\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d");
        }
        BaseJsonVo vo = this.cashticketCustomerService.sendTicket4Code(customerId, cashticketBatchEntity, 1, cashticketEntity == null ? 0 : cashticketEntity.getTicketId(), platformId, Objects.equals(1, cashticketBatchEntity.getUserVisible()));
        if (vo.isSuccess() && cashticketEntity != null) {
            cashticketEntity.setActivtionTime(DateUtils.now());
            cashticketEntity.setActivtionCount(cashticketEntity.getActivtionCount() + 1);
            cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
            this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity);
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
        }
        return vo;
    }

    private String getTicketNo(int ticketPosition) {
        String randNo = RandomUtils.generateString((int)ticketPosition);
        if (this.redisService.sIsMember("ticketNo", randNo)) {
            return this.getTicketNo(ticketPosition);
        }
        return randNo;
    }

    private String getTicketNo() {
        String randNo = IDGenerate.getUniqueIdStr();
        if (!this.redisService.sadd("ticketNo", randNo)) {
            return this.getTicketNo();
        }
        return randNo;
    }
}

