/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.apiinvoke.ec.AddressInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.customer.CustomerAddressTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.tree.TreeBuilder;
import cc.lechun.ec.entity.DistrictEntity;
import cc.lechun.ec.entity.bo.ProvinceVo;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerAddressMapper;
import cc.lechun.mall.dao.sales.MallGroupProductMapper;
import cc.lechun.mall.dao.shoppingcart.MallShoppingcartMapper;
import cc.lechun.mall.entity.common.MallTreeVo;
import cc.lechun.mall.entity.customer.AreaCityProvinceVo;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.SysAreaVo;
import cc.lechun.mall.entity.customer.SysCityAreaVo;
import cc.lechun.mall.entity.customer.SysProvinceCityAreaVo;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.deliver.MallProvinceEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.deliver.MallProvinceInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerAddressService
extends BaseService
implements CustomerAddressInterface {
    @Autowired
    private CustomerAddressMapper customerAddressMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    MallCityInterface cityService;
    @Autowired
    MallAreaInterface areaService;
    @Autowired
    MallProvinceInterface provinceInterface;
    @Autowired
    MallShoppingcartMapper cartMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupProductMapper groupProductMapper;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    private AddressInvoke addressInvoke;
    @Autowired
    private RedisService redisService;
    private static final String AREA_LIST_CACHE_KEY = "area_list_cache";
    private static final long CACHE_EXPIRATION_TIME = 43200L;
    private static final String REDIS_AREA_KEY_PREFIX = "area_info:";

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="CustomerAddressService.getAddressList", expiration=300)
    public String getAddressList() {
        try {
            ClassPathResource resource = new ClassPathResource("area.json");
            InputStream inputStream = resource.getInputStream();
            String mapping = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            return mapping.replace("\t", "");
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\u4e86:{}", (Throwable)e);
            return "";
        }
    }

    @Override
    public List<CustomerAddressTypeEnum> getAddressType() {
        return CustomerAddressTypeEnum.getList();
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerAddress", expiration=7200)
    public CustomerAddressEntity getCustomerAddress(@ParameterValueKeyProvider String addrId) {
        return (CustomerAddressEntity)this.customerAddressMapper.selectByPrimaryKey((Serializable)((Object)addrId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getValidCustomerAddressList", expiration=7200)
    public List<CustomerAddressEntity> getValidCustomerAddressList(@ParameterValueKeyProvider String customerId) {
        return this.customerAddressMapper.getValidCustomerAddressList(customerId);
    }

    @Override
    @Transactional
    public BaseJsonVo saveCustomerAddress(AddressForm form) {
        BaseJsonVo vo = this.validateAddress(form);
        if (!vo.isSuccess()) {
            return vo;
        }
        CustomerAddressEntity customerAddressEntity = new CustomerAddressEntity();
        customerAddressEntity.setCustomerId(form.getCustomerId());
        customerAddressEntity.setAddress(form.getAddress());
        customerAddressEntity.setConsigneeName(form.getConsigneename());
        customerAddressEntity.setConsigneePhone(form.getConsingeephone());
        MallAreaEntity area = this.areaService.getArea(form.getAreaid());
        customerAddressEntity.setAreaId(form.getAreaid());
        customerAddressEntity.setAreaName(area.getAreaName());
        customerAddressEntity.setCityId(area.getCityId());
        MallCityEntity city = this.cityService.getCity(area.getCityId());
        customerAddressEntity.setCityName(city.getCityName());
        customerAddressEntity.setProvinceId(city.getProvinceId());
        MallProvinceEntity provinceEntity = this.provinceInterface.getProvince(city.getProvinceId());
        customerAddressEntity.setProvinceName(provinceEntity.getProvinceName());
        customerAddressEntity.setAddressType(form.getAddresstype());
        CustomerAddressEntity rt = (CustomerAddressEntity)this.customerAddressMapper.getSingle(customerAddressEntity);
        customerAddressEntity.setLastTime(DateUtils.now());
        if (form.getIsdefault() != null && Objects.equals(form.getIsdefault(), 1)) {
            this.logger.info("\u7528\u6237:{}\u4fee\u6539\u4e86\u9ed8\u8ba4\u5730\u5740", (Object)form.getCustomerId());
            this.customerAddressMapper.updateCustomerDefaultAddress(form.getCustomerId());
        }
        if (form.getIsDelete() == 1) {
            customerAddressEntity.setIsDelete((short)1);
        }
        if (rt != null) {
            customerAddressEntity.setAddrId(rt.getAddrId());
            customerAddressEntity.setIsdefault(form.getIsdefault());
            this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        } else {
            customerAddressEntity.setAddrId(RandomUtils.generateStrId());
            customerAddressEntity.setCreateTime(DateUtils.now());
            customerAddressEntity.setConsigneeTel("");
            customerAddressEntity.setIsdefault(form.getIsdefault());
            this.customerAddressMapper.insertSelective(customerAddressEntity);
        }
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo updateCustomerAddress(AddressForm form) {
        BaseJsonVo vo = this.validateAddress(form);
        if (!vo.isSuccess()) {
            return vo;
        }
        if (form.getIsdefault() != null && Objects.equals(form.getIsdefault().intValue(), 1)) {
            this.logger.info("\u7528\u6237:{}\u4fee\u6539\u4e86\u9ed8\u8ba4\u5730\u5740", (Object)form.getCustomerId());
            this.customerAddressMapper.updateCustomerDefaultAddress(form.getCustomerId());
        }
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(form.getAddrId());
        customerAddressEntity.setAreaId(form.getAreaid());
        MallAreaEntity area = this.areaService.getArea(form.getAreaid());
        customerAddressEntity.setAreaId(form.getAreaid());
        customerAddressEntity.setAreaName(area.getAreaName());
        customerAddressEntity.setCityId(area.getCityId());
        MallCityEntity city = this.cityService.getCity(area.getCityId());
        customerAddressEntity.setCityName(city.getCityName());
        customerAddressEntity.setProvinceId(city.getProvinceId());
        MallProvinceEntity provinceEntity = this.provinceInterface.getProvince(city.getProvinceId());
        customerAddressEntity.setProvinceName(provinceEntity.getProvinceName());
        customerAddressEntity.setAddress(form.getAddress());
        customerAddressEntity.setConsigneeName(form.getConsigneename());
        customerAddressEntity.setConsigneePhone(form.getConsingeephone());
        customerAddressEntity.setAddressType(form.getAddresstype());
        customerAddressEntity.setIsdefault(form.getIsdefault());
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    @Override
    public CustomerAddressEntity updateAddressLastTime(String addrId) {
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(addrId);
        customerAddressEntity.setLastTime(DateUtils.now());
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return customerAddressEntity;
    }

    @Override
    public BaseJsonVo updateAddressLastTime(String addrId, String customerId) {
        this.logger.info("\u7528\u6237:{},\u9009\u62e9\u4e86\u5730\u5740:{}", (Object)customerId, (Object)addrId);
        this.redisCacheUtil.set(customerId + ":selectAdress", (Object)addrId, Long.valueOf(1800L));
        return BaseJsonVo.success((Object)"\u9009\u62e9\u5730\u5740\u5b58\u50a8\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo updateCustomerAddress(String addrId) {
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(addrId);
        customerAddressEntity.setIsDelete((short)1);
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    private BaseJsonVo validateAddress(AddressForm form) {
        if (StringUtils.isEmpty((String)form.getConsingeephone())) {
            return BaseJsonVo.paramError((String)"\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getConsigneename())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getAddress())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (form.getAddresstype() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5730\u5740\u7c7b\u578b");
        }
        if (form.getAreaid() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u57ce\u5e02");
        }
        return BaseJsonVo.success(null);
    }

    private void removeCache(String customerId, String addrId) {
        this.memcachedService.delete("getCustomerAddress", addrId);
        this.memcachedService.delete("getValidCustomerAddressList", customerId);
    }

    @Override
    public List<CustomerAddressVo> getValidCustomerAddressList(String customerId, String addressId, int transportType, Integer orderSource) {
        List<CustomerAddressEntity> addressList = this.getValidCustomerAddressList(customerId);
        if (StringUtils.isNotEmpty((String)addressId)) {
            addressList = addressList.stream().filter(c -> c.getAddrId().equals(addressId)).collect(Collectors.toList());
        }
        ArrayList<CustomerAddressVo> customerAddressVos = new ArrayList<CustomerAddressVo>();
        for (CustomerAddressEntity e : addressList) {
            CustomerAddressVo customerAddressVo = new CustomerAddressVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)e, (Object)customerAddressVo);
                customerAddressVo.setSpeedUp("0");
            }
            catch (Exception e1) {
                this.logger.error("\u83b7\u53d6\u5730\u5740\u5217\u8868\u65f6\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e1);
            }
            List<MallAreaEntity> mallAreaEntityList = this.getAreaErp(null, String.valueOf(e.getAreaId()), null);
            if (mallAreaEntityList != null && mallAreaEntityList.size() > 0) {
                for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                    int status = mallAreaEntity.getStatus();
                    int nomalStatus = mallAreaEntity.getOrdinaryStatus();
                    customerAddressVo.setEnable(true);
                    if (transportType == 1) {
                        if (status == 1) {
                            customerAddressVo.setEnable(true);
                        } else {
                            customerAddressVo.setEnable(false);
                        }
                    }
                    if (transportType == 2) {
                        if (nomalStatus == 1) {
                            customerAddressVo.setEnable(true);
                        } else {
                            customerAddressVo.setEnable(false);
                        }
                    }
                    if (orderSource == null || OrderSourceEnum.COMMUNITY_GROUP.getValue() != orderSource.intValue()) continue;
                    customerAddressVo.setEnable(true);
                }
            } else {
                customerAddressVo.setEnable(false);
            }
            customerAddressVos.add(customerAddressVo);
        }
        return customerAddressVos;
    }

    @Override
    public List<CustomerAddressVo> getValidCustomerAddressList2(String customerId) {
        List<CustomerAddressEntity> addressList = this.getValidCustomerAddressList(customerId);
        ArrayList<CustomerAddressVo> customerAddressVos = new ArrayList<CustomerAddressVo>();
        ArrayList<String> areaList = new ArrayList<String>();
        List<MallAreaEntity> mallAreaEntityList = this.getAreaErp(areaList);
        for (CustomerAddressEntity e : addressList) {
            CustomerAddressVo customerAddressVo = new CustomerAddressVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)e, (Object)customerAddressVo);
                customerAddressVo.setSpeedUp("0");
            }
            catch (Exception e1) {
                this.logger.error("\u83b7\u53d6\u5730\u5740\u5217\u8868\u65f6\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e1);
            }
            List tempList = mallAreaEntityList.stream().filter(areaEntity -> areaEntity.getAreaId().equals(e.getAreaId())).collect(Collectors.toList());
            if (tempList != null && tempList.size() > 0) {
                for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                    int status = mallAreaEntity.getStatus();
                    int nomalStatus = mallAreaEntity.getOrdinaryStatus();
                    customerAddressVo.setEnable(true);
                }
            } else {
                customerAddressVo.setEnable(false);
            }
            customerAddressVos.add(customerAddressVo);
        }
        return customerAddressVos;
    }

    private List<MallAreaEntity> getAreaErp(String cityId, String areaId, String areaName) {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("cityId", cityId);
        mapParam.put("areaId", areaId);
        mapParam.put("areaName", areaName);
        this.logger.info("\u8c03\u7528ERP3.0\u83b7\u53d6areaList, \u53c2\u6570: {}", (Object)JSON.toJSONString(mapParam));
        try {
            BaseJsonVo<List<DistrictEntity>> baseJsonVo = this.addressInvoke.getAreaList(mapParam);
            this.logger.info("ERP3.0 \u8fd4\u56de\u7684\u53c2\u6570: {}", (Object)JSON.toJSONString(baseJsonVo));
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(baseJsonVo));
            if (jsonObject.getInteger("status") != 200 || !jsonObject.getBoolean("success").booleanValue()) {
                return this.getAreaListFromCache();
            }
            JSONArray jsonArray = jsonObject.getJSONArray("result");
            if (jsonArray == null || jsonArray.isEmpty()) {
                return Collections.emptyList();
            }
            List<MallAreaEntity> areaList = jsonArray.stream().map(obj -> this.convertToMallAreaEntity((JSONObject)obj)).collect(Collectors.toList());
            this.cacheAreaList(areaList);
            return areaList;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528ERP3.0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage(), (Object)e);
            return this.getAreaListFromCache();
        }
    }

    private MallAreaEntity convertToMallAreaEntity(JSONObject jsonObject) {
        MallAreaEntity mallAreaEntity = new MallAreaEntity();
        mallAreaEntity.setAreaId(jsonObject.getInteger("code"));
        mallAreaEntity.setAreaName(jsonObject.getString("name"));
        mallAreaEntity.setCityId(jsonObject.getInteger("parentcode"));
        mallAreaEntity.setStatus(jsonObject.getInteger("coldstatus"));
        mallAreaEntity.setOrdinaryStatus(jsonObject.getInteger("nomalstatus"));
        return mallAreaEntity;
    }

    private List<MallAreaEntity> getAreaListFromCache() {
        String cachedData;
        Object data = this.redisCacheUtil.get(AREA_LIST_CACHE_KEY);
        if (data != null && StringUtils.isNotEmpty((String)(cachedData = data.toString()))) {
            return JSON.parseArray((String)cachedData, MallAreaEntity.class);
        }
        return null;
    }

    private void cacheAreaList(List<MallAreaEntity> areaList) {
        if (!this.redisCacheUtil.exists(AREA_LIST_CACHE_KEY)) {
            this.redisCacheUtil.set(AREA_LIST_CACHE_KEY, (Object)JSON.toJSONString(areaList), Long.valueOf(43200L));
            this.logger.info("\u533a\u57df\u5217\u8868\u7f13\u5b58\u5df2\u66f4\u65b0");
        }
    }

    private List<MallAreaEntity> getAreaErp(List<String> areaIdList) {
        if (CollectionUtils.isEmpty(areaIdList)) {
            this.logger.warn("getAreaErp: \u4f20\u5165\u7684 areaIdList \u4e3a\u7a7a");
            return Collections.emptyList();
        }
        String[] areaIdArr = areaIdList.toArray(new String[0]);
        ArrayList<DistrictEntity> districtList = new ArrayList();
        try {
            BaseJsonVo baseJsonVo = this.addressInvoke.getAreaListByAreaIds(areaIdArr);
            if (baseJsonVo != null && baseJsonVo.isSuccess()) {
                districtList = Optional.ofNullable(baseJsonVo.getValue()).orElse(Collections.emptyList());
                this.cacheDistrictData(areaIdList, districtList);
            } else {
                this.logger.warn("getAreaErp: \u8fdc\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f={}", (Object)(baseJsonVo != null ? baseJsonVo.getError_msg() : "\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a"));
                districtList = this.getDistrictFromCache(areaIdList);
            }
        }
        catch (Exception e) {
            this.logger.error("getAreaErp: \u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u5c1d\u8bd5\u4ece Redis \u83b7\u53d6\u6570\u636e", (Throwable)e);
            districtList = this.getDistrictFromCache(areaIdList);
        }
        return districtList.stream().map(this::convertToMallAreaEntity).collect(Collectors.toList());
    }

    private MallAreaEntity convertToMallAreaEntity(DistrictEntity districtEntity) {
        MallAreaEntity mallAreaEntity = new MallAreaEntity();
        mallAreaEntity.setAreaId(Integer.parseInt(districtEntity.getCode()));
        mallAreaEntity.setAreaName(districtEntity.getName());
        mallAreaEntity.setCityId(Integer.parseInt(districtEntity.getParentcode()));
        mallAreaEntity.setStatus(districtEntity.getColdstatus());
        mallAreaEntity.setOrdinaryStatus(districtEntity.getNomalstatus());
        return mallAreaEntity;
    }

    private void cacheDistrictData(List<String> areaIdList, List<DistrictEntity> districtList) {
        for (DistrictEntity district : districtList) {
            String key = REDIS_AREA_KEY_PREFIX + district.getCode();
            this.redisCacheUtil.set(key, (Object)JSON.toJSONString((Object)district), Long.valueOf(43200L));
        }
    }

    private List<DistrictEntity> getDistrictFromCache(List<String> areaIdList) {
        ArrayList<DistrictEntity> districtList = new ArrayList<DistrictEntity>();
        for (String areaId : areaIdList) {
            String districtJson;
            String key = REDIS_AREA_KEY_PREFIX + areaId;
            Object data = this.redisCacheUtil.get(key);
            if (data == null || !StringUtils.isNotEmpty((String)(districtJson = data.toString()))) continue;
            districtList.add((DistrictEntity)JSON.parseObject((String)districtJson, DistrictEntity.class));
        }
        return districtList;
    }

    @Override
    public CustomerAddressVo getCustomerDefaultAddress(String customerId, String areaId, String address, String requestIp, int[] transportTypeArry) throws Exception {
        String addressId;
        List<CustomerAddressEntity> addrs;
        if (transportTypeArry == null) {
            transportTypeArry = new int[]{-1, -1};
            List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCart(customerId, "0");
            boolean hasCold = cartEntityList.stream().anyMatch(cartPro -> cartPro.getTransportType() == 1);
            boolean hasNomal = cartEntityList.stream().anyMatch(cartPro -> cartPro.getTransportType() == 2);
            if (hasCold) {
                transportTypeArry[0] = TransportTypeEnum.COLD_CHAIN.getValue();
            }
            if (hasNomal) {
                transportTypeArry[1] = TransportTypeEnum.NORMAL_CHAIN.getValue();
            }
        }
        if ((addrs = this.getValidCustomerAddressList(customerId)) == null || addrs.size() == 0) {
            CustomerAddressEntity entity = new CustomerAddressEntity();
            entity.setAreaId(110100);
            entity.setCityId(110000);
            entity.setAddress("\u5317\u4eac");
            return this.buildAddressVO(entity, transportTypeArry);
        }
        CustomerAddressEntity addressVo = null;
        Object object = this.redisCacheUtil.get(customerId + ":selectAdress");
        String string = addressId = object != null ? object.toString() : "";
        if (StringUtils.isNotEmpty((String)addressId)) {
            this.logger.info("\u7528\u6237:{} \u53d6\u9009\u4e2d\u5730\u5740:{}", (Object)customerId, (Object)addressId);
            addressVo = (CustomerAddressEntity)this.customerAddressMapper.selectByPrimaryKey((Serializable)((Object)addressId));
            return this.buildAddressVO(addressVo, transportTypeArry);
        }
        List tempList = addrs.stream().filter(a -> Objects.equals(a.getIsdefault(), new Short("1"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tempList)) {
            return this.buildAddressVO((CustomerAddressEntity)tempList.get(0), transportTypeArry);
        }
        return this.buildAddressVO(addrs.get(0), transportTypeArry);
    }

    @Override
    public CustomerAddressVo getCustomerDefaultAddress(String customerId, int[] transportType) throws Exception {
        List<CustomerAddressEntity> addrs = this.getValidCustomerAddressList(customerId);
        if (addrs == null || addrs.size() == 0) {
            CustomerAddressEntity entity = new CustomerAddressEntity();
            entity.setAreaId(110100);
            entity.setCityId(110000);
            entity.setAddress("\u5317\u4eac");
            return this.buildAddressVO(entity, transportType);
        }
        return this.buildAddressVO(addrs.get(0), transportType);
    }

    @Override
    public CustomerAddressVo getCustomerAddressVO(String addressId, int[] transportType) throws Exception {
        return this.buildAddressVO(this.getCustomerAddress(addressId), transportType);
    }

    @Override
    public CustomerAddressVo buildAddressVO(CustomerAddressEntity entity, int[] transportTypeArry) throws Exception {
        CustomerAddressVo addressVo = new CustomerAddressVo();
        ObjectConvert.fatherConvertToChild((Object)entity, (Object)addressVo);
        addressVo.setEnable(true);
        addressVo.setSpeedUp("0");
        try {
            List<MallAreaEntity> mallAreaEntityList = this.getAreaErp(null, String.valueOf(addressVo.getAreaId()), null);
            if (mallAreaEntityList != null && mallAreaEntityList.size() > 0) {
                for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                    int status = mallAreaEntity.getStatus();
                    int ordinaryStatus = mallAreaEntity.getOrdinaryStatus();
                    if (transportTypeArry == null) continue;
                    for (int i = 0; i < transportTypeArry.length; ++i) {
                        int transportTypeArryValue = transportTypeArry[i];
                        this.logger.info("======getCustomerDefaultAddress.transportTypeArryValue======transportTypeArryValue={}", (Object)transportTypeArryValue);
                        if (transportTypeArryValue == 1) {
                            if (status == 1) {
                                addressVo.setEnable(true);
                            } else {
                                addressVo.setEnable(false);
                            }
                        }
                        if (transportTypeArryValue != 2) continue;
                        if (ordinaryStatus == 1) {
                            addressVo.setEnable(true);
                            continue;
                        }
                        addressVo.setEnable(false);
                    }
                }
            } else {
                addressVo.setEnable(false);
            }
            return addressVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return addressVo;
        }
    }

    @Override
    public List<SysProvinceCityAreaVo> getProvinceCityArea(int transportType, int platformGroupId) {
        List<AreaCityProvinceVo> ls = this.customerAddressMapper.getAllAreaCityProvince(transportType);
        ArrayList<SysProvinceCityAreaVo> rs = new ArrayList<SysProvinceCityAreaVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getProvinceId())).entrySet().forEach(integerListEntry -> {
            if (integerListEntry.getValue() != null && ((List)integerListEntry.getValue()).size() > 0) {
                SysProvinceCityAreaVo sysProvinceCityAreaVo = new SysProvinceCityAreaVo();
                sysProvinceCityAreaVo.setProvinceId(((AreaCityProvinceVo)((List)integerListEntry.getValue()).get(0)).getProvinceId());
                sysProvinceCityAreaVo.setProvinceName(((AreaCityProvinceVo)((List)integerListEntry.getValue()).get(0)).getProvinceName());
                ArrayList<SysCityAreaVo> cityVoList = new ArrayList<SysCityAreaVo>();
                ((List)integerListEntry.getValue()).stream().collect(Collectors.groupingBy(o1 -> o1.getCityId())).entrySet().forEach(integerListEntry1 -> {
                    if (integerListEntry1.getValue() != null && ((List)integerListEntry1.getValue()).size() > 0) {
                        SysCityAreaVo sysCityAreaVo = new SysCityAreaVo();
                        sysCityAreaVo.setCityId(((AreaCityProvinceVo)((List)integerListEntry1.getValue()).get(0)).getCityId());
                        sysCityAreaVo.setCityName(((AreaCityProvinceVo)((List)integerListEntry1.getValue()).get(0)).getCityName());
                        ArrayList<SysAreaVo> areaVoList = new ArrayList<SysAreaVo>();
                        ((List)integerListEntry1.getValue()).stream().collect(Collectors.groupingBy(o2 -> o2.getAreaId())).entrySet().forEach(integerListEntry2 -> {
                            if (integerListEntry2.getValue() != null && ((List)integerListEntry2.getValue()).size() > 0) {
                                SysAreaVo sysAreaVo = new SysAreaVo();
                                sysAreaVo.setAreaId(((AreaCityProvinceVo)((List)integerListEntry2.getValue()).get(0)).getAreaId());
                                sysAreaVo.setAreaName(((AreaCityProvinceVo)((List)integerListEntry2.getValue()).get(0)).getAreaName());
                                areaVoList.add(sysAreaVo);
                            }
                        });
                        areaVoList.sort((o1, o2) -> o1.getAreaId() - o2.getAreaId());
                        sysCityAreaVo.setAreaVoList(areaVoList);
                        cityVoList.add(sysCityAreaVo);
                    }
                });
                cityVoList.sort((o1, o2) -> o1.getCityId() - o2.getCityId());
                sysProvinceCityAreaVo.setCityVoList(cityVoList);
                rs.add(sysProvinceCityAreaVo);
            }
        });
        rs.sort((o1, o2) -> o1.getProvinceId() - o2.getProvinceId());
        return rs;
    }

    public List<MallTreeVo> getProvinceCity(int platformGroupId, int transportType) {
        List<SysProvinceCityAreaVo> provinceVos = this.getProvinceCityErpThr(-1, 0, null);
        ArrayList<MallTreeVo> treeVos = new ArrayList<MallTreeVo>();
        if (provinceVos != null && provinceVos.size() > 0) {
            for (SysProvinceCityAreaVo p : provinceVos) {
                MallTreeVo treeVo = new MallTreeVo();
                treeVo.setId(String.valueOf(p.getProvinceId()));
                treeVo.setName(p.getProvinceName());
                treeVo.setpId("");
                treeVo.setRemark("");
                treeVo.setLeaf(0);
                treeVos.add(treeVo);
                for (SysCityAreaVo c : p.getCityVoList()) {
                    treeVo = new MallTreeVo();
                    treeVo.setId(String.valueOf(c.getCityId()));
                    treeVo.setName(c.getCityName());
                    treeVo.setpId(String.valueOf(p.getProvinceId()));
                    treeVo.setRemark("");
                    treeVo.setLeaf(1);
                    treeVos.add(treeVo);
                }
            }
        }
        return TreeBuilder.builder(treeVos);
    }

    @Override
    public String getCityNamesByIds(String cityIds) {
        List<MallCityEntity> cityEntities = this.customerAddressMapper.getCityNamesByIds(cityIds.split(","));
        if (cityEntities != null && cityEntities.size() > 0) {
            return org.apache.commons.lang3.StringUtils.join((Object[])cityEntities.stream().map(c -> c.getCityName()).toArray(), (String)",");
        }
        return "";
    }

    @Override
    public Map getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy, Integer orderSource) {
        List<SysProvinceCityAreaVo> sysProvinceCityAreaVoList = this.getProvinceCityErpThr(transportType, isLongPeriodBuy, orderSource);
        HashMap<String, List<SysProvinceCityAreaVo>> map = new HashMap<String, List<SysProvinceCityAreaVo>>();
        map.put("provinceVoList", sysProvinceCityAreaVoList);
        return map;
    }

    @Override
    public List<SysProvinceCityAreaVo> getProvinceCityErpThr(Integer transportType, Integer isLongPeriodBuy, Integer orderSource) {
        int nomalStatus = 0;
        int coldStatus = 0;
        int freshStatus = 0;
        if (isLongPeriodBuy == 1) {
            coldStatus = 1;
        } else {
            switch (transportType) {
                case 1: 
                case 3: {
                    coldStatus = 1;
                    freshStatus = 1;
                    break;
                }
                case 2: {
                    nomalStatus = 1;
                    break;
                }
                case -1: {
                    nomalStatus = 1;
                    coldStatus = 1;
                    freshStatus = 1;
                }
            }
        }
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("nomalStatus", nomalStatus);
        mapParam.put("coldStatus", coldStatus);
        mapParam.put("freshStatus", freshStatus);
        String cacheKey = this.buildCacheKey(mapParam);
        List<Object> sysProvinceCityAreaVoList = new ArrayList();
        try {
            BaseJsonVo<List<ProvinceVo>> baseJsonVo = this.addressInvoke.getProvinceAreaList(mapParam);
            String result = JsonUtils.toJson(baseJsonVo, (boolean)false);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.getIntValue("status") == 200 && jsonObject.getBoolean("success").booleanValue()) {
                sysProvinceCityAreaVoList = JSON.parseArray((String)jsonObject.getJSONArray("result").toJSONString(), SysProvinceCityAreaVo.class);
                this.redisCacheUtil.set(cacheKey, (Object)JSON.toJSONString(sysProvinceCityAreaVoList), Long.valueOf(86400L));
            } else {
                sysProvinceCityAreaVoList = this.getCachedData(cacheKey);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u5c1d\u8bd5\u4ece Redis \u83b7\u53d6\u6570\u636e", (Throwable)e);
            sysProvinceCityAreaVoList = this.getCachedData(cacheKey);
        }
        if (orderSource != null && orderSource.equals(OrderSourceEnum.COMMUNITY_GROUP.getValue())) {
            sysProvinceCityAreaVoList.add(this.getShanghaiGroupData());
        }
        sysProvinceCityAreaVoList.sort(Comparator.comparingInt(SysProvinceCityAreaVo::getProvinceId));
        return sysProvinceCityAreaVoList;
    }

    private List<SysProvinceCityAreaVo> getCachedData(String cacheKey) {
        String cachedData;
        Object data = this.redisCacheUtil.get(cacheKey);
        if (data != null && StringUtils.isNotEmpty((String)(cachedData = data.toString()))) {
            return JSON.parseArray((String)cachedData, SysProvinceCityAreaVo.class);
        }
        return new ArrayList<SysProvinceCityAreaVo>();
    }

    private String buildCacheKey(Map<String, Object> params) {
        return "province_city_area:" + params.hashCode();
    }

    private SysProvinceCityAreaVo getShanghaiGroupData() {
        SysProvinceCityAreaVo shanghai = new SysProvinceCityAreaVo();
        shanghai.setProvinceId(310000);
        shanghai.setProvinceName("\u4e0a\u6d77");
        SysCityAreaVo city = new SysCityAreaVo();
        city.setCityId(310100);
        city.setCityName("\u4e0a\u6d77\u5e02");
        List<SysAreaVo> areaList = Arrays.asList(new SysAreaVo(310101, "\u9ec4\u6d66\u533a"), new SysAreaVo(310104, "\u5f90\u6c47\u533a"), new SysAreaVo(310105, "\u957f\u5b81\u533a"), new SysAreaVo(310106, "\u9759\u5b89\u533a"), new SysAreaVo(310107, "\u666e\u9640\u533a"), new SysAreaVo(310108, "\u95f8\u5317\u533a"), new SysAreaVo(310109, "\u8679\u53e3\u533a"), new SysAreaVo(310110, "\u6768\u6d66\u533a"), new SysAreaVo(310112, "\u95f5\u884c\u533a"), new SysAreaVo(310113, "\u5b9d\u5c71\u533a"), new SysAreaVo(310114, "\u5609\u5b9a\u533a"), new SysAreaVo(310115, "\u6d66\u4e1c\u65b0\u533a"), new SysAreaVo(310116, "\u91d1\u5c71\u533a"), new SysAreaVo(310117, "\u677e\u6c5f\u533a"), new SysAreaVo(310118, "\u9752\u6d66\u533a"), new SysAreaVo(310120, "\u5949\u8d24\u533a"), new SysAreaVo(310230, "\u5d07\u660e\u53bf"));
        city.setAreaVoList(areaList);
        shanghai.setCityVoList(Collections.singletonList(city));
        return shanghai;
    }

    @Override
    public BaseJsonVo getAreaIsOpen(Integer areaId) {
        BaseJsonVo baseJsonVo = this.areaService.getAreaIsOpen(areaId);
        return baseJsonVo;
    }
}

