/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerInfoDetailMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerInfoDetailEntity;
import cc.lechun.mall.iservice.customer.CustomerInfoDetailInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerInfoDetailService
extends BaseService
implements CustomerInfoDetailInterface {
    @Autowired
    private CustomerInfoDetailMapper customerInfoDetailMapper;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallVipInterface vipService;

    @Override
    @ReadThroughSingleCache(namespace="getCustomerInfoDetail", expiration=7200)
    public CustomerInfoDetailEntity getCustomerInfoDetail(@ParameterValueKeyProvider String customerId) {
        return (CustomerInfoDetailEntity)this.customerInfoDetailMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    @Override
    @InvalidateSingleCache(namespace="getCustomerInfoDetail")
    public CustomerInfoDetailEntity updateCustomerInfoDetail(@ParameterValueKeyProvider String customerId, CustomerInfoDetailEntity customerInfoDetailEntity) {
        customerInfoDetailEntity.setCustomerId(customerId);
        CustomerInfoDetailEntity customerInfoDetailEntity1 = (CustomerInfoDetailEntity)this.customerInfoDetailMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (customerInfoDetailEntity1 == null) {
            this.customerInfoDetailMapper.insertSelective(customerInfoDetailEntity);
        } else {
            this.customerInfoDetailMapper.updateByPrimaryKeySelective(customerInfoDetailEntity);
        }
        try {
            CustomerEntity customer = this.customerInterface.getCustomer(customerId);
            if (StringUtils.isNotEmpty((String)customerInfoDetailEntity.getCustomerBirthday()) && StringUtils.isNotEmpty((String)customer.getNickName()) && StringUtils.isNotEmpty((String)customer.getHeadImageUrl())) {
                BaseJsonVo result = this.vipService.finishTaskImproveInfo(customerId);
                this.logger.error("\u4f1a\u5458\u7528\u6237:{}\u5b8c\u6210\u4efb\u52a1:{}", (Object)customerId, (Object)result.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u660e\u7ec6\u51fa\u9519:{},{}", new Object[]{customerId, customerInfoDetailEntity.toString(), e});
        }
        return customerInfoDetailEntity;
    }
}

