/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.customer.MobileValidateTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerMobileMapper;
import cc.lechun.mall.entity.customer.CustomerMobileEntity;
import cc.lechun.mall.entity.customer.SmsHistoryEntity;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerMobileService
extends BaseService
implements CustomerMobileInterface {
    @Autowired
    private CustomerMobileMapper customerMobileMapper;
    @Autowired
    private RedisService redisService;
    public static int bindMobileReward = 200;
    public static final int code_exp = 600;

    @Override
    public void sendValidateCode(String validateCodeType, String mobile, String customerId) {
        String validateCode = RandomUtils.generateNumString((int)4);
        String msg = "\u9a8c\u8bc1\u7801: " + validateCode;
        if (this.redisService.save(validateCodeType + "_" + mobile, validateCode, 600L)) {
            String sendStatus = this.sendSmsSaveLog(mobile, msg);
            CustomerMobileEntity customerMobileEntity = new CustomerMobileEntity();
            customerMobileEntity.setCustomerId(customerId);
            customerMobileEntity.setMobile(mobile);
            customerMobileEntity.setReward(validateCodeType.equals(MobileValidateTypeEnum.bindMobile.name()) ? bindMobileReward : 0);
            customerMobileEntity.setVersionDetailId("");
            customerMobileEntity.setBindCode(validateCode);
            customerMobileEntity.setCreateTime(DateUtils.now());
            customerMobileEntity.setSendStatus(sendStatus);
            customerMobileEntity.setType(validateCodeType);
            this.customerMobileMapper.insertSelective(customerMobileEntity);
        }
    }

    @Override
    @Transactional
    public String sendSmsSaveLog(String mobile, String msg) {
        String msg_id = RandomUtils.generateId() + "";
        String result = SmsUtil.sendSms((String)mobile, (String)msg, (String)msg_id);
        this.logger.info("\u624b\u673a\u53f7:{}\u9a8c\u8bc1\u7801\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)mobile, (Object)result);
        int commit_success = 0;
        if (result != null && !"".equals(result) && result.length() > 10) {
            commit_success = 1;
        }
        int send_status = 0;
        send_status = commit_success == 1 ? 2 : -1;
        SmsHistoryEntity smsHistoryEntity = new SmsHistoryEntity();
        smsHistoryEntity.setVid("10000");
        smsHistoryEntity.setUid(RandomUtils.generateId() + "");
        smsHistoryEntity.setMsisdn(mobile);
        smsHistoryEntity.setMsg(msg);
        smsHistoryEntity.setCreateTime(DateUtils.now());
        smsHistoryEntity.setMsgStatus(send_status);
        smsHistoryEntity.setStatusDesc(commit_success + "");
        smsHistoryEntity.setLastTime(DateUtils.now());
        smsHistoryEntity.setMsgId(msg_id);
        smsHistoryEntity.setSmsId(msg_id);
        smsHistoryEntity.setFlagStr("bindcode_" + mobile + "_" + msg + "_" + DateUtils.date());
        smsHistoryEntity.setTempleteId("");
        this.customerMobileMapper.saveSmsHistory(smsHistoryEntity);
        return commit_success + "";
    }

    @Override
    public boolean validateCode(String validateCodeType, String mobile, String validateCode) {
        String key = validateCodeType + "_" + mobile;
        try {
            Object code = this.redisService.get(key);
            if (code != null) {
                return Objects.equals(validateCode.trim(), code.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u9a8c\u8bc1\u7801\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean validateCode(String validateCodeType, String mobile, String validateCode, String customerId) {
        boolean result = this.validateCode(validateCodeType, mobile, validateCode);
        if (!result) {
            CustomerMobileEntity customerMobileEntity = new CustomerMobileEntity();
            customerMobileEntity.setCustomerId(customerId);
            customerMobileEntity.setMobile(mobile);
            customerMobileEntity.setReward(validateCodeType.equals(MobileValidateTypeEnum.bindMobile.name()) ? bindMobileReward : 0);
            customerMobileEntity.setSendStatus("1");
            customerMobileEntity.setType(validateCodeType);
            CustomerMobileEntity temp = this.customerMobileMapper.getCode(customerMobileEntity);
            if (temp != null) {
                if (DateUtils.getAddDateBySecond((Date)temp.getCreateTime(), (int)600).after(DateUtils.now())) {
                    result = Objects.equals(temp.getBindCode(), validateCode);
                    this.logger.error("\u624b\u673a\u53f7:{},\u9a8c\u8bc1\u7801:{} {}\u5339\u914d", new Object[]{mobile, validateCode, result});
                } else {
                    this.logger.error("\u624b\u673a\u53f7:{},\u9a8c\u8bc1\u7801:{}\u5df2\u8fc7\u671f", (Object)mobile, (Object)validateCode);
                }
            } else {
                this.logger.error("\u624b\u673a\u53f7:{},\u9a8c\u8bc1\u7801:{}\u4e0d\u5339\u914d", (Object)mobile, (Object)validateCode);
            }
        }
        return result;
    }

    @Override
    public List<CustomerMobileEntity> findMobile(String mobile) {
        CustomerMobileEntity customerMobileEntity = new CustomerMobileEntity();
        customerMobileEntity.setMobile(mobile);
        return this.customerMobileMapper.getList(customerMobileEntity);
    }
}

