/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerOpenidMapper;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.weixin.SubscribeSceneEnum;
import cc.lechun.mall.iservice.customer.CustomerOpenidInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.User;

@Service
public class CustomerOpenidService
extends BaseService<CustomerOpenidEntity, String>
implements CustomerOpenidInterface {
    @Resource
    private CustomerOpenidMapper customerOpenidMapper;
    @Autowired
    private WeiXinBaseService weiWinBaseService;

    @Override
    @Async
    public void saveCustomerSource() {
        boolean flag = true;
        int i = 0;
        while (flag) {
            ++i;
            CustomerOpenidEntity customerOpenidEntity = new CustomerOpenidEntity();
            customerOpenidEntity.setPlatformId(1);
            customerOpenidEntity.setSubscribe(1);
            customerOpenidEntity.setCustomerSource(0);
            customerOpenidEntity.setVersionDetailId("");
            PageInfo pageInfo = this.getPageList(i, 20, customerOpenidEntity);
            List list = pageInfo.getList();
            if (list == null || list.size() == 0) {
                flag = false;
                this.logger.info("\u7528\u6237\u5173\u6ce8\u6765\u6e90\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6bd5....");
                continue;
            }
            for (CustomerOpenidEntity item : list) {
                String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(item.getPlatformId());
                User user = UserAPI.userInfo((String)accessToken, (String)item.getOpenId());
                CustomerOpenidEntity update = new CustomerOpenidEntity();
                update.setCustomerOpenId(item.getCustomerOpenId());
                update.setVersionDetailId("update");
                if (user != null) {
                    update.setCustomerSource(SubscribeSceneEnum.UNKNOWN.getValue());
                    if (StringUtils.isNotEmpty((String)user.getSubscribe_scene())) {
                        update.setCustomerSource(SubscribeSceneEnum.getValue(user.getSubscribe_scene()));
                    }
                }
                this.customerOpenidMapper.updateByPrimaryKeySelective(update);
            }
        }
    }
}

