/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.common.enums.customer.UserInfoStatusEnum;
import cc.lechun.common.enums.weixin.SubscribeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.ids.UuidUtil;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.sign.PasswordUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.customer.CustomerInfoDetailMapper;
import cc.lechun.mall.dao.customer.CustomerMapper;
import cc.lechun.mall.dao.customer.CustomerOpenidMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerInfoDetailEntity;
import cc.lechun.mall.entity.customer.CustomerMobileEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.customer.SubscribeVo;
import cc.lechun.mall.entity.distribution.QiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.weixin.SubscribeSceneEnum;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.customer.CustomerOpenidInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.QiyeweixinExternalContactInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.WeiXinOpenIdInterface;
import cc.lechun.mall.service.customer.CustomerSafeQuestionService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.FollowResult;
import weixin.popular.bean.user.User;
import weixin.popular.bean.user.UserInfoList;

@Service
public class CustomerService
extends BaseService
implements CustomerInterface {
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerOpenidMapper customerOpenidMapper;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private WeiXinBaseService weiWinBaseService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CustomerSafeQuestionService customerSafeQuestionService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private AccountBalanceInterface accountBalanceService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private CustomerMobileInterface customerMobileService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private CustomerOpenidInterface customerOpenidInterface;
    @Autowired
    private QiyeweixinExternalContactInterface qiyeweixinExternalContactInterface;
    @Autowired
    private WeiXinOpenIdInterface weiXinOpenIdInterface;
    @Autowired
    private CustomerInfoDetailMapper customerInfoDetailMapper;

    @Override
    public int getUserMobileStatus(String customerId, Integer platFormId) {
        CustomerDetailVo customerDetailVo = this.getCustomerDetail(customerId, platFormId);
        return this.getUserMobileStatus(customerDetailVo);
    }

    @Override
    public int getUserMobileStatus(CustomerDetailVo customerDetailVo) {
        int userInfoStatus = UserInfoStatusEnum.No_need.getValue();
        if (customerDetailVo == null) {
            return userInfoStatus;
        }
        userInfoStatus = StringUtils.isNotEmpty((String)customerDetailVo.getMobile()) ? UserInfoStatusEnum.No_need.getValue() : UserInfoStatusEnum.Nedd_Mobile.getValue();
        return userInfoStatus;
    }

    @Override
    public Integer getUserSubscribe(String openId, Integer platFormId) {
        try {
            WeiXinBaseEntity weiXinBaseEntity = this.weiWinBaseService.getWeixinBaseByFlatformId(platFormId);
            User user = UserAPI.userInfo((String)weiXinBaseEntity.getAccessToken(), (String)openId);
            return user == null ? 1 : (user.getSubscribe() == null ? 1 : user.getSubscribe());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7528\u6237\u662f\u5426\u5173\u6ce8\u516c\u4f17\u53f7\u51fa\u9519", (Throwable)e);
            return 1;
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomer", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomer(@ParameterValueKeyProvider String customerId) {
        return (CustomerEntity)this.customerMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerBySign", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerBySign(@ParameterValueKeyProvider String sign) {
        return this.listToEntiy(this.customerMapper.getCustomerBySign(sign));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerByOpenid", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerByOpenId(@ParameterValueKeyProvider String openid) {
        CustomerEntity param = new CustomerEntity();
        param.setChannelCustomerId(openid);
        param.setStatus(1);
        List customers = this.customerMapper.getList(param);
        return customers == null || customers.size() == 0 ? null : (CustomerEntity)customers.get(0);
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerOpenid", expiration=7200)
    @ReadDataSource
    public CustomerOpenidEntity getCustomerOpenid(@ParameterValueKeyProvider String customerOpenId) {
        return (CustomerOpenidEntity)this.customerOpenidMapper.selectByPrimaryKey((Serializable)((Object)customerOpenId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerByMobile", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerByMobile(@ParameterValueKeyProvider(order=0) String mobile, @ParameterValueKeyProvider(order=1) int platformGroupId) {
        return this.listToEntiy(this.customerMapper.getCustomerByMobile(mobile, platformGroupId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetail", expiration=7200)
    @ReadDataSource
    public CustomerDetailVo getCustomerDetail(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetail(customerId, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailBySignActive", expiration=300)
    @ReadDataSource
    public CustomerDetailVo getCustomerDetailBySign(@ParameterValueKeyProvider(order=0) String sign, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailBySign(sign, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailByOpenid")
    @ReadDataSource
    public CustomerDetailVo getCustomerDetailByOpenid(@ParameterValueKeyProvider(order=0) String openId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openId, platformId));
    }

    @Override
    @ReadDataSource
    public List<CustomerOpenidEntity> getCustomerOpenidList(String customerId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setCustomerId(customerId);
        return this.customerOpenidMapper.getList(customerOpenid);
    }

    @Override
    @Transactional
    public BaseJsonVo addCustomer4Wechat(int platformId, String openID, String unionid, String userName, String fxId, User user, String bindCode, String versionDetailId) throws IOException {
        Boolean collectionFlag = false;
        PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
        if (platFormAndGroup == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
        }
        if (user != null) {
            if (StringUtils.isEmpty((String)openID)) {
                openID = user.getOpenid();
            }
            if (StringUtils.isEmpty((String)unionid) && !StringUtils.isEmpty((String)user.getUnionid())) {
                unionid = user.getUnionid();
            }
            if (StringUtils.isEmpty((String)userName)) {
                String string = userName = user.getNickname() == null ? "" : user.getNickname();
            }
        }
        if (!StringUtils.checkOpenID((String)openID) || StringUtils.isEmpty((String)unionid)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        CustomerEntity customerEntity = null;
        CustomerOpenidEntity customerOpenid = null;
        CustomerDetailVo customerDeatail = null;
        boolean lock = this.mallRedisLock.tryLock(openID + ":customer", 5000L);
        if (lock) {
            customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platFormAndGroup.getPlatformId()));
            if (customerDeatail != null) {
                customerEntity = this.getCustomer(customerDeatail.getCustomerId());
            } else {
                if (StringUtils.isNotEmpty((String)unionid)) {
                    customerEntity = this.listToEntiy(this.customerMapper.getCustomerByUnionid(unionid, platFormAndGroup.getPlatformGroupId()));
                }
                if (customerEntity == null) {
                    CustomerEntity queryCustomer = new CustomerEntity();
                    queryCustomer.setChannelCustomerId(openID);
                    queryCustomer.setStatus(1);
                    customerEntity = (CustomerEntity)this.customerMapper.getSingle(queryCustomer);
                }
            }
        }
        if (customerEntity != null) {
            this.removeCache(customerEntity);
            if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                customerEntity.setSign(this.getNewCustomerSign());
            }
            if (!StringUtils.isEmpty((String)unionid)) {
                customerEntity.setUnionid(unionid);
            }
            if (!StringUtils.isEmpty((String)fxId)) {
                customerEntity.setFxId(fxId);
            }
            if (user != null && platformId != 4) {
                this.userToCustomer(user, customerEntity);
                customerEntity.setSubscribe(user.getSubscribe());
            }
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
        } else {
            customerEntity = new CustomerEntity();
            customerEntity.setIsNew(1);
            customerEntity.setSign(this.getNewCustomerSign());
            customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
            customerEntity.setCreateTime(DateUtils.now());
            customerEntity.setVemail(this.getVemail());
            customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
            customerEntity.setUnionid(unionid);
            if (StringUtils.isNotEmpty((String)userName)) {
                customerEntity.setNickName(userName);
            }
            customerEntity.setFxId(fxId);
            customerEntity.setSubscribe(user.getSubscribe());
            customerEntity.setChannelCustomerId(openID);
            if (user != null) {
                this.userToCustomer(user, customerEntity);
            }
            customerEntity.setLoginName(customerEntity.getCustomerId());
            this.customerMapper.insertSelective(customerEntity);
            collectionFlag = true;
        }
        if (customerDeatail != null) {
            customerOpenid = this.getCustomerOpenid(customerDeatail.getCustomerOpenId());
        }
        if (customerOpenid != null) {
            if (StringUtils.isNotEmpty((String)bindCode)) {
                customerOpenid.setBindCode(bindCode);
            }
            if (StringUtils.isNotEmpty((String)versionDetailId)) {
                customerOpenid.setVersionDetailId(versionDetailId);
            }
            if (StringUtils.isNotEmpty((String)user.getQr_scene_str())) {
                this.logger.info("\u7528\u6237\u5173\u6ce8\u5173\u6ce8bindCode={}", (Object)user.getQr_scene_str());
                customerOpenid.setBindCode(user.getQr_scene());
            }
            if (!StringUtils.isEmpty((String)unionid)) {
                customerOpenid.setUnionId(unionid);
            }
            if (user != null) {
                this.userToCustomerOpenId(user, customerOpenid);
            }
            this.logger.info("{},{}", (Object)user.toString(), (Object)customerOpenid.toString());
            this.customerOpenidMapper.updateByPrimaryKeySelective(customerOpenid);
        } else {
            customerOpenid = new CustomerOpenidEntity();
            customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
            customerOpenid.setOpenId(openID);
            customerOpenid.setUnionId(unionid);
            customerOpenid.setPlatformId(platformId);
            customerOpenid.setCustomerId(customerEntity.getCustomerId());
            customerOpenid.setCreateTime(DateUtils.now());
            customerOpenid.setBindCode(bindCode);
            customerOpenid.setVersionDetailId(versionDetailId);
            customerOpenid.setCustomerSource(SubscribeSceneEnum.UNKNOWN.getValue());
            customerOpenid.setUpdateTime(new Date());
            if (StringUtils.isNotEmpty((String)user.getSubscribe_scene())) {
                customerOpenid.setCustomerSource(SubscribeSceneEnum.getValue(user.getSubscribe_scene()));
            }
            customerOpenid.setSource(platformId == 4 ? 2 : platformId);
            if (user != null) {
                this.userToCustomerOpenId(user, customerOpenid);
            }
            this.logger.info("{},{}", (Object)user.toString(), (Object)customerOpenid.toString());
            this.customerOpenidMapper.insertSelective(customerOpenid);
        }
        if (collectionFlag.booleanValue()) {
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerEntity.getCustomerId()));
        }
        return BaseJsonVo.success((Object)customerEntity);
    }

    @Override
    public BaseJsonVo addCustomer4Wechat_new(int platformId, String openID, String unionid, String userName, String fxId, User user, String bindCode, String versionDetailId) throws IOException {
        CustomerEntity customerEntity = null;
        if (user != null && StringUtils.isEmpty((String)openID)) {
            openID = user.getOpenid();
        }
        CustomerDetailVo customerDeatail = null;
        customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platformId));
        if (customerDeatail == null && StringUtils.isNotEmpty((String)unionid)) {
            customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByUnionid(unionid, platformId));
        }
        if (customerDeatail != null && (customerEntity = this.getCustomer(customerDeatail.getCustomerId())) != null) {
            this.removeCache(customerEntity);
            if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                customerEntity.setSign(this.getNewCustomerSign());
            }
            if (StringUtils.isNotEmpty((String)unionid)) {
                customerEntity.setUnionid(unionid);
            }
            if (StringUtils.isNotEmpty((String)fxId)) {
                customerEntity.setFxId(fxId);
            }
            if (platformId != 4 && user != null) {
                this.userToCustomer(user, customerEntity);
            }
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            return BaseJsonVo.success((Object)customerEntity);
        }
        return BaseJsonVo.error((String)"\u65b0\u7528\u6237");
    }

    @Override
    @WriteDataSource
    public BaseJsonVo addCustomer4Wechat(int platformId, String openID, String unionid) {
        Boolean collectionFlag = false;
        PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
        if (platFormAndGroup == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
        }
        if (!StringUtils.checkOpenID((String)openID) || StringUtils.isEmpty((String)unionid)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        CustomerEntity customerEntity = null;
        CustomerOpenidEntity customerOpenid = null;
        CustomerDetailVo customerDeatail = null;
        boolean lock = this.mallRedisLock.tryLock(openID + ":customer", 5000L);
        if (lock) {
            customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platformId));
            if (customerDeatail != null) {
                customerEntity = this.getCustomer(customerDeatail.getCustomerId());
            } else {
                if (StringUtils.isNotEmpty((String)unionid)) {
                    customerEntity = this.listToEntiy(this.customerMapper.getCustomerByUnionid(unionid, platFormAndGroup.getPlatformGroupId()));
                }
                if (customerEntity == null) {
                    CustomerEntity queryCustomer = new CustomerEntity();
                    queryCustomer.setChannelCustomerId(openID);
                    queryCustomer.setStatus(1);
                    customerEntity = (CustomerEntity)this.customerMapper.getSingle(queryCustomer);
                }
            }
        }
        if (customerEntity != null) {
            this.removeCache(customerEntity);
            if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                customerEntity.setSign(this.getNewCustomerSign());
            }
            if (!StringUtils.isEmpty((String)unionid)) {
                customerEntity.setUnionid(unionid);
            }
            customerEntity.setSubscribe(0);
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
        } else {
            customerEntity = new CustomerEntity();
            customerEntity.setIsNew(1);
            customerEntity.setSign(this.getNewCustomerSign());
            customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
            customerEntity.setCreateTime(DateUtils.now());
            customerEntity.setVemail(this.getVemail());
            customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
            customerEntity.setUnionid(unionid);
            customerEntity.setNickName("\u5fae\u4fe1\u7528\u6237");
            customerEntity.setFxId("");
            customerEntity.setSubscribe(0);
            customerEntity.setChannelCustomerId(openID);
            customerEntity.setHeadImageUrl("https://thirdwx.qlogo.cn/mmopen/vi_32/POgEwh4mIHO4nibH0KlMECNjjGxQUq24ZEaGT4poC6icRiccVGKSyXwibcPq4BWmiaIGuG1icwxaQX6grC9VemZoJ8rg/132");
            customerEntity.setLoginName(customerEntity.getCustomerId());
            this.customerMapper.insertSelective(customerEntity);
            collectionFlag = true;
        }
        if (customerDeatail != null) {
            customerOpenid = this.getCustomerOpenid(customerDeatail.getCustomerOpenId());
        }
        if (customerOpenid != null) {
            if (!StringUtils.isEmpty((String)unionid)) {
                customerOpenid.setUnionId(unionid);
            }
            this.logger.info("{}", (Object)customerOpenid.toString());
            this.customerOpenidMapper.updateByPrimaryKeySelective(customerOpenid);
        } else {
            customerOpenid = new CustomerOpenidEntity();
            customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
            customerOpenid.setOpenId(openID);
            customerOpenid.setUnionId(unionid);
            customerOpenid.setPlatformId(platformId);
            customerOpenid.setCustomerId(customerEntity.getCustomerId());
            customerOpenid.setCreateTime(DateUtils.now());
            customerOpenid.setBindCode("");
            customerOpenid.setVersionDetailId("");
            customerOpenid.setCustomerSource(SubscribeSceneEnum.UNKNOWN.getValue());
            customerOpenid.setSource(platformId == 4 ? 2 : platformId);
            this.logger.info("{}", (Object)customerOpenid.toString());
            this.customerOpenidMapper.insertSelective(customerOpenid);
        }
        if (collectionFlag.booleanValue()) {
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerEntity.getCustomerId()));
        }
        return BaseJsonVo.success((Object)customerEntity);
    }

    @Override
    public BaseJsonVo minilogin(int platformId, String openID, String unionid) throws IOException {
        CustomerEntity customerEntity = null;
        CustomerDetailVo customerDeatail = null;
        customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platformId));
        if (customerDeatail == null && StringUtils.isNotEmpty((String)unionid)) {
            customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByUnionid(unionid, platformId));
        }
        if (customerDeatail != null && (customerEntity = this.getCustomer(customerDeatail.getCustomerId())) != null) {
            this.removeCache(customerEntity);
            if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                customerEntity.setSign(this.getNewCustomerSign());
            }
            if (StringUtils.isNotEmpty((String)unionid)) {
                customerEntity.setUnionid(unionid);
            }
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            customerEntity.setChannelCustomerId(customerDeatail.getOpenId());
            return BaseJsonVo.success((Object)customerEntity);
        }
        return BaseJsonVo.error((String)"\u65b0\u7528\u6237");
    }

    @Override
    public BaseJsonVo saveCustomerInfo(int platformId, User user, CustomerDetailVo customerDetailVo) {
        block13: {
            try {
                this.logger.info("{}", (Object)JsonUtils.toJson((Object)user, (boolean)false));
                this.redisService.save(customerDetailVo.getCustomerId() + ":author", 1, 864000L);
                CustomerEntity customerEntity = this.getCustomer(customerDetailVo.getCustomerId());
                if (customerEntity == null) break block13;
                this.removeCache(customerEntity);
                if (!StringUtils.isEmpty((String)customerDetailVo.getUnionid())) {
                    customerEntity.setUnionid(customerDetailVo.getUnionid());
                }
                if (StringUtils.isNotEmpty((String)user.getNickname())) {
                    customerEntity.setNickName(user.getNickname());
                }
                if (user.getSex() != null && user.getSex() != 0) {
                    customerEntity.setGender(user.getSex());
                }
                if (StringUtils.isNotEmpty((String)user.getCountry())) {
                    customerEntity.setCountry(user.getCountry());
                }
                if (StringUtils.isNotEmpty((String)user.getProvince())) {
                    customerEntity.setProvince(user.getProvince());
                }
                if (StringUtils.isNotEmpty((String)user.getCity())) {
                    customerEntity.setCity(user.getCity());
                }
                if (StringUtils.isNotEmpty((String)user.getHeadimgurl())) {
                    customerEntity.setHeadImageUrl(user.getHeadimgurl());
                }
                if (StringUtils.isNotEmpty((String)user.getLanguage())) {
                    customerEntity.setLanguage(user.getLanguage());
                }
                customerEntity.setUpdateTime(DateUtils.now());
                this.customerMapper.updateByPrimaryKeySelective(customerEntity);
                try {
                    CustomerInfoDetailEntity customerInfoDetailEntity = (CustomerInfoDetailEntity)this.customerInfoDetailMapper.selectByPrimaryKey((Serializable)((Object)customerEntity.getCustomerId()));
                    if (customerInfoDetailEntity != null && StringUtils.isNotEmpty((String)customerInfoDetailEntity.getCustomerBirthday()) && StringUtils.isNotEmpty((String)customerEntity.getNickName()) && StringUtils.isNotEmpty((String)customerEntity.getHeadImageUrl())) {
                        BaseJsonVo result = this.vipService.finishTaskImproveInfo(customerEntity.getCustomerId());
                        this.logger.error("\u4f1a\u5458\u7528\u6237:{}\u5b8c\u6210\u4efb\u52a1:{}", (Object)customerEntity.getCustomerId(), (Object)result.getMessage());
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u51fa\u9519:{}", (Object)customerDetailVo.toString(), (Object)e);
                }
                return BaseJsonVo.success((Object)customerEntity);
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u51fa\u9519:{}", (Object)customerDetailVo.toString(), (Object)e);
            }
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveCustomerInfo(int platformId, CustomerDetailVo customerDetailVo) {
        User user = UserAPI.userInfo((String)this.weiWinBaseService.getAccessTokenValueByPlatformId(platformId), (String)customerDetailVo.getOpenId());
        return this.saveCustomerInfo(platformId, user, customerDetailVo);
    }

    @Override
    @Transactional
    public BaseJsonVo subscribe(SubscribeVo subscribeVo) throws IOException {
        WeiXinBaseEntity weiXinBase = this.weiWinBaseService.getWeixinBaseByFlatformId(subscribeVo.getPlatformId());
        User user = UserAPI.userInfo((String)weiXinBase.getAccessToken(), (String)subscribeVo.getOpenId());
        BaseJsonVo vo = this.addCustomer4Wechat(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), user.getUnionid(), user.getNickname(), "", user, subscribeVo.getBindCode(), subscribeVo.getVersionDetailId());
        this.customerMapper.subscribe(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), SubscribeEnum.SUBSCRIBE.getValue());
        if (vo.isSuccess()) {
            CustomerEntity customerEntity = (CustomerEntity)vo.getValue();
            this.mergeCustomer4UnionId(user.getUnionid(), customerEntity.getPlatformGroupId());
        }
        return vo;
    }

    @Override
    public BaseJsonVo unSubscribe(SubscribeVo subscribeVo) {
        CustomerDetailVo customerDetailVo = this.getCustomerDetailByOpenid(subscribeVo.getOpenId(), subscribeVo.getPlatformId());
        if (customerDetailVo != null) {
            CustomerEntity customerEntity = this.getCustomer(customerDetailVo.getCustomerId());
            this.removeCache(customerEntity);
            this.customerMapper.subscribe(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), SubscribeEnum.UNSUBSCRIBE.getValue());
        }
        return BaseJsonVo.success((Object)"\u53d6\u5173\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo addCustomer4Mobile(int platformId, String mobile, String bindCode, String versionDetailId) throws IOException {
        Boolean collectionFlag = false;
        PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
        if (platFormAndGroup == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
        }
        if (mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u683c\u5f0f\u9519\u8bef");
        }
        this.mergeCustomer4Mobile(mobile, platFormAndGroup.getPlatformGroupId());
        CustomerEntity customerEntity = null;
        CustomerDetailVo customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByMobile(mobile, platFormAndGroup.getPlatformId()));
        if (customerDeatail == null) {
            customerEntity = this.listToEntiy(this.customerMapper.getCustomerByMobile(mobile, platFormAndGroup.getPlatformGroupId()));
            if (customerEntity == null) {
                customerEntity = new CustomerEntity();
                customerEntity.setMobile(mobile);
                customerEntity.setIsNew(1);
                customerEntity.setSign(this.getNewCustomerSign());
                customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
                customerEntity.setCreateTime(DateUtils.now());
                customerEntity.setVemail(this.getVemail());
                customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
                customerEntity.setUnionid("");
                customerEntity.setNickName(mobile);
                customerEntity.setLoginName(customerEntity.getCustomerId());
                collectionFlag = true;
                this.customerMapper.insertSelective(customerEntity);
            }
            CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
            customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
            customerOpenid.setOpenId("");
            customerOpenid.setUnionId("");
            customerOpenid.setPlatformId(platformId);
            customerOpenid.setCustomerId(customerEntity.getCustomerId());
            customerOpenid.setCreateTime(DateUtils.now());
            customerOpenid.setBindCode(bindCode);
            customerOpenid.setVersionDetailId(versionDetailId);
            customerOpenid.setSource(platformId == 4 ? 2 : platformId);
            this.customerOpenidMapper.insertSelective(customerOpenid);
        } else {
            customerEntity = this.getCustomer(customerDeatail.getCustomerId());
        }
        if (collectionFlag.booleanValue()) {
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
        }
        return BaseJsonVo.success((Object)customerEntity);
    }

    @Override
    public BaseJsonVo bindMobile(String mobile, String customerId, String safeQuestion) throws IOException {
        return ((CustomerService)AopContext.currentProxy()).bindMobile(mobile, customerId, safeQuestion, 1);
    }

    @Transactional
    public BaseJsonVo<CustomerEntity> bindMobile(String mobile, String customerId, String safeQuestion, Integer customerFrom) throws IOException {
        CustomerEntity customerNew = this.getCustomer(customerId);
        if (customerNew == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        this.removeCache(customerNew);
        this.vipService.finishTaskBindMobile(customerId);
        String old_mobile = customerNew.getMobile();
        List<CustomerEntity> customer4Mobiles = this.customerMapper.getCustomerByMobile(mobile, customerNew.getPlatformGroupId());
        if (customer4Mobiles != null && customer4Mobiles.size() > 0) {
            for (CustomerEntity customerOld : customer4Mobiles) {
                if (customerOld.getCustomerId().equals(customerNew.getCustomerId())) continue;
                this.removeCache(customerOld);
                customerOld.setMobile(null);
                customerOld.setPayPassword(null);
                this.customerMapper.updateByPrimaryKey(customerOld);
                this.customerSafeQuestionService.deleteCustomerSafeQuestion(customerOld.getCustomerId());
            }
        }
        customerNew.setMobile(mobile);
        customerNew.setCustomerFrom(customerFrom);
        int k = this.customerMapper.updateByPrimaryKeySelective(customerNew);
        if (k >= 1) {
            int amount;
            if (!StringUtils.isEmpty((String)safeQuestion)) {
                this.customerSafeQuestionService.saveCustomerSafeQuestion(customerId, safeQuestion);
            }
            List<CustomerMobileEntity> mobiles = this.customerMobileService.findMobile(mobile);
            if (StringUtils.isEmpty((String)old_mobile) && (mobiles == null || mobiles.size() <= 1) && (amount = this.dictionaryInterface.getDictionaryToInt(customerNew.getPlatformGroupId(), 101, "bindMobileBalance")) > 0) {
                this.accountBalanceService.activeCharge(customerId, new BigDecimal(amount), "\u7ed1\u5b9a\u624b\u673a", true, "\u7ed1\u5b9a\u624b\u673a\u8d60\u9001", mobile);
            }
        } else {
            return BaseJsonVo.error((String)"\u5662\u54e6~\u624b\u673a\u53f7\u7ed1\u5b9a\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)customerNew);
    }

    @Override
    public BaseJsonVo validatePassword(String customerId, String password, PasswordTypeEnum passwordTypeEnum) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtils.isEmpty((String)password)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u5bc6\u7801");
        }
        CustomerEntity customer = this.getCustomer(customerId);
        if (customer == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7528\u6237");
        }
        String hashPassword = customer.getPayPassword();
        if (passwordTypeEnum.getValue() == PasswordTypeEnum.login_password.getValue()) {
            hashPassword = customer.getPassword();
        }
        if (StringUtils.isEmpty((String)hashPassword)) {
            return new BaseJsonVo(100101, "\u5c1a\u672a\u8bbe\u7f6e\u5bc6\u7801");
        }
        String key = this.getCountLimitKey(customerId, passwordTypeEnum);
        long countLimit = this.redisService.increment(key, 0L);
        if (countLimit >= 5L) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u572824\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
        boolean b = PasswordUtils.validatePassword((String)password, (String)hashPassword);
        if (b) {
            this.redisService.increment(key, -countLimit);
            return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u901a\u8fc7");
        }
        countLimit = this.redisService.increment(key, 1L);
        if (countLimit >= 5L) {
            this.logger.error("\u7528\u6237" + customerId + "\u5c1d\u8bd5\u5bc6\u7801\u6b21\u6570\u592a\u591a\uff0c\u5df2\u9501\u5b9a\u5bc6\u780124\u5c0f\u65f6" + passwordTypeEnum.getValue());
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u572824\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
        return BaseJsonVo.paramError((String)("\u5bc6\u7801\u9519\u8bef\uff0c\u518d\u9519\u8bef" + (5L - countLimit) + "\u6b21\uff0c\u8d26\u53f7\u5c06\u9501\u5b9a24\u5c0f\u65f6"));
    }

    @Override
    public BaseJsonVo updatePassword(String customerId, String newPassword, PasswordTypeEnum passwordTypeEnum) throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.logger.info("updatePassword,customerId\uff1a" + customerId + "," + newPassword);
        if (StringUtils.isEmpty((String)newPassword)) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customer = this.getCustomer(customerId);
        if (customer == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7528\u6237");
        }
        this.removeCache(customer);
        this.logger.info("updatePassword,customer\uff1a" + JsonUtils.toJson((Object)customer, (boolean)false));
        String hashPassword = PasswordUtils.generateStorngPasswordHash((String)newPassword);
        if (passwordTypeEnum.getValue() == PasswordTypeEnum.login_password.getValue()) {
            customer.setPassword(hashPassword);
        } else {
            customer.setPayPassword(hashPassword);
        }
        this.logger.info("updatePassword,customer1\uff1a" + JsonUtils.toJson((Object)customer, (boolean)false));
        this.customerMapper.updateByPrimaryKeySelective(customer);
        String key = this.getCountLimitKey(customerId, passwordTypeEnum);
        long countLimit = this.redisService.increment(key, 0L);
        countLimit = this.redisService.increment(key, -countLimit);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public void test() {
        this.logger.info("spring \u5b9a\u65f6\u4efb\u52a1\u6d4b\u8bd5");
    }

    private String getCountLimitKey(String customerId, PasswordTypeEnum passwordTypeEnum) {
        String key = customerId + "_validatepassword_count_" + passwordTypeEnum.getValue();
        return key;
    }

    private void mergeCustomer4OpenId(int platformId, String openId) throws IOException {
        if (StringUtils.isEmpty((String)openId)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByOpenid(openId, platformId);
        if (ls != null && ls.size() > 0) {
            HashSet<CustomerEntity> set = new HashSet<CustomerEntity>();
            set.addAll(ls);
            if (set != null && set.size() == 1) {
                CustomerEntity customerEntity = ls.get(0);
                this.removeCache(customerEntity);
                List<CustomerDetailVo> ls_old_openids = this.customerMapper.getCustomerDetail(customerEntity.getCustomerId(), platformId);
                if (ls_old_openids != null && ls_old_openids.size() > 0) {
                    for (int i = 1; i < ls_old_openids.size(); ++i) {
                        CustomerDetailVo customerDetailVo = ls_old_openids.get(i);
                        this.customerOpenidMapper.deleteByPrimaryKey((Serializable)((Object)customerDetailVo.getCustomerOpenId()));
                    }
                }
            } else {
                this.mergeCustomer4list(new ArrayList<CustomerEntity>(set));
            }
        }
    }

    private void mergeCustomer4Mobile(String mobile, int platformGroupId) throws IOException {
        if (StringUtils.isEmpty((String)mobile)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByMobile(mobile, platformGroupId);
        this.mergeCustomer4list(ls);
    }

    private void mergeCustomer4UnionId(String unionid, int platformGroupId) throws IOException {
        if (StringUtils.isEmpty((String)unionid)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByUnionid(unionid, platformGroupId);
        this.mergeCustomer4list(ls);
    }

    private void mergeCustomer4list(List<CustomerEntity> ls) throws IOException {
        CustomerEntity customerNew;
        if (ls != null && ls.size() > 1 && (customerNew = this.mergeCustomerDetail(ls)) != null) {
            List<CustomerOpenidEntity> ls_new_openids = this.getCustomerOpenidList(customerNew.getCustomerId());
            ArrayList<Integer> ls_new_openids_platforms = new ArrayList<Integer>();
            if (ls_new_openids != null && ls_new_openids.size() > 0) {
                for (CustomerOpenidEntity customerOpenidEntity : ls_new_openids) {
                    ls_new_openids_platforms.add(customerOpenidEntity.getPlatformId());
                }
            }
            CustomerEntity customerOld = null;
            for (int i = 1; i < ls.size(); ++i) {
                customerOld = ls.get(i);
                if (customerOld.getCustomerId().equals(customerNew.getCustomerId())) continue;
                this.removeCache(customerOld);
                this.updateCustomerFailed(customerOld, customerNew.getCustomerId());
                this.mergerCustomerData(customerNew.getCustomerId(), customerOld.getCustomerId());
                List<CustomerOpenidEntity> ls_old_openids = this.getCustomerOpenidList(customerOld.getCustomerId());
                if (ls_old_openids == null || ls_old_openids.size() <= 0) continue;
                for (CustomerOpenidEntity customerOpenidEntity : ls_old_openids) {
                    if (ls_new_openids_platforms.contains(customerOpenidEntity.getPlatformId())) {
                        this.customerOpenidMapper.deleteByPrimaryKey((Serializable)((Object)customerOpenidEntity.getCustomerOpenId()));
                        continue;
                    }
                    customerOpenidEntity.setCustomerId(customerNew.getCustomerId());
                    this.customerOpenidMapper.updateByPrimaryKeySelective(customerOpenidEntity);
                }
            }
        }
    }

    private void mergerCustomerData(String newCustomerId, String oldCustomerId) throws IOException {
        this.customerMapper.mergeCustomer(newCustomerId, oldCustomerId);
        this.mergeCustomerVip(newCustomerId, oldCustomerId);
    }

    private void mergeCustomerVip(String newCustomerId, String oldCustomerId) throws IOException {
        try {
            this.vipService.rebuildVipLevel(newCustomerId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accountBalanceService.mergeAccount(oldCustomerId, newCustomerId);
    }

    private void updateCustomerFailed(CustomerEntity customerOld, String newCustomerId) {
        this.removeCache(customerOld);
        customerOld.setStatus(StatusEnum.STATUS_FAIL.getValue());
        customerOld.setSign("\u5220" + customerOld.getMobile() + ":" + customerOld.getUnionid());
        customerOld.setUnionid("");
        customerOld.setMobile("");
        customerOld.setTrueName(newCustomerId);
        this.customerMapper.updateByPrimaryKeySelective(customerOld);
    }

    private CustomerEntity mergeCustomerDetail(List<CustomerEntity> ls) {
        CustomerEntity customerNew = null;
        if (ls != null && ls.size() > 1) {
            customerNew = ls.get(0);
            customerNew.setStatus(StatusEnum.STATUS_OK.getValue());
            CustomerEntity customerOld = null;
            for (int i = 1; i < ls.size(); ++i) {
                customerOld = ls.get(i);
                this.removeCache(customerOld);
                if (customerOld.getCustomerId().equals(customerNew.getCustomerId())) continue;
                if (StringUtils.isEmpty((String)customerNew.getNickName()) && StringUtils.isNotEmpty((String)customerOld.getNickName())) {
                    customerNew.setNickName(customerOld.getNickName());
                }
                if (StringUtils.isEmpty((String)customerNew.getTrueName()) && StringUtils.isNotEmpty((String)customerOld.getTrueName())) {
                    customerNew.setTrueName(customerOld.getTrueName());
                }
                if (StringUtils.isEmpty((String)customerNew.getLoginName()) && StringUtils.isNotEmpty((String)customerOld.getLoginName())) {
                    customerNew.setLoginName(customerOld.getLoginName());
                }
                if (StringUtils.isEmpty((String)customerNew.getMobile()) && StringUtils.isNotEmpty((String)customerOld.getMobile())) {
                    customerNew.setMobile(customerOld.getMobile());
                }
                if (StringUtils.isEmpty((String)customerNew.getCity()) && StringUtils.isNotEmpty((String)customerOld.getCity())) {
                    customerNew.setCity(customerOld.getCity());
                }
                if (StringUtils.isEmpty((String)customerNew.getProvince()) && StringUtils.isNotEmpty((String)customerOld.getProvince())) {
                    customerNew.setProvince(customerOld.getProvince());
                }
                if (StringUtils.isEmpty((String)customerNew.getHeadImageUrl()) && StringUtils.isNotEmpty((String)customerOld.getHeadImageUrl())) {
                    customerNew.setHeadImageUrl(customerOld.getHeadImageUrl());
                }
                if (StringUtils.isEmpty((String)customerNew.getFxId()) && StringUtils.isNotEmpty((String)customerOld.getFxId())) {
                    customerNew.setFxId(customerOld.getFxId());
                }
                if (StringUtils.isEmpty((String)customerNew.getUnionid()) && StringUtils.isNotEmpty((String)customerOld.getUnionid())) {
                    customerNew.setUnionid(customerOld.getUnionid());
                }
                if (StringUtils.isEmpty((String)customerNew.getPayPassword()) && StringUtils.isNotEmpty((String)customerOld.getPayPassword())) {
                    customerNew.setPayPassword(customerOld.getPayPassword());
                }
                if (!StringUtils.isEmpty((String)customerNew.getCustomerServiceId()) || !StringUtils.isNotEmpty((String)customerOld.getCustomerServiceId())) continue;
                customerNew.setCustomerServiceId(customerOld.getCustomerServiceId());
            }
            this.customerMapper.updateByPrimaryKeySelective(customerNew);
        }
        return customerNew;
    }

    private void userToCustomer(User user, CustomerEntity customerEntity) {
        if (user.getSex() != null && user.getSex() != 0) {
            customerEntity.setGender(user.getSex());
        }
        if (StringUtils.isNotEmpty((String)user.getLanguage())) {
            customerEntity.setLanguage(user.getLanguage());
        }
        if (StringUtils.isNotEmpty((String)user.getCity())) {
            customerEntity.setCity(user.getCity() == null ? "" : user.getCity());
        }
        if (StringUtils.isNotEmpty((String)user.getProvince())) {
            customerEntity.setProvince(user.getProvince() == null ? "" : user.getProvince());
        }
        if (StringUtils.isNotEmpty((String)user.getCountry())) {
            customerEntity.setCountry(user.getCountry() == null ? "" : user.getCountry());
        }
        if (StringUtils.isNotEmpty((String)user.getNickname())) {
            customerEntity.setNickName(user.getNickname());
        }
        if (StringUtils.isNotEmpty((String)user.getHeadimgurl())) {
            customerEntity.setHeadImageUrl(user.getHeadimgurl());
        }
    }

    private void userToCustomerOpenId(User user, CustomerOpenidEntity customerOpenid) {
        customerOpenid.setSubscribe(user.getSubscribe() == null ? 0 : user.getSubscribe());
        if (user.getSubscribe_time() != null && user.getSubscribe_time() != 0) {
            customerOpenid.setSubscribeTime(new Date(MathUtils.mulBigDecimal((Number)user.getSubscribe_time(), (Number)1000).longValue()));
        }
    }

    private String getCustomerId(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + RandomUtils.generateStrId();
    }

    private String getCustomerOpenID(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + platFormAndGroup.getPlatformId() + RandomUtils.generateStrId();
    }

    private String getNewCustomerSign() {
        String sign = UuidUtil.get32UUID() + UuidUtil.get32UUID();
        return sign;
    }

    private String getVemail() {
        return "v" + RandomUtils.generateStrId() + "@lechun.cc";
    }

    private <T> T listToEntiy(List<T> ls) {
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }

    @Override
    public void removeCache(String customerId) {
        this.removeCache(this.getCustomer(customerId));
    }

    @Override
    public void removeCache(CustomerEntity customer) {
        if (customer != null) {
            this.memcachedService.delete("getCustomer", customer.getCustomerId());
            this.memcachedService.delete("getCustomerBySign", customer.getSign());
            this.memcachedService.delete("getCustomerByMobile", new String[]{StringUtils.isEmpty((String)customer.getMobile()) ? "" : customer.getMobile(), "" + customer.getPlatformGroupId()});
            List<CustomerOpenidEntity> ls = this.getCustomerOpenidList(customer.getCustomerId());
            if (ls != null && ls.size() > 0) {
                ls.forEach(customerOpenidEntity -> {
                    this.memcachedService.delete("getCustomerOpenid", customerOpenidEntity.getCustomerOpenId());
                    this.memcachedService.delete("getCustomerDetail", new String[]{customer.getCustomerId(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailBySignActive", new String[]{customer.getSign(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailByOpenid", customerOpenidEntity.getOpenId());
                    this.memcachedService.delete("getCustomerDetailByOpenid", new String[]{customerOpenidEntity.getOpenId(), customerOpenidEntity.getPlatformId() + ""});
                });
            }
        }
    }

    @Override
    public void updateCustomerEntitySelective(CustomerEntity customerEntity) {
        if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getCustomerId())) {
            this.removeCache(customerEntity);
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            if (customerEntity.getIsNew() != null) {
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerEntity.getCustomerId()));
            }
        }
    }

    @Override
    public List<CustomerEntity> getCustomerByCustomerIds(List<String> ids) {
        return this.customerMapper.getCustomerByCustomerIds(ids);
    }

    @Override
    public List<CustomerEntity> getCustomerBySignIds(List<String> ids) {
        return this.customerMapper.getCustomerBySignIds(ids);
    }

    @Override
    public List<CustomerDetailVo> getCustomerDetailByOpenIds(List<String> ids, int platformId) {
        return this.customerMapper.getCustomerDetailByOpenIds(ids, platformId);
    }

    @Override
    public BaseJsonVo batchGetUsers(int platFormId, String nextOpenId) {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platFormId);
        do {
            try {
                FollowResult result = UserAPI.userGet((String)accessToken, (String)nextOpenId);
                if (result.isSuccess()) {
                    FollowResult.Data data = result.getData();
                    if (data == null) {
                        nextOpenId = "";
                        continue;
                    }
                    nextOpenId = result.getNext_openid();
                    List<List<String>> lists = CustomerService.splitAry(data.getOpenid(), 100);
                    for (List<String> lst : lists) {
                        UserInfoList userInfoList = UserAPI.userInfoBatchget((String)accessToken, (String)"zh_CN", lst);
                        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.batchGetUser, MessageParam.messageParam((String)(platFormId + "|" + UUID.randomUUID()), (Object)userInfoList.getUser_info_list()));
                    }
                    continue;
                }
                nextOpenId = "";
            }
            catch (Exception e) {
                this.logger.error("\u62c9\u53d6\u7528\u6237\u5931\u8d25\uff1a" + nextOpenId + "," + e.getMessage());
            }
        } while (StringUtils.isNotEmpty((String)nextOpenId));
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    private static List<List<String>> splitAry(String[] ary, int subSize) {
        ArrayList numList = Lists.newArrayList((Object[])ary);
        return Lists.partition((List)numList, (int)subSize);
    }

    @Override
    public BaseJsonVo batchUPdateUser(String key, List<User> users) throws IOException {
        if (StringUtils.isNotEmpty((String)key) && users != null) {
            key = key.split("\\|")[0];
            key = key.split(":")[1];
            Integer platformId = Integer.valueOf(key);
            UserInfoList userInfoList = new UserInfoList();
            userInfoList.setUser_info_list(users);
            this.weiXinOpenIdInterface.saveWeixinOpenId(userInfoList, platformId);
            for (User user : users) {
                CustomerOpenidEntity op = new CustomerOpenidEntity();
                op.setOpenId(user.getOpenid());
                op = (CustomerOpenidEntity)this.customerOpenidInterface.getSingle(op);
                if (op == null) {
                    this.addCustomer4Wechat(platformId, user.getOpenid(), user.getUnionid(), user.getNickname(), "", user, null, null);
                    continue;
                }
                op.setUpdateTime(new Date());
                op.setPlatformId(platformId);
                op.setSubscribe(user.getSubscribe());
                op.setSubscribeTime(new Date(MathUtils.mulBigDecimal((Number)user.getSubscribe_time(), (Number)1000).longValue()));
                this.customerOpenidInterface.updateByPrimaryKey(op);
            }
            return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return BaseJsonVo.error((String)"batchUPdateUser\u5bf9\u8c61\u4e3a\u7a7a");
    }

    @Override
    public String getQiyeweixinContactor(String customerId) {
        QiyeweixinExternalContactEntity param = new QiyeweixinExternalContactEntity();
        param.setCustomerId(customerId);
        List list = this.qiyeweixinExternalContactInterface.getList(param);
        if (list != null && list.size() > 0) {
            return ((QiyeweixinExternalContactEntity)list.get(0)).getQyWeixinUserid();
        }
        return null;
    }

    @Override
    public boolean checkQiyeweixinContactor(String customerId) {
        return this.getQiyeweixinContactor(customerId, 1);
    }

    @Override
    public boolean getQiyeweixinContactor(String customerId, Integer saveSucc) {
        QiyeweixinExternalContactEntity param = new QiyeweixinExternalContactEntity();
        param.setCustomerId(customerId);
        param.setSaveSucc(1);
        List list = this.qiyeweixinExternalContactInterface.getList(param);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public BaseJsonVo updateMobileByLogiscMessage(String mobile, String customerId, String bindCode) {
        try {
            int i;
            CustomerEntity customerEntity = this.getCustomerByMobile(mobile, 1000);
            if (customerEntity != null) {
                return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u5df2\u7ecf\u7ed1\u5b9a");
            }
            customerEntity = this.getCustomer(customerId);
            if (customerEntity == null) {
                return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNotEmpty((String)customerEntity.getMobile())) {
                return BaseJsonVo.error((String)"\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\u53f7");
            }
            customerEntity.setMobile(mobile);
            customerEntity.setCustomerFrom(2);
            if (StringUtils.isEmpty((String)customerEntity.getBindCode())) {
                customerEntity.setBindCode(bindCode);
            }
            if ((i = this.customerMapper.updateByPrimaryKeySelective(customerEntity)) > 0) {
                return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
            }
            return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            return BaseJsonVo.error((String)"\u66f4\u65b0\u7528\u6237\u624b\u673a\u53f7\u5f02\u5e38");
        }
    }

    @Override
    public void mergeFix() {
        List<Map<String, String>> fixed = this.customerMapper.getMergeFix();
        fixed.forEach(map -> {
            String oldCustomer = (String)map.get("CUSTOMER_ID");
            String newCustomer = (String)map.get("TO_CUSTOMER_ID");
            try {
                this.mergerCustomerData(newCustomer, oldCustomer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

