/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.InteractionMapper;
import cc.lechun.mall.dao.weixin.WeiXinMenuMapper;
import cc.lechun.mall.entity.customer.InteractionDetailEntity;
import cc.lechun.mall.entity.customer.InteractionEntity;
import cc.lechun.mall.entity.weixin.WeiXinMenuEntity;
import cc.lechun.mall.iservice.customer.InteractionDetailInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InteractionService
extends BaseService<InteractionEntity, Integer>
implements InteractionInterface {
    @Resource
    private InteractionMapper interactionMapper;
    @Autowired
    private InteractionDetailInterface interactionDetailInterface;
    @Resource
    private WeiXinMenuMapper weiXinMenuMapper;

    @Override
    public BaseJsonVo saveCustomerInteractionStatus(String customerId, Integer status, Integer platformId) {
        InteractionEntity query = new InteractionEntity();
        query.setCustomerId(customerId);
        List list = this.interactionMapper.getList(query);
        if (list.size() == 0) {
            InteractionEntity interactionEntity = new InteractionEntity();
            interactionEntity.setCustomerId(customerId);
            interactionEntity.setStatus(2);
            interactionEntity.setCreateTime(DateUtils.now());
            interactionEntity.setExpired(DateUtils.now());
            interactionEntity.setPlatformId(platformId);
            return this.interactionMapper.insert(interactionEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        for (InteractionEntity interactionEntity : list) {
            InteractionEntity update = new InteractionEntity();
            update.setId(interactionEntity.getId());
            update.setStatus(1);
            this.interactionMapper.updateByPrimaryKeySelective(update);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public void saveCustomerInteractionAsync(final String customerId, Integer status, final Integer type, final String key, final Integer platformId) {
        try {
            ThreadPool.services.execute(new Runnable(){

                @Override
                public void run() {
                    InteractionDetailEntity interactionDetailEntity = new InteractionDetailEntity();
                    interactionDetailEntity.setCreateTime(DateUtils.now());
                    interactionDetailEntity.setCustomerId(customerId);
                    interactionDetailEntity.setInteractionKey(StringUtils.isNotEmpty((String)key) ? key : "");
                    interactionDetailEntity.setType(type);
                    interactionDetailEntity.setPlatformId(platformId);
                    InteractionService.this.logger.info(interactionDetailEntity.toString());
                    if (type == 4) {
                        WeiXinMenuEntity queryMenu = new WeiXinMenuEntity();
                        queryMenu.setMenuKey(key);
                        WeiXinMenuEntity weiXinMenuEntity = (WeiXinMenuEntity)InteractionService.this.weiXinMenuMapper.getSingle(queryMenu);
                        if (weiXinMenuEntity != null) {
                            interactionDetailEntity.setMenuClassName(weiXinMenuEntity.getMenuClassName());
                        }
                    }
                    InteractionService.this.interactionDetailInterface.insert(interactionDetailEntity);
                    InteractionEntity query = new InteractionEntity();
                    query.setCustomerId(customerId);
                    query.setType(type);
                    InteractionEntity interactionEntity = (InteractionEntity)InteractionService.this.interactionMapper.getSingle(query);
                    if (interactionEntity == null) {
                        InteractionEntity newInteractionEntity = new InteractionEntity();
                        newInteractionEntity.setCustomerId(customerId);
                        newInteractionEntity.setStatus(1);
                        newInteractionEntity.setCreateTime(DateUtils.now());
                        newInteractionEntity.setExpired(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)2));
                        newInteractionEntity.setType(type);
                        InteractionService.this.interactionMapper.insert(newInteractionEntity);
                    } else {
                        interactionEntity.setCreateTime(DateUtils.now());
                        interactionEntity.setExpired(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)2));
                        InteractionService.this.interactionMapper.updateByPrimaryKeySelective(interactionEntity);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

