/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.apiinvoke.ec.DeliverInvoke;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.ec.entity.bo.MyWXBBaseFormJson;
import cc.lechun.ec.entity.bo.WXBaseForm;
import cc.lechun.ec.entity.bo.WXProductForm;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.deliver.DeliverDateVo;
import cc.lechun.mall.entity.deliver.DeliverSoldProductVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.deliver.ProductFormVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.shoppingcart.SaleOutTypeEnum;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.feign.FeignCallErrorLogInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.shoppingcart.ShoppingcartSoldoutRecordInterface;
import cc.lechun.mall.service.deliver.DeliverEntity;
import cc.lechun.mall.service.deliver.DeliverProductVo;
import cc.lechun.mall.service.deliver.GroupProductEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeliverNewErpService
extends BaseService
implements DeliverNewErpInterface {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private GrouponInterface grouponInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private ShoppingcartSoldoutRecordInterface soldoutRecordInterface;
    @Value(value="${lechun.oldapi.domain:}")
    private String oldApiHost;
    @Autowired
    private DeliverInvoke deliverInvoke;
    @Autowired
    private FeignCallErrorLogInterface feignCallErrorLogInterface;

    @Override
    public DeliverVo getDeliverByErp(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int speedUp, int cacheType) {
        return this.getProductDeliverByErp(shoppingcartVO, addressVo, deliverDate, speedUp, cacheType);
    }

    public DeliverVo getProductDeliverByErp(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int speedUp, int cacheType) {
        MyWXBBaseFormJson myWXBBaseFormJson;
        this.logger.info("***********getProductDeliverByErp************shoppingcartVO={},addressVo={},deliverDate={}", new Object[]{shoppingcartVO.toString(), addressVo == null ? "" : addressVo.toString(), deliverDate});
        DeliverVo deliverVo = new DeliverVo();
        if (addressVo == null) {
            deliverVo.setNomalInventory(0);
            deliverVo.setInventory(-2);
            return deliverVo;
        }
        if (!addressVo.isEnable()) {
            deliverVo.setNomalInventory(0);
            deliverVo.setInventory(-1);
            this.logger.info("\u533a\u80fd\u4e0d\u80fd\u914d\u9001\u5462\uff1f{}:isEnabled-false", (Object)addressVo.getAreaName());
            return deliverVo;
        }
        if (shoppingcartVO.getOrderSource() != OrderSourceEnum.LONGPERIOD_BUY.getValue() && "1".equals(addressVo.getSpeedUp())) {
            if (cacheType == 1) {
                this.getSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate);
            } else if (DateUtils.date().equals(deliverDate)) {
                this.getSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate);
                if (deliverVo.getInventory() > 0) {
                    return deliverVo;
                }
            }
        }
        if ((myWXBBaseFormJson = this.getDeliverByErpThr(shoppingcartVO, addressVo, deliverDate, cacheType)) != null) {
            this.getNoSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate, JsonUtils.toJson((Object)myWXBBaseFormJson, (boolean)false), cacheType);
            this.logger.info("cacheType={},Inventory={},orderSource={},deliverDateVos={},myWXBBaseFormJson={}", new Object[]{cacheType, deliverVo.getInventory(), shoppingcartVO.getOrderSource(), JSONObject.toJSONString(deliverVo.getDeliverDateVos(), (boolean)false), JsonUtils.toJson((Object)myWXBBaseFormJson, (boolean)false)});
            if (!deliverVo.isBaseSuccess()) {
                this.logger.error("******\u8fd4\u56de\u5931\u8d25getNoSeepUpProductDeliverByErp******{},{}", (Object)deliverVo.toString());
                return deliverVo;
            }
            if (deliverVo.getInventory() == 1) {
                int day = 5;
                List<DictionaryEntity> getValidDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 200);
                if (CollectionUtils.isNotEmpty(getValidDictionaryList)) {
                    for (DictionaryEntity dictionaryEntity : getValidDictionaryList) {
                        if (!Objects.equals("sale_out_days", dictionaryEntity.getDictionaryKey())) continue;
                        day = Integer.valueOf(dictionaryEntity.getDictionaryName());
                        break;
                    }
                }
                if (CollectionUtils.isNotEmpty(deliverVo.getDeliverDateVos())) {
                    List<DeliverDateVo> temp = deliverVo.getDeliverDateVos().subList(0, day);
                    if (temp.stream().anyMatch(t -> t.getInventory() == 1)) {
                        return deliverVo;
                    }
                    List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(shoppingcartVO.getPlatFormGroupId(), 20);
                    if (list.stream().filter(d -> Objects.equals(d.getDictionaryKey(), "11")).findFirst().isPresent()) {
                        deliverVo.setInventoryMessage(list.stream().filter(d -> Objects.equals(d.getDictionaryKey(), "11")).findFirst().get().getDictionaryName());
                    }
                    if (cacheType == 1) {
                        deliverVo.setInventory(2);
                    }
                    deliverVo.setDeliverDate("");
                    deliverVo.setDeliverDateShow("");
                    deliverVo.setPickDate("");
                    deliverVo.setDeliverDates(Collections.emptyList());
                }
            }
            if (deliverVo.getInventory() == 0) {
                this.logger.info("\u5e38\u6e29\u5546\u54c1\u7f3a\u8d27\u5904\u7406\u903b\u8f91....");
                deliverVo.setDeliverDate("");
                deliverVo.setDeliverDateShow("");
                deliverVo.setPickDate("");
                if (cacheType == 1) {
                    deliverVo.setInventory(2);
                } else {
                    deliverVo.setInventory(1);
                }
                deliverVo.setDeliverDates(Collections.emptyList());
            }
            return deliverVo;
        }
        deliverVo.setInventory(-2);
        return deliverVo;
    }

    @Override
    public MyWXBBaseFormJson getDeliverByErpThr(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int cacheType) {
        List<DictionaryEntity> getValidDictionaryStopDeliverList;
        if (cacheType == 1) {
            deliverDate = null;
        }
        Date dateTime = new Date();
        String buildDays = "7";
        String fiveDays = "";
        List<DictionaryEntity> getValidDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 200);
        if (CollectionUtils.isNotEmpty(getValidDictionaryList)) {
            for (DictionaryEntity dictionaryEntity : getValidDictionaryList) {
                if ("deliver_days".equals(dictionaryEntity.getDictionaryKey())) {
                    buildDays = dictionaryEntity.getDictionaryName();
                }
                if (!"deliver_days_group".equals(dictionaryEntity.getDictionaryKey())) continue;
                fiveDays = dictionaryEntity.getDictionaryName();
            }
        }
        if (shoppingcartVO.getOrderSource() == OrderSourceEnum.TEAM_BUY.getValue()) {
            Integer time = this.grouponInterface.getGrouponHourByBindCode(shoppingcartVO.getBindCode());
            if (time != null) {
                dateTime = DateUtils.getAddDateBySecond((Date)dateTime, (int)(time * 60 * 60));
            }
            if (StringUtils.isNotEmpty((CharSequence)fiveDays)) {
                buildDays = fiveDays;
            }
        }
        WXBaseForm wxBaseForm = new WXBaseForm();
        String stopDeliver = "";
        Date startDate = new Date();
        Date endDate = new Date();
        int transportType = shoppingcartVO.getTransportType();
        if (shoppingcartVO.getTransportType() == 0) {
            transportType = this.productInterface.getTransportType(shoppingcartVO);
        }
        if ((getValidDictionaryStopDeliverList = this.dictionaryInterface.getValidDictionaryList(1000, 202)) != null && getValidDictionaryStopDeliverList.size() > 0 && StringUtils.isNotEmpty((CharSequence)(stopDeliver = getValidDictionaryStopDeliverList.get(0).getDictionaryName()))) {
            String[] arr = stopDeliver.split("-");
            String startStr = arr[0].replace(".", "-");
            String endStr = arr[1].replace(".", "-");
            startDate = DateUtils.getDateFromString((String)startStr, (String)"yyyy-MM-dd");
            endDate = DateUtils.getDateFromString((String)endStr, (String)"yyyy-MM-dd");
        }
        if (startDate.getTime() <= dateTime.getTime() && dateTime.getTime() <= endDate.getTime()) {
            dateTime = endDate;
        }
        if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            transportType = 1;
            wxBaseForm.setIfLongTime(Integer.valueOf(1));
            buildDays = "7";
        } else {
            if (transportType == 1) {
                transportType = 13;
            }
            wxBaseForm.setIfLongTime(Integer.valueOf(0));
        }
        wxBaseForm.setBuildStartTime(dateTime);
        wxBaseForm.setBuildDays(Integer.valueOf(buildDays));
        wxBaseForm.setPrivinceName(addressVo.getProvinceName());
        wxBaseForm.setCityName(addressVo.getCityName());
        wxBaseForm.setAreaName(addressVo.getAreaName());
        wxBaseForm.setAddress(addressVo.getAddress());
        if (StringUtils.isEmpty((CharSequence)deliverDate)) {
            wxBaseForm.setEarliestDeliverDate(null);
        } else {
            wxBaseForm.setEarliestDeliverDate(deliverDate);
        }
        this.logger.info("transportType={}", (Object)transportType);
        wxBaseForm.setDeliverType(Integer.valueOf(transportType));
        ArrayList<WXProductForm> wxProductForms = new ArrayList<WXProductForm>();
        if (CollectionUtils.isNotEmpty(shoppingcartVO.getProductsPool())) {
            for (MallProductVO productVO : shoppingcartVO.getProductsPool()) {
                if (!productVO.getValid().booleanValue()) continue;
                WXProductForm wxProductForm = new WXProductForm();
                wxProductForm.setBarCode(productVO.getBarCode());
                if (StringUtils.isEmpty((CharSequence)productVO.getBarCode())) {
                    throw new RuntimeException("\u5546\u54c1:" + productVO.getProNameSx() + "\u65e0\u6548");
                }
                wxProductForm.setProId(productVO.getProId());
                wxProductForm.setProductName(productVO.getProName());
                if (StringUtils.isEmpty((CharSequence)productVO.getPromotionId()) && StringUtils.isEmpty((CharSequence)productVO.getPromotionName())) {
                    wxProductForm.setProductCount(Double.valueOf(productVO.getCount().intValue()));
                } else if (CollectionUtils.isNotEmpty(shoppingcartVO.getPromotions())) {
                    for (MallPromotionVO vo : shoppingcartVO.getPromotions()) {
                        if (vo == null || !vo.getPromotionId().equals(productVO.getPromotionId())) continue;
                        if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(vo.getProductType()).intValue()) {
                            if (vo.getProduct() == null || !vo.getProduct().getProId().equals(productVO.getProId())) continue;
                            wxProductForm.setProductCount(Double.valueOf(vo.getProduct().getCount().intValue()));
                            continue;
                        }
                        if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(vo.getProductType()).intValue() || vo.getGroup() == null) continue;
                        for (MallProductVO proVO : vo.getGroup().getProductList()) {
                            if (!proVO.getProId().equals(productVO.getProId())) continue;
                            wxProductForm.setProductCount(Double.valueOf(proVO.getCount() * vo.getCount()));
                        }
                    }
                } else {
                    wxProductForm.setProductCount(Double.valueOf(productVO.getCount().intValue()));
                }
                wxProductForm.setPromotionId(productVO.getPromotionId());
                wxProductForm.setPromotionName(productVO.getPromotionName());
                wxProductForms.add(wxProductForm);
            }
            wxBaseForm.setWxProductForms(wxProductForms);
        }
        this.logger.info(" getProductDeliverByErp \u8c03\u7528ERP3.0\u4f20\u9012\u7684\u53c2\u6570 mapParam={} ", (Object)JSON.toJSONString((Object)wxBaseForm));
        long startTime = System.currentTimeMillis();
        MyWXBBaseFormJson myWXBBaseFormJson = this.deliverInvoke.getDeliver(wxBaseForm);
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        this.logger.info("\u8c03\u7528\u53ef\u552e\u5356\u91cf\u63a5\u53e3 \u8017\u65f6time={}", (Object)time);
        this.logger.info("*************************getProductDeliverByErp********************\u8c03\u7528ERP3.0\u8fd4\u56de\u7684\u6570\u636e*************result={}", (Object)JSON.toJSONString((Object)myWXBBaseFormJson));
        return myWXBBaseFormJson;
    }

    public DeliverVo getSeepUpProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate) {
        this.logger.info("*************************\u8fdb\u5165getSeepUpProductDeliverByErp***********");
        DeliverDateVo deliverDateVo = new DeliverDateVo();
        deliverDateVo.setDeliverDate(DateUtils.date());
        deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)DateUtils.date()));
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0 && this.getPrepositionCartProductsStock(addressVo.getSpeedUpWcId(), shoppingcartVO.getProductsPool()).isSuccess()) {
            deliverDateVo.setInventory(1);
        } else {
            deliverDateVo.setInventory(0);
        }
        deliverDateVo.setSpeedUp(1);
        deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)DateUtils.date(), (String)"yyyy-MM-dd")));
        deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)DateUtils.date(), (String)"yyyy-MM-dd")));
        if (StringUtils.isEmpty((CharSequence)deliverDate)) {
            if (deliverVo.getDeliverDateVos() == null) {
                deliverVo.setDeliverDateVos(new ArrayList<DeliverDateVo>());
            }
            deliverVo.getDeliverDateVos().add(deliverDateVo);
            deliverVo.getDeliverDateVos().sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
        }
        if (deliverDateVo.getInventory() == 1) {
            deliverVo.setDeliverId("0");
            deliverVo.setDeliverName("\u7f8e\u56e2\u914d\u9001");
            deliverVo.setDeliverDate(DateUtils.date());
            deliverVo.setDeliverDateShow("\u7acb\u5373\u914d\u9001");
            deliverVo.setPickDate(DateUtils.date());
            deliverVo.setDeliverEndTime("22:00");
            deliverVo.setDelay(0);
            deliverVo.setDcId(addressVo.getSpeedUpWcId());
            deliverVo.setInventory(1);
            deliverVo.setSpeedupInventory(1);
            shoppingcartVO.getProducts().forEach(MallProductVo -> {
                MallProductVo.setDelay(false);
                MallProductVo.setDelayDate(DateUtils.date());
                MallProductVo.setDelayDays(0);
            });
        }
        return deliverVo;
    }

    public DeliverVo getNoSeepUpProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, String result, int cacheType) {
        LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)result, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.putAll((Map)jsonMap);
        this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObject);
        int status = (Integer)jsonObject.get((Object)"status");
        if (status == 200) {
            boolean success = (Boolean)jsonObject.get((Object)"success");
            if (success) {
                JSONObject objectResult = (JSONObject)jsonObject.get((Object)"result");
                JSONObject deliverDates = null;
                JSONArray jsonArrayProduct = null;
                deliverDates = (JSONObject)objectResult.get((Object)"dates");
                jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
                if (objectResult.get((Object)"deliverDates") != null || objectResult.get((Object)"deliverDates") != "" && StringUtils.isEmpty((CharSequence)deliverDate)) {
                    deliverVo.setDeliverDates(JSONArray.parseArray((String)objectResult.get((Object)"deliverDates").toString(), DeliverSoldProductVo.class));
                    this.bulidSoldProduct(deliverVo.getDeliverDates());
                } else {
                    deliverVo.setDeliverDates(null);
                }
                int saleOutType = SaleOutTypeEnum.HAS_SALE_OUT.getValue();
                boolean saleOutFlag = false;
                saleOutFlag = this.handleSoldOut(objectResult);
                if (cacheType == 1 && saleOutFlag) {
                    saleOutType = SaleOutTypeEnum.PART_SALE_OUT.getValue();
                }
                if (cacheType == 2 && saleOutFlag) {
                    saleOutType = SaleOutTypeEnum.SALE_OUT_ORDER.getValue();
                }
                String earliestPickupDate = (String)objectResult.get((Object)"earliestPickupDate");
                String earliestDeliverDate = (String)objectResult.get((Object)"earliestDeliverDate");
                String finishTime = objectResult.get((Object)"finishTime").toString();
                String weekSetPickup = (String)objectResult.get((Object)"weekSetPickup");
                String deliverId = (String)objectResult.get((Object)"deliverId");
                String deliverName = (String)objectResult.get((Object)"deliverName");
                String kwId = (String)objectResult.get((Object)"kwId");
                String edbStoreId = (String)objectResult.get((Object)"edbStoreId");
                int agingDays = (Integer)objectResult.get((Object)"days");
                int buildDays = (Integer)objectResult.get((Object)"buildDays");
                String kwAndEdbStoreId = kwId + "|" + edbStoreId;
                int ifLongTime = (Integer)objectResult.get((Object)"ifLongTime");
                if (deliverVo != null && deliverVo.getInventory() == 0) {
                    deliverVo.setDeliverId(deliverId);
                    deliverVo.setDeliverName(deliverName);
                    deliverVo.setDcId(kwAndEdbStoreId);
                }
                if (deliverVo.getDeliverDateVos() == null) {
                    deliverVo.setDeliverDateVos(new ArrayList<DeliverDateVo>());
                }
                if (deliverDates != null) {
                    int inventory = 1;
                    this.removeStopDeliver(deliverVo, deliverDates, agingDays, buildDays, ifLongTime);
                    for (DeliverDateVo deliverDateVo : deliverVo.getDeliverDateVos()) {
                        if (deliverDateVo.getInventory() != 1) continue;
                        earliestDeliverDate = deliverDateVo.getDeliverDate();
                        break;
                    }
                    int nomalInventory = 1;
                    if (StringUtils.isEmpty((CharSequence)earliestDeliverDate)) {
                        nomalInventory = 0;
                    } else {
                        Date earliestDeliverDateTime = DateUtils.getDateFromString((String)earliestDeliverDate, (String)"yyyy-MM-dd");
                        earliestDeliverDateTime = DateUtils.getAddDateByDay((Date)earliestDeliverDateTime, (int)(-agingDays));
                        earliestPickupDate = DateUtils.formatDate((Date)earliestDeliverDateTime, (String)"yyyy-MM-dd");
                    }
                    if (nomalInventory != 1 && deliverVo.getSpeedupInventory() != 1) {
                        inventory = 0;
                    }
                    if (deliverVo != null && deliverVo.getInventory() == 0) {
                        if (StringUtils.isNotEmpty((CharSequence)deliverDate)) {
                            deliverVo.setDeliverDate(deliverDate);
                            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDate));
                        } else {
                            deliverVo.setDeliverDate(earliestDeliverDate);
                            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                        }
                        deliverVo.setPickDate(earliestPickupDate);
                        deliverVo.setDeliverEndTime(finishTime);
                        deliverVo.setDelay(0);
                        deliverVo.setNomalInventory(nomalInventory);
                        deliverVo.setInventory(inventory);
                        deliverVo.setDeliverWeekShow(weekSetPickup);
                    }
                    deliverVo.getDeliverDateVos().sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
                } else if (deliverVo != null && deliverVo.getInventory() == 0) {
                    deliverVo.setInventory(1);
                    deliverVo.setDeliverEndTime(finishTime);
                    deliverVo.setDeliverDate(earliestDeliverDate);
                    deliverVo.setPickDate(earliestPickupDate);
                    deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                    deliverVo.setDeliverEndTime(finishTime);
                    deliverVo.setDeliverWeekShow(weekSetPickup);
                }
                if (jsonArrayProduct != null && jsonArrayProduct.size() > 0 && deliverVo.getSpeedupInventory() != 1) {
                    List deliverProductVoList = JSON.parseArray((String)jsonArrayProduct.toJSONString(), DeliverProductVo.class);
                    this.logger.info("deliverProductVoList={}", (Object)deliverProductVoList.toString());
                    if (CollectionUtils.isNotEmpty((Collection)deliverProductVoList)) {
                        DeliverEntity deliverEntity = new DeliverEntity();
                        ArrayList<GroupProductEntity> gpList = new ArrayList<GroupProductEntity>();
                        int isInventory = 1;
                        boolean salseInt = false;
                        deliverProductVoList.sort((f1, f2) -> String.valueOf(f1.getSalesCount()).compareTo(String.valueOf(f2.getSalesCount())));
                        for (DeliverProductVo deliverProductVo : deliverProductVoList) {
                            boolean proInventory = true;
                            GroupProductEntity groupProductEntity = new GroupProductEntity();
                            groupProductEntity.setDelay(deliverProductVo.getDelayDays());
                            groupProductEntity.setDelayDate(deliverProductVo.getDeliverDate());
                            groupProductEntity.setInventoryCount(deliverProductVo.getSalesCount());
                            groupProductEntity.setProductName(deliverProductVo.getProductName());
                            groupProductEntity.setQuantity(deliverProductVo.getProductCount());
                            if (StringUtils.isNotEmpty((CharSequence)deliverProductVo.getBarCode())) {
                                groupProductEntity.setProductId(deliverProductVo.getProId());
                                if (StringUtils.isEmpty((CharSequence)deliverDate) && StringUtils.isEmpty((CharSequence)earliestDeliverDate)) {
                                    if (deliverProductVo.getSalesCount() <= 0) {
                                        salseInt = true;
                                        proInventory = false;
                                        isInventory = 0;
                                    } else if (!salseInt) {
                                        proInventory = false;
                                        isInventory = 0;
                                    }
                                }
                                groupProductEntity.setInventory(StringUtils.isEmpty((CharSequence)deliverProductVo.getDeliverDate()) ? 0 : (deliverProductVo.getSalesCount() > 0 ? 1 : 0));
                            } else {
                                groupProductEntity.setInventory(-2);
                            }
                            gpList.add(groupProductEntity);
                        }
                        this.logger.info("gpList={},cacheType={}", (Object)((Object)gpList).toString(), (Object)cacheType);
                        deliverVo.setInventory(isInventory);
                        deliverEntity.setGpList(gpList);
                        this.gpListConvertCartVoNew(deliverEntity.getGpList(), shoppingcartVO, deliverVo, addressVo, saleOutType);
                    }
                }
            } else {
                this.logger.info("*************************getNoSeepUpProductDeliverByErp************\u8c03\u7528erp3\u30020\u83b7\u53d6\u914d\u9001\u65e5\u671f\u5931\u8d25****success={},status={}", (Object)success, (Object)status);
                deliverVo.setInventory(-1);
            }
            return deliverVo;
        }
        if (status == 1000 || status == 106) {
            deliverVo.setInventory(-1);
            if (jsonObject.containsKey((Object)"message")) {
                this.logger.error("erp\u8fd4\u56de\u9519\u8bef\u6d88\u606f:{}", (Object)jsonObject.getString("message"));
            }
            return deliverVo;
        }
        if (status == 408) {
            deliverVo.setInventory(2);
            deliverVo.setDeliverEndTime("20:00");
            return deliverVo;
        }
        if (cacheType != 2) {
            deliverVo.setInventory(1);
            deliverVo.setDeliverEndTime("20:00");
            deliverVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)1), (String)"yyyy-MM-dd"));
            deliverVo.setPickDate(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverVo.getDeliverDate()));
        }
        return deliverVo;
    }

    private boolean handleSoldOut(JSONObject result) {
        List deliverDates;
        boolean saleOutFlag = false;
        if ((result.get((Object)"earliestPickupDate") == null || StringUtils.isEmpty((CharSequence)((String)result.get((Object)"earliestPickupDate")))) && result.get((Object)"deliverDates") != null && (deliverDates = JSONArray.parseArray((String)result.get((Object)"deliverDates").toString(), DeliverSoldProductVo.class)) != null && deliverDates.size() == 10) {
            this.logger.info("handleSoldOut-begin");
            String deliverDate = ((DeliverSoldProductVo)deliverDates.get(7)).getProductForms().get(0).getDeliverDate();
            String pickupDate = ((DeliverSoldProductVo)deliverDates.get(7)).getProductForms().get(0).getPickupDate();
            result.put("earliestPickupDate", (Object)pickupDate);
            result.put("earliestDeliverDate", (Object)deliverDate);
            saleOutFlag = true;
            JSONArray jsonArrayProduct = (JSONArray)result.get((Object)"wxProductForms");
            List deliverProductVoList = JSON.parseArray((String)jsonArrayProduct.toJSONString(), DeliverProductVo.class);
            deliverProductVoList.forEach(deliverProductVo -> {
                deliverProductVo.setPickupDate(pickupDate);
                deliverProductVo.setDeliverDate(deliverDate);
            });
            result.put("wxProductForms", JSONArray.toJSON((Object)deliverProductVoList));
            JSONObject dates = (JSONObject)result.get((Object)"dates");
            String time7 = ((DeliverSoldProductVo)deliverDates.get(7)).getTime();
            String time8 = ((DeliverSoldProductVo)deliverDates.get(8)).getTime();
            String time9 = ((DeliverSoldProductVo)deliverDates.get(9)).getTime();
            dates.keySet().forEach(key -> {
                if (key.startsWith(time7) || key.startsWith(time8) || key.startsWith(time9)) {
                    dates.put(key, (Object)1);
                }
            });
            deliverDates.remove(9);
            deliverDates.remove(8);
            deliverDates.remove(7);
            result.put("deliverDates", JSONArray.toJSON((Object)deliverDates));
        }
        return saleOutFlag;
    }

    private void removeStopDeliver(DeliverVo deliverVo, JSONObject deliverDates, int agingDays, int buildDays, int ifLongTime) {
        List<DictionaryEntity> getValidDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 202);
        if (CollectionUtils.isNotEmpty(getValidDictionaryList)) {
            String stopDeliver = "";
            boolean isStopDeliver = false;
            Date startDate = new Date();
            Date endDate = new Date();
            stopDeliver = getValidDictionaryList.get(0).getDictionaryName();
            if (StringUtils.isNotEmpty((CharSequence)stopDeliver)) {
                isStopDeliver = true;
                String[] arr = stopDeliver.split("-");
                String startStr = arr[0].replace(".", "-");
                String endStr = arr[1].replace(".", "-");
                startDate = DateUtils.getDateFromString((String)startStr, (String)"yyyy-MM-dd");
                endDate = DateUtils.getDateFromString((String)endStr, (String)"yyyy-MM-dd");
            }
            int n = 0;
            for (String k : deliverDates.keySet()) {
                DeliverDateVo deliverDateVo = new DeliverDateVo();
                if (isStopDeliver) {
                    Date deliverTime = DateUtils.getDateFromString((String)k.split("\\|")[0], (String)"yyyy-MM-dd");
                    if (startDate.getTime() <= deliverTime.getTime() && deliverTime.getTime() <= endDate.getTime()) {
                        if (ifLongTime == 1) {
                            int addInt = 0;
                            double daysDouble = (endDate.getTime() - deliverTime.getTime()) / 86400000L;
                            double daysDiff = daysDouble / (double)buildDays;
                            addInt = (int)(daysDiff + 1.0) * buildDays;
                            deliverDateVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)deliverTime, (int)addInt), (String)"yyyy-MM-dd"));
                        } else {
                            this.logger.info("\u505c\u914d\u4e86\uff1a{}", (Object)k);
                            int key = deliverDates.keySet().size() - 1;
                            ArrayList keyList = new ArrayList(deliverDates.keySet());
                            String lastKey = (String)keyList.get(key);
                            Date deliverTimeLast = DateUtils.getDateFromString((String)lastKey.split("\\|")[0], (String)"yyyy-MM-dd");
                            if (deliverTimeLast.getTime() >= endDate.getTime()) {
                                deliverDateVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)deliverTimeLast, (int)(agingDays + n)), (String)"yyyy-MM-dd"));
                                this.logger.info("\u770b\u8fd9\u91cc1\uff1adeliverTimeLast={},agingDays={},n={}", new Object[]{DateUtils.formatDate((Date)deliverTimeLast, (String)"yyyy-MM-dd"), agingDays, n});
                                this.logger.info("\u770b\u8fd9\u91cc\u7ed3\u675f1\uff1adeliverDateVo={}", (Object)JsonUtils.toJson((Object)deliverDateVo, (boolean)false));
                            } else {
                                deliverDateVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)endDate, (int)(agingDays + n)), (String)"yyyy-MM-dd"));
                                this.logger.info("\u770b\u8fd9\u91cc2\uff1aendDate={},agingDays={},n={}", new Object[]{DateUtils.formatDate((Date)endDate, (String)"yyyy-MM-dd"), agingDays, n});
                                this.logger.info("\u770b\u8fd9\u91cc\u7ed3\u675f2\uff1adeliverDateVo={}", (Object)JsonUtils.toJson((Object)deliverDateVo, (boolean)false));
                            }
                            ++n;
                        }
                        deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDateVo.getDeliverDate()));
                        deliverDateVo.setInventory(1);
                        deliverDateVo.setSpeedUp(deliverDateVo.getDeliverDate().equals(DateUtils.date()) ? 1 : 0);
                        deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                        deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                    }
                    if (deliverTime.getTime() > endDate.getTime() || deliverTime.getTime() < startDate.getTime()) {
                        deliverDateVo.setDeliverDate(k.split("\\|")[0]);
                        deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDateVo.getDeliverDate()));
                        deliverDateVo.setInventory((Integer)deliverDates.get((Object)k));
                        deliverDateVo.setSpeedUp(deliverDateVo.getDeliverDate().equals(DateUtils.date()) ? 1 : 0);
                        deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                        deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                    }
                } else {
                    deliverDateVo.setDeliverDate(k.split("\\|")[0]);
                    deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDateVo.getDeliverDate()));
                    deliverDateVo.setInventory((Integer)deliverDates.get((Object)k));
                    deliverDateVo.setSpeedUp(deliverDateVo.getDeliverDate().equals(DateUtils.date()) ? 1 : 0);
                    deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                    deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                }
                if (!StringUtils.isNotEmpty((CharSequence)deliverDateVo.getDeliverDate())) continue;
                deliverVo.getDeliverDateVos().add(deliverDateVo);
            }
        }
    }

    public void bulidSoldProduct(List<DeliverSoldProductVo> deliverDates) {
        if (deliverDates != null && deliverDates.size() > 0) {
            for (DeliverSoldProductVo deliverSoldProductVo : deliverDates) {
                List<ProductFormVo> productFormList = deliverSoldProductVo.getProductForms();
                if (CollectionUtils.isNotEmpty(productFormList)) {
                    for (ProductFormVo productFormVo : productFormList) {
                        if (!StringUtils.isNotEmpty((CharSequence)productFormVo.getPromotionId()) || !StringUtils.isNotEmpty((CharSequence)productFormVo.getPromotionName())) continue;
                        productFormVo.setProductName(productFormVo.getPromotionName());
                        productFormVo.setSalesCount(0);
                    }
                }
                List productFormVos = productFormList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductFormVo>(Comparator.comparing(t -> t.getProductName()))), ArrayList::new));
                deliverSoldProductVo.setProductForms(productFormVos);
            }
        }
        this.logger.info("deliverDates={}", (Object)deliverDates.toString());
    }

    @Override
    public BaseJsonVo getPrepositionCartProductsStock(String kwid, List<MallProductVO> productVos) {
        BaseJsonVo kwJson = this.getPrepositionProducts(kwid);
        if (kwJson.isSuccess()) {
            List kwProductList = (List)kwJson.getValue();
            Boolean exits = true;
            for (MallProductVO pro : productVos) {
                Optional<Map> aa1 = kwProductList.parallelStream().filter(kwPro -> pro.getProId().equals(kwPro.get("proid")) && Integer.valueOf((String)kwPro.get("count")) >= pro.getCount()).findAny();
                if (aa1.isPresent()) continue;
                return BaseJsonVo.error((String)("\u5546\u54c1" + pro.getProName() + "(" + pro.getProId() + ")\u5728\u524d\u7f6e\u4ed3" + kwid + "\u5e93\u5b58\u4e0d\u8db3"));
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6\u524d\u7f6e\u4ed3\u5546\u54c1\u9519\u8bef");
    }

    @Override
    public BaseJsonVo getPrepositionProducts(@ParameterValueKeyProvider(order=0) String kwId) {
        this.logger.info(">>>>>>>>>>>>>>>>\u67e5\u8be2\u7684\u662f\u8fd9\u4e2a\u5e93\u7684\u5e93\u5b58:" + kwId);
        HashMap<String, String> map = new HashMap<String, String>();
        String productUrl = this.oldApiHost + "malldeliver/getJishudaProList";
        map.put("kw_id", kwId);
        HttpRequest prodRequest = new HttpRequest(productUrl, map);
        prodRequest.setMethod("POST");
        prodRequest.setConnectTimeout(30000);
        String prodResult = "";
        prodResult = HttpComponentUtil.execute((HttpRequest)prodRequest);
        this.logger.info("getProductStock, \u8c03\u7528getJishudaProList\u7684\u53c2\u6570\u3010" + kwId + "\u3011\uff0c\u8fd4\u56de\u503c \uff1a" + prodResult);
        ArrayList<Map> kwProductList = new ArrayList<Map>();
        if (StringUtils.isNotBlank((CharSequence)prodResult)) {
            JSONObject prodObject = JSON.parseObject((String)prodResult);
            JSONArray prodInfo = new ArrayList();
            prodInfo = prodObject.getJSONArray("proList");
            ArrayList objects = new ArrayList();
            if (prodInfo != null && prodInfo.size() > 0) {
                int i = 0;
                for (Object objectPro : prodInfo) {
                    ++i;
                    Map ret = (Map)objectPro;
                    kwProductList.add(ret);
                }
            }
        }
        return BaseJsonVo.success(kwProductList);
    }

    private void gpListConvertCartVo(List<GroupProductEntity> gpList, MallShoppingcartVO shoppingcartVO, DeliverVo deliverVo, CustomerAddressVo addressVo, int saleOutType) {
        for (GroupProductEntity g : gpList) {
            MallProductVO productVO;
            List<MallProductVO> productVOs;
            List productVOs2;
            if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0 && (productVOs2 = shoppingcartVO.getProductsPool().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() > 0) {
                this.getProductVoDeliver((MallProductVO)productVOs2.get(0), g, deliverVo, false);
            }
            if (shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0 && (productVOs2 = shoppingcartVO.getProducts().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() > 0) {
                this.getProductVoDeliver((MallProductVO)productVOs2.get(0), g, deliverVo, false);
            }
            if (shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
                for (MallGroupVO group : shoppingcartVO.getGroups()) {
                    productVOs = group.getProductList().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList());
                    if (productVOs.size() <= 0) continue;
                    productVO = productVOs.get(0);
                    this.getProductVoDeliver(productVO, g, deliverVo, false);
                    this.getGroupVoDeliver(group, productVO, g, deliverVo, true, false);
                }
            }
            if (shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
                for (MallPromotionVO p : shoppingcartVO.getPromotions()) {
                    if (p.getProduct() != null && p.getProduct().getProId().equals(g.getProductId())) {
                        this.getProductVoDeliver(p.getProduct(), g, deliverVo, false);
                        this.getPromotionVoDeliver(p, p.getProduct(), g, deliverVo, true, false);
                    }
                    if (p.getGroup() == null || (productVOs = p.getGroup().getProductList().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() <= 0) continue;
                    productVO = productVOs.get(0);
                    this.getGroupVoDeliver(p.getGroup(), productVO, g, deliverVo, true, false);
                    this.getPromotionVoDeliver(p, p.getGroup(), g, deliverVo, true, false);
                }
            }
            if (shoppingcartVO.getFrees() == null || shoppingcartVO.getFrees().size() <= 0) continue;
            for (MallFreeVO f : shoppingcartVO.getFrees()) {
                productVOs = f.getProductList();
                if ((productVOs = productVOs.stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() <= 0) continue;
                productVO = productVOs.get(0);
                this.getFreeVoDeliver(f, productVO, g, deliverVo);
            }
        }
    }

    private void gpListConvertCartVoNew(List<GroupProductEntity> gpList, MallShoppingcartVO shoppingcartVO, DeliverVo deliverVo, CustomerAddressVo addressVo, int saleOutType) {
        GroupProductEntity g;
        List tempList;
        List<Object> gps;
        String delayDate;
        GroupProductEntity g2;
        boolean onlyOneType = false;
        Map<String, List<GroupProductEntity>> map = gpList.stream().collect(Collectors.groupingBy(GroupProductEntity::getProductId));
        Map<String, List<GroupProductEntity>> map2 = gpList.stream().filter(c -> StringUtils.isNotEmpty((CharSequence)c.getGroupId())).collect(Collectors.groupingBy(GroupProductEntity::getGroupId));
        Map<String, List<GroupProductEntity>> map3 = gpList.stream().filter(c -> StringUtils.isNotEmpty((CharSequence)c.getPromotionId())).collect(Collectors.groupingBy(GroupProductEntity::getPromotionId));
        if (map.size() + map2.size() + map3.size() == 1) {
            onlyOneType = true;
        }
        if (shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0) {
            for (MallProductVO productVO : shoppingcartVO.getProducts()) {
                List tempList2;
                if (!CollectionUtils.isNotEmpty(gpList) || !CollectionUtils.isNotEmpty(tempList2 = gpList.stream().filter(c -> c.getProductId().equals(productVO.getProId())).collect(Collectors.toList()))) continue;
                g2 = (GroupProductEntity)tempList2.get(0);
                this.getProductVoDeliver(productVO, g2, deliverVo, onlyOneType);
            }
        }
        if (shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
            for (MallGroupVO group : shoppingcartVO.getGroups()) {
                boolean isSameDay = true;
                delayDate = "";
                gps = new ArrayList();
                for (MallProductVO productVO : group.getProductList()) {
                    if (!CollectionUtils.isNotEmpty(gpList) || !CollectionUtils.isNotEmpty(tempList = gpList.stream().filter(c -> c.getProductId().equals(productVO.getProId())).collect(Collectors.toList()))) continue;
                    g = (GroupProductEntity)tempList.get(0);
                    gps.add(g);
                    this.getProductVoDeliver(productVO, g, deliverVo, onlyOneType);
                    if (delayDate != "" && !delayDate.equals(g.getDelayDate()) && g.getDelayDate() != null) {
                        isSameDay = false;
                    }
                    delayDate = g.getDelayDate() == null ? "" : g.getDelayDate();
                }
                gps = gps.stream().sorted(Comparator.comparing(GroupProductEntity::getDelayDate, Comparator.nullsLast(String::compareTo)).reversed()).collect(Collectors.toList());
                this.getGroupVoDeliver(group, group.getProductList().get(0), (GroupProductEntity)gps.get(0), deliverVo, isSameDay, onlyOneType);
            }
        }
        if (shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
            for (MallPromotionVO p : shoppingcartVO.getPromotions()) {
                List tempList3;
                if (p.getProduct() != null && CollectionUtils.isNotEmpty(gpList) && CollectionUtils.isNotEmpty(tempList3 = gpList.stream().filter(c -> c.getProductId().equals(p.getProduct().getProId())).collect(Collectors.toList()))) {
                    g2 = (GroupProductEntity)tempList3.get(0);
                    if (p.getProduct().getProId().equals(g2.getProductId())) {
                        this.getProductVoDeliver(p.getProduct(), g2, deliverVo, onlyOneType);
                        this.getPromotionVoDeliver(p, p.getProduct(), g2, deliverVo, true, onlyOneType);
                    }
                }
                if (p.getGroup() == null) continue;
                boolean isSameDay = true;
                delayDate = "";
                gps = new ArrayList();
                for (MallProductVO productVO : p.getGroup().getProductList()) {
                    if (!CollectionUtils.isNotEmpty(gpList) || !CollectionUtils.isNotEmpty(tempList = gpList.stream().filter(c -> c.getProductId().equals(productVO.getProId())).collect(Collectors.toList()))) continue;
                    g = (GroupProductEntity)tempList.get(0);
                    gps.add(g);
                    this.getProductVoDeliver(productVO, g, deliverVo, onlyOneType);
                    if (delayDate != "" && !delayDate.equals(g.getDelayDate()) && g.getDelayDate() != null) {
                        isSameDay = false;
                    }
                    delayDate = g.getDelayDate() == null ? "" : g.getDelayDate();
                }
                if (!CollectionUtils.isNotEmpty(gps = gps.stream().sorted(Comparator.comparing(GroupProductEntity::getDelayDate, Comparator.nullsLast(String::compareTo)).reversed()).collect(Collectors.toList()))) continue;
                if (CollectionUtils.isNotEmpty(p.getGroup().getProductList())) {
                    this.getGroupVoDeliver(p.getGroup(), p.getGroup().getProductList().get(0), (GroupProductEntity)gps.get(0), deliverVo, isSameDay, onlyOneType);
                }
                this.getPromotionVoDeliver(p, p.getGroup(), (GroupProductEntity)gps.get(0), deliverVo, isSameDay, onlyOneType);
            }
        }
        if (shoppingcartVO.getFrees() != null && shoppingcartVO.getFrees().size() > 0) {
            for (MallFreeVO f : shoppingcartVO.getFrees()) {
                List<MallProductVO> productVOs = f.getProductList();
                for (MallProductVO productVO : productVOs) {
                    List tempList4;
                    if (!CollectionUtils.isNotEmpty(gpList) || !CollectionUtils.isNotEmpty(tempList4 = gpList.stream().filter(c -> c.getProductId().equals(productVO.getProId())).collect(Collectors.toList()))) continue;
                    GroupProductEntity g3 = (GroupProductEntity)tempList4.get(0);
                    this.getFreeVoDeliver(f, productVO, g3, deliverVo);
                }
            }
        }
    }

    private void getProductVoDeliver(MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo, boolean onlyOneType) {
        if (productVO != null) {
            if (deliverVo.getInventory() == 0) {
                productVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                productVO.setShort(g.getInventoryCount() < 5);
            } else {
                productVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                productVO.setShort(g.getInventoryCount() < 5);
            }
            productVO.setStockCount(g.getInventoryCount());
            if (!"\u7f8e\u56e2\u914d\u9001".equals(deliverVo.getDeliverName())) {
                productVO.setDelay(g.getDelay() > 0);
                productVO.setDelayDays(g.getDelay());
                productVO.setDelayDate(g.getDelayDate());
                productVO.setDelayTips(this.getDelayTips(4, g.getDelayDate(), g.getDelay(), deliverVo, true, onlyOneType));
            }
        }
    }

    public String getDelayTips(int productType, String date, int delaydays, DeliverVo deliverVo, boolean isSameDay, boolean onlyOneType) {
        String tips = "\u5f71\u54cd\u914d\u9001\u65f6\u6548";
        try {
            if (StringUtils.isNotEmpty((CharSequence)date)) {
                tips = "\u6700\u65e9" + DateUtils.formatDate((Date)DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"), (String)"M\u6708d\u65e5") + "\u914d\u9001";
                if (!isSameDay && onlyOneType && deliverVo.getInventory() == 2) {
                    tips = "\u5c3d\u5feb\u914d\u9001";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tips;
    }

    private void getGroupVoDeliver(MallGroupVO groupVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo, boolean isSameDay, boolean onlyOneType) {
        if (productVO != null) {
            if (groupVO.getSoldOut() == null || !groupVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    groupVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    groupVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (groupVO.getShort() == null || !groupVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    groupVO.setShort(g.getInventoryCount() < 5);
                } else {
                    groupVO.setShort(false);
                }
            }
            if (!"\u7f8e\u56e2\u914d\u9001".equals(deliverVo.getDeliverName())) {
                if (groupVO.getDelay() == null || !groupVO.getDelay().booleanValue()) {
                    groupVO.setDelay(g.getDelay() > 0);
                }
                if (groupVO.getDelayDays() == null || groupVO.getDelayDays() < g.getDelay()) {
                    groupVO.setDelayDays(g.getDelay());
                    groupVO.setDelayDate(g.getDelayDate());
                    groupVO.setDelayTips(this.getDelayTips(2, g.getDelayDate(), g.getDelay(), deliverVo, isSameDay, onlyOneType));
                }
            }
        }
    }

    private void getPromotionVoDeliver(MallPromotionVO promotionVO, MallGroupVO groupVO, GroupProductEntity g, DeliverVo deliverVo, boolean isSameDay, boolean onlyOneType) {
        if (groupVO != null) {
            if (promotionVO.getSoldOut() == null || !promotionVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setSoldOut(g.getInventory() == 0 || groupVO.getCount() > g.getInventoryCount());
                } else {
                    promotionVO.setSoldOut(g.getInventory() == 0 || groupVO.getCount() > g.getInventoryCount());
                }
            }
            if (promotionVO.getShort() == null || !promotionVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setShort(g.getInventoryCount() < 5);
                } else {
                    promotionVO.setShort(false);
                }
            }
            if (!"\u7f8e\u56e2\u914d\u9001".equals(deliverVo.getDeliverName())) {
                if (promotionVO.getDelay() == null || !promotionVO.getDelay().booleanValue()) {
                    promotionVO.setDelay(g.getDelay() > 0);
                }
                if (promotionVO.getDelayDays() == null || promotionVO.getDelayDays() < g.getDelay()) {
                    promotionVO.setDelayDays(g.getDelay());
                    promotionVO.setDelayDate(g.getDelayDate());
                    promotionVO.setDelayTips(this.getDelayTips(1, g.getDelayDate(), g.getDelay(), deliverVo, isSameDay, onlyOneType));
                }
            }
        }
    }

    private void getPromotionVoDeliver(MallPromotionVO promotionVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo, boolean isSameDay, boolean onlyOneType) {
        if (productVO != null) {
            if (promotionVO.getSoldOut() == null || !promotionVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (promotionVO.getShort() == null || !promotionVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setShort(g.getInventoryCount() < 5);
                } else {
                    promotionVO.setShort(false);
                }
            }
            if (!"\u7f8e\u56e2\u914d\u9001".equals(deliverVo.getDeliverName())) {
                if (promotionVO.getDelay() == null || !promotionVO.getDelay().booleanValue()) {
                    promotionVO.setDelay(g.getDelay() > 0);
                }
                if (promotionVO.getDelayDays() == null || promotionVO.getDelayDays() < g.getDelay()) {
                    promotionVO.setDelayDays(g.getDelay());
                    promotionVO.setDelayDate(g.getDelayDate());
                    promotionVO.setDelayTips(this.getDelayTips(1, g.getDelayDate(), g.getDelay(), deliverVo, isSameDay, onlyOneType));
                }
            }
        }
    }

    private void getFreeVoDeliver(MallFreeVO freeVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        if (productVO != null) {
            if (freeVO.getSoldOut() == null || !freeVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    freeVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    freeVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (freeVO.getShort() == null || !freeVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    freeVO.setShort(g.getInventoryCount() < 5);
                } else {
                    freeVO.setShort(false);
                }
            }
        }
    }
}

